/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.dstore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.internal.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.internal.services.dstore.search.DStoreSearchResultConfiguration;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreSearchResult;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.search.IHostSearchResult;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.AbstractRemoteFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.OutputRefresh;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.swt.widgets.Display;

public class DStoreFileSubSystemSearchResultConfiguration
extends DStoreSearchResultConfiguration {
    private FileServiceSubSystem _fileSubSystem;
    private IRemoteFile _searchObject;
    private List _convertedResults;

    public DStoreFileSubSystemSearchResultConfiguration(IHostSearchResultSet set, Object searchObject, SystemSearchString searchString, ISearchService searchService, IHostFileToRemoteFileAdapter fileAdapter) {
        super(set, searchObject, searchString, searchService);
        this._searchObject = (IRemoteFile)searchObject;
        this._fileSubSystem = (FileServiceSubSystem)this._searchObject.getParentRemoteFileSubSystem();
        this._convertedResults = new ArrayList();
    }

    public int getResultsSize() {
        DataElement status = this.getStatusObject();
        if (status != null) {
            return this.getStatusObject().getNestedSize();
        }
        return 0;
    }

    public Object[] getResults() {
        List results = this.getStatusObject().getNestedData();
        if (results != null) {
            if (results.size() > this._convertedResults.size()) {
                int i = this._convertedResults.size();
                while (i < results.size()) {
                    DataElement fileNode = (DataElement)results.get(i);
                    if (fileNode != null && !fileNode.getType().equals("error")) {
                        try {
                            DStoreHostFile hostFile = new DStoreHostFile(fileNode);
                            IRemoteFileContext context = this._fileSubSystem.getTheDefaultContext();
                            AbstractRemoteFile remoteFile = this._fileSubSystem.getHostFileToRemoteFileAdapter().convertToRemoteFile(this._fileSubSystem, context, null, (IHostFile)hostFile);
                            List contained = fileNode.getNestedData();
                            if (contained != null) {
                                Object[] searchResults = new IHostSearchResult[contained.size()];
                                int c = 0;
                                while (c < contained.size()) {
                                    searchResults[c] = new DStoreSearchResult((IHostSearchResultConfiguration)this, remoteFile, (DataElement)contained.get(c), this.getSearchString());
                                    ++c;
                                }
                                remoteFile.setContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), this.getSearchString().getTextString(), searchResults);
                            }
                            this._convertedResults.add(remoteFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            return this._convertedResults.toArray(new IRemoteFile[this._convertedResults.size()]);
        }
        return new IRemoteFile[0];
    }

    public Object getSearchTarget() {
        try {
            return this._fileSubSystem.getFileService().getFile(this._searchObject.getParentPath(), this._searchObject.getName(), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void domainChanged(DomainEvent e) {
        if (this._status.getValue().equals("done")) {
            DelayedDomainListenerRemover remover = new DelayedDomainListenerRemover(this, this._status);
            remover.start();
            OutputRefresh refresh = new OutputRefresh((IHostSearchResultConfiguration)this);
            Display.getDefault().asyncExec((Runnable)refresh);
        } else if (this._status.getValue().equals("cancelled")) {
            this.setStatus(2);
            this._status.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
            OutputRefresh refresh = new OutputRefresh((IHostSearchResultConfiguration)this);
            Display.getDefault().asyncExec((Runnable)refresh);
        }
    }

    public void cancel() {
        if (this.getStatus() == 0) {
            this.getSearchService().cancelSearch((IHostSearchResultConfiguration)this, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class DelayedDomainListenerRemover
    extends Thread {
        private DStoreFileSubSystemSearchResultConfiguration _config;
        private DataElement _status;

        public DelayedDomainListenerRemover(DStoreFileSubSystemSearchResultConfiguration config, DataElement status) {
            this._status = status;
            this._config = config;
        }

        public void run() {
            try {
                DelayedDomainListenerRemover.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._status.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this._config);
            this._config.setStatus(1);
        }
    }
}

