/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.common.base.Functions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.DocumentContentSynchronizer;
import org.eclipse.lsp4e.FileBufferListenerAdapter;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.internal.SupportedFeatures;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ClientInfo;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DocumentFormattingOptions;
import org.eclipse.lsp4j.DocumentRangeFormattingOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.SelectionRangeRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LanguageServerWrapper {
    private final IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void bufferDisposed(IFileBuffer buffer) {
            LanguageServerWrapper.this.disconnect(LSPEclipseUtils.toUri(buffer));
        }

        @Override
        public void stateChanging(IFileBuffer buffer) {
            DocumentContentSynchronizer documentListener;
            if (buffer.isDirty() && (documentListener = LanguageServerWrapper.this.connectedDocuments.get(LSPEclipseUtils.toUri(buffer))) != null) {
                documentListener.documentAboutToBeSaved();
            }
        }

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (isDirty) {
                return;
            }
            DocumentContentSynchronizer documentListener = LanguageServerWrapper.this.connectedDocuments.get(LSPEclipseUtils.toUri(buffer));
            if (documentListener != null) {
                documentListener.documentSaved(buffer);
            }
        }
    };
    public final @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition;
    protected final @Nullable IProject initialProject;
    protected @NonNull Map<@NonNull URI, @NonNull DocumentContentSynchronizer> connectedDocuments;
    protected final @Nullable IPath initialPath;
    protected final InitializeParams initParams = new InitializeParams();
    protected StreamConnectionProvider lspStreamProvider;
    private Future<?> launcherFuture;
    private CompletableFuture<Void> initializeFuture;
    private LanguageServer languageServer;
    private LanguageClientImpl languageClient;
    private ServerCapabilities serverCapabilities;
    private Timer timer;
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private final ExecutorService dispatcher;
    private final ExecutorService listener;
    private final @NonNull Map<@NonNull String, @NonNull Runnable> dynamicRegistrations = new HashMap<String, Runnable>();
    private boolean initiallySupportsWorkspaceFolders = false;
    private final @NonNull IResourceChangeListener workspaceFolderUpdater = new WorkspaceFolderListener();

    public LanguageServerWrapper(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        this(project, serverDefinition, null);
    }

    public LanguageServerWrapper(@NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) {
        this(null, serverDefinition, initialPath);
    }

    private LanguageServerWrapper(@Nullable IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) {
        this.initialProject = project;
        this.initialPath = initialPath;
        this.serverDefinition = serverDefinition;
        this.connectedDocuments = new HashMap<URI, DocumentContentSynchronizer>();
        String projectName = project != null && project.getName() != null && !serverDefinition.isSingleton ? "@" + project.getName() : "";
        String dispatcherThreadNameFormat = "LS-" + serverDefinition.id + projectName + "#dispatcher";
        this.dispatcher = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(dispatcherThreadNameFormat).build());
        String listenerThreadNameFormat = "LS-" + serverDefinition.id + projectName + "#listener-%d";
        this.listener = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(listenerThreadNameFormat).build());
    }

    void stopDispatcher() {
        this.dispatcher.shutdownNow();
        this.listener.shutdownNow();
    }

    private List<WorkspaceFolder> getRelevantWorkspaceFolders() {
        LanguageClientImpl languageClient = this.languageClient;
        List<WorkspaceFolder> folders = null;
        if (languageClient != null) {
            try {
                folders = languageClient.workspaceFolders().get(5L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException ex) {
                LanguageServerPlugin.logError(ex);
            }
            catch (InterruptedException ex) {
                LanguageServerPlugin.logError(ex);
                Thread.currentThread().interrupt();
            }
        }
        if (folders == null) {
            folders = LSPEclipseUtils.getWorkspaceFolders();
        }
        return folders;
    }

    public synchronized void start() throws IOException {
        HashMap<URI, IDocument> filesToReconnect = new HashMap<URI, IDocument>();
        if (this.languageServer != null) {
            if (this.isActive()) {
                return;
            }
            for (Map.Entry<URI, DocumentContentSynchronizer> entry : this.connectedDocuments.entrySet()) {
                filesToReconnect.put(entry.getKey(), entry.getValue().getDocument());
            }
            this.stop();
        }
        if (this.initializeFuture == null) {
            URI rootURI = this.getRootURI();
            this.initializeFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                this.lspStreamProvider = LoggingStreamConnectionProviderProxy.shouldLog(this.serverDefinition.id) ? new LoggingStreamConnectionProviderProxy(this.serverDefinition.createConnectionProvider(), this.serverDefinition.id) : this.serverDefinition.createConnectionProvider();
                this.initParams.setInitializationOptions(this.lspStreamProvider.getInitializationOptions(rootURI));
                try {
                    this.lspStreamProvider.start();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }).thenRun(() -> {
                this.languageClient = this.serverDefinition.createLanguageClient();
                this.initParams.setProcessId(Integer.valueOf((int)ProcessHandle.current().pid()));
                if (rootURI != null) {
                    this.initParams.setRootUri(rootURI.toString());
                    this.initParams.setRootPath(rootURI.getPath());
                }
                UnaryOperator wrapper = consumer -> message -> {
                    this.logMessage(message);
                    consumer.consume(message);
                    StreamConnectionProvider currentConnectionProvider = this.lspStreamProvider;
                    if (currentConnectionProvider != null && this.isActive()) {
                        currentConnectionProvider.handleMessage(message, this.languageServer, rootURI);
                    }
                };
                this.initParams.setWorkspaceFolders(this.getRelevantWorkspaceFolders());
                Launcher launcher = this.serverDefinition.createLauncherBuilder().setLocalService((Object)this.languageClient).setRemoteInterface(this.serverDefinition.getServerInterface()).setInput(this.lspStreamProvider.getInputStream()).setOutput(this.lspStreamProvider.getOutputStream()).setExecutorService(this.listener).wrapMessages((Function)wrapper).create();
                this.languageServer = (LanguageServer)launcher.getRemoteProxy();
                this.languageClient.connect(this.languageServer, this);
                this.launcherFuture = launcher.startListening();
            })).thenCompose(unused -> this.initServer(rootURI))).thenAccept(res -> {
                this.serverCapabilities = res.getCapabilities();
                this.initiallySupportsWorkspaceFolders = LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
            })).thenRun(() -> this.languageServer.initialized(new InitializedParams()))).thenRun(() -> {
                HashMap toReconnect = filesToReconnect;
                this.initializeFuture.thenRunAsync(() -> {
                    this.watchProjects();
                    for (Map.Entry fileToReconnect : toReconnect.entrySet()) {
                        try {
                            this.connect((URI)fileToReconnect.getKey(), (IDocument)fileToReconnect.getValue());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
            })).exceptionally(e -> {
                LanguageServerPlugin.logError(e);
                this.initializeFuture.completeExceptionally((Throwable)e);
                this.stop();
                return null;
            });
        }
    }

    private CompletableFuture<InitializeResult> initServer(URI rootURI) {
        String name = Platform.getProduct() != null ? Platform.getProduct().getName() : "Eclipse IDE";
        WorkspaceClientCapabilities workspaceClientCapabilities = SupportedFeatures.getWorkspaceClientCapabilities();
        TextDocumentClientCapabilities textDocumentClientCapabilities = SupportedFeatures.getTextDocumentClientCapabilities();
        WindowClientCapabilities windowClientCapabilities = SupportedFeatures.getWindowClientCapabilities();
        this.initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, windowClientCapabilities, this.lspStreamProvider.getExperimentalFeaturesPOJO()));
        this.initParams.setClientInfo(this.getClientInfo(name));
        this.initParams.setTrace(this.lspStreamProvider.getTrace(rootURI));
        return this.languageServer.initialize(this.initParams);
    }

    private ClientInfo getClientInfo(String name) {
        String pluginVersion = Platform.getBundle((String)"org.eclipse.lsp4e").getVersion().toString();
        ClientInfo clientInfo = new ClientInfo(name, pluginVersion);
        return clientInfo;
    }

    private @Nullable URI getRootURI() {
        IProject project = this.initialProject;
        if (project != null && project.exists()) {
            return LSPEclipseUtils.toUri((IResource)project);
        }
        IPath path = this.initialPath;
        if (path != null) {
            File projectDirectory = path.toFile();
            if (projectDirectory.isFile()) {
                projectDirectory = projectDirectory.getParentFile();
            }
            return LSPEclipseUtils.toUri(projectDirectory);
        }
        return null;
    }

    private static boolean supportsWorkspaceFolders(ServerCapabilities serverCapabilities) {
        return serverCapabilities != null && serverCapabilities.getWorkspace() != null && serverCapabilities.getWorkspace().getWorkspaceFolders() != null && Boolean.TRUE.equals(serverCapabilities.getWorkspace().getWorkspaceFolders().getSupported());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void logMessage(Message message) {
        Message message2 = message;
        if (message2 instanceof ResponseMessage) {
            void responseMessage;
            ResponseMessage responseMessage2 = (ResponseMessage)message2;
            ResponseMessage cfr_ignored_0 = (ResponseMessage)message2;
            if (responseMessage.getError() != null && responseMessage.getId().equals(Integer.toString(ResponseErrorCode.RequestCancelled.getValue()))) {
                LanguageServerPlugin.logError(new ResponseErrorException(responseMessage.getError()));
                return;
            }
        }
        if (!LanguageServerPlugin.DEBUG) return;
        LanguageServerPlugin.logInfo(String.valueOf(message.getClass().getSimpleName()) + '\n' + message);
    }

    public boolean isActive() {
        return this.launcherFuture != null && !this.launcherFuture.isDone() && !this.launcherFuture.isCancelled();
    }

    private void removeStopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void startStopTimer() {
        this.timer = new Timer("Stop Language Server Timer");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                LanguageServerWrapper.this.stop();
            }
        }, TimeUnit.SECONDS.toMillis(this.serverDefinition.lastDocumentDisconnectedTimeout));
    }

    boolean isWrapperFor(LanguageServer server) {
        return server == this.languageServer;
    }

    public synchronized void stop() {
        boolean alreadyStopping = this.stopping.getAndSet(true);
        if (alreadyStopping) {
            return;
        }
        this.removeStopTimer();
        if (this.initializeFuture != null) {
            this.initializeFuture.cancel(true);
            this.initializeFuture = null;
        }
        this.serverCapabilities = null;
        this.dynamicRegistrations.clear();
        Future<?> serverFuture = this.launcherFuture;
        StreamConnectionProvider provider = this.lspStreamProvider;
        LanguageServer languageServerInstance = this.languageServer;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceFolderUpdater);
        Runnable shutdownKillAndStopFutureAndProvider = () -> {
            if (languageServerInstance != null) {
                CompletableFuture shutdown = languageServerInstance.shutdown();
                try {
                    shutdown.get(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    LanguageServerPlugin.logError(ex);
                }
            }
            if (serverFuture != null) {
                serverFuture.cancel(true);
            }
            if (languageServerInstance != null) {
                languageServerInstance.exit();
            }
            if (provider != null) {
                provider.stop();
            }
            this.stopping.set(false);
        };
        CompletableFuture.runAsync(shutdownKillAndStopFutureAndProvider);
        this.launcherFuture = null;
        this.lspStreamProvider = null;
        while (!this.connectedDocuments.isEmpty()) {
            this.disconnect(this.connectedDocuments.keySet().iterator().next());
        }
        this.languageServer = null;
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
    }

    @Deprecated(forRemoval=true)
    public @Nullable CompletableFuture<LanguageServer> connect(@NonNull IFile file, IDocument document) throws IOException {
        CompletableFuture<@NonNull LanguageServerWrapper> connect = this.connect(document, file);
        if (connect != null) {
            return connect.thenApply(theVoid -> this.languageServer);
        }
        return null;
    }

    public @Nullable CompletableFuture<@NonNull LanguageServerWrapper> connect(IDocument document, @NonNull IFile file) throws IOException {
        URI uri = LSPEclipseUtils.toUri((IResource)file);
        if (uri != null) {
            return this.connect(uri, document);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public @Nullable CompletableFuture<LanguageServer> connect(IDocument document) throws IOException {
        CompletableFuture<LanguageServerWrapper> connect2 = this.connectDocument(document);
        if (connect2 != null) {
            return connect2.thenApply(theVoid -> this.languageServer);
        }
        return null;
    }

    public @Nullable CompletableFuture<LanguageServerWrapper> connectDocument(IDocument document) throws IOException {
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists()) {
            return this.connect(document, file);
        }
        URI uri = LSPEclipseUtils.toUri(document);
        return uri == null ? null : this.connect(uri, document);
    }

    private void watchProjects() {
        if (!this.supportsWorkspaceFolderCapability()) {
            return;
        }
        final LanguageServer currentLS = this.languageServer;
        new WorkspaceJob("Setting watch projects on server " + this.serverDefinition.label){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                WorkspaceFoldersChangeEvent wsFolderEvent = new WorkspaceFoldersChangeEvent();
                wsFolderEvent.getAdded().addAll(LanguageServerWrapper.this.getRelevantWorkspaceFolders());
                if (currentLS != null && currentLS == LanguageServerWrapper.this.languageServer) {
                    currentLS.getWorkspaceService().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(wsFolderEvent));
                }
                ResourcesPlugin.getWorkspace().addResourceChangeListener(LanguageServerWrapper.this.workspaceFolderUpdater, 5);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean canOperate(@NonNull IProject project) {
        return project.equals((Object)this.initialProject) || this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }

    private boolean supportsWorkspaceFolderCapability() {
        if (this.initializeFuture != null) {
            try {
                this.initializeFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get if the workspace folder capability is supported due to timeout after 1 second", e);
            }
        }
        return this.initiallySupportsWorkspaceFolders || LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities);
    }

    private @Nullable CompletableFuture<@NonNull LanguageServerWrapper> connect(@NonNull URI uri, IDocument document) throws IOException {
        this.removeStopTimer();
        if (this.connectedDocuments.containsKey(uri)) {
            return CompletableFuture.completedFuture(this);
        }
        this.start();
        if (this.initializeFuture == null) {
            return null;
        }
        if (document == null) {
            IFile docFile = (IFile)LSPEclipseUtils.findResourceFor(uri);
            document = LSPEclipseUtils.getDocument((IResource)docFile);
        }
        if (document == null) {
            return null;
        }
        IDocument theDocument = document;
        return ((CompletableFuture)this.initializeFuture.thenAcceptAsync(theVoid -> {
            Map<URI, DocumentContentSynchronizer> map = this.connectedDocuments;
            synchronized (map) {
                if (this.connectedDocuments.containsKey(uri)) {
                    return;
                }
                TextDocumentSyncKind syncKind = this.initializeFuture == null ? null : (TextDocumentSyncKind)this.serverCapabilities.getTextDocumentSync().map((Function)Functions.identity(), TextDocumentSyncOptions::getChange);
                DocumentContentSynchronizer listener = new DocumentContentSynchronizer(this, this.languageServer, theDocument, syncKind);
                theDocument.addDocumentListener((IDocumentListener)listener);
                this.connectedDocuments.put(uri, listener);
            }
        })).thenApply(theVoid -> this);
    }

    public CompletableFuture<Void> disconnect(URI uri) {
        DocumentContentSynchronizer documentListener = this.connectedDocuments.remove(uri);
        CompletableFuture<Void> documentClosedFuture = null;
        if (documentListener != null) {
            documentListener.getDocument().removeDocumentListener((IDocumentListener)documentListener);
            documentClosedFuture = documentListener.documentClosed();
        }
        if (this.connectedDocuments.isEmpty()) {
            if (this.serverDefinition.lastDocumentDisconnectedTimeout != 0) {
                this.removeStopTimer();
                this.startStopTimer();
            } else {
                this.stop();
            }
        }
        return documentClosedFuture;
    }

    public void disconnectContentType(@NonNull IContentType contentType) {
        ArrayList<URI> urisToDisconnect = new ArrayList<URI>();
        for (URI uri : this.connectedDocuments.keySet()) {
            IFile[] foundFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (foundFiles.length == 0) continue;
            if (!LSPEclipseUtils.getFileContentTypes(foundFiles[0]).stream().anyMatch(contentType::equals)) continue;
            urisToDisconnect.add(uri);
        }
        for (URI uri : urisToDisconnect) {
            this.disconnect(uri);
        }
    }

    public boolean isConnectedTo(URI uri) {
        return this.connectedDocuments.containsKey(uri);
    }

    @Deprecated(forRemoval=true)
    public @Nullable LanguageServer getServer() {
        CompletableFuture<LanguageServer> languagServerFuture = this.getInitializedServer();
        if (Display.getCurrent() != null) {
            return this.languageServer;
        }
        return languagServerFuture.join();
    }

    @Deprecated(forRemoval=true)
    public @NonNull CompletableFuture<LanguageServer> getInitializedServer() {
        try {
            this.start();
        }
        catch (IOException ex) {
            LanguageServerPlugin.logError(ex);
        }
        if (this.initializeFuture != null && !this.initializeFuture.isDone()) {
            if (Display.getCurrent() != null) {
                Job waitForInitialization = new Job(Messages.initializeLanguageServer_job){

                    protected IStatus run(IProgressMonitor monitor) {
                        LanguageServerWrapper.this.initializeFuture.join();
                        return Status.OK_STATUS;
                    }
                };
                waitForInitialization.setUser(true);
                waitForInitialization.setSystem(false);
                PlatformUI.getWorkbench().getProgressService().showInDialog(UI.getActiveShell(), waitForInitialization);
            }
            if (this.initializeFuture != null) {
                return this.initializeFuture.thenApply(r -> this.languageServer);
            }
        }
        return CompletableFuture.completedFuture(this.languageServer);
    }

    public void sendNotification(@NonNull Consumer<LanguageServer> fn) {
        this.getInitializedServer().thenAcceptAsync((Consumer)fn, (Executor)this.dispatcher);
    }

    public <T> CompletableFuture<T> execute(@NonNull Function<LanguageServer, ? extends CompletableFuture<T>> fn) {
        CompletableFuture lsRequest = this.executeImpl(fn);
        CompletionStage future = lsRequest.thenApplyAsync(Function.identity());
        ((CompletableFuture)future).exceptionally(t -> {
            if (t instanceof CancellationException) {
                lsRequest.cancel(true);
            }
            return null;
        });
        return future;
    }

    <T> @NonNull CompletableFuture<T> executeImpl(@NonNull Function<LanguageServer, ? extends CompletableFuture<T>> fn) {
        AtomicReference request = new AtomicReference();
        Function<LanguageServer, CompletableFuture> cancelWrapper = ls -> {
            CompletableFuture res = (CompletableFuture)fn.apply((LanguageServer)ls);
            request.set(res);
            return res;
        };
        CompletionStage res = this.getInitializedServer().thenComposeAsync(cancelWrapper, (Executor)this.dispatcher);
        ((CompletableFuture)res).exceptionally(e -> {
            CompletableFuture stage;
            if (e instanceof CancellationException && (stage = (CompletableFuture)request.get()) != null) {
                stage.cancel(false);
            }
            return null;
        });
        return res;
    }

    public ServerCapabilities getServerCapabilities() {
        try {
            this.getInitializedServer().get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logError("LanguageServer not initialized within 10s", e);
        }
        catch (CancellationException | ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LanguageServerPlugin.logError(e);
        }
        return this.serverCapabilities;
    }

    public String getLanguageId(IContentType[] contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            String languageId = this.serverDefinition.languageIdMappings.get(contentType);
            if (languageId != null) {
                return languageId;
            }
            ++n2;
        }
        return null;
    }

    void registerCapability(RegistrationParams params) {
        params.getRegistrations().forEach(reg -> {
            switch (reg.getMethod()) {
                case "workspace/didChangeWorkspaceFolders": {
                    Assert.isNotNull((Object)this.serverCapabilities, (String)"Dynamic capability registration failed! Server not yet initialized?");
                    if (this.initiallySupportsWorkspaceFolders) break;
                    if (LanguageServerWrapper.supportsWorkspaceFolders(this.serverCapabilities)) {
                        LanguageServerPlugin.logWarning("Dynamic registration of 'workspace/didChangeWorkspaceFolders' ignored. It was already enabled before", null);
                        break;
                    }
                    this.addRegistration((Registration)reg, () -> this.setWorkspaceFoldersEnablement(false));
                    this.setWorkspaceFoldersEnablement(true);
                    break;
                }
                case "workspace/executeCommand": {
                    Gson gson = new Gson();
                    ExecuteCommandOptions executeCommandOptions = (ExecuteCommandOptions)gson.fromJson((JsonElement)((JsonObject)reg.getRegisterOptions()), ExecuteCommandOptions.class);
                    List newCommands = executeCommandOptions.getCommands();
                    if (newCommands.isEmpty()) break;
                    this.addRegistration((Registration)reg, () -> this.unregisterCommands(newCommands));
                    this.registerCommands(newCommands);
                    break;
                }
                case "textDocument/formatting": {
                    Either documentFormattingProvider = this.serverCapabilities.getDocumentFormattingProvider();
                    if (documentFormattingProvider == null || documentFormattingProvider.isLeft()) {
                        this.serverCapabilities.setDocumentFormattingProvider(Boolean.TRUE);
                        this.addRegistration((Registration)reg, () -> this.serverCapabilities.setDocumentFormattingProvider(documentFormattingProvider));
                        break;
                    }
                    this.serverCapabilities.setDocumentFormattingProvider((DocumentFormattingOptions)documentFormattingProvider.getRight());
                    this.addRegistration((Registration)reg, () -> this.serverCapabilities.setDocumentFormattingProvider(documentFormattingProvider));
                    break;
                }
                case "textDocument/rangeFormatting": {
                    Either documentRangeFormattingProvider = this.serverCapabilities.getDocumentRangeFormattingProvider();
                    if (documentRangeFormattingProvider == null || documentRangeFormattingProvider.isLeft()) {
                        this.serverCapabilities.setDocumentRangeFormattingProvider(Boolean.TRUE);
                        this.addRegistration((Registration)reg, () -> this.serverCapabilities.setDocumentRangeFormattingProvider(documentRangeFormattingProvider));
                        break;
                    }
                    this.serverCapabilities.setDocumentRangeFormattingProvider((DocumentRangeFormattingOptions)documentRangeFormattingProvider.getRight());
                    this.addRegistration((Registration)reg, () -> this.serverCapabilities.setDocumentRangeFormattingProvider(documentRangeFormattingProvider));
                    break;
                }
                case "textDocument/codeAction": {
                    Either beforeRegistration = this.serverCapabilities.getCodeActionProvider();
                    this.serverCapabilities.setCodeActionProvider(Boolean.TRUE);
                    this.addRegistration((Registration)reg, () -> this.serverCapabilities.setCodeActionProvider(beforeRegistration));
                    break;
                }
                case "workspace/symbol": {
                    Either workspaceSymbolBeforeRegistration = this.serverCapabilities.getWorkspaceSymbolProvider();
                    this.serverCapabilities.setWorkspaceSymbolProvider(Boolean.TRUE);
                    this.addRegistration((Registration)reg, () -> this.serverCapabilities.setWorkspaceSymbolProvider(workspaceSymbolBeforeRegistration));
                    break;
                }
                case "textDocument/selectionRange": {
                    Either selectionRangeProvider = this.serverCapabilities.getSelectionRangeProvider();
                    if (selectionRangeProvider == null || selectionRangeProvider.isLeft()) {
                        this.serverCapabilities.setSelectionRangeProvider(Boolean.TRUE);
                        this.addRegistration((Registration)reg, () -> this.serverCapabilities.setSelectionRangeProvider(selectionRangeProvider));
                        break;
                    }
                    this.serverCapabilities.setSelectionRangeProvider((SelectionRangeRegistrationOptions)selectionRangeProvider.getRight());
                    this.addRegistration((Registration)reg, () -> this.serverCapabilities.setSelectionRangeProvider(selectionRangeProvider));
                    break;
                }
                case "textDocument/typeHierarchy": {
                    Either typeHierarchyBeforeRegistration = this.serverCapabilities.getTypeHierarchyProvider();
                    this.serverCapabilities.setTypeHierarchyProvider(Boolean.TRUE);
                    this.addRegistration((Registration)reg, () -> this.serverCapabilities.setTypeHierarchyProvider(typeHierarchyBeforeRegistration));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegistration(@NonNull Registration reg, @NonNull Runnable unregistrationHandler) {
        String regId = reg.getId();
        Map<String, Runnable> map = this.dynamicRegistrations;
        synchronized (map) {
            Assert.isLegal((!this.dynamicRegistrations.containsKey(regId) ? 1 : 0) != 0, (String)"Registration id is not unique");
            this.dynamicRegistrations.put(regId, unregistrationHandler);
        }
    }

    synchronized void setWorkspaceFoldersEnablement(boolean enable) {
        WorkspaceFoldersOptions folders;
        WorkspaceServerCapabilities workspace;
        if (enable == this.supportsWorkspaceFolderCapability()) {
            return;
        }
        if (this.serverCapabilities == null) {
            this.serverCapabilities = new ServerCapabilities();
        }
        if ((workspace = this.serverCapabilities.getWorkspace()) == null) {
            workspace = new WorkspaceServerCapabilities();
            this.serverCapabilities.setWorkspace(workspace);
        }
        if ((folders = workspace.getWorkspaceFolders()) == null) {
            folders = new WorkspaceFoldersOptions();
            workspace.setWorkspaceFolders(folders);
        }
        folders.setSupported(Boolean.valueOf(enable));
        if (enable) {
            this.watchProjects();
        }
    }

    synchronized void registerCommands(List<String> newCommands) {
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null) {
            ExecuteCommandOptions commandProvider = caps.getExecuteCommandProvider();
            if (commandProvider == null) {
                commandProvider = new ExecuteCommandOptions(new ArrayList());
                caps.setExecuteCommandProvider(commandProvider);
            }
            List existingCommands = commandProvider.getCommands();
            for (String newCmd : newCommands) {
                Assert.isLegal((!existingCommands.contains(newCmd) ? 1 : 0) != 0, (String)("Command already registered '" + newCmd + "'"));
                existingCommands.add(newCmd);
            }
        } else {
            throw new IllegalStateException("Dynamic command registration failed! Server not yet initialized?");
        }
    }

    void unregisterCapability(UnregistrationParams params) {
        params.getUnregisterations().forEach(reg -> {
            Runnable unregistrator;
            String id = reg.getId();
            Map<String, Runnable> map = this.dynamicRegistrations;
            synchronized (map) {
                unregistrator = this.dynamicRegistrations.get(id);
                this.dynamicRegistrations.remove(id);
            }
            if (unregistrator != null) {
                unregistrator.run();
            }
        });
    }

    void unregisterCommands(List<String> cmds) {
        ExecuteCommandOptions commandProvider;
        ServerCapabilities caps = this.getServerCapabilities();
        if (caps != null && (commandProvider = caps.getExecuteCommandProvider()) != null) {
            List existingCommands = commandProvider.getCommands();
            existingCommands.removeAll(cmds);
        }
    }

    int getVersion(URI uri) {
        DocumentContentSynchronizer documentContentSynchronizer = this.connectedDocuments.get(uri);
        if (documentContentSynchronizer != null) {
            return documentContentSynchronizer.getVersion();
        }
        return -1;
    }

    public boolean canOperate(@NonNull IDocument document) {
        URI documentUri = LSPEclipseUtils.toUri(document);
        if (documentUri == null) {
            return false;
        }
        if (this.isConnectedTo(documentUri)) {
            return true;
        }
        if (this.initialProject == null && this.connectedDocuments.isEmpty()) {
            return true;
        }
        IFile file = LSPEclipseUtils.getFile(document);
        if (file != null && file.exists() && this.canOperate(file.getProject())) {
            return true;
        }
        return this.serverDefinition.isSingleton || this.supportsWorkspaceFolderCapability();
    }

    private final class WorkspaceFolderListener
    implements IResourceChangeListener {
        private WorkspaceFolderListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            WorkspaceFoldersChangeEvent workspaceFolderEvent = this.toWorkspaceFolderEvent(event);
            if (workspaceFolderEvent == null || workspaceFolderEvent.getAdded().isEmpty() && workspaceFolderEvent.getRemoved().isEmpty()) {
                return;
            }
            LanguageServer currentServer = LanguageServerWrapper.this.languageServer;
            if (currentServer != null) {
                currentServer.getWorkspaceService().didChangeWorkspaceFolders(new DidChangeWorkspaceFoldersParams(workspaceFolderEvent));
            }
        }

        /*
         * WARNING - void declaration
         */
        private @Nullable WorkspaceFoldersChangeEvent toWorkspaceFolderEvent(IResourceChangeEvent e) {
            if (!this.isPostChangeEvent(e) && !this.isPreDeletEvent(e)) {
                return null;
            }
            WorkspaceFoldersChangeEvent wsFolderEvent = new WorkspaceFoldersChangeEvent();
            if (this.isPreDeletEvent(e)) {
                IResource resource = e.getResource();
                IResource iResource = resource;
                if (iResource instanceof IProject) {
                    void project;
                    IProject iProject = (IProject)iResource;
                    IProject cfr_ignored_0 = (IProject)iResource;
                    wsFolderEvent.getRemoved().add(LSPEclipseUtils.toWorkspaceFolder((IProject)project));
                    return wsFolderEvent;
                }
                return null;
            }
            List<WorkspaceFolder> relevantFolders = LanguageServerWrapper.this.getRelevantWorkspaceFolders();
            try {
                e.getDelta().accept(delta -> {
                    IResource iResource = delta.getResource();
                    if (iResource instanceof IProject) {
                        void project;
                        IProject iProject = (IProject)iResource;
                        IProject cfr_ignored_0 = (IProject)iResource;
                        WorkspaceFolder wsFolder = LSPEclipseUtils.toWorkspaceFolder((IProject)project);
                        if (relevantFolders.contains(wsFolder) && (this.isAddEvent(delta) || this.isProjectOpenCloseEvent(delta)) && project.isAccessible() && this.isValid(wsFolder)) {
                            wsFolderEvent.getAdded().add(wsFolder);
                        } else if ((this.isRemoveEvent(delta) || this.isProjectOpenCloseEvent(delta)) && !project.isAccessible() && this.isValid(wsFolder)) {
                            wsFolderEvent.getRemoved().add(wsFolder);
                        }
                    }
                    return delta.getResource().getType() == 8;
                });
            }
            catch (CoreException ex) {
                LanguageServerPlugin.logError(ex);
            }
            if (wsFolderEvent.getAdded().isEmpty() && wsFolderEvent.getRemoved().isEmpty()) {
                return null;
            }
            return wsFolderEvent;
        }

        private boolean isPostChangeEvent(IResourceChangeEvent e) {
            return e.getType() == 1;
        }

        private boolean isPreDeletEvent(IResourceChangeEvent e) {
            return e.getType() == 4;
        }

        private boolean isAddEvent(IResourceDelta delta) {
            return delta.getKind() == 1;
        }

        private boolean isRemoveEvent(IResourceDelta delta) {
            return delta.getKind() == 2;
        }

        private boolean isProjectOpenCloseEvent(IResourceDelta delta) {
            return delta.getKind() == 4 && (delta.getFlags() & 0x4000) == 16384;
        }

        private boolean isValid(WorkspaceFolder wsFolder) {
            return wsFolder != null && wsFolder.getUri() != null && !wsFolder.getUri().isEmpty();
        }
    }
}

