/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.utils;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.console.ansi.AnsiConsoleUtils;
import org.eclipse.ui.internal.console.ansi.preferences.AnsiConsolePreferenceUtils;

public class AnsiClipboardUtils {
    public static void textToClipboard(StyledText styledText, boolean removeEscapeSeq) {
        RTFTransfer rtfTransfer;
        Object rtfData;
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.clearContents();
        styledText.copy();
        ArrayList<String> clipboardData = new ArrayList<String>(2);
        ArrayList<Object> clipboardTransfers = new ArrayList<Object>(2);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object textData = clipboard.getContents((Transfer)textTransfer);
        if (textData != null && textData instanceof String) {
            String plainText = (String)textData;
            if (removeEscapeSeq) {
                plainText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_TXT.matcher(plainText).replaceAll("");
            }
            clipboardData.add(plainText);
            clipboardTransfers.add(textTransfer);
        }
        if (AnsiConsolePreferenceUtils.putRtfInClipboard() && (rtfData = clipboard.getContents((Transfer)(rtfTransfer = RTFTransfer.getInstance()))) != null && rtfData instanceof String) {
            String rtfText = (String)rtfData;
            if (removeEscapeSeq) {
                rtfText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_RTF.matcher(rtfText).replaceAll("");
            }
            rtfText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_RTF_FIX_SRC.matcher(rtfText).replaceAll("$0\\\\cb$1");
            clipboardData.add(rtfText);
            clipboardTransfers.add(rtfTransfer);
        }
        clipboard.setContents(clipboardData.toArray(), clipboardTransfers.toArray(new Transfer[0]));
        clipboard.dispose();
    }
}

