/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class NewTextSearchActionGroup
extends ActionGroup {
    private ISelectionProvider fSelectionProvider;
    private IWorkbenchPage fPage;
    private OpenFileAction fOpenAction;
    private PropertyDialogAction fOpenPropertiesDialog;

    public NewTextSearchActionGroup(IViewPart part) {
        Assert.isNotNull((Object)part);
        IWorkbenchPartSite site = part.getSite();
        this.fSelectionProvider = site.getSelectionProvider();
        this.fPage = site.getPage();
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, this.fSelectionProvider);
        this.fOpenAction = new OpenFileAction(this.fPage);
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fOpenPropertiesDialog.selectionChanged((IStructuredSelection)selection);
        } else {
            this.fOpenPropertiesDialog.selectionChanged(selection);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.addOpenWithMenu(menu, (IStructuredSelection)selection);
            if (this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && this.fOpenPropertiesDialog.isApplicableForSelection((IStructuredSelection)selection)) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
            }
        }
    }

    private void addOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection == null) {
            return;
        }
        this.fOpenAction.selectionChanged(selection);
        if (this.fOpenAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.fOpenAction);
        }
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (!(o instanceof IAdaptable)) {
            return;
        }
        MenuManager submenu = new MenuManager(SearchMessages.OpenWithMenu_label);
        submenu.add((IContributionItem)new OpenWithMenu(this.fPage, (IAdaptable)o));
        menu.appendToGroup("group.open", (IContributionItem)submenu);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
    }
}

