/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;

final class BaseThemeAssociationRegistry {
    private @Nullable IThemeAssociation defaultAssociation;
    private final Map<String, @Nullable List<IThemeAssociation>> eclipseThemeIds = new HashMap<String, List<IThemeAssociation>>();
    private final List<IThemeAssociation> allAssociations = new ArrayList<IThemeAssociation>();

    BaseThemeAssociationRegistry() {
    }

    void register(IThemeAssociation association) {
        this.allAssociations.clear();
    }

    void unregister(IThemeAssociation association) {
        this.allAssociations.clear();
    }

    @Nullable IThemeAssociation getThemeAssociationFor(String eclipseThemeId) {
        List<IThemeAssociation> associations = this.eclipseThemeIds.get(eclipseThemeId);
        if (associations != null && associations.size() == 1) {
            return associations.get(0);
        }
        return null;
    }

    IThemeAssociation[] getThemeAssociations(boolean isDefault) {
        return (IThemeAssociation[])this.getThemeAssociations().toArray(IThemeAssociation[]::new);
    }

    @Nullable IThemeAssociation getDefaultAssociation() {
        return this.defaultAssociation;
    }

    IThemeAssociation[] getThemeAssociationsForTheme(String themeId) {
        return (IThemeAssociation[])this.getThemeAssociations().stream().filter(themeAssociation -> themeId.equals(themeAssociation.getThemeId())).collect(Collectors.toList()).toArray(IThemeAssociation[]::new);
    }

    boolean hasThemeAssociationsForTheme(String themeId, String eclipseThemeId) {
        return true;
    }

    List<IThemeAssociation> getThemeAssociations() {
        if (this.allAssociations.isEmpty()) {
            if (this.defaultAssociation != null) {
                this.allAssociations.add(this.defaultAssociation);
            }
            Collection<List<IThemeAssociation>> associations = this.eclipseThemeIds.values();
            for (List<IThemeAssociation> collection : associations) {
                this.allAssociations.addAll(collection);
            }
        }
        return this.allAssociations;
    }
}

