/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.AlgorithmNameProvider;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider
implements AlgorithmNameProvider,
KeySizeIndicator {
    public static final String DEFAULT_ALGORITHM = "EC";
    public static final boolean DEFAULT_ALLOWED_TO_OVERWRITE = true;
    private final AtomicReference<Iterable<KeyPair>> keyPairHolder = new AtomicReference();
    private Path path;
    private String algorithm = "EC";
    private int keySize;
    private AlgorithmParameterSpec keySpec;
    private boolean overwriteAllowed = true;

    protected AbstractGeneratorHostKeyProvider() {
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path == null ? null : path.toAbsolutePath();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public AlgorithmParameterSpec getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(AlgorithmParameterSpec keySpec) {
        this.keySpec = keySpec;
    }

    public boolean isOverwriteAllowed() {
        return this.overwriteAllowed;
    }

    public void setOverwriteAllowed(boolean overwriteAllowed) {
        this.overwriteAllowed = overwriteAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLoadedKeys() {
        Iterable ids;
        AtomicReference<Iterable<KeyPair>> atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            ids = this.keyPairHolder.getAndSet(null);
        }
        if (ids != null & this.log.isDebugEnabled()) {
            this.log.debug("clearLoadedKeys({}) removed keys", (Object)this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<KeyPair> loadKeys(SessionContext session) {
        Iterable<KeyPair> ids;
        Path keyPath = this.getPath();
        AtomicReference<Iterable<KeyPair>> atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            ids = this.keyPairHolder.get();
            if (ids == null) {
                try {
                    ids = this.resolveKeyPairs(session, keyPath);
                    if (ids != null) {
                        this.keyPairHolder.set(ids);
                    }
                }
                catch (Throwable t) {
                    this.warn("loadKeys({}) Failed ({}) to resolve: {}", keyPath, t.getClass().getSimpleName(), t.getMessage(), t);
                }
            }
        }
        ArrayList<KeyPair> pairs = Collections.emptyList();
        if (ids instanceof List) {
            pairs = (ArrayList<KeyPair>)ids;
        } else if (ids != null) {
            pairs = new ArrayList<KeyPair>();
            for (KeyPair kp : ids) {
                if (kp == null) continue;
                pairs.add(kp);
            }
        }
        return pairs;
    }

    protected Iterable<KeyPair> resolveKeyPairs(SessionContext session, Path keyPath) throws IOException, GeneralSecurityException {
        String alg = this.getAlgorithm();
        if (keyPath != null) {
            try {
                Iterable<KeyPair> ids = this.loadFromFile(session, alg, keyPath);
                KeyPair kp = GenericUtils.head(ids);
                if (kp != null) {
                    return ids;
                }
            }
            catch (Throwable e) {
                this.warn("resolveKeyPair({}) Failed ({}) to load: {}", keyPath, e.getClass().getSimpleName(), e.getMessage(), e);
            }
        }
        KeyPair kp = null;
        try {
            kp = this.generateKeyPair(alg);
            if (kp == null) {
                return null;
            }
            if (this.log.isDebugEnabled()) {
                PublicKey key = kp.getPublic();
                this.log.debug("resolveKeyPair({}) generated {} key={}-{}", new Object[]{keyPath, alg, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key)});
            }
        }
        catch (Throwable e) {
            this.warn("resolveKeyPair({})[{}] Failed ({}) to generate {} key-pair: {}", keyPath, alg, e.getClass().getSimpleName(), alg, e.getMessage(), e);
            return null;
        }
        if (keyPath != null) {
            try {
                this.writeKeyPair(kp, keyPath, new OpenOption[0]);
            }
            catch (Throwable e) {
                this.warn("resolveKeyPair({})[{}] Failed ({}) to write {} key: {}", alg, keyPath, e.getClass().getSimpleName(), alg, e.getMessage(), e);
            }
        }
        return Collections.singletonList(kp);
    }

    protected Iterable<KeyPair> loadFromFile(SessionContext session, String alg, Path keyPath) throws IOException, GeneralSecurityException {
        LinkOption[] options = IoUtils.getLinkOptions(true);
        if (!Files.exists(keyPath, options) || !Files.isRegularFile(keyPath, options)) {
            return null;
        }
        Iterable<KeyPair> ids = this.readKeyPairs(session, keyPath, IoUtils.EMPTY_OPEN_OPTIONS);
        KeyPair kp = GenericUtils.head(ids);
        if (kp == null) {
            return null;
        }
        PublicKey key = kp.getPublic();
        String keyAlgorithm = key.getAlgorithm();
        if ("ECDSA".equalsIgnoreCase(keyAlgorithm)) {
            keyAlgorithm = DEFAULT_ALGORITHM;
        } else if ("ED25519".equalsIgnoreCase(keyAlgorithm)) {
            keyAlgorithm = "EdDSA";
        }
        if (Objects.equals(alg, keyAlgorithm)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveKeyPair({}) loaded key={}-{}", new Object[]{keyPath, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key)});
            }
            return ids;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveKeyPair({}) mismatched loaded key algorithm: expected={}, loaded={}", new Object[]{keyPath, alg, keyAlgorithm});
        }
        Files.deleteIfExists(keyPath);
        return null;
    }

    protected Iterable<KeyPair> readKeyPairs(SessionContext session, Path keyPath, OpenOption ... options) throws IOException, GeneralSecurityException {
        PathResource location = new PathResource(keyPath, options);
        try (InputStream inputStream = location.openInputStream();){
            Iterable<KeyPair> iterable = this.doReadKeyPairs(session, location, inputStream);
            return iterable;
        }
    }

    protected Iterable<KeyPair> doReadKeyPairs(SessionContext session, NamedResource resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
        return SecurityUtils.loadKeyPairIdentities(session, resourceKey, inputStream, null);
    }

    protected void writeKeyPair(KeyPair kp, Path keyPath, OpenOption ... options) throws IOException, GeneralSecurityException {
        if (!Files.exists(keyPath, new LinkOption[0]) || this.isOverwriteAllowed()) {
            PathResource location = new PathResource(keyPath);
            try (OutputStream os = Files.newOutputStream(keyPath, options);){
                this.doWriteKeyPair(location, kp, os);
            }
            catch (Throwable e) {
                this.warn("writeKeyPair({}) failed ({}) to write key {}: {}", keyPath, e.getClass().getSimpleName(), kp, e.getMessage(), e);
            }
        } else {
            this.log.error("Overwriting key ({}) is disabled: using throwaway {}: {}", new Object[]{keyPath, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp == null ? null : kp.getPublic())});
        }
    }

    protected abstract void doWriteKeyPair(NamedResource var1, KeyPair var2, OutputStream var3) throws IOException, GeneralSecurityException;

    protected KeyPair generateKeyPair(String algorithm) throws GeneralSecurityException {
        KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator(algorithm);
        if (this.keySpec != null) {
            generator.initialize(this.keySpec);
            this.log.info("generateKeyPair(" + algorithm + ") generating host key - spec=" + this.keySpec.getClass().getSimpleName());
        } else if (DEFAULT_ALGORITHM.equals(algorithm)) {
            ECCurves curve;
            if (this.keySize == 0) {
                int numCurves = ECCurves.SORTED_KEY_SIZE.size();
                curve = ECCurves.SORTED_KEY_SIZE.get(numCurves - 1);
            } else {
                curve = ECCurves.fromCurveSize(this.keySize);
                if (curve == null) {
                    throw new InvalidKeyException("No match found for curve with key size=" + this.keySize);
                }
            }
            generator.initialize(curve.getParameters());
            this.log.info("generateKeyPair(" + algorithm + ") generating host key=" + curve);
        } else if (this.keySize != 0) {
            generator.initialize(this.keySize);
            this.log.info("generateKeyPair(" + algorithm + ") generating host key - size=" + this.keySize);
        }
        return generator.generateKeyPair();
    }
}

