/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class BeginBlockEvent
extends DocumentBuilderEvent {
    private final DocumentBuilder.BlockType type;
    private final Attributes attributes;

    public BeginBlockEvent(DocumentBuilder.BlockType type, Attributes attributes) {
        this.type = Objects.requireNonNull(type, "Must provide a blockType");
        this.attributes = Objects.requireNonNull(attributes, "Must provide attributes").clone();
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.beginBlock(this.type, this.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeginBlockEvent)) {
            return false;
        }
        BeginBlockEvent other = (BeginBlockEvent)obj;
        return this.type == other.type;
    }

    public String toString() {
        return String.format("beginBlock(%s)", new Object[]{this.type});
    }
}

