/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitInfoBuilder;
import org.eclipse.egit.ui.internal.history.GitCommitReference;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;

class FormatJob
extends Job {
    private Object lock = new Object();
    private FormatRequest formatRequest;
    private FormatResult formatResult;

    public boolean belongsTo(Object family) {
        if (JobFamilies.FORMAT_COMMIT_INFO.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    FormatJob(FormatRequest formatRequest) {
        super(UIText.FormatJob_buildingCommitInfo);
        this.formatRequest = formatRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FormatResult getFormatResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.formatResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        FormatResult commitInfo;
        Object object;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            CommitInfoBuilder builder;
            object = this.lock;
            synchronized (object) {
                SWTCommit commit = (SWTCommit)this.formatRequest.getCommit();
                commit.parseBody();
                builder = new CommitInfoBuilder(this.formatRequest.getRepository(), commit, this.formatRequest.isFill(), this.formatRequest.getAllRefs());
            }
            commitInfo = builder.format(monitor);
        }
        catch (IOException e) {
            return Activator.createErrorStatus(e.getMessage(), e);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        object = this.lock;
        synchronized (object) {
            this.formatResult = commitInfo;
        }
        return Status.OK_STATUS;
    }

    static class FormatRequest {
        private Repository repository;
        private PlotCommit<?> commit;
        private boolean fill;
        private Collection<Ref> allRefs;

        public Collection<Ref> getAllRefs() {
            return this.allRefs;
        }

        public void setAllRefs(Collection<Ref> allRefs) {
            this.allRefs = allRefs;
        }

        FormatRequest(Repository repository, PlotCommit<?> commit, boolean fill, Collection<Ref> allRefs) {
            this.repository = repository;
            this.commit = commit;
            this.fill = fill;
            this.allRefs = allRefs;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public PlotCommit<?> getCommit() {
            return this.commit;
        }

        public boolean isFill() {
            return this.fill;
        }
    }

    static class FormatResult {
        private final String commitInfo;
        private final List<GitCommitReference> knownLinks;
        private final int headerEnd;
        private final int footerStart;

        FormatResult(String commmitInfo, List<GitCommitReference> links, int headerEnd, int footerStart) {
            this.commitInfo = commmitInfo;
            this.knownLinks = links;
            this.headerEnd = headerEnd;
            this.footerStart = footerStart;
        }

        public String getCommitInfo() {
            return this.commitInfo;
        }

        public List<GitCommitReference> getKnownLinks() {
            return this.knownLinks;
        }

        public int getHeaderEnd() {
            return this.headerEnd;
        }

        public int getFooterStart() {
            return this.footerStart;
        }
    }
}

