/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveStepActionToolBarProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

class PlanContextMenuAction
extends Action {
    private RebaseInteractivePlan.ElementAction action;
    private TreeViewer planViewer;
    private RebaseInteractiveStepActionToolBarProvider actionToolbarProvider;

    public PlanContextMenuAction(String text, ImageDescriptor image, RebaseInteractivePlan.ElementAction action, TreeViewer planViewer, RebaseInteractiveStepActionToolBarProvider actionToolbarProvider) {
        super(text, image);
        int accelerator = actionToolbarProvider.getActionAccelerators().get(action);
        if (accelerator == 127) {
            this.setText(String.valueOf(text) + '\t' + SWTKeySupport.getKeyFormatterForPlatform().format(SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator)));
        }
        this.setAccelerator(accelerator);
        this.action = action;
        this.planViewer = planViewer;
        this.actionToolbarProvider = actionToolbarProvider;
    }

    public void run() {
        ISelection selection = this.planViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedRow : structuredSelection.toList()) {
                if (!(selectedRow instanceof RebaseInteractivePlan.PlanElement)) continue;
                RebaseInteractivePlan.PlanElement planElement = (RebaseInteractivePlan.PlanElement)selectedRow;
                planElement.setPlanElementAction(this.action);
            }
            this.actionToolbarProvider.mapActionItemsToSelection(selection);
        }
    }
}

