"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const index_1 = require("../index");
describe('random tests', () => {
    it('random insert delete', () => {
        let pieceTreeTextBufferBuilder = new index_1.PieceTreeTextBufferBuilder();
        pieceTreeTextBufferBuilder.acceptChunk('abc\n');
        pieceTreeTextBufferBuilder.acceptChunk('def');
        let pieceTreeFactory = pieceTreeTextBufferBuilder.finish(true);
        let pieceTree = pieceTreeFactory.create(1 /* LF */);
        expect(pieceTree.getLineCount()).toEqual(2);
        expect(pieceTree.getLineContent(1)).toEqual('abc');
        expect(pieceTree.getLineContent(2)).toEqual('def');
        pieceTree.insert(1, '+');
        expect(pieceTree.getLineCount()).toEqual(2);
        expect(pieceTree.getLineContent(1)).toEqual('a+bc');
        expect(pieceTree.getLineContent(2)).toEqual('def');
    });
});
