/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class SignatureHelper {
    public static final char C_WHITESPACE = ' ';
    public static final char C_COMMA = ',';

    public static String getSignatureResolvedName(char[] typeSignature, IType relativeType) {
        StringBuffer buffer = new StringBuffer();
        try {
            SignatureHelper.computeSignatureResolvedName(typeSignature, relativeType, buffer);
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        return buffer.toString();
    }

    private static void computeSignatureResolvedName(char[] typeSignature, IType relativeType, StringBuffer buffer) throws JavaModelException {
        char[] erasureType = Signature.getTypeErasure((char[])typeSignature);
        if (erasureType != null) {
            SignatureHelper.computeSignatureResolvedNameNoNesting(erasureType, relativeType, buffer);
        } else {
            char[] variableName = Signature.getTypeVariable((char[])typeSignature);
            if (variableName != null) {
                buffer.append(variableName);
            }
        }
        char[][] typeArgs = Signature.getTypeArguments((char[])typeSignature);
        if (typeArgs != null && typeArgs.length > 0) {
            buffer.append('<');
            int i = 0;
            while (i < typeArgs.length) {
                SignatureHelper.computeSignatureResolvedName(typeArgs[i], relativeType, buffer);
                if (i + 1 < typeArgs.length) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append('>');
        }
    }

    private static void computeSignatureResolvedNameNoNesting(char[] typeSignature, IType relativeType, StringBuffer buffer) throws JavaModelException {
        switch (Signature.getTypeSignatureKind((char[])typeSignature)) {
            case 1: {
                if (typeSignature[0] == 'L') {
                    buffer.append(Signature.toCharArray((char[])typeSignature));
                    break;
                }
                buffer.append(Signature.toQualifiedName((String[])relativeType.resolveType(new String(Signature.toCharArray((char[])typeSignature)))[0]));
                break;
            }
            case 5: {
                if (typeSignature.length > 1 && typeSignature[1] == 'Q') {
                    char[] wildcardType = new char[typeSignature.length - 3];
                    System.arraycopy(typeSignature, 2, wildcardType, 0, wildcardType.length);
                    String resolvedType = Signature.toQualifiedName((String[])relativeType.resolveType(new String(wildcardType))[0]);
                    char[] resolvedTypeChars = resolvedType.toCharArray();
                    if (resolvedTypeChars.length > typeSignature.length - 3) {
                        char[] result = new char[resolvedTypeChars.length + 3];
                        result[0] = typeSignature[0];
                        result[1] = 76;
                        System.arraycopy(resolvedTypeChars, 0, result, 2, resolvedTypeChars.length);
                        result[result.length - 1] = 59;
                        buffer.append(Signature.toCharArray((char[])result));
                        break;
                    }
                }
            }
            default: {
                buffer.append(Signature.getSignatureSimpleName((char[])typeSignature));
            }
        }
    }
}

