/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.JavadocCoverage;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.internal.Type;

public class ClassAPI
extends Type {
    private String superClass;
    private List interfaces;
    private int access = -1;
    private Map methodAPIs;
    private Map fieldAPIs;
    private JavadocCoverage javadocCoverage;

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public void addInterface(String interfaz) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList();
        }
        this.interfaces.add(interfaz);
    }

    public Collection getInterfaces() {
        if (this.interfaces == null) {
            return new ArrayList(0);
        }
        return new ArrayList(this.interfaces);
    }

    public Collection getFieldAPIs() {
        if (this.fieldAPIs == null) {
            this.fieldAPIs = new HashMap(1);
        }
        return this.fieldAPIs.values();
    }

    public FieldAPI getFieldAPI(String name) {
        if (this.fieldAPIs == null) {
            return null;
        }
        return (FieldAPI)this.fieldAPIs.get(name);
    }

    public void addFieldAPI(FieldAPI fieldAPI) {
        if (this.fieldAPIs == null) {
            this.fieldAPIs = new HashMap(1);
        }
        this.fieldAPIs.put(fieldAPI.getName(), fieldAPI);
    }

    public void removeFieldAPI(FieldAPI fieldAPI) {
        this.fieldAPIs.remove(fieldAPI.getName());
    }

    public int sizeFieldAPIs() {
        return this.fieldAPIs != null ? this.fieldAPIs.size() : 0;
    }

    public Collection getMethodAPIs() {
        if (this.methodAPIs == null) {
            this.methodAPIs = new HashMap(1);
        }
        return this.methodAPIs.values();
    }

    public MethodAPI getMethodAPI(String name, String descriptor) {
        if (this.methodAPIs == null) {
            return null;
        }
        StringBuffer key = new StringBuffer();
        key.append(name);
        key.append(" ");
        key.append(descriptor);
        MethodAPI result = (MethodAPI)this.methodAPIs.get(key.toString());
        if (result != null) {
            return result;
        }
        if (name.indexOf("<") > -1) {
            return this.getMethodAPI(name.replaceFirst("<", "&lt;"), descriptor);
        }
        return null;
    }

    public MethodAPI getMethodAPI(String name, List inputs, String returnType) {
        Iterator it = this.methodAPIs.values().iterator();
        while (it.hasNext()) {
            MethodAPI methodAPI = (MethodAPI)it.next();
            if (!name.equals(methodAPI.getName()) || !this.match(inputs, methodAPI.getInputs()) || !methodAPI.getReturn().endsWith(returnType)) continue;
            return methodAPI;
        }
        return null;
    }

    private boolean match(List list1, List list2) {
        if (list1.size() == list2.size()) {
            int i = 0;
            while (i < list1.size()) {
                String x = (String)list1.get(0);
                String y = (String)list2.get(0);
                if (!y.endsWith(x)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void addMethodAPI(MethodAPI methodAPI) {
        if (this.methodAPIs == null) {
            this.methodAPIs = new HashMap(1);
        }
        StringBuffer key = new StringBuffer();
        key.append(methodAPI.getName());
        key.append(" ");
        key.append(methodAPI.getDescriptor());
        this.methodAPIs.put(key.toString(), methodAPI);
    }

    public void removeMethodAPI(MethodAPI methodAPI) {
        StringBuffer key = new StringBuffer();
        key.append(methodAPI.getName());
        key.append(" ");
        key.append(methodAPI.getDescriptor());
        this.methodAPIs.remove(key.toString());
    }

    public int sizeMethodAPIs() {
        return this.methodAPIs != null ? this.methodAPIs.size() : 0;
    }

    public JavadocCoverage getJavadocCoverage() {
        if (this.javadocCoverage == null) {
            this.javadocCoverage = new JavadocCoverage();
        }
        return this.javadocCoverage;
    }

    public void setJavadocCoverage(JavadocCoverage javadocCoverage) {
        this.javadocCoverage = javadocCoverage;
    }

    public boolean isSetJavadocCoverage() {
        return this.javadocCoverage != null;
    }

    public String toString() {
        int access;
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("<class-api");
        sb.append(this.toAttribute("name", this.getName()));
        sb.append(this.toAttribute("super", this.getSuperClass()));
        if (this.interfaces != null) {
            StringBuffer interfacesAttr = new StringBuffer();
            it = this.interfaces.iterator();
            boolean hasNext = it.hasNext();
            while (hasNext) {
                interfacesAttr.append((String)it.next());
                hasNext = it.hasNext();
                if (!hasNext) continue;
                interfacesAttr.append(" ");
            }
            sb.append(this.toAttribute("interfaces", interfacesAttr.toString()));
        }
        if ((access = this.getAccess()) != -1) {
            sb.append(this.toAttribute("access", String.valueOf(access)));
        }
        if (this.getReference() != null) {
            sb.append(this.toAttribute("reference", String.valueOf(this.isReference())));
        }
        if (this.getImplement() != null) {
            sb.append(this.toAttribute("implement", String.valueOf(this.isImplement())));
        }
        if (this.getSubclass() != null) {
            sb.append(this.toAttribute("subclass", String.valueOf(this.isSubclass())));
        }
        if (this.getInstantiate() != null) {
            sb.append(this.toAttribute("instantiate", String.valueOf(this.isInstantiate())));
        }
        sb.append(">");
        if (this.javadocCoverage != null) {
            sb.append(this.javadocCoverage.toString());
        }
        if (this.sizeMethodAPIs() > 0) {
            it = this.getMethodAPIs().iterator();
            while (it.hasNext()) {
                sb.append(((MethodAPI)it.next()).toString());
            }
        }
        if (this.sizeFieldAPIs() > 0) {
            it = this.getFieldAPIs().iterator();
            while (it.hasNext()) {
                sb.append(((FieldAPI)it.next()).toString());
            }
        }
        sb.append("</class-api>");
        return sb.toString();
    }
}

