/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.File;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.ZipLocation;

public abstract class Location
implements ILocation {
    protected ILocation parent;
    protected String name;

    public Location(ILocation parent, String fullName) {
        this.parent = parent;
        this.name = fullName.replace('\\', '/');
    }

    public void accept(ILocationVisitor visitor) {
        if (visitor.accept(this) && this.hasChildren()) {
            ILocationChildrenIterator i = this.childIterator();
            ILocation child = i.next();
            while (child != null) {
                child.accept(visitor);
                child = i.next();
            }
        }
    }

    public ILocation getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public static ILocation createLocation(File file) {
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            return new FileLocation(file);
        }
        if (Location.isArchive(file.getAbsolutePath())) {
            return new ZipLocation(file);
        }
        return new FileLocation(file);
    }

    public static boolean isArchive(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() < 5) {
            return false;
        }
        int index = path.length() - 1;
        char extChar = path.charAt(index--);
        block0 : switch (extChar) {
            case 'P': 
            case 'p': {
                if (!path.endsWith(".zip")) break;
                return true;
            }
            case 'R': 
            case 'r': {
                extChar = path.charAt(index--);
                switch (extChar) {
                    case 'A': 
                    case 'a': {
                        extChar = path.charAt(index--);
                        switch (extChar) {
                            case 'J': 
                            case 'j': {
                                if (path.charAt(index) != '.') break block0;
                                return true;
                            }
                            case 'E': 
                            case 'e': {
                                if (path.charAt(index) != '.') break block0;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public static String getExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return path.substring(index + 1).toLowerCase();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ILocation) {
            ILocation location = this;
            ILocation otherLocation = (ILocation)object;
            do {
                if (!location.getName().equals(otherLocation.getName())) {
                    return false;
                }
                location = location.getParent();
                otherLocation = otherLocation.getParent();
            } while (location != null && otherLocation != null);
            if (location == null) {
                return otherLocation == null;
            }
            return otherLocation != null;
        }
        return false;
    }

    public int hashCode() {
        StringBuffer b = new StringBuffer();
        ILocation location = this;
        while (location != null) {
            b.insert(0, this.getName());
            location = location.getParent();
        }
        return b.toString().hashCode();
    }
}

