/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.adopters.ComponentTeamScanner;
import org.eclipse.wtp.releng.tools.component.adopters.IOutputConstants;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class CombineExtensionPointScans
extends ComponentTeamScanner
implements IOutputConstants {
    private static final String ARG_SOURCE = "sourceFiles";
    private static final String ARG_OUTPUT = "output";
    private Collection sourceFiles;
    private String output;
    private static final String EXTENSION_POINT_USAGE_FILE = "org/eclipse/wtp/releng/tools/component/xsl/extpt.xsl";
    private static final String HTML_OUTPUT_EXTENSION = "/combinedExtPtUsage.html";
    private static final String ORG_ECLIPSE = "org.eclipse.";
    private static final String BEGIN_TD = "<td>";
    private static final String END_TD = "</td>";

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get(ARG_SOURCE);
        Collection output = (Collection)options.get(ARG_OUTPUT);
        if (src == null || output == null) {
            CombineExtensionPointScans.printUsage();
            System.exit(-1);
        }
        CombineExtensionPointScans combineExtPtUsage = new CombineExtensionPointScans();
        combineExtPtUsage.setOutput((String)output.iterator().next());
        combineExtPtUsage.setSourceFiles(src);
        combineExtPtUsage.execute();
    }

    public void execute() {
        Iterator sourceFilesIterator = this.getSourceFiles().iterator();
        while (sourceFilesIterator.hasNext()) {
            String file = (String)sourceFilesIterator.next();
            this.processFile(file);
        }
        this.generateHTMLFile();
    }

    private void processFile(String fileLocation) {
        try {
            String currentLine;
            FileInputStream fstream = new FileInputStream(fileLocation);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int useCount = 0;
            while ((currentLine = br.readLine()) != null) {
                if (currentLine.indexOf(ORG_ECLIPSE) < 0) continue;
                int beginExtPtName = currentLine.indexOf(BEGIN_TD) + 4;
                int endExtPtName = currentLine.indexOf(END_TD);
                String extensionPointName = currentLine.substring(beginExtPtName, endExtPtName);
                int beginUseCount = currentLine.lastIndexOf(BEGIN_TD) + 4;
                int endUseCount = currentLine.lastIndexOf(END_TD);
                useCount = Integer.parseInt(currentLine.substring(beginUseCount, endUseCount));
                ComponentTeamScanner.ComponentTeam compTeam = this.getComponentTeam(extensionPointName);
                String previousCount = (String)compTeam.getExtensionPointReferenceCounts().get(extensionPointName);
                if (previousCount == null) {
                    compTeam.getExtensionPointReferenceCounts().put(extensionPointName, String.valueOf(useCount));
                    continue;
                }
                compTeam.getExtensionPointReferenceCounts().put(extensionPointName, String.valueOf(Integer.parseInt(previousCount) + useCount));
            }
            in.close();
            fstream.close();
            br.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void generateHTMLFile() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("<root>".getBytes());
            int i = 0;
            while (i < this.getComponentTeams().size()) {
                ComponentTeamScanner.ComponentTeam compTeam = (ComponentTeamScanner.ComponentTeam)this.getComponentTeams().get(i);
                this.writeCompTeamXML(compTeam, baos);
                ++i;
            }
            baos.write("</root>".getBytes());
            baos.close();
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream(EXTENSION_POINT_USAGE_FILE), new ByteArrayInputStream(baos.toByteArray()), (OutputStream)new FileOutputStream(String.valueOf(this.getOutput()) + HTML_OUTPUT_EXTENSION));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void writeCompTeamXML(ComponentTeamScanner.ComponentTeam compTeam, ByteArrayOutputStream baos) throws IOException {
        baos.write("<team lead=\"".getBytes());
        baos.write(compTeam.getTeamName().getBytes());
        baos.write("\">".getBytes());
        Iterator it = compTeam.getExtensionPointReferenceCounts().keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String refCount = (String)compTeam.getExtensionPointReferenceCounts().get(id);
            baos.write("<extpt id=\"".getBytes());
            baos.write(id.getBytes());
            baos.write("\" ref=\"".getBytes());
            baos.write(refCount.getBytes());
            baos.write("\"/>".getBytes());
        }
        baos.write("</team>".getBytes());
    }

    public Collection getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(Collection sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.adopters.CombineExtensionPointScans -sourceFiles <sourcFiles> -output <output>");
        System.out.println("");
        System.out.println("\t-sourceFiles\t\t<sourceFiles>\t\tlocation of your extension point usage reports");
        System.out.println("\t-output\t<output>\t\tlocation of the output file");
    }
}

