/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;

public class TestTemplateModeCompletionProposal
extends AbstractSourceViewerTest {
    public void testModeProposals() throws Exception {
        this.fileName = "modeTest.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int chars = 36;
        int line = 16;
        try {
            int offset = document.getLineOffset(line) + chars;
            ICompletionProposal[] proposals = this.getProposals(offset);
            this.assertProposalExists("\"#all\"", proposals);
            this.assertProposalExists("mode1", proposals);
            this.assertProposalExists("mode2", proposals);
            this.assertProposalExists("mode3", proposals);
        }
        finally {
            this.model.releaseFromEdit();
        }
    }

    private void assertProposalExists(String expected, ICompletionProposal[] proposal) throws Exception {
        TestTemplateModeCompletionProposal.assertNotNull((String)"No proposals.", (Object)proposal);
        boolean foundsw = false;
        int i = 0;
        while (i < proposal.length) {
            if (proposal[i].getDisplayString().equals(expected)) {
                foundsw = true;
                break;
            }
            ++i;
        }
        if (!foundsw) {
            TestTemplateModeCompletionProposal.fail((String)("Proposal " + expected + " was not found in the proposal list."));
        }
    }
}

