/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.util;

import java.util.Enumeration;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;

public final class Debug {
    public static final boolean checkForMemoryLeaks = false;
    public static final boolean collectStats = false;
    public static final int DEBUG = 0;
    public static final boolean DEBUG_THREADLOCAL = false;
    public static final boolean debugBreakpoints = false;
    public static final boolean debugCaretMediator = false;
    public static final boolean debugDisplayTreePositions = false;
    public static final boolean debugMediator = false;
    public static final boolean debugNotification = false;
    public static final boolean debugNotificationAndEvents = false;
    public static final boolean debugNotifyDeferred = false;
    public static final boolean debugReconciling = false;
    public static final boolean debugRtfFormatProvider = false;
    public static final boolean debugStructuredDocument = false;
    public static final boolean debugTaglibs = false;
    public static final boolean debugTokenizer = false;
    public static final boolean debugLauncher = false;
    public static final boolean debugXSLModel = false;
    public static final boolean debugTreeModel = false;
    public static final boolean debugUpdateTreePositions = false;
    public static final boolean displayInfo = false;
    public static final boolean displayToConsole = true;
    public static final boolean displayWarnings = false;
    public static final boolean headParsing = false;
    public static final boolean jsDebugContextAssist = false;
    public static final boolean jsDebugSyntaxColoring = false;
    public static final boolean LOCKS = false;
    public static final boolean perfTest = false;
    public static final boolean perfTestAdapterClassLoading = false;
    public static final boolean perfTestFormat = false;
    public static final boolean perfTestRawStructuredDocumentOnly = false;
    public static final boolean perfTestStructuredDocumentEventOnly = false;
    public static final boolean perfTestStructuredDocumentOnly = false;
    public static final boolean syntaxHighlighting = false;
    public static final boolean useStandardEolInWidget = false;

    public static final void dump(IStructuredDocument structuredDocument) {
        Debug.dump(structuredDocument, false);
    }

    public static final void dump(IStructuredDocument structuredDocument, boolean verbose) {
        ITextRegionCollection flatNode = null;
        System.out.println("Dump of structuredDocument:");
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        Enumeration structuredDocumentRegions = flatNodes.elements();
        while (structuredDocumentRegions.hasMoreElements()) {
            flatNode = (ITextRegionCollection)structuredDocumentRegions.nextElement();
            if (!verbose) {
                String outString = flatNode.toString();
                outString = StringUtils.escape((String)outString);
                System.out.println(outString);
                continue;
            }
            Debug.dump(flatNode, verbose);
        }
        System.out.println();
        System.out.println("= = = = = =");
        System.out.println();
    }

    public static final void dump(ITextRegionCollection region, boolean verbose) {
        if (region == null) {
            return;
        }
        if (verbose) {
            Debug.printParent(region);
        }
        Debug.printChildRegions(region, 0);
    }

    private static void printChildRegions(ITextRegionCollection region, int depth) {
        if (region != null) {
            System.out.println(region);
            ITextRegionList regionList = region.getRegions();
            int i = 0;
            while (i < regionList.size()) {
                ITextRegion r = regionList.get(i);
                if (r instanceof ITextRegionCollection) {
                    ITextRegionCollection rc = (ITextRegionCollection)r;
                    Debug.printChildRegions(rc, depth++);
                } else {
                    System.out.println(String.valueOf(Debug.space(depth)) + r);
                    --depth;
                }
                ++i;
            }
        }
    }

    public static final synchronized void println(String msg) {
        System.out.println(String.valueOf(System.currentTimeMillis()) + "\t" + msg);
    }

    private static void printParent(IStructuredDocumentRegion region) {
        System.out.println("    [parent document: " + Debug.toStringUtil(region.getParentDocument()) + "]");
    }

    private static void printParent(ITextRegionCollection region) {
        if (region instanceof IStructuredDocumentRegion) {
            Debug.printParent((IStructuredDocumentRegion)region);
        } else if (region instanceof ITextRegionContainer) {
            Debug.printParent((ITextRegionContainer)region);
        } else {
            System.out.println("    [parent document: (na)]");
        }
    }

    private static void printParent(ITextRegionContainer region) {
        System.out.println("    [parent document: " + Debug.toStringUtil(region.getParent()) + "]");
    }

    private static String space(int depth) {
        String result = "  ";
        int i = 0;
        while (i < depth) {
            result = String.valueOf(result) + "  ";
            ++i;
        }
        return result;
    }

    public static final String toStringUtil(IStructuredDocument object) {
        String shortClassName;
        String className = object.getClass().getName();
        String result = shortClassName = className.substring(className.lastIndexOf(".") + 1);
        return result;
    }

    public static final String toStringUtil(ITextRegionCollection object) {
        String shortClassName;
        String className = object.getClass().getName();
        String result = shortClassName = className.substring(className.lastIndexOf(".") + 1);
        return result;
    }
}

