/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;

public class XSFloat
extends NumericType {
    private float _value;

    public XSFloat(float x) {
        this._value = x;
    }

    public XSFloat() {
        this(0.0f);
    }

    public String string_type() {
        return "xs:float";
    }

    public String type_name() {
        return "float";
    }

    public String string_value() {
        return "" + this._value;
    }

    public boolean nan() {
        return this._value == Float.NaN;
    }

    public boolean zero() {
        return (double)this._value == 0.0;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        try {
            Float f = new Float(aat.string_value());
            rs.add(new XSFloat(f.floatValue()));
            return rs;
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public float float_value() {
        return this._value;
    }

    public boolean eq(AnyType aa) throws DynamicError {
        if (!(aa instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat f = (XSFloat)aa;
        return this.float_value() == f.float_value();
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSFloat val = (XSFloat)XSFloat.get_single_type(arg, XSFloat.class);
        return this.float_value() > val.float_value();
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSFloat val = (XSFloat)XSFloat.get_single_type(arg, XSFloat.class);
        return this.float_value() < val.float_value();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        AnyType at = this.get_single_arg(arg);
        if (!(at instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat val = (XSFloat)at;
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() + val.float_value()));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        AnyType at = this.get_single_arg(arg);
        if (!(at instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat val = (XSFloat)at;
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() - val.float_value()));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSFloat val = (XSFloat)XSFloat.get_single_type(arg, XSFloat.class);
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() * val.float_value()));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        XSFloat val = (XSFloat)XSFloat.get_single_type(arg, XSFloat.class);
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() / val.float_value()));
    }

    public ResultSequence idiv(ResultSequence arg) throws DynamicError {
        XSFloat val = (XSFloat)XSFloat.get_single_type(arg, XSFloat.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        return ResultSequenceFactory.create_new(new XSInteger((int)(this.float_value() / val.float_value())));
    }

    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        XSFloat val = (XSFloat)XSFloat.get_single_type(arg, XSFloat.class);
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() % val.float_value()));
    }

    public ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSFloat(-1.0f * this.float_value()));
    }

    public NumericType abs() {
        return new XSFloat(Math.abs(this.float_value()));
    }

    public NumericType ceiling() {
        return new XSFloat((float)Math.ceil(this.float_value()));
    }

    public NumericType floor() {
        return new XSFloat((float)Math.floor(this.float_value()));
    }

    public NumericType round() {
        return new XSFloat(Math.round(this.float_value()));
    }

    public NumericType round_half_to_even() {
        return new XSFloat((float)Math.rint(this.float_value()));
    }
}

