/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.xs.ItemPSVI;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.function.ConstructorFL;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;

public class DefaultStaticContext
implements StaticContext {
    private boolean _xpath1_compatible = false;
    private String _default_namespace = null;
    private String _default_function_namespace = "http://www.w3.org/2004/10/xpath-functions";
    private XSModel _schema;
    private Map _namespaces;
    private String _cntxt_item_type;
    private Map _functions;
    private XSAnyURI _base_uri;
    private Map _documents;
    private Map _collections;
    private String _default_collection_type;
    private Stack _scopes;

    public DefaultStaticContext(XSModel schema) {
        this._schema = schema;
        this._functions = new HashMap(20);
        this._namespaces = new HashMap(20);
        this._cntxt_item_type = null;
        this._scopes = new Stack();
        this.new_scope();
        if (this._schema != null) {
            this.init_schema(schema);
        }
        this._base_uri = new XSAnyURI();
        this.add_namespace("*", "*");
    }

    public DefaultStaticContext() {
        this(null);
    }

    private void init_schema(XSModel schema) {
    }

    public XSAnyURI base_uri() {
        return this._base_uri;
    }

    public boolean xpath1_compatible() {
        return this._xpath1_compatible;
    }

    public void add_namespace(String prefix, String namespace) {
        if (prefix.equals("fs") || prefix.equals("op") || prefix.equals("dm")) {
            return;
        }
        this._namespaces.put(prefix, namespace);
    }

    public String default_namespace() {
        return this._default_namespace;
    }

    public String default_function_namespace() {
        return this._default_function_namespace;
    }

    public void add_function_library(FunctionLibrary fl) {
        fl.set_static_context(this);
        this._functions.put(fl.namespace(), fl);
    }

    public boolean function_exists(QName name, int arity) {
        String ns = name.namespace();
        if (!this._functions.containsKey(ns)) {
            return false;
        }
        FunctionLibrary fl = (FunctionLibrary)this._functions.get(ns);
        return fl.function_exists(name, arity);
    }

    protected Function function(QName name, int arity) {
        String ns = name.namespace();
        if (!this._functions.containsKey(ns)) {
            return null;
        }
        FunctionLibrary fl = (FunctionLibrary)this._functions.get(ns);
        return fl.function(name, arity);
    }

    public AnyAtomicType make_atomic(QName name) {
        String ns = name.namespace();
        if (!this._functions.containsKey(ns)) {
            return null;
        }
        FunctionLibrary fl = (FunctionLibrary)this._functions.get(ns);
        if (!(fl instanceof ConstructorFL)) {
            return null;
        }
        ConstructorFL cfl = (ConstructorFL)fl;
        return cfl.atomic_type(name);
    }

    private boolean expand_qname(QName name, String def) {
        String prefix = name.prefix();
        if (prefix == null) {
            name.set_namespace(def);
            return true;
        }
        if (!this.prefix_exists(prefix)) {
            return false;
        }
        name.set_namespace(this.resolve_prefix(prefix));
        return true;
    }

    public boolean expand_qname(QName name) {
        return this.expand_qname(name, null);
    }

    public boolean expand_function_qname(QName name) {
        return this.expand_qname(name, this.default_function_namespace());
    }

    public boolean expand_elem_type_qname(QName name) {
        return this.expand_qname(name, this.default_namespace());
    }

    public boolean type_defined(QName qname) {
        if (this._schema == null) {
            return false;
        }
        XSTypeDefinition td = this._schema.getTypeDefinition(qname.local(), qname.namespace());
        return td != null;
    }

    public boolean type_defined(String ns, String type) {
        return this.type_defined(new QName(ns, type));
    }

    public boolean element_declared(QName elem) {
        if (this._schema == null) {
            return false;
        }
        XSElementDeclaration ed = this._schema.getElementDeclaration(elem.local(), elem.namespace());
        return ed != null;
    }

    public XSTypeDefinition element_type_definition(QName elem) {
        XSElementDeclaration ed = this._schema.getElementDeclaration(elem.local(), elem.namespace());
        return ed.getTypeDefinition();
    }

    public boolean attribute_declared(QName attr) {
        if (this._schema == null) {
            return false;
        }
        XSAttributeDeclaration ad = this._schema.getAttributeDeclaration(attr.local(), attr.namespace());
        return ad != null;
    }

    public XSTypeDefinition attribute_type_definition(QName elem) {
        XSAttributeDeclaration ad = this._schema.getAttributeDeclaration(elem.local(), elem.namespace());
        return ad.getTypeDefinition();
    }

    public boolean prefix_exists(String pref) {
        return this._namespaces.containsKey(pref);
    }

    public String resolve_prefix(String pref) {
        return (String)this._namespaces.get(pref);
    }

    public boolean derives_from(NodeType at, QName et) {
        ItemPSVI psvi = (ItemPSVI)at.node_value();
        XSTypeDefinition td = psvi.getTypeDefinition();
        short method = 0;
        if (!et.expanded()) {
            String pre = et.prefix();
            if (pre != null) {
                if (this.prefix_exists(pre)) {
                    et.set_namespace(this.resolve_prefix(pre));
                } else assert (false);
            } else {
                et.set_namespace(this.default_namespace());
            }
        }
        return td.derivedFrom(et.namespace(), et.local(), method);
    }

    public boolean derives_from(NodeType at, XSTypeDefinition et) {
        ItemPSVI psvi = (ItemPSVI)at.node_value();
        XSTypeDefinition td = psvi.getTypeDefinition();
        short method = 0;
        return td.derivedFromType(et, method);
    }

    public void new_scope() {
        HashMap vars = new HashMap();
        this._scopes.push(vars);
    }

    public void destroy_scope() {
        this._scopes.pop();
    }

    private Map current_scope() {
        return (Map)this._scopes.peek();
    }

    public boolean variable_exists(QName var) {
        Map scope = this.current_scope();
        return scope.containsKey(var);
    }

    public boolean variable_in_scope(QName var) {
        for (Map scope : this._scopes) {
            if (!scope.containsKey(var)) continue;
            return true;
        }
        return false;
    }

    public void add_variable(QName var) {
        this.set_variable(var, null);
    }

    protected void set_variable(QName var, AnyType val) {
        Map scope = this.current_scope();
        scope.put(var, val);
    }

    public boolean del_variable(QName var) {
        if (!this.variable_exists(var)) {
            return false;
        }
        Map scope = this.current_scope();
        return scope.remove(var) != null;
    }

    protected AnyType get_var(QName var) {
        int pos = this._scopes.size();
        while (--pos >= 0) {
            Map scope = (Map)this._scopes.get(pos);
            if (!scope.containsKey(var)) continue;
            return (AnyType)scope.get(var);
        }
        return null;
    }

    public void debug_print_vars() {
        int level = 0;
        for (Map scope : this._scopes) {
            System.out.println("Scope level " + level);
            for (QName varname : scope.keySet()) {
                AnyType val = (AnyType)scope.get(varname);
                String string_val = "null";
                if (val != null) {
                    string_val = val.string_value();
                }
                System.out.println("Varname: " + varname.string() + " expanded=" + varname.expanded() + " Value: " + string_val);
            }
            ++level;
        }
    }
}

