/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.transport;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPMessage;
import org.eclipse.wst.ws.internal.explorer.transport.ISerializer;
import org.eclipse.wst.ws.internal.explorer.transport.MessageContext;
import org.eclipse.wst.ws.internal.explorer.transport.TransportException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SOAPMessage
implements ISOAPMessage {
    private MessageContext context;
    private ISerializer serializer;
    private Map properties = new Hashtable();
    private Element envelope = null;
    private Element header = null;
    private Element[] headerContent = null;
    private Element body = null;
    private Element[] bodyContent = null;
    private Element fault = null;
    private String xml = null;

    public SOAPMessage(MessageContext context, ISerializer serializer) {
        this.context = context;
        this.serializer = serializer;
    }

    public MessageContext getMessageContext() {
        return this.context;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public synchronized void setNamespaceTable(Map namespaceTable) {
        if (namespaceTable == null || this.envelope == null) {
            return;
        }
        for (Map.Entry entry : namespaceTable.entrySet()) {
            String name = "xmlns:" + entry.getValue();
            this.envelope.setAttribute(name, entry.getKey().toString());
        }
        this.xml = null;
    }

    private String getNSPrefix(Attr attribute) {
        String name = attribute.getName();
        if (name.startsWith("xmlns:")) {
            return name.substring(6);
        }
        return null;
    }

    public Map getNamespaceTable() {
        Hashtable<String, String> namespaceTable = new Hashtable<String, String>();
        if (this.envelope != null) {
            NamedNodeMap attributes = this.envelope.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attribute = (Attr)attributes.item(i);
                String prefix = this.getNSPrefix(attribute);
                if (prefix != null) {
                    namespaceTable.put(attribute.getValue(), prefix);
                }
                ++i;
            }
        }
        return namespaceTable;
    }

    private void appendNode(Node parent, Node child) {
        if (parent == null || child == null) {
            return;
        }
        Document owner = parent.getOwnerDocument();
        if (!owner.equals(child.getOwnerDocument())) {
            child = owner.importNode(child, true);
        }
        parent.appendChild(child);
    }

    private void appendChildren(Element parent, Element[] children) {
        if (parent == null || children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                this.appendNode(parent, children[i]);
            }
            ++i;
        }
    }

    public synchronized void setEnvelope(Element envelope) {
        this.envelope = envelope == null ? envelope : (Element)envelope.cloneNode(false);
        this.xml = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getEnvelope(boolean deep) {
        if (!deep) {
            return this.envelope;
        }
        SOAPMessage sOAPMessage = this;
        synchronized (sOAPMessage) {
            block6: {
                if (this.envelope != null) break block6;
                return null;
            }
            Element clonedEnvelope = (Element)this.envelope.cloneNode(false);
            if (this.headerContent != null && this.headerContent.length > 0) {
                this.appendNode(clonedEnvelope, this.getHeader(true));
            }
            this.appendNode(clonedEnvelope, this.getBody(true));
            return clonedEnvelope;
        }
    }

    public synchronized void setHeader(Element header) {
        this.header = header == null ? null : (Element)header.cloneNode(false);
        this.xml = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getHeader(boolean deep) {
        if (!deep) {
            return this.header;
        }
        SOAPMessage sOAPMessage = this;
        synchronized (sOAPMessage) {
            block5: {
                if (this.header != null) break block5;
                return null;
            }
            Element clonedHeader = (Element)this.header.cloneNode(false);
            this.appendChildren(clonedHeader, this.headerContent);
            return clonedHeader;
        }
    }

    public synchronized void setHeaderContent(Element[] headerContent) {
        this.headerContent = headerContent;
        this.xml = null;
    }

    public Element[] getHeaderContent() {
        return this.headerContent;
    }

    public synchronized void setBody(Element body) {
        if (body == null) {
            this.body = null;
        } else {
            NodeList childElements;
            this.body = (Element)body.cloneNode(false);
            if (!this.context.isDocumentStyle() && this.fault == null && (childElements = body.getElementsByTagName("*")).getLength() > 0) {
                this.body.appendChild(childElements.item(0).cloneNode(false));
            }
        }
        this.xml = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getBody(boolean deep) {
        if (!deep) {
            return this.body;
        }
        SOAPMessage sOAPMessage = this;
        synchronized (sOAPMessage) {
            block8: {
                if (this.body != null) break block8;
                return null;
            }
            Element clonedBody = (Element)this.body.cloneNode(true);
            if (this.fault != null) {
                this.appendNode(clonedBody, this.fault);
            } else {
                Element target = clonedBody;
                if (clonedBody.getFirstChild() != null) {
                    target = (Element)clonedBody.getFirstChild();
                }
                this.appendChildren(target, this.bodyContent);
            }
            return clonedBody;
        }
    }

    public synchronized void setBodyContent(Element[] bodyContent) {
        this.bodyContent = bodyContent;
        if (bodyContent != null) {
            this.fault = null;
        }
        this.xml = null;
    }

    public Element[] getBodyContent() {
        return this.bodyContent;
    }

    public synchronized void setFault(Element fault) {
        this.fault = fault;
        if (fault != null) {
            if (this.body != null && this.body.getFirstChild() != null) {
                this.body.removeChild(this.body.getFirstChild());
            }
            this.bodyContent = null;
        }
        this.xml = null;
    }

    public Element getFault() {
        return this.fault;
    }

    public synchronized String toXML() throws TransportException {
        if (this.xml == null) {
            this.xml = this.serializer.serialize(0, this);
        }
        return this.xml;
    }
}

