/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.model;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.ExtensionUtility;
import org.osgi.framework.BundleContext;

public class Extension {
    private ImageDescriptor imageDescriptor;
    private IInstallableUnit iu;
    private URI uri;
    private ProvisioningContext provContext;
    private ProvisioningPlan plan;

    public Extension(IInstallableUnit iu, URI uri) {
        this.iu = iu;
        this.uri = uri;
    }

    public String getName() {
        return IUPropertyUtils.getIUProperty((IInstallableUnit)this.iu, (String)"org.eclipse.equinox.p2.name");
    }

    public String getDescription() {
        return IUPropertyUtils.getIUProperty((IInstallableUnit)this.iu, (String)"org.eclipse.equinox.p2.description");
    }

    public Image getImage() {
        return null;
    }

    public String getLicense() {
        return this.iu.getLicense().getBody();
    }

    public String getProvider() {
        return IUPropertyUtils.getIUProperty((IInstallableUnit)this.iu, (String)"org.eclipse.equinox.p2.provider");
    }

    public String getId() {
        return this.iu.getId();
    }

    public Version getVersion() {
        return this.iu.getVersion();
    }

    public IStatus install(IProgressMonitor monitor) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ProvisioningPlan plan = this.getProvisioningPlan(true, monitor);
        if (!plan.getStatus().isOK()) {
            return plan.getStatus();
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)ExtensionUtility.getService(bundleContext, IProfileRegistry.class.getName());
        IProfile profile = profileRegistry.getProfile("_SELF_");
        IEngine engine = (IEngine)ExtensionUtility.getService(bundleContext, IEngine.SERVICE_NAME);
        return engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), plan.getOperands(), this.provContext, monitor);
    }

    public IInstallableUnit[] getIUs() {
        return new IInstallableUnit[]{this.iu};
    }

    public ProvisioningPlan getProvisioningPlan(boolean explain, IProgressMonitor monitor) {
        if (this.plan != null) {
            return this.plan;
        }
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IPlanner planner = (IPlanner)ExtensionUtility.getService(bundleContext, IPlanner.class.getName());
        IProfileRegistry profileRegistry = (IProfileRegistry)ExtensionUtility.getService(bundleContext, IProfileRegistry.class.getName());
        IProfile profile = profileRegistry.getProfile("_SELF_");
        ProfileChangeRequest pcr = new ProfileChangeRequest(profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.iu});
        this.provContext = new ProvisioningContext(new URI[]{this.uri});
        this.provContext.setArtifactRepositories(new URI[]{this.uri});
        if (!explain) {
            this.provContext.setProperty("org.eclipse.equinox.p2.director.explain", "false");
        }
        this.plan = planner.getProvisioningPlan(pcr, this.provContext, monitor);
        return this.plan;
    }
}

