/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class LocalTypeAnalyzer
extends ASTVisitor {
    private Selection fSelection;
    private List fTypeDeclarationsBefore = new ArrayList(2);
    private List fTypeDeclarationsSelected = new ArrayList(2);
    private String fBeforeTypeReferenced;
    private String fSelectedTypeReferenced;

    public static RefactoringStatus perform(BodyDeclaration declaration, Selection selection) {
        LocalTypeAnalyzer analyzer = new LocalTypeAnalyzer(selection);
        declaration.accept((ASTVisitor)analyzer);
        RefactoringStatus result = new RefactoringStatus();
        analyzer.check(result);
        return result;
    }

    private LocalTypeAnalyzer(Selection selection) {
        this.fSelection = selection;
    }

    public boolean visit(SimpleName node) {
        if (node.isDeclaration()) {
            return true;
        }
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            this.processLocalTypeBinding((ITypeBinding)binding, this.fSelection.getVisitSelectionMode((ASTNode)node));
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        return this.visitType((AbstractTypeDeclaration)node);
    }

    private boolean visitType(AbstractTypeDeclaration node) {
        int mode = this.fSelection.getVisitSelectionMode((ASTNode)node);
        switch (mode) {
            case 1: {
                this.fTypeDeclarationsBefore.add(node);
                break;
            }
            case 2: {
                this.fTypeDeclarationsSelected.add(node);
            }
        }
        return true;
    }

    private void processLocalTypeBinding(ITypeBinding binding, int mode) {
        switch (mode) {
            case 2: {
                if (this.fBeforeTypeReferenced != null || !this.checkBinding(this.fTypeDeclarationsBefore, binding)) break;
                this.fBeforeTypeReferenced = RefactoringCoreMessages.LocalTypeAnalyzer_local_type_from_outside;
                break;
            }
            case 3: {
                if (this.fSelectedTypeReferenced != null || !this.checkBinding(this.fTypeDeclarationsSelected, binding)) break;
                this.fSelectedTypeReferenced = RefactoringCoreMessages.LocalTypeAnalyzer_local_type_referenced_outside;
            }
        }
    }

    private boolean checkBinding(List declarations, ITypeBinding binding) {
        Iterator iter = declarations.iterator();
        while (iter.hasNext()) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)iter.next();
            if (declaration.resolveBinding() != binding) continue;
            return true;
        }
        return false;
    }

    private void check(RefactoringStatus status) {
        if (this.fBeforeTypeReferenced != null) {
            status.addFatalError(this.fBeforeTypeReferenced);
        }
        if (this.fSelectedTypeReferenced != null) {
            status.addFatalError(this.fSelectedTypeReferenced);
        }
    }
}

