/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class FactoryTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public FactoryTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.FactoryTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return FactoryTests.buildModelTestSuite(clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateBinaryToolObject() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], new String[]{"lib"}, "bin");
            IFile file = this.createFile("/P/lib/X.class", "");
            IJavaScriptElement object = JavaScriptCore.create((IFile)file);
            FactoryTests.assertTrue((String)"tooling object not created", (object != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"class file does not exist", (boolean)object.exists());
            FactoryTests.assertTrue((String)"wrong object created", (boolean)(object instanceof IClassFile));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateCompilationUnits() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.createFolder("/P/src/x/y/z");
            IFile fileA = this.createFile("/P/src/x/y/z/A.js", "package x.y.z;\npublic class A {\n}");
            IFile fileB = this.createFile("/P/src/x/y/B.js", "package x.y;\npublic class B {\n}");
            IJavaScriptElement objectA = JavaScriptCore.create((IFile)fileA);
            FactoryTests.assertTrue((String)"tooling object A not created", (objectA != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"wrong object A created", (boolean)(objectA instanceof IJavaScriptUnit));
            FactoryTests.assertTrue((String)"compilation unit A does not exist", (boolean)objectA.exists());
            IJavaScriptElement objectB = JavaScriptCore.create((IFile)fileB);
            FactoryTests.assertTrue((String)"tooling object B not created", (objectB != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"wrong object B created", (boolean)(objectB instanceof IJavaScriptUnit));
            FactoryTests.assertTrue((String)"compilation unit B does not exist", (boolean)objectB.exists());
            FactoryTests.assertEquals((String)"should share project", (Object)((IJavaScriptUnit)objectA).getJavaScriptProject(), (Object)((IJavaScriptUnit)objectB).getJavaScriptProject());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateCompilationUnitsNotOnClasspath() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.createFolder("/P/other/nested");
            IFile fileA = this.createFile("/P/other/A.js", "public class A {}");
            IFile fileB = this.createFile("/P/other/nested/B.js", "public class B {}");
            IFile fileC = this.createFile("/P/C.js", "public class C {}");
            IJavaScriptElement objectA = JavaScriptCore.create((IFile)fileA);
            FactoryTests.assertTrue((String)"tooling object A not created", (objectA != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"wrong object A created", (boolean)(objectA instanceof IJavaScriptUnit));
            FactoryTests.assertTrue((String)"compilation unit A should not exist", (!objectA.exists() ? 1 : 0) != 0);
            IJavaScriptElement objectB = JavaScriptCore.create((IFile)fileB);
            FactoryTests.assertTrue((String)"tooling object B not created", (objectB != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"wrong object B created", (boolean)(objectB instanceof IJavaScriptUnit));
            FactoryTests.assertTrue((String)"compilation unit B should not exist", (!objectB.exists() ? 1 : 0) != 0);
            FactoryTests.assertEquals((String)"should share project", (Object)((IJavaScriptUnit)objectA).getJavaScriptProject(), (Object)((IJavaScriptUnit)objectB).getJavaScriptProject());
            IJavaScriptElement objectC = JavaScriptCore.create((IFile)fileC);
            FactoryTests.assertTrue((String)"tooling object C not created", (objectC != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"wrong object C created", (boolean)(objectC instanceof IJavaScriptUnit));
            FactoryTests.assertTrue((String)"compilation unit C should not exist", (!objectC.exists() ? 1 : 0) != 0);
            IPackageFragment pkg = (IPackageFragment)objectA.getParent();
            IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
            FactoryTests.assertEquals((String)"pkg should be default", (String)"", (String)pkg.getElementName());
            FactoryTests.assertEquals((String)"unexpected parent's folder", (Object)this.getFolder("/P/other"), (Object)pkg.getResource());
            FactoryTests.assertEquals((String)"unexpected root", (Object)this.getFolder("/P/other"), (Object)root.getResource());
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateFolderToolObjects() throws CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P", new String[0], "bin");
            this.createFolder("/P/src/x/y/z");
            IFolder src = this.getFolder("/P/src");
            IFolder res = src.getFolder("x");
            IJavaScriptElement object = JavaScriptCore.create((IFolder)res);
            FactoryTests.assertTrue((String)"tooling object 1 should not be created", (object == null ? 1 : 0) != 0);
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)src.getFullPath())};
            javaProject.setRawIncludepath(classpath, null);
            object = JavaScriptCore.create((IFolder)src);
            FactoryTests.assertTrue((String)"tooling object 2 should be created", (object != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"tooling object 2 should be a IPackageFragmentRoot", (boolean)(object instanceof IPackageFragmentRoot));
            FactoryTests.assertEquals((String)"IPackageFragmentRoot 2 name is incorrect", (String)"src", (String)object.getElementName());
            FactoryTests.assertTrue((String)"root 'src' does not exist", (boolean)object.exists());
            object = JavaScriptCore.create((IFolder)res);
            FactoryTests.assertTrue((String)"tooling object 3 should be created", (object != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"tooling object 3 should be a IPackageFragment", (boolean)(object instanceof IPackageFragment));
            FactoryTests.assertEquals((String)"IPackageFragment 3 name is incorrect", (String)"x", (String)object.getElementName());
            FactoryTests.assertTrue((String)"package 'com' does not exist", (boolean)object.exists());
            IFolder subFolder = res.getFolder("y");
            object = JavaScriptCore.create((IFolder)subFolder);
            FactoryTests.assertTrue((String)"tooling object 'x.y' should be created", (object != null ? 1 : 0) != 0);
            FactoryTests.assertTrue((String)"tooling object 'x.y' should be a IPackageFragment", (boolean)(object instanceof IPackageFragment));
            FactoryTests.assertEquals((String)"IPackageFragment 'x.y' name is incorrect", (String)"x.y", (String)object.getElementName());
            FactoryTests.assertTrue((String)"package 'x.y' does not exist", (boolean)object.exists());
            IFolder bin = this.getFolder("/P/bin");
            object = JavaScriptCore.create((IFolder)bin);
            FactoryTests.assertTrue((String)"tooling object 4 should not be created", (object == null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateFromEmptyJavaFile() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            IFile file = this.createFile("/P/src/X.js", "");
            IJavaScriptElement cu = JavaScriptCore.create((IFile)file);
            FactoryTests.assertTrue((String)"does not handle empty Java files", (cu != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateFromFileWithoutExtension() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            IFile file = this.createFile("/P/src/FileWithoutExtension", "public class X {}");
            IJavaScriptElement cu = JavaScriptCore.create((IFile)file);
            FactoryTests.assertTrue((String)"invalid file not detected", (cu == null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    public void testCreateFromInvalidMemento() {
        FactoryTests.assertTrue((String)"invalid parameter not detected", (JavaScriptCore.create(null) == null ? 1 : 0) != 0);
        FactoryTests.assertTrue((String)"should return the java model", (JavaScriptCore.create((String)"") != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateJarToolObject() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], new String[]{"/P/lib.jar"}, "");
            IFile file = this.createFile("/P/lib.jar", "");
            IJavaScriptElement jar = JavaScriptCore.create((IFile)file);
            FactoryTests.assertTrue((String)"tooling object not created", (jar != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateLibInOutput() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], new String[]{"/P/lib"}, "");
            IFolder folder = this.createFolder("/P/lib");
            IJavaScriptElement lib = JavaScriptCore.create((IFolder)folder);
            FactoryTests.assertTrue((String)"tooling object not created", (lib != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }
}

