/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.tests.dom.ASTStructuralPropertyTest;
import org.eclipse.wst.jsdt.core.tests.dom.SampleASTs;
import org.eclipse.wst.jsdt.core.tests.junit.extension.TestCase;

public class ASTStructuralPropertyTest
extends TestCase {
    AST ast;
    ASTParser parser;
    int API_LEVEL;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTStructuralPropertyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTStructuralPropertyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> c = clazz2;
        Method[] methods = c.getMethods();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            if (methods[i].getName().startsWith("test")) {
                suite.addTest((Test)new ASTStructuralPropertyTest(methods[i].getName(), 2));
                suite.addTest((Test)new ASTStructuralPropertyTest(methods[i].getName(), 3));
            }
            ++i;
        }
        return suite;
    }

    public ASTStructuralPropertyTest(String name, int apiLevel) {
        super(name);
        this.API_LEVEL = apiLevel;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ast = AST.newAST((int)this.API_LEVEL);
        this.parser = ASTParser.newParser((int)this.API_LEVEL);
    }

    protected void tearDown() throws Exception {
        this.ast = null;
        super.tearDown();
    }

    public String getName() {
        String name = super.getName();
        switch (this.API_LEVEL) {
            case 2: {
                name = "JLS2 - " + name;
                break;
            }
            case 3: {
                name = "JLS3 - " + name;
            }
        }
        return name;
    }

    public void testLocationInParent() {
        final ASTNode root = SampleASTs.oneOfEach(this.ast);
        ASTVisitor v = new ASTVisitor(true){

            public void postVisit(ASTNode node) {
                StructuralPropertyDescriptor me = node.getLocationInParent();
                ASTStructuralPropertyTest.assertTrue((me != null || node == root ? 1 : 0) != 0);
                ASTNode p = node.getParent();
                if (p != null) {
                    List parentProperties = p.structuralPropertiesForType();
                    boolean foundMe = false;
                    Iterator it = parentProperties.iterator();
                    while (it.hasNext()) {
                        StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)it.next();
                        if (me != prop && !prop.getId().equals(me.getId())) continue;
                        foundMe = true;
                        break;
                    }
                    ASTStructuralPropertyTest.assertTrue((boolean)foundMe);
                }
            }
        };
        root.accept(v);
    }

    public void testStructuralProperties() {
        ASTNode root = SampleASTs.oneOfEach(this.ast);
        final HashSet simpleProperties = new HashSet(400);
        final HashSet childProperties = new HashSet(400);
        final HashSet childListProperties = new HashSet(400);
        final HashSet visitedProperties = new HashSet(400);
        final HashSet nodeClasses = new HashSet(100);
        ASTVisitor v = new ASTVisitor(true){

            public void postVisit(ASTNode node) {
                StructuralPropertyDescriptor me = node.getLocationInParent();
                if (me != null) {
                    visitedProperties.add(me);
                }
                visitedProperties.add(me);
                nodeClasses.add(node.getClass());
                List ps = node.structuralPropertiesForType();
                Iterator it = ps.iterator();
                while (it.hasNext()) {
                    StructuralPropertyDescriptor p = (StructuralPropertyDescriptor)it.next();
                    Object o = node.getStructuralProperty(p);
                    if (p.isSimpleProperty()) {
                        simpleProperties.add(p);
                        node.setStructuralProperty(p, o);
                        continue;
                    }
                    if (p.isChildProperty()) {
                        childProperties.add(p);
                        ASTNode copy = ASTNode.copySubtree((AST)ASTStructuralPropertyTest.this.ast, (ASTNode)((ASTNode)o));
                        node.setStructuralProperty(p, (Object)copy);
                        continue;
                    }
                    if (!p.isChildListProperty()) continue;
                    childListProperties.add(p);
                    List list = (List)o;
                    List copy = ASTNode.copySubtrees((AST)ASTStructuralPropertyTest.this.ast, (List)list);
                    list.clear();
                    list.addAll(copy);
                }
            }
        };
        root.accept(v);
        switch (this.API_LEVEL) {
            case 2: {
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of visited node classes", (int)67, (int)nodeClasses.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of visited properties", (int)82, (int)visitedProperties.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of simple properties", (int)26, (int)simpleProperties.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of child properties", (int)90, (int)childProperties.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of child list properties", (int)26, (int)childListProperties.size());
                break;
            }
            case 3: {
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of visited node classes", (int)80, (int)nodeClasses.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of visited properties", (int)104, (int)visitedProperties.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of simple properties", (int)23, (int)simpleProperties.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of child properties", (int)115, (int)childProperties.size());
                ASTStructuralPropertyTest.assertEquals((String)"Wrong number of child list properties", (int)52, (int)childListProperties.size());
            }
        }
        ASTNode newRoot = SampleASTs.oneOfEach(this.ast);
        ASTStructuralPropertyTest.assertTrue((boolean)root.subtreeMatch(new ASTMatcher(), (Object)newRoot));
    }

    public void testProtect() {
        ASTNode root = SampleASTs.oneOfEach(this.ast);
        class Protector
        extends ASTVisitor {
            boolean shouldBeProtected;
            final /* synthetic */ ASTStructuralPropertyTest this$0;

            Protector(ASTStructuralPropertyTest aSTStructuralPropertyTest, boolean shouldBeProtected) {
                super(true);
                this.this$0 = aSTStructuralPropertyTest;
                this.shouldBeProtected = shouldBeProtected;
            }

            public void preVisit(ASTNode node) {
                int f = node.getFlags();
                f = this.shouldBeProtected ? (f |= 4) : (f &= 0xFFFFFFFB);
                node.setFlags(f);
            }
        }
        root.accept((ASTVisitor)new Protector(this, true));
        class Slammer
        extends ASTVisitor {
            boolean shouldBeProtected;
            final /* synthetic */ ASTStructuralPropertyTest this$0;

            Slammer(ASTStructuralPropertyTest aSTStructuralPropertyTest, boolean shouldBeProtected) {
                super(true);
                this.this$0 = aSTStructuralPropertyTest;
                this.shouldBeProtected = shouldBeProtected;
            }

            public void postVisit(ASTNode node) {
                try {
                    node.setSourceRange(1, 1);
                    ASTStructuralPropertyTest.assertTrue((!this.shouldBeProtected ? 1 : 0) != 0);
                }
                catch (RuntimeException runtimeException) {
                    ASTStructuralPropertyTest.assertTrue((boolean)this.shouldBeProtected);
                }
                List ps = node.structuralPropertiesForType();
                Iterator<E> it = ps.iterator();
                while (it.hasNext()) {
                    StructuralPropertyDescriptor p = (StructuralPropertyDescriptor)it.next();
                    Object o = node.getStructuralProperty(p);
                    if (p.isSimpleProperty()) {
                        try {
                            node.setStructuralProperty(p, o);
                            ASTStructuralPropertyTest.assertTrue((!this.shouldBeProtected ? 1 : 0) != 0);
                        }
                        catch (RuntimeException runtimeException) {
                            ASTStructuralPropertyTest.assertTrue((boolean)this.shouldBeProtected);
                        }
                        continue;
                    }
                    if (p.isChildProperty()) {
                        ASTNode copy = ASTNode.copySubtree((AST)this.this$0.ast, (ASTNode)((ASTNode)o));
                        try {
                            node.setStructuralProperty(p, (Object)copy);
                            ASTStructuralPropertyTest.assertTrue((!this.shouldBeProtected ? 1 : 0) != 0);
                        }
                        catch (RuntimeException runtimeException) {
                            ASTStructuralPropertyTest.assertTrue((boolean)this.shouldBeProtected);
                        }
                        continue;
                    }
                    if (!p.isChildListProperty()) continue;
                    List list = (List)o;
                    List copy = ASTNode.copySubtrees((AST)this.this$0.ast, (List)list);
                    if (list.isEmpty()) continue;
                    try {
                        list.clear();
                        ASTStructuralPropertyTest.assertTrue((!this.shouldBeProtected ? 1 : 0) != 0);
                    }
                    catch (RuntimeException runtimeException) {
                        ASTStructuralPropertyTest.assertTrue((boolean)this.shouldBeProtected);
                    }
                    try {
                        list.addAll(copy);
                        ASTStructuralPropertyTest.assertTrue((!this.shouldBeProtected ? 1 : 0) != 0);
                    }
                    catch (RuntimeException runtimeException) {
                        ASTStructuralPropertyTest.assertTrue((boolean)this.shouldBeProtected);
                    }
                }
            }
        }
        root.accept((ASTVisitor)new Slammer(this, true));
        root.accept((ASTVisitor)new Protector(this, false));
        root.accept((ASTVisitor)new Slammer(this, false));
    }

    public void testDelete() {
        ASTNode root = SampleASTs.oneOfEach(this.ast);
        root.accept(new ASTVisitor(true){

            public void postVisit(ASTNode node) {
                List ps = node.structuralPropertiesForType();
                Iterator it = ps.iterator();
                while (it.hasNext()) {
                    StructuralPropertyDescriptor p = (StructuralPropertyDescriptor)it.next();
                    if (p.isChildProperty()) {
                        ChildPropertyDescriptor c = (ChildPropertyDescriptor)p;
                        ASTNode child = (ASTNode)node.getStructuralProperty((StructuralPropertyDescriptor)c);
                        if (c.isMandatory() || child == null) continue;
                        try {
                            child.delete();
                            ASTStructuralPropertyTest.assertTrue((node.getStructuralProperty((StructuralPropertyDescriptor)c) == null ? 1 : 0) != 0);
                        }
                        catch (RuntimeException runtimeException) {
                            ASTStructuralPropertyTest.assertTrue((boolean)false);
                        }
                        continue;
                    }
                    if (!p.isChildListProperty()) continue;
                    List list = (List)node.getStructuralProperty(p);
                    ArrayList copy = new ArrayList();
                    copy.addAll(list);
                    Iterator it2 = copy.iterator();
                    while (it2.hasNext()) {
                        ASTNode n = (ASTNode)it2.next();
                        try {
                            n.delete();
                            ASTStructuralPropertyTest.assertTrue((!list.contains(n) ? 1 : 0) != 0);
                        }
                        catch (RuntimeException runtimeException) {
                            ASTStructuralPropertyTest.assertTrue((boolean)false);
                        }
                    }
                }
            }
        });
    }

    public void testCreateInstance() {
        int nodeType = 0;
        while (nodeType < 100) {
            Class nodeClass = null;
            try {
                nodeClass = ASTNode.nodeClassForType((int)nodeType);
            }
            catch (RuntimeException runtimeException) {}
            if (nodeClass != null) {
                try {
                    ASTNode node = this.ast.createInstance(nodeClass);
                    if (this.ast.apiLevel() == 2) {
                        ASTStructuralPropertyTest.assertTrue((nodeType >= 1 && nodeType <= 69 ? 1 : 0) != 0);
                    } else {
                        ASTStructuralPropertyTest.assertTrue((nodeType >= 1 && nodeType <= 83 ? 1 : 0) != 0);
                    }
                    ASTStructuralPropertyTest.assertTrue((node.getNodeType() == nodeType ? 1 : 0) != 0);
                }
                catch (RuntimeException runtimeException) {
                    if (this.ast.apiLevel() == 2) {
                        ASTStructuralPropertyTest.assertTrue((nodeType < 1 || nodeType > 69 ? 1 : 0) != 0);
                    }
                    ASTStructuralPropertyTest.assertTrue((nodeType < 1 || nodeType > 83 ? 1 : 0) != 0);
                }
            }
            ++nodeType;
        }
    }

    public void testNodeClassForType() {
        HashSet<Class> classes = new HashSet<Class>(100);
        int hi = 0;
        int nodeType = 1;
        while (nodeType < 100) {
            try {
                Class nodeClass = ASTNode.nodeClassForType((int)nodeType);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.ASTNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ASTStructuralPropertyTest.assertTrue((boolean)clazz.isAssignableFrom(nodeClass));
                classes.add(nodeClass);
                if (nodeType > 1) {
                    ASTStructuralPropertyTest.assertTrue((hi == nodeType - 1 ? 1 : 0) != 0);
                }
                hi = nodeType;
            }
            catch (RuntimeException runtimeException) {}
            ++nodeType;
        }
        ASTStructuralPropertyTest.assertTrue((hi == 83 ? 1 : 0) != 0);
        ASTStructuralPropertyTest.assertTrue((classes.size() == hi ? 1 : 0) != 0);
    }
}

