/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTestOptions
extends JavadocTest {
    String docCommentSupport = null;
    String reportInvalidJavadoc = null;
    String reportInvalidJavadocTagsVisibility = null;
    String reportInvalidJavadocTags = null;
    String reportInvalidJavadocTagsDeprecatedRef = null;
    String reportInvalidJavadocTagsNotVisibleRef = null;
    String reportMissingJavadocTags = null;
    String reportMissingJavadocTagsVisibility = null;
    String reportMissingJavadocTagsOverriding = null;
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;
    String reportMissingJavadocCommentsOverriding = null;
    private final int PUBLIC_VISIBILITY = 0;
    private final int PROTECTED_VISIBILITY = 1;
    private final int DEFAULT_VISIBILITY = 2;
    private final int PRIVATE_VISIBILITY = 3;
    private static String INVALID_CLASS_JAVADOC_REF = "\t/**\n\t * @see X_dep\n\t * @see X.X_priv\n\t * @see X.Unknown\n\t * @see X#X(int)\n\t * @see X#X(String)\n\t * @see X#X()\n\t * @see X#x_dep\n\t * @see X#x_priv\n\t * @see X#unknown\n\t * @see X#foo_dep()\n\t * @see X#foo_priv()\n\t * @see X#foo_dep(String)\n\t * @see X#unknown()\n\t */\n";
    private static String INVALID_METHOD_JAVADOC_REF = "\t/**\n\t * @param str\n\t * @param str\n\t * @param xxx\n\t * @throws IllegalArgumentException\n\t * @throws IllegalArgumentException\n\t * @throws java.io.IOException\n\t * @throws Unknown\n\t * @see X_dep\n\t * @see X.X_priv\n\t * @see X.Unknown\n\t * @see X#X(int)\n\t * @see X#X(String)\n\t * @see X#X()\n\t * @see X#x_dep\n\t * @see X#x_priv\n\t * @see X#unknown\n\t * @see X#foo_dep()\n\t * @see X#foo_priv()\n\t * @see X#foo_dep(String)\n\t * @see X#unknown()\n\t */\n";
    private static String DEP_CLASS = "/** @deprecated */\npublic class X_dep {}\n";
    private static String REF_CLASS = "public class X {\n\tprivate class X_priv{}\n\t/** @deprecated */\n\tpublic int x_dep;\n\tprivate int x_priv;\n\t/** @deprecated */\n\tpublic X() {}\n\tprivate X(int x) {}\n\t/** @deprecated */\n\tpublic void foo_dep() {}\n\tprivate void foo_priv() {}\n\t}\n";
    private static String[] CLASSES_INVALID_COMMENT = new String[]{"X.java", REF_CLASS, "X_dep.java", DEP_CLASS, "Y.java", "public class Y {\n" + INVALID_CLASS_JAVADOC_REF + "\tpublic class X_pub {}\n" + INVALID_CLASS_JAVADOC_REF + "\tprotected class X_prot {}\n" + INVALID_CLASS_JAVADOC_REF + "\tclass X_pack {}\n" + INVALID_CLASS_JAVADOC_REF + "\tprivate class X_priv {}\n" + "}\n" + "\n"};
    private static String[] FIELDS_INVALID_COMMENT = new String[]{"X.java", REF_CLASS, "X_dep.java", DEP_CLASS, "Y.java", "public class Y {\n" + INVALID_CLASS_JAVADOC_REF + "\tpublic int x_pub;\n" + INVALID_CLASS_JAVADOC_REF + "\tprotected int x_prot;\n" + INVALID_CLASS_JAVADOC_REF + "\tint x_pack;\n" + INVALID_CLASS_JAVADOC_REF + "\tprivate int x_priv;\n" + "}\n" + "\n"};
    private static String[] METHODS_INVALID_COMMENT = new String[]{"X.java", REF_CLASS, "X_dep.java", DEP_CLASS, "Y.java", "public class Y {\n" + INVALID_METHOD_JAVADOC_REF + "\tpublic void foo_pub(String str) throws IllegalArgumentException {}\n" + INVALID_METHOD_JAVADOC_REF + "\tprotected void foo_pro(String str) throws IllegalArgumentException {}\n" + INVALID_METHOD_JAVADOC_REF + "\tvoid foo_pack(String str) throws IllegalArgumentException {}\n" + INVALID_METHOD_JAVADOC_REF + "\tprivate void foo_priv(String str) throws IllegalArgumentException {}\n" + "}\n" + "\n"};
    private static String[] CONSTRUCTORS_INVALID_COMMENT = new String[]{"X.java", REF_CLASS, "X_dep.java", DEP_CLASS, "Y.java", "public class Y {\n" + INVALID_METHOD_JAVADOC_REF + "\tpublic Y(int str) {}\n" + INVALID_METHOD_JAVADOC_REF + "\tprotected Y(long str) {}\n" + INVALID_METHOD_JAVADOC_REF + "\tY(float str) {}\n" + INVALID_METHOD_JAVADOC_REF + "\tprivate Y(double str) {}\n" + "}\n" + "\n"};
    private static String[] MISSING_TAGS = new String[]{"X.java", "public class X {\n\t// public\n\t/** */\n\tpublic class PublicClass {}\n\t/** */\n\tpublic int publicField;\n\t/** */\n\tpublic X(int i) {}\n\t/** */\n\tpublic int publicMethod(long l) { return 0;}\n\t// protected\n\t/** */\n\tprotected class ProtectedClass {}\n\t/** */\n\tprotected int protectedField;\n\t/** */\n\tprotected X(long l) {}\n\t/** */\n\tprotected int protectedMethod(long l) { return 0; }\n\t// default\n\t/** */\n\tclass PackageClass {}\n\t/** */\n\tint packageField;\n\t/** */\n\tX(float f) {}\n\t/** */\n\tint packageMethod(long l) { return 0;}\n\t// private\n\t/** */\n\tprivate class PrivateClass {}\n\t/** */\n\tprivate int privateField;\n\t/** */\n\tprivate X(double d) {}\n\t/** */\n\tprivate int privateMethod(long l) { return 0;}\n}\n\n", "Y.java", "/** */\npublic class Y extends X {\n\tpublic Y(int i) { super(i); }\n\t//methods\n\t/** */\n\tpublic int publicMethod(long l) { return 0;}\n\t/** */\n\tprotected int protectedMethod(long l) { return 0;}\n\t/** */\n\tint packageMethod(long l) { return 0;}\n\t/** */\n\tprivate int privateMethod(long l) { return 0;}\n}\n"};
    private static String[] MISSING_COMMENTS = new String[]{"X.java", "/** */\npublic class X {\n\t// public\n\tpublic class PublicClass {}\n\tpublic int publicField;\n\tpublic X(int i) {}\n\tpublic int publicMethod(long l) { return 0;}\n\t// protected\n\tprotected class ProtectedClass {}\n\tprotected int protectedField;\n\tprotected X(long l) {}\n\tprotected int protectedMethod(long l) { return 0; }\n\t// default\n\tclass PackageClass {}\n\tint packageField;\n\tX(float f) {}\n\tint packageMethod(long l) { return 0;}\n\t// private\n\tprivate class PrivateClass {}\n\tprivate int privateField;\n\tprivate X(double d) {}\n\tprivate int privateMethod(long l) { return 0;}\n}\n\n", "Y.java", "/** */\npublic class Y extends X {\n\t/** */\n\tpublic Y(int i) { super(i); }\n\tpublic int publicMethod(long l) { return 0;}\n\tprotected int protectedMethod(long l) { return 0;}\n\tint packageMethod(long l) { return 0;}\n\tprivate int privateMethod(long l) { return 0;}\n}\n"};
    private static String[] CLASSES_ERRORS = new String[]{"1. ERROR in Y.java (at line 3)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n2. ERROR in Y.java (at line 4)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n3. ERROR in Y.java (at line 5)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n4. ERROR in Y.java (at line 6)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n5. ERROR in Y.java (at line 7)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n6. ERROR in Y.java (at line 8)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n7. ERROR in Y.java (at line 9)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n8. ERROR in Y.java (at line 10)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n9. ERROR in Y.java (at line 11)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n10. ERROR in Y.java (at line 12)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n11. ERROR in Y.java (at line 13)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n12. ERROR in Y.java (at line 14)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n13. ERROR in Y.java (at line 15)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n", "14. ERROR in Y.java (at line 19)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n15. ERROR in Y.java (at line 20)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n16. ERROR in Y.java (at line 21)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n17. ERROR in Y.java (at line 22)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n18. ERROR in Y.java (at line 23)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n19. ERROR in Y.java (at line 24)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n20. ERROR in Y.java (at line 25)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n21. ERROR in Y.java (at line 26)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n22. ERROR in Y.java (at line 27)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n23. ERROR in Y.java (at line 28)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n24. ERROR in Y.java (at line 29)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n25. ERROR in Y.java (at line 30)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n26. ERROR in Y.java (at line 31)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n", "27. ERROR in Y.java (at line 35)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n28. ERROR in Y.java (at line 36)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n29. ERROR in Y.java (at line 37)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n30. ERROR in Y.java (at line 38)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n31. ERROR in Y.java (at line 39)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n32. ERROR in Y.java (at line 40)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n33. ERROR in Y.java (at line 41)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n34. ERROR in Y.java (at line 42)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n35. ERROR in Y.java (at line 43)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n36. ERROR in Y.java (at line 44)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n37. ERROR in Y.java (at line 45)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n38. ERROR in Y.java (at line 46)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n39. ERROR in Y.java (at line 47)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n", "40. ERROR in Y.java (at line 51)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n41. ERROR in Y.java (at line 52)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n42. ERROR in Y.java (at line 53)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n43. ERROR in Y.java (at line 54)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n44. ERROR in Y.java (at line 55)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n45. ERROR in Y.java (at line 56)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n46. ERROR in Y.java (at line 57)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n47. ERROR in Y.java (at line 58)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n48. ERROR in Y.java (at line 59)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n49. ERROR in Y.java (at line 60)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n50. ERROR in Y.java (at line 61)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n51. ERROR in Y.java (at line 62)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n52. ERROR in Y.java (at line 63)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n"};
    private static String[] METHODS_ERRORS = new String[]{"1. ERROR in Y.java (at line 4)\n\t* @param str\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n2. ERROR in Y.java (at line 5)\n\t* @param xxx\n\t         ^^^\nJavadoc: Parameter xxx is not declared\n----------\n3. ERROR in Y.java (at line 8)\n\t* @throws java.io.IOException\n\t          ^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception IOException is not declared\n----------\n4. ERROR in Y.java (at line 9)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n5. ERROR in Y.java (at line 10)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n6. ERROR in Y.java (at line 11)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n7. ERROR in Y.java (at line 12)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n8. ERROR in Y.java (at line 13)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n9. ERROR in Y.java (at line 14)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n10. ERROR in Y.java (at line 15)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n11. ERROR in Y.java (at line 16)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n12. ERROR in Y.java (at line 17)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n13. ERROR in Y.java (at line 18)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n14. ERROR in Y.java (at line 19)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n15. ERROR in Y.java (at line 20)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n16. ERROR in Y.java (at line 21)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n17. ERROR in Y.java (at line 22)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n", "18. ERROR in Y.java (at line 27)\n\t* @param str\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n19. ERROR in Y.java (at line 28)\n\t* @param xxx\n\t         ^^^\nJavadoc: Parameter xxx is not declared\n----------\n20. ERROR in Y.java (at line 31)\n\t* @throws java.io.IOException\n\t          ^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception IOException is not declared\n----------\n21. ERROR in Y.java (at line 32)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n22. ERROR in Y.java (at line 33)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n23. ERROR in Y.java (at line 34)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n24. ERROR in Y.java (at line 35)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n25. ERROR in Y.java (at line 36)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n26. ERROR in Y.java (at line 37)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n27. ERROR in Y.java (at line 38)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n28. ERROR in Y.java (at line 39)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n29. ERROR in Y.java (at line 40)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n30. ERROR in Y.java (at line 41)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n31. ERROR in Y.java (at line 42)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n32. ERROR in Y.java (at line 43)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n33. ERROR in Y.java (at line 44)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n34. ERROR in Y.java (at line 45)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n", "35. ERROR in Y.java (at line 50)\n\t* @param str\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n36. ERROR in Y.java (at line 51)\n\t* @param xxx\n\t         ^^^\nJavadoc: Parameter xxx is not declared\n----------\n37. ERROR in Y.java (at line 54)\n\t* @throws java.io.IOException\n\t          ^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception IOException is not declared\n----------\n38. ERROR in Y.java (at line 55)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n39. ERROR in Y.java (at line 56)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n40. ERROR in Y.java (at line 57)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n41. ERROR in Y.java (at line 58)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n42. ERROR in Y.java (at line 59)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n43. ERROR in Y.java (at line 60)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n44. ERROR in Y.java (at line 61)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n45. ERROR in Y.java (at line 62)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n46. ERROR in Y.java (at line 63)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n47. ERROR in Y.java (at line 64)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n48. ERROR in Y.java (at line 65)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n49. ERROR in Y.java (at line 66)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n50. ERROR in Y.java (at line 67)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n51. ERROR in Y.java (at line 68)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n", "52. ERROR in Y.java (at line 73)\n\t* @param str\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n53. ERROR in Y.java (at line 74)\n\t* @param xxx\n\t         ^^^\nJavadoc: Parameter xxx is not declared\n----------\n54. ERROR in Y.java (at line 77)\n\t* @throws java.io.IOException\n\t          ^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception IOException is not declared\n----------\n55. ERROR in Y.java (at line 78)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n56. ERROR in Y.java (at line 79)\n\t* @see X_dep\n\t       ^^^^^\nJavadoc: The type X_dep is deprecated\n----------\n57. ERROR in Y.java (at line 80)\n\t* @see X.X_priv\n\t       ^^^^^^^^\nJavadoc: The type X.X_priv is not visible\n----------\n58. ERROR in Y.java (at line 81)\n\t* @see X.Unknown\n\t       ^^^^^^^^^\nJavadoc: X.Unknown cannot be resolved to a type\n----------\n59. ERROR in Y.java (at line 82)\n\t* @see X#X(int)\n\t         ^^^^^^\nJavadoc: The constructor X(int) is not visible\n----------\n60. ERROR in Y.java (at line 83)\n\t* @see X#X(String)\n\t         ^^^^^^^^^\nJavadoc: The constructor X(String) is undefined\n----------\n61. ERROR in Y.java (at line 84)\n\t* @see X#X()\n\t         ^^^\nJavadoc: The constructor X() is deprecated\n----------\n62. ERROR in Y.java (at line 85)\n\t* @see X#x_dep\n\t         ^^^^^\nJavadoc: The field X.x_dep is deprecated\n----------\n63. ERROR in Y.java (at line 86)\n\t* @see X#x_priv\n\t         ^^^^^^\nJavadoc: The field x_priv is not visible\n----------\n64. ERROR in Y.java (at line 87)\n\t* @see X#unknown\n\t         ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n65. ERROR in Y.java (at line 88)\n\t* @see X#foo_dep()\n\t         ^^^^^^^^^\nJavadoc: The method foo_dep() from the type X is deprecated\n----------\n66. ERROR in Y.java (at line 89)\n\t* @see X#foo_priv()\n\t         ^^^^^^^^\nJavadoc: The method foo_priv() from the type X is not visible\n----------\n67. ERROR in Y.java (at line 90)\n\t* @see X#foo_dep(String)\n\t         ^^^^^^^\nJavadoc: The method foo_dep() in the type X is not applicable for the arguments (String)\n----------\n68. ERROR in Y.java (at line 91)\n\t* @see X#unknown()\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n"};
    private static String[] X_ResultForMissingTags = new String[]{"1. ERROR in X.java (at line 8)\n\tpublic X(int i) {}\n\t             ^\nJavadoc: Missing tag for parameter i\n----------\n2. ERROR in X.java (at line 10)\n\tpublic int publicMethod(long l) { return 0;}\n\t       ^^^\nJavadoc: Missing tag for return type\n----------\n3. ERROR in X.java (at line 10)\n\tpublic int publicMethod(long l) { return 0;}\n\t                             ^\nJavadoc: Missing tag for parameter l\n----------\n", "4. ERROR in X.java (at line 17)\n\tprotected X(long l) {}\n\t                 ^\nJavadoc: Missing tag for parameter l\n----------\n5. ERROR in X.java (at line 19)\n\tprotected int protectedMethod(long l) { return 0; }\n\t          ^^^\nJavadoc: Missing tag for return type\n----------\n6. ERROR in X.java (at line 19)\n\tprotected int protectedMethod(long l) { return 0; }\n\t                                   ^\nJavadoc: Missing tag for parameter l\n----------\n", "7. ERROR in X.java (at line 26)\n\tX(float f) {}\n\t        ^\nJavadoc: Missing tag for parameter f\n----------\n8. ERROR in X.java (at line 28)\n\tint packageMethod(long l) { return 0;}\n\t^^^\nJavadoc: Missing tag for return type\n----------\n9. ERROR in X.java (at line 28)\n\tint packageMethod(long l) { return 0;}\n\t                       ^\nJavadoc: Missing tag for parameter l\n----------\n", "10. ERROR in X.java (at line 35)\n\tprivate X(double d) {}\n\t                 ^\nJavadoc: Missing tag for parameter d\n----------\n11. ERROR in X.java (at line 37)\n\tprivate int privateMethod(long l) { return 0;}\n\t        ^^^\nJavadoc: Missing tag for return type\n----------\n12. ERROR in X.java (at line 37)\n\tprivate int privateMethod(long l) { return 0;}\n\t                               ^\nJavadoc: Missing tag for parameter l\n----------\n"};
    private static String[] Y_ResultForMissingTags = new String[]{"1. ERROR in Y.java (at line 6)\n\tpublic int publicMethod(long l) { return 0;}\n\t       ^^^\nJavadoc: Missing tag for return type\n----------\n2. ERROR in Y.java (at line 6)\n\tpublic int publicMethod(long l) { return 0;}\n\t                             ^\nJavadoc: Missing tag for parameter l\n----------\n", "3. ERROR in Y.java (at line 8)\n\tprotected int protectedMethod(long l) { return 0;}\n\t          ^^^\nJavadoc: Missing tag for return type\n----------\n4. ERROR in Y.java (at line 8)\n\tprotected int protectedMethod(long l) { return 0;}\n\t                                   ^\nJavadoc: Missing tag for parameter l\n----------\n", "5. ERROR in Y.java (at line 10)\n\tint packageMethod(long l) { return 0;}\n\t^^^\nJavadoc: Missing tag for return type\n----------\n6. ERROR in Y.java (at line 10)\n\tint packageMethod(long l) { return 0;}\n\t                       ^\nJavadoc: Missing tag for parameter l\n----------\n", "7. ERROR in Y.java (at line 12)\n\tprivate int privateMethod(long l) { return 0;}\n\t        ^^^\nJavadoc: Missing tag for return type\n----------\n8. ERROR in Y.java (at line 12)\n\tprivate int privateMethod(long l) { return 0;}\n\t                               ^\nJavadoc: Missing tag for parameter l\n----------\n", "----------\n1. ERROR in Y.java (at line 12)\n\tprivate int privateMethod(long l) { return 0;}\n\t        ^^^\nJavadoc: Missing tag for return type\n----------\n2. ERROR in Y.java (at line 12)\n\tprivate int privateMethod(long l) { return 0;}\n\t                               ^\nJavadoc: Missing tag for parameter l\n----------\n"};
    private static String[] X_ResultForMissingComments = new String[]{"1. ERROR in X.java (at line 4)\n\tpublic class PublicClass {}\n\t             ^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n2. ERROR in X.java (at line 5)\n\tpublic int publicField;\n\t           ^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n3. ERROR in X.java (at line 6)\n\tpublic X(int i) {}\n\t       ^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n4. ERROR in X.java (at line 7)\n\tpublic int publicMethod(long l) { return 0;}\n\t           ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n", "5. ERROR in X.java (at line 9)\n\tprotected class ProtectedClass {}\n\t                ^^^^^^^^^^^^^^\nJavadoc: Missing comment for protected declaration\n----------\n6. ERROR in X.java (at line 10)\n\tprotected int protectedField;\n\t              ^^^^^^^^^^^^^^\nJavadoc: Missing comment for protected declaration\n----------\n7. ERROR in X.java (at line 11)\n\tprotected X(long l) {}\n\t          ^^^^^^^^^\nJavadoc: Missing comment for protected declaration\n----------\n8. ERROR in X.java (at line 12)\n\tprotected int protectedMethod(long l) { return 0; }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for protected declaration\n----------\n", "9. ERROR in X.java (at line 14)\n\tclass PackageClass {}\n\t      ^^^^^^^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n10. ERROR in X.java (at line 15)\n\tint packageField;\n\t    ^^^^^^^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n11. ERROR in X.java (at line 16)\n\tX(float f) {}\n\t^^^^^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n12. ERROR in X.java (at line 17)\n\tint packageMethod(long l) { return 0;}\n\t    ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n", "13. ERROR in X.java (at line 19)\n\tprivate class PrivateClass {}\n\t              ^^^^^^^^^^^^\nJavadoc: Missing comment for private declaration\n----------\n14. ERROR in X.java (at line 20)\n\tprivate int privateField;\n\t            ^^^^^^^^^^^^\nJavadoc: Missing comment for private declaration\n----------\n15. ERROR in X.java (at line 21)\n\tprivate X(double d) {}\n\t        ^^^^^^^^^^^\nJavadoc: Missing comment for private declaration\n----------\n16. ERROR in X.java (at line 22)\n\tprivate int privateMethod(long l) { return 0;}\n\t            ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for private declaration\n----------\n"};
    private static String[] Y_ResultForMissingComments = new String[]{"1. ERROR in Y.java (at line 5)\n\tpublic int publicMethod(long l) { return 0;}\n\t           ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n", "2. ERROR in Y.java (at line 6)\n\tprotected int protectedMethod(long l) { return 0;}\n\t              ^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for protected declaration\n----------\n", "3. ERROR in Y.java (at line 7)\n\tint packageMethod(long l) { return 0;}\n\t    ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n", "4. ERROR in Y.java (at line 8)\n\tprivate int privateMethod(long l) { return 0;}\n\t            ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for private declaration\n----------\n", "----------\n1. ERROR in Y.java (at line 8)\n\tprivate int privateMethod(long l) { return 0;}\n\t            ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for private declaration\n----------\n"};
    static /* synthetic */ Class class$0;

    private String resultForInvalidTagsClassOrField(int visibility) {
        if (this.reportInvalidJavadocTagsDeprecatedRef == null && this.reportInvalidJavadocTagsNotVisibleRef == null) {
            String result = "----------\n";
            int i = 0;
            while (i <= visibility) {
                result = String.valueOf(result) + CLASSES_ERRORS[i];
                ++i;
            }
            return result;
        }
        StringBuffer result = new StringBuffer("----------\n");
        int i = 0;
        int count = 1;
        while (i <= visibility) {
            StringTokenizer tokenizer = new StringTokenizer(CLASSES_ERRORS[i], "\n");
            while (tokenizer.hasMoreTokens()) {
                StringBuffer error = new StringBuffer();
                boolean add = true;
                int j = 0;
                while (j < 5) {
                    String line = tokenizer.nextToken();
                    switch (j) {
                        case 0: {
                            error.append(count);
                            error.append(line.substring(line.indexOf(46)));
                            break;
                        }
                        case 3: {
                            if ("disabled".equals(this.reportInvalidJavadocTagsDeprecatedRef)) {
                                boolean bl = add = line.indexOf("is deprecated") == -1;
                            }
                            if (add && "disabled".equals(this.reportInvalidJavadocTagsNotVisibleRef)) {
                                add = line.indexOf("is not visible") == -1 && line.indexOf("visibility for malformed doc comments") == -1;
                            }
                        }
                        default: {
                            error.append(line);
                        }
                    }
                    error.append('\n');
                    ++j;
                }
                if (!add) continue;
                ++count;
                result.append(error);
            }
            ++i;
        }
        return result.toString();
    }

    private String resultForInvalidTagsMethodOrConstructor(int visibility) {
        if (this.reportInvalidJavadocTagsDeprecatedRef == null && this.reportInvalidJavadocTagsNotVisibleRef == null) {
            String result = "----------\n";
            int i = 0;
            while (i <= visibility) {
                result = String.valueOf(result) + METHODS_ERRORS[i];
                ++i;
            }
            return result;
        }
        StringBuffer result = new StringBuffer("----------\n");
        int i = 0;
        int count = 1;
        while (i <= visibility) {
            StringTokenizer tokenizer = new StringTokenizer(METHODS_ERRORS[i], "\n");
            while (tokenizer.hasMoreTokens()) {
                StringBuffer error = new StringBuffer();
                boolean add = true;
                int j = 0;
                while (j < 5) {
                    String line = tokenizer.nextToken();
                    switch (j) {
                        case 0: {
                            error.append(count);
                            error.append(line.substring(line.indexOf(46)));
                            break;
                        }
                        case 3: {
                            if ("disabled".equals(this.reportInvalidJavadocTagsDeprecatedRef)) {
                                boolean bl = add = line.indexOf("is deprecated") == -1;
                            }
                            if (add && "disabled".equals(this.reportInvalidJavadocTagsNotVisibleRef)) {
                                add = line.indexOf("is not visible") == -1 && line.indexOf("visibility for malformed doc comments") == -1;
                            }
                        }
                        default: {
                            error.append(line);
                        }
                    }
                    error.append('\n');
                    ++j;
                }
                if (!add) continue;
                ++count;
                result.append(error);
            }
            ++i;
        }
        return result.toString();
    }

    private String resultForMissingTags(int visibility) {
        StringBuffer result = new StringBuffer("----------\n");
        int i = 0;
        while (i <= visibility) {
            result.append(X_ResultForMissingTags[i]);
            ++i;
        }
        if ("enabled".equals(this.reportMissingJavadocTagsOverriding)) {
            result.append("----------\n");
            result.append(Y_ResultForMissingTags[0]);
            if (visibility >= 1) {
                result.append(Y_ResultForMissingTags[1]);
                if (visibility >= 2) {
                    result.append(Y_ResultForMissingTags[2]);
                    if (visibility == 3) {
                        result.append(Y_ResultForMissingTags[3]);
                    }
                }
            }
        } else if (visibility == 3) {
            result.append(Y_ResultForMissingTags[4]);
        }
        return result.toString();
    }

    private String resultForMissingComments(int visibility) {
        StringBuffer result = new StringBuffer("----------\n");
        int i = 0;
        while (i <= visibility) {
            result.append(X_ResultForMissingComments[i]);
            ++i;
        }
        if ("enabled".equals(this.reportMissingJavadocCommentsOverriding)) {
            result.append("----------\n");
            result.append(Y_ResultForMissingComments[0]);
            if (visibility >= 1) {
                result.append(Y_ResultForMissingComments[1]);
                if (visibility >= 2) {
                    result.append(Y_ResultForMissingComments[2]);
                    if (visibility == 3) {
                        result.append(Y_ResultForMissingComments[3]);
                    }
                }
            }
        } else if (visibility == 3) {
            result.append(Y_ResultForMissingComments[4]);
        }
        return result.toString();
    }

    public JavadocTestOptions(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Test suite() {
        return JavadocTestOptions.buildAllCompliancesTestSuite(JavadocTestOptions.javadocTestClass());
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        if (this.docCommentSupport != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", this.docCommentSupport);
        }
        if (this.reportInvalidJavadoc != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        }
        if (this.reportInvalidJavadocTagsVisibility != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocTagsVisibility);
        }
        if (this.reportInvalidJavadocTags != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", this.reportInvalidJavadocTags);
        }
        if (this.reportInvalidJavadocTagsDeprecatedRef != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportInvalidJavadocTagsDeprecatedRef);
        }
        if (this.reportInvalidJavadocTagsNotVisibleRef != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", this.reportInvalidJavadocTagsNotVisibleRef);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
        }
        if (this.reportMissingJavadocTagsVisibility != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", this.reportMissingJavadocTagsVisibility);
        }
        if (this.reportMissingJavadocTagsOverriding != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsOverriding", this.reportMissingJavadocTagsOverriding);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        }
        if (this.reportMissingJavadocCommentsVisibility != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
        }
        if (this.reportMissingJavadocCommentsOverriding != null) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsOverriding", this.reportMissingJavadocCommentsOverriding);
        }
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reportInvalidJavadoc = null;
        this.reportInvalidJavadocTagsVisibility = null;
        this.reportInvalidJavadocTags = null;
        this.reportInvalidJavadocTagsDeprecatedRef = null;
        this.reportInvalidJavadocTagsNotVisibleRef = null;
        this.reportMissingJavadocTags = null;
        this.reportMissingJavadocTagsVisibility = null;
        this.reportMissingJavadocTagsOverriding = null;
        this.reportMissingJavadocComments = null;
        this.reportMissingJavadocCommentsVisibility = null;
        this.reportMissingJavadocCommentsOverriding = null;
    }

    public void testInvalidTagsClassNoSupport() {
        this.docCommentSupport = "disabled";
        this.runConformTest(CLASSES_INVALID_COMMENT);
    }

    public void testInvalidTagsFieldNoSupport() {
        this.docCommentSupport = "disabled";
        this.runConformTest(FIELDS_INVALID_COMMENT);
    }

    public void testInvalidTagsMethodNoSupport() {
        this.docCommentSupport = "disabled";
        this.runConformTest(METHODS_INVALID_COMMENT);
    }

    public void testInvalidTagsConstructorNoSupport() {
        this.docCommentSupport = "disabled";
        this.runConformTest(CONSTRUCTORS_INVALID_COMMENT);
    }

    public void testInvalidTagsClassDefaults() {
        this.runConformTest(CLASSES_INVALID_COMMENT);
    }

    public void testInvalidTagsFieldDefaults() {
        this.runConformTest(FIELDS_INVALID_COMMENT);
    }

    public void testInvalidTagsMethodDefaults() {
        this.runConformTest(METHODS_INVALID_COMMENT);
    }

    public void testInvalidTagsConstructorDefaults() {
        this.runConformTest(CONSTRUCTORS_INVALID_COMMENT);
    }

    public void testInvalidTagsClassErrorNotags() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "disabled";
        this.runConformTest(CLASSES_INVALID_COMMENT);
    }

    public void testInvalidTagsFieldErrorNotags() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "disabled";
        this.runConformTest(FIELDS_INVALID_COMMENT);
    }

    public void testInvalidTagsMethodErrorNotags() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "disabled";
        this.runConformTest(METHODS_INVALID_COMMENT);
    }

    public void testInvalidTagsConstructorErrorNotags() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "disabled";
        this.runConformTest(CONSTRUCTORS_INVALID_COMMENT);
    }

    public void testInvalidTagsClassErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsFieldErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsMethodErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsConstructorErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsClassErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsFieldErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsMethodErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsConstructorErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsClassErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsFieldErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsMethodErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsConstructorErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsClassErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsFieldErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsMethodErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsConstructorErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsDeprecatedRefClassErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsDeprecatedRefFieldErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsDeprecatedRefMethodErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsDeprecatedRefConstructorErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsDeprecatedRefClassErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsDeprecatedRefFieldErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsDeprecatedRefMethodErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsDeprecatedRefConstructorErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsDeprecatedRefClassErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsDeprecatedRefFieldErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsDeprecatedRefMethodErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsDeprecatedRefConstructorErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsDeprecatedRefClassErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsDeprecatedRefFieldErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsDeprecatedRefMethodErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsDeprecatedRefConstructorErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsNotVisibleRefClassErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsNotVisibleRefFieldErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsNotVisibleRefMethodErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsNotVisibleRefConstructorErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsNotVisibleRefClassErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsNotVisibleRefFieldErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsNotVisibleRefMethodErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsNotVisibleRefConstructorErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsNotVisibleRefClassErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsNotVisibleRefFieldErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsNotVisibleRefMethodErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsNotVisibleRefConstructorErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsNotVisibleRefClassErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsNotVisibleRefFieldErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsNotVisibleRefMethodErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsNotVisibleRefConstructorErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefClassErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefFieldErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(0));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefMethodErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefConstructorErrorTagsPublic() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "public";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(0));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefClassErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefFieldErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(1));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefMethodErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefConstructorErrorTagsProtected() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "protected";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(1));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefClassErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefFieldErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(2));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefMethodErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefConstructorErrorTagsPackage() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.reportInvalidJavadocTagsVisibility = "default";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(2));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefClassErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(CLASSES_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefFieldErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(FIELDS_INVALID_COMMENT, this.resultForInvalidTagsClassOrField(3));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefMethodErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(METHODS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testInvalidTagsDeprecatedAndNotVisibleRefConstructorErrorTagsPrivate() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTagsDeprecatedRef = "disabled";
        this.reportInvalidJavadocTagsNotVisibleRef = "disabled";
        this.runNegativeTest(CONSTRUCTORS_INVALID_COMMENT, this.resultForInvalidTagsMethodOrConstructor(3));
    }

    public void testMissingTagsDefaults() {
        this.runConformTest(MISSING_TAGS);
    }

    public void testMissingTagsErrorPublicOverriding() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "public";
        this.reportMissingJavadocTagsOverriding = "enabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(0));
    }

    public void testMissingTagsErrorPublic() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "public";
        this.reportMissingJavadocTagsOverriding = "disabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(0));
    }

    public void testMissingTagsErrorProtectedOverriding() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "protected";
        this.reportMissingJavadocTagsOverriding = "enabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(1));
    }

    public void testMissingTagsErrorProtected() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "protected";
        this.reportMissingJavadocTagsOverriding = "disabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(1));
    }

    public void testMissingTagsErrorPackageOverriding() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "default";
        this.reportMissingJavadocTagsOverriding = "enabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(2));
    }

    public void testMissingTagsErrorPackage() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "default";
        this.reportMissingJavadocTagsOverriding = "disabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(2));
    }

    public void testMissingTagsErrorPrivateOverriding() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "private";
        this.reportMissingJavadocTagsOverriding = "enabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(3));
    }

    public void testMissingTagsErrorPrivate() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "private";
        this.reportMissingJavadocTagsOverriding = "disabled";
        this.runNegativeTest(MISSING_TAGS, this.resultForMissingTags(3));
    }

    public void testMissingCommentsDefaults() {
        this.runConformTest(MISSING_COMMENTS);
    }

    public void testMissingCommentsErrorPublicOverriding() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "public";
        this.reportMissingJavadocCommentsOverriding = "enabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(0));
    }

    public void testMissingCommentsErrorPublic() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "public";
        this.reportMissingJavadocCommentsOverriding = "disabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(0));
    }

    public void testMissingCommentsErrorProtectedOverriding() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "protected";
        this.reportMissingJavadocCommentsOverriding = "enabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(1));
    }

    public void testMissingCommentsErrorProtected() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "protected";
        this.reportMissingJavadocCommentsOverriding = "disabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(1));
    }

    public void testMissingCommentsErrorPackageOverriding() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "default";
        this.reportMissingJavadocCommentsOverriding = "enabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(2));
    }

    public void testMissingCommentsErrorPackage() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "default";
        this.reportMissingJavadocCommentsOverriding = "disabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(2));
    }

    public void testMissingCommentsErrorPrivateOverriding() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "private";
        this.reportMissingJavadocCommentsOverriding = "enabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(3));
    }

    public void testMissingCommentsErrorPrivate() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "private";
        this.reportMissingJavadocCommentsOverriding = "disabled";
        this.runNegativeTest(MISSING_COMMENTS, this.resultForMissingComments(3));
    }

    public void testInvalidTagsClassWithMissingTagsOption() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "private";
        this.runConformTest(CLASSES_INVALID_COMMENT);
    }

    public void testInvalidTagsFieldWithMissingTagsOption() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "private";
        this.runConformTest(FIELDS_INVALID_COMMENT);
    }

    public void testInvalidTagsMethodWithMissingTagsOption() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "private";
        this.runConformTest(METHODS_INVALID_COMMENT);
    }

    public void testInvalidTagsConstructorWithMissingTagsOption() {
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsVisibility = "private";
        this.runConformTest(CONSTRUCTORS_INVALID_COMMENT);
    }

    public void testMissingTagsWithInvalidTagsOption() {
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocTagsVisibility = "private";
        this.runConformTest(MISSING_TAGS);
    }

    public void testInvalidTagsJavadocSupportDisabled() {
        this.docCommentSupport = "disabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "error";
        this.runConformTest(CLASSES_INVALID_COMMENT);
        this.runConformTest(FIELDS_INVALID_COMMENT);
        this.runConformTest(METHODS_INVALID_COMMENT);
        this.runConformTest(CONSTRUCTORS_INVALID_COMMENT);
    }

    public void testMissingCommentsJavadocSupportDisabled() {
        this.docCommentSupport = "disabled";
        this.reportMissingJavadocComments = "error";
        this.runConformReferenceTest(MISSING_COMMENTS);
    }

    public void testMissingTagsJavadocSupportDisabled() {
        this.docCommentSupport = "disabled";
        this.reportMissingJavadocTags = "error";
        this.runConformReferenceTest(MISSING_TAGS);
    }
}

