/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class InnerEmulationTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public InnerEmulationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return InnerEmulationTest.buildAllCompliancesTestSuite(InnerEmulationTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\nimport p2.*;\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\n\tprotected int value = 0;\t\t\t\t\n\tprotected A delegatee;\t\t\t\t\t\n\tpublic A(A del, int val) {\t\t\t\t\n\t\tthis.delegatee = del;\t\t\t\t\n\t\tthis.value = val;\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tprotected void foo() {\t\t\t\t\t\n\t\tvalue += 3;\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String[] argv){\t\n\t\tint result = new B(\t\t\t\t\t\n\t\t\t\t\t  new B(null, 10), 20)  \n\t\t\t\t\t .value; \t\t\t\t\n\t\tint expected = 30; \t\t\t\t\t\n\t\tSystem.out.println( \t\t\t\t\n\t\t\tresult == expected \t\t\t\t\n\t\t\t\t? \"SUCCESS\"  \t\t\t\t\n\t\t\t\t: \"FAILED : got \"+result+\" instead of \"+ expected); \n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "p2/B.java", "package p2;\t\t\t\t\t\t\t\t\nimport p1.*;\t\t\t\t\t\t\t\t\npublic class B extends A {\t\t\t\t\t\n\tpublic B(B del, int val){\t\t\t\t\n\t\tsuper(del, val);\t\t\t\t\t\n\t\tRunnable r = new Runnable () {\t\t\n\t\t\tpublic void run() {\t\t\t\t\n\t\t\t\tfoo(); \t\t\t\t\t\t\n\t\t\t\tif (delegatee != null) \t\t\n\t\t\t\t\tvalue += 7;\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\n\t\tr.run();\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n"}, "SUCCESS");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"A.java", "class B { \n} \npublic class A { \n\tB b; \n\tclass C extends B { \n\t\tpublic C() { \n\t\t} \n\t} \n\tpublic A() { \n\t\tthis(new C()); \n\t} \n\tpublic A(C c) { \n\t\tthis.b = c; \n\t} \n\tpublic static void main(String[] args) { \n\t\tA a = new A(); \n\t\tSystem.out.println(a); \n\t} \n} \n"}, "----------\n1. ERROR in A.java (at line 10)\n\tthis(new C()); \n\t     ^^^^^^^\nNo enclosing instance of type A is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"A.java", "public class A extends Thread { \n\tprivate class B { \n\t} \n\tprivate static Runnable getRunnable() { \n\t\treturn null; \n\t} \n\tpublic A() { \n\t\tsuper(getRunnable(), new B().toString()); \n\t} \n} \n"}, "----------\n1. WARNING in A.java (at line 8)\n\tsuper(getRunnable(), new B().toString()); \n\t                     ^^^^^^^\nAccess to enclosing constructor A.B() is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n2. ERROR in A.java (at line 8)\n\tsuper(getRunnable(), new B().toString()); \n\t                     ^^^^^^^\nNo enclosing instance of type A is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test004() {
        this.runConformTest(new String[]{"A3.java", "class A3 { \n\tclass B {} \n} \n"}, null, null);
        this.runConformTest(new String[]{"A4.java", "class A4 { \n\tvoid foo(){ \n\t\tnew A3().new B(){}; \n\t} \n} \n"}, null, null, false, null);
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tprivate X(){} \n\tclass Y extends X { \n\t} \n\tpublic static void main(String[] argv){\t\n\t\tnew X().new Y();\t \t\t\t\t \n\t\tSystem.out.println(\"SUCCESS\");\t \n\t}\t\t\t\t\t\t\t\t\t\t\n} \n"}, "SUCCESS");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] argv){ \n\t\tnew B(); \n\t\tSystem.out.println(\"SUCCESS\"); \n\t} \n\tprivate static void foo(int i, int j) { \n\t\tSystem.out.println(\"private foo\"); \n\t} \n\tstatic class B { \n\t\t{ \n\t\t\tfoo(1, 2); \n\t\t} \n\t} \n}\t\t \n"}, "private foo\nSUCCESS");
    }

    public void test007() {
        this.runConformTest(new String[]{"Y.java", "public class Y { \n\tpublic static void main(String[] argv){ \n\t\tif (new Y().bar() == 3) \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\telse \n\t\t\tSystem.out.println(\"FAILED\"); \n\t} \n\tint bar() { \n\t\tfinal int i = \"xxx\".length(); \n\t\tclass X { \n\t\t\tclass AX { \n\t\t\t\tint foo() { \n\t\t\t\t\treturn new BX().foo(); \n\t\t\t\t} \n\t\t\t} \n\t\t\tclass BX { \n\t\t\t\tint foo() { \n\t\t\t\t\treturn new CX().foo(); \n\t\t\t\t} \n\t\t\t} \n\t\t\tclass CX { \n\t\t\t\tint foo() { \n\t\t\t\t\treturn i; \n\t\t\t\t} \n\t\t\t} \n\t\t} \n\t\treturn new X().new AX().foo(); \n\t} \n} \n"}, "SUCCESS");
    }

    public void test008() {
        this.runConformTest(new String[]{"Y2.java", "public class Y2 { \n\tpublic static void main(String[] argv){ \n\t\tif (new Y2().foo(45) == 45) \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\telse \n\t\t\tSystem.out.println(\"FAILED\"); \n\t} \n\tint foo(final int i){ \n\t\tclass B { \n\t\t\tint foo(){ \n\t\t\t\treturn new C().foo(); \n\t\t\t} \n\t\t\tclass C { \n\t\t\t\tint foo(){ return i; } \n\t\t\t} \n\t\t}; \n\t\treturn new B().foo(); \n\t} \n} \n"}, "SUCCESS");
    }

    public void test009() {
        this.runConformTest(new String[]{"Y3.java", "public class Y3 { \n\tpublic static void main(String[] argv){ \n\t\tif (new Y3().bar() == 8) \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\telse \n\t\t\tSystem.out.println(\"FAILED\"); \n\t} \n\tint bar() { \n\t\tfinal int i = \"xxx\".length(); \n\t\tfinal String s = this.toString(); \n\t\tclass X { \n\t\t\tclass AX { \n\t\t\t\tint foo() { \n\t\t\t\t\treturn i + new CX().foo(); \n\t\t\t\t} \n\t\t\t} \n\t\t\tclass BX { \n\t\t\t\tint foo() { \n\t\t\t\t\treturn new AX().foo(); \n\t\t\t\t} \n\t\t\t} \n\t\t\tclass CX { \n\t\t\t\tint foo() { \n\t\t\t\t\treturn 5; \n\t\t\t\t} \n\t\t\t} \n\t\t} \n\t\treturn new X().new AX().foo(); \n\t} \n} \n"}, "SUCCESS");
    }

    public void test010() {
        this.runConformTest(new String[]{"Y4.java", "public class Y4 { \n\tpublic static void main(String[] argv){ \n\t\tif (new Y4().bar() == 3) \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\telse \n\t\t\tSystem.out.println(\"FAILED\"); \n\t} \n\tint bar() { \n\t\tfinal int i = \"xxx\".length(); \n\t\tfinal String s = this.toString(); \n\t\tclass X { \n\t\t\tclass AX { \n\t\t\t\tint bar() { \n\t\t\t\t\tclass BX { \n\t\t\t\t\t\tint foo() { \n\t\t\t\t\t\t\treturn new AX().foo(); \n\t\t\t\t\t\t} \n\t\t\t\t\t} \n\t\t\t\t\treturn new BX().foo(); \n\t\t\t\t} \n\t\t\t\tint foo() { \n\t\t\t\t\treturn i; \n\t\t\t\t} \n\t\t\t} \n\t\t} \n\t\treturn new X().new AX().bar(); \n\t} \n} \n"}, "SUCCESS");
    }

    public void test011() {
        this.runConformTest(new String[]{"Y5.java", "public class Y5 { \n\tpublic static void main(String[] argv){ \n\t\tif (new Y5().bar(5) == 5) \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\telse \n\t\t\tSystem.out.println(\"FAILED\"); \n\t} \n\tint bar(final int i) { \n\t\tclass X { \n\t\t\tint bar() { \n\t\t\t\treturn new Object(){  \n\t\t\t\t\t\tint foo(){ \n\t\t\t\t\t\t\treturn i; \n\t\t\t\t\t\t} \n\t\t\t\t\t}.foo(); \n\t\t\t} \n\t\t} \n\t\treturn new X().bar(); \n\t} \n} \n"}, "SUCCESS");
    }

    public void test012() {
        this.runConformTest(new String[]{"A.java", "public class A { \n\tpublic static void main(String[] argv){ \n\t\tif (new A().foo() == 5) \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\telse \n\t\t\tSystem.out.println(\"FAILED\"); \n\t} \n\tint foo() { \n\t\treturn new A() { \n\t\t\tint foo() { \n\t\t\t\tfinal int i = \"hello\".length(); \n\t\t\t\treturn new A() { \n\t\t\t\t\tint foo() { \n\t\t\t\t\t\treturn i; \n\t\t\t\t\t} \n\t\t\t\t} \n\t\t\t\t.foo(); \n\t\t\t} \n\t\t} \n\t\t.foo(); \n\t} \n} \n"}, "SUCCESS");
    }

    public void test013() {
        this.runConformTest(new String[]{"Inner.java", "public class Inner { \n\tpublic static void main(String[] argv){ \n\t\tnew B().new C(\"hello\"); \n\t\tSystem.out.println(\"SUCCESS\"); \n\t} \n  class A { \t\n    public A(String s){ this.s=s; }\t\n    String s;\t\n  }\t\n}\t\nclass B {\t\n  class C extends Inner.A {\t\n    public C(String s){  B.this.inner.super(s); }   \t\n  }\t\n  Inner inner=new Inner();\t\n}\t\n"}, "SUCCESS");
    }

    public void test014() {
        this.runConformTest(new String[]{"Z1.java", "public class Z1 { \n\tpublic static void main(String[] argv){ \n\t\tnew Z1().new W(); \n\t\tSystem.out.println(\"SUCCESS\"); \n\t} \n\tclass W extends Y { \n\t\tW() { \n\t\t\tsuper(new Object(), foo()); \n\t\t} \n\t} \n\tString foo() { \n\t\treturn \"\"; \n\t} \n} \nclass Y { \n\tY(Object o, String s) { \n\t} \n}\t\n"}, "SUCCESS");
    }

    public void test015() {
        this.runConformTest(new String[]{"AAA.java", "public class AAA {  \n\tpublic static void main(String argv[]){  \n\t\tif (new AAA().foo(5) == 15);  \n\t\tSystem.out.println(\"SUCCESS\"); \n\t}  \n\tint foo(final int loc){  \n\t\tclass I {  \n\t\t\tint i = loc;  \n\t\t\t{  \n\t\t\t\tSystem.out.println(\"loc=\"+ loc );\t  \n\t\t\t}  \n\t\t\tint foo(){   \n\t\t\t\tSystem.out.println(\"I:i=\"+ i );\t  \n\t\t\t\treturn i;}   \n\t\t}    \n\t\tclass J extends I {  \n\t\t\tI obj = new I(){  \n\t\t\t\tint foo() {  \n\t\t\t\t\tSystem.out.println(\"J\");  \n\t\t\t\t\treturn super.foo() + 10; }};  \n\t\t}  \n\t\treturn new J().obj.foo();  \n\t}  \n }  \n"}, "loc=5\nloc=5\nJ\nI:i=5\nSUCCESS");
    }

    public void test016() {
        this.runConformTest(new String[]{"AAA.java", "public class AAA {  \n\tpublic static void main(String argv[]){  \n\t\tif (new AAA().foo(5) == 15);  \n\t\tSystem.out.println(\"SUCCESS\"); \n\t}  \n\tclass B{} \n\tint foo(final int loc){ \n\t\tclass I extends B { \n\t\t\tint i = loc; \n\t\t\t{ \n\t\t\t\tSystem.out.println(\"loc=\"+ loc );\t \n\t\t\t} \n\t\t\tint foo(){  \n\t\t\t\tSystem.out.println(\"I:i=\"+ i );\t \n\t\t\t\treturn i;}  \n\t\t}   \n\t\tclass J extends I { \n\t\t\tI obj = new I(){ \n\t\t\t\tint foo() { \n\t\t\t\t\tSystem.out.println(\"J\"); \n\t\t\t\t\treturn super.foo() + 10; }}; \n\t\t} \n\t\treturn new J().obj.foo(); \n\t} \n }  \n"}, "loc=5\nloc=5\nJ\nI:i=5\nSUCCESS");
    }

    public void test017() {
        this.runConformTest(new String[]{"MultiComplex.java", "public class MultiComplex {\n\t// should just be an interface, once supported...\n\tabstract class AbstractTask implements Runnable {\n\t\tpublic void run() {\n\t\t\tMultiComplex.this.notifyCompletion(this,0); \n\t\t}\n\t\tabstract public String taskName();\t\t\n\t}\n\tpublic static void main(String argv[]){\n\t\ttry {\n\t\t\tnew MultiComplex().performTasks(3);\n\t\t}\n\t\tcatch(InterruptedException e){};\n\t}  \n\tvoid notifyCompleted(AbstractTask task) {\n\t}\n\tvoid notifyCompletion(AbstractTask task, int percentage) {\n\t}\n\tvoid notifyExecutionEnd() {\n\t\tSystem.out.println(\"EXECUTION FINISHED\");\n\t}\n\tvoid notifyExecutionStart() {\n\t\tSystem.out.println(\"EXECUTION STARTING\");\n\t}\n\tvoid performTasks(final int maxTasks) throws InterruptedException {\n\t\tThread workers[] = new Thread[maxTasks];\n\t\tAbstractTask tasks[] = new AbstractTask[maxTasks];\n\t\tfinal int maxIteration = 5;\n \n\t\t// Local Task \n\t\tclass Task extends AbstractTask { \n\t\t\t\tString taskName; \n\t\t\t\tTask(String aName) {\n\t\t\t\t\ttaskName = aName;\n\t\t\t\t}\n\t\t\t\tpublic String taskName() { \n\t\t\t\t\treturn taskName; \n\t\t\t\t}\n\t\n\t\t\t\tpublic void run() {\n\t\t\t\t\tsuper.run();\n\t\t\t\t\tfor(int j = 0; j < maxIteration; j++)\n\t\t\t\t\t\tMultiComplex.this.notifyCompletion(this,  (int)((float) (j + 1) / maxIteration * 100));\n\t\t\t\t}\n\t\t};\n\t\tnotifyExecutionStart();\n\t\t\n\t\t// Creating and launching the tasks\n\t\tfor (int ii = 0; ii < maxTasks; ii++) {\n\t\t\tfinal int i = ii;\n\t\t\ttasks[i] = new Task(String.valueOf(i + 1)) {\t\t\t\n\t\t\t\tpublic String taskName() { \n\t\t\t\t\treturn super.taskName() +  \" of \" + maxTasks; }\n\t\t\t\tpublic void run() {\n\t\t\t\t\tsuper.run();\n\t\t\t\t\tMultiComplex.this.notifyCompleted(this);\n\t\t\t\t}\t\t\n\t\t\t};\n\t\t\tworkers[i] = new Thread(tasks[i],tasks[i].taskName());\n\t\t\tworkers[i].start();\n\t\t}\n\t\t// Waiting for *all* tasks to be ended\n\t\tfor (int i = 0; i < tasks.length; i++)\n\t\t\tworkers[i].join();\n\t\tnotifyExecutionEnd();\n\t}\n}\n"}, "EXECUTION STARTING\nEXECUTION FINISHED");
    }

    public void test018() {
        this.runConformTest(new String[]{"MultiAnonymous.java", "public class MultiAnonymous {\n\tpublic static void main(String argv[]){\n\t\ttry {\n\t\t\tnew MultiAnonymous().performTasks(3);\n\t\t}\n\t\tcatch(InterruptedException e){};\n\t}\n\tvoid notifyExecutionEnd() {\n\t\tSystem.out.println(\"EXECUTION FINISHED\");\n\t}\n\tvoid notifyExecutionStart() {\n\t\tSystem.out.println(\"EXECUTION STARTING\");\n\t}\n\tvoid performTasks(final int maxTasks) throws java.lang.InterruptedException {\n\t\tThread workers[] = new Thread[maxTasks];\n\t\tRunnable tasks[] = new Runnable[maxTasks];\n\t\tfinal int maxIteration = 5;\n\t\tnotifyExecutionStart();\n\t\t\n\t\t// Creating and launching the tasks\n\t\tfor (int ii = 0; ii < maxTasks; ii++) {\n\t\t\tfinal int i = ii;\n\t\t\ttasks[i] = new Runnable() {\t\t\t\n\t\t\t\tpublic String toString() { return ((i + 1) + \" of \" + maxTasks); }\n\t\t\t\tpublic void run() {\n\t\t\t\t\tfor(int j = 0; j < maxIteration; j++)\n\t\t\t\t\t\tnotifyCompletion( (int)((float) (j + 1) / maxIteration * 100));\n\t\t\t\t}\t\t\n\t\t\t\n\t\t\t\tvoid notifyCompletion(int percentage) {\n\t\t\t\t}\n\t\t\t};\n\t\t\tworkers[i] = new Thread(tasks[i],\"Running task(\"+(tasks[i].toString())+\")\");\n\t\t\tworkers[i].start();\n\t\t}\n\t\t// Waiting for *all* tasks to be ended\n\t\tfor (int i = 0; i < tasks.length; i++)\n\t\t\tworkers[i].join();\n\t\tnotifyExecutionEnd();\n\t}\n}\n"}, "EXECUTION STARTING\nEXECUTION FINISHED");
    }

    public void test019() {
        this.runConformTest(new String[]{"MultiComplex2.java", "public class MultiComplex2 {\n\tpublic interface AbstractTask extends Runnable {\n\t\tpublic void run();\n\t\tpublic String taskName();\t\t\n\t}\n\t\n\tpublic static void main(String argv[]){\n\t\ttry {\n\t\t\tnew MultiComplex2().performTasks(3);\n\t\t}\n\t\tcatch(InterruptedException e){};\n\t}\n\tvoid notifyCompleted(AbstractTask task) {\n\t}\n\tvoid notifyCompletion(AbstractTask task, int percentage) {\n\t}\n\tvoid notifyExecutionEnd() {\n\t\tSystem.out.println(\"EXECUTION FINISHED\");\n\t}\n\tvoid notifyExecutionStart() {\n\t\tSystem.out.println(\"EXECUTION STARTING\");\n\t}\n\t\tvoid performTasks(final int maxTasks) throws java.lang.InterruptedException {\n\t\tThread workers[] = new Thread[maxTasks];\n\t\tAbstractTask tasks[] = new AbstractTask[maxTasks];\n\t\tfinal int maxIteration = 5;\n\t\t// Local Task\n\t\tclass Task implements AbstractTask {\n\t\t\t\tString taskName;\n\t\t\t\tTask(String aName) {\n\t\t\t\t\ttaskName = aName;\n\t\t\t\t}\n\t\t\t\tpublic String taskName() { \n\t\t\t\t\treturn taskName; \n\t\t\t\t}\n\t\n\t\t\t\tpublic void run() {\n\t\t\t\t\tMultiComplex2.this.notifyCompletion(this,0); \n\t\t\t\t\tfor(int j = 0; j < maxIteration; j++)\n\t\t\t\t\t\tMultiComplex2.this.notifyCompletion(this,  (int)((float) (j + 1) / maxIteration * 100));\n\t\t\t\t}\n\t\t};\n\t\tnotifyExecutionStart();\n\t\t\n\t\t// Creating and launching the tasks\n\t\tfor (int ii = 0; ii < maxTasks; ii++) {\n\t\t\tfinal int i = ii;\n\t\t\ttasks[i] = new Task(String.valueOf(i + 1)) {\t\t\t\n\t\t\t\tpublic String taskName() { \n\t\t\t\t\treturn super.taskName() +  \" of \" + maxTasks; }\n\t\t\t\tpublic void run() {\n\t\t\t\t\tsuper.run();\n\t\t\t\t\tMultiComplex2.this.notifyCompleted(this);\n\t\t\t\t}\t\t\n\t\t\t};\n\t\t\tworkers[i] = new Thread(tasks[i],tasks[i].taskName());\n\t\t\tworkers[i].start();\n\t\t}\n\t\t// Waiting for *all* tasks to be ended\n\t\tfor (int i = 0; i < tasks.length; i++)\n\t\t\tworkers[i].join();\n\t\tnotifyExecutionEnd();\n\t}\n}\n"}, "EXECUTION STARTING\nEXECUTION FINISHED");
    }

    public void test020() {
        this.runConformTest(new String[]{"MultiLocal.java", "public class MultiLocal {\n\tpublic static void main(String argv[]){\n\t\tclass Task implements Runnable {\n\t\t\tprivate String taskName;\n\t\t\tprivate int maxIteration; \n\t\t\tpublic Task(String name, int value) {\n\t\t\t\ttaskName = name; \n\t\t\t\tmaxIteration = value;\n\t\t\t}\n\t\n\t\t\tpublic String toString() { return taskName; }\n\t\t\tpublic void run() {\n\t\t\t\tfor(int i = 0; i < maxIteration; i++)\n\t\t\t\t\tnotifyCompletion( (int)((float) (i + 1) / maxIteration * 100));\n\t\t\t}\t\t\n\t\t\t\n\t\t\tvoid notifyCompletion(int percentage) {\n\t\t\t}\n\t\t};\n\t\tMultiLocal multi = new MultiLocal();\n\t\tint maxTasks = 3;\n\t\tTask tasks[] = new Task[maxTasks];\n\t\tfor (int i = 0; i < maxTasks; i++) \n\t\t\ttasks[i] = new Task(String.valueOf(i),5);\n\t\ttry {\n\t\t\tmulti.performTasks(tasks);\n\t\t}\n\t\tcatch(InterruptedException e){};\n\t}\n\tvoid notifyExecutionEnd() {\n\t\tSystem.out.println(\"EXECUTION FINISHED\");\n\t}\n\tvoid notifyExecutionStart() {\n\t\tSystem.out.println(\"EXECUTION STARTING\");\n\t}\n\tvoid performTasks(Runnable tasks[]) throws java.lang.InterruptedException {\n\t\tThread workers[] = new Thread[tasks.length];\n\t\tnotifyExecutionStart();\n\t\t\n\t\t// Launching the tasks\n\t\tfor (int i = 0; i < tasks.length; i++) {\n\t\t\tworkers[i] = new Thread(tasks[i],\"Running task(\"+(tasks[i].toString())+\")\");\n\t\t\tworkers[i].start();\n\t\t}\n\t\t// Waiting for *all* tasks to be ended\n\t\tfor (int i = 0; i < tasks.length; i++)\n\t\t\tworkers[i].join();\n\t\tnotifyExecutionEnd();\n\t}\n}\n"}, "EXECUTION STARTING\nEXECUTION FINISHED");
    }

    public void test021() {
        this.runConformTest(new String[]{"MultiLocal2.java", "public class MultiLocal2 {\n\tpublic static void main(String argv[]){\n\t\tfinal int maxTasks = 3;\n\t\tclass Task implements Runnable {\n\t\t\tprivate String taskName;\n\t\t\tprivate int maxIteration;\n\t\t\tpublic Task(String name, int value) {\n\t\t\t\ttaskName = name; \n\t\t\t\tmaxIteration = value;\n\t\t\t}\n\t\n\t\t\tpublic String toString() { return taskName + \" of \" + String.valueOf(maxTasks); }\n\t\t\tpublic void run() {\n\t\t\t\tfor(int i = 0; i < maxIteration; i++)\n\t\t\t\t\tnotifyCompletion( (int)((float) (i + 1) / maxIteration * 100));\n\t\t\t}\t\t\n\t\t\t\n\t\t\tvoid notifyCompletion(int percentage) {\n\t\t\t}\n\t\t};\n\t\tMultiLocal2 multi = new MultiLocal2();\n\t\tTask tasks[] = new Task[maxTasks];\n\t\tfor (int i = 0; i < maxTasks; i++) \n\t\t\ttasks[i] = new Task(String.valueOf(i+1),5);\n\t\ttry {\n\t\t\tmulti.performTasks(tasks);\n\t\t}\n\t\tcatch(InterruptedException e){};\n\t}\n\tvoid notifyExecutionEnd() {\n\t\tSystem.out.println(\"EXECUTION FINISHED\");\n\t}\n\tvoid notifyExecutionStart() {\n\t\tSystem.out.println(\"EXECUTION STARTING\");\n\t}\n\tvoid performTasks(Runnable tasks[]) throws java.lang.InterruptedException {\n\t\tThread workers[] = new Thread[tasks.length];\n\t\tnotifyExecutionStart();\n\t\t\n\t\t// Launching the tasks\n\t\tfor (int i = 0; i < tasks.length; i++) {\n\t\t\tworkers[i] = new Thread(tasks[i],\"Running task(\"+(tasks[i].toString())+\")\");\n\t\t\tworkers[i].start();\n\t\t}\n\t\t// Waiting for *all* tasks to be ended\n\t\tfor (int i = 0; i < tasks.length; i++)\n\t\t\tworkers[i].join();\n\t\tnotifyExecutionEnd();\n\t}\n}\n"}, "EXECUTION STARTING\nEXECUTION FINISHED");
    }

    public void test022() {
        this.runConformTest(new String[]{"MultiMember.java", "public class MultiMember {\n\tclass Task implements Runnable {\n\t\tprivate String taskName; \n\t\tprivate int maxIteration;\n\t\tpublic Task(String name, int value) {\n\t\t\ttaskName = name; \n\t\t\tmaxIteration = value;\n\t\t}\n\t\tpublic String toString() { return taskName; }\n\t\tpublic void run() {\n\t\t\tfor(int i = 0; i < maxIteration; i++)\n\t\t\t\tnotifyCompletion( (int)((float) (i + 1) / maxIteration * 100));\n\t\t}\t\t\n\t\t\n\t\tvoid notifyCompletion(int percentage) {\n\t\t}\n\t}\n\tpublic static void main(String argv[]){\n\t\tMultiMember multi = new MultiMember();\n\t\tint maxTasks = 3;\n\t\tTask tasks[] = new Task[maxTasks];\n\t\tfor (int i = 0; i < maxTasks; i++) \n\t\t\ttasks[i] = multi.new Task(String.valueOf(i),5);\n\t\ttry {\n\t\t\tmulti.performTasks(tasks);\n\t\t}\n\t\tcatch(InterruptedException e){};\n\t}\n\tvoid notifyExecutionEnd() {\n\t\tSystem.out.println(\"EXECUTION FINISHED\");\n\t}\n\tvoid notifyExecutionStart() {\n\t\tSystem.out.println(\"EXECUTION STARTING\");\n\t}\n\tvoid performTasks(Task tasks[]) throws java.lang.InterruptedException {\n\t\tThread workers[] = new Thread[tasks.length];\n\t\tnotifyExecutionStart();\n\t\t\n\t\t// Launching the tasks\n\t\tfor (int i = 0; i < tasks.length; i++) {\n\t\t\tworkers[i] = new Thread(tasks[i],\"Running task(\"+(tasks[i].toString())+\")\");\n\t\t\tworkers[i].start();\n\t\t}\n\t\t// Waiting for *all* tasks to be ended\n\t\tfor (int i = 0; i < tasks.length; i++)\n\t\t\tworkers[i].join();\n\t\tnotifyExecutionEnd();\n\t}\n}\n"}, "EXECUTION STARTING\nEXECUTION FINISHED");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"p/X.java", "public class X extends q.Y { \n\tvoid bar(){ Object o = someObject; } \n\tpublic static void main(String[] argv){ \n\t\tnew X().bar();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n", "q/Y.java", "package q; \npublic class Y { \n\tprotected Object someObject; \n}\n"}, "");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"p/X.java", "package p; \npublic class X extends q.Y { \n\tvoid bar(){ foo(); } \n\tpublic static void main(String[] argv){ \n\t\tnew X().bar();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n", "q/Y.java", "package q; \npublic class Y { \n\tprotected Object foo(){ return null;} \n}\n"}, "");
    }

    public void test025() {
        this.runConformTest(new String[]{"PortReport.java", "import java.util.*; \npublic class PortReport { \n\tpublic static void main(String[] args) { \n\t\tPortfolio port = new Portfolio(\"foobar\"); \n\t\tSystem.out.println(\"SUCCESS\"); \n\t} \n} \n", "Portfolio.java", "import java.util.*;\t\npublic class Portfolio {\t\n\tString name;\t\n\tpublic Portfolio(String buf) {\t\n\t\tTokenBuffer tbuf = new TokenBuffer();\t\n\t\tswitch (1) {\t\n\t\t\tcase TokenBuffer.T_NAME :\t\n\t\t\t\tname = \"figi\";\t\n\t\t}\t\n\t}\t\n\tString getName() {\t\n\t\treturn name;\t\n\t}\t\n\tclass TokenBuffer {\t\n\t\tstatic final int T_NAME = 3;\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test026() {
        this.runConformTest(new String[]{"p2/Test.java", "package p2;\t\npublic class Test {\t\n\tpublic static void main (String args[]){\t\n\t\tnew c2();\t\n\t}\t\n}\t\n", "p1/c1.java", "package p1;\t\npublic class c1 {\t\n\tprotected class c1a{\t\n\t\tpublic c1a(){}\t\n\t\tpublic void foo(){ System.out.println(\"Foo called\");\t\n\t\t}\t\n\t};\t\n}\t\n", "p2/c2.java", "package p2;\t\nimport p1.*;\t\npublic class c2 extends c1 {\t\n\tpublic c1a myC1a;\t\n\t{\t\n\t\tmyC1a = new c1a();\t\n\t\tmyC1a.foo();\t\n\t}\t\n}\t\n"}, "Foo called");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"p2/Test.java", "package p2;\t\npublic class Test {\t\n\tpublic static void main (String args[]){\t\n\t\tnew c2();\t\n\t}\t\n}\t\n", "p1/c1.java", "package p1;\t\npublic class c1 {\t\n\tpublic class c1m {\t\n\t\tprotected class c1a{\t\n\t\t\tpublic c1a(){}\t\n\t\t\tpublic void foo(){ System.out.println(\"Foo called\");\t\n\t\t\t}\t\n\t\t};\t\n\t};\t\n}\t\n", "p2/c2.java", "package p2;\t\nimport p1.*;\t\npublic class c2 extends c1 {\t\n\tpublic c1m.c1a myC1a;\t\n\t{\t\n\t\tmyC1a = new c1m().new c1a();\t\n\t\tmyC1a.foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p2\\c2.java (at line 4)\n\tpublic c1m.c1a myC1a;\t\n\t       ^^^^^^^\nThe type c1m.c1a is not visible\n----------\n2. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1m().new c1a();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n3. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1m().new c1a();\t\n\t                      ^^^\nThe type c1.c1m.c1a is not visible\n----------\n4. ERROR in p2\\c2.java (at line 7)\n\tmyC1a.foo();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"p2/Test.java", "package p2;\t\npublic class Test {\t\n\tpublic static void main (String args[]){\t\n\t\tnew c2();\t\n\t}\t\n}\t\n", "p1/c1.java", "package p1;\t\npublic class c1 {\t\n\tprotected class c1m {\t\n\t\tprotected class c1a{\t\n\t\t\tpublic c1a(){}\t\n\t\t\tpublic void foo(){ System.out.println(\"Foo called\");\t\n\t\t\t}\t\n\t\t};\t\n\t};\t\n}\t\n", "p2/c2.java", "package p2;\t\nimport p1.*;\t\npublic class c2 extends c1 {\t\n\tpublic c1m.c1a myC1a;\t\n\t{\t\n\t\tmyC1a = new c1m().new c1a();\t\n\t\tmyC1a.foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p2\\c2.java (at line 4)\n\tpublic c1m.c1a myC1a;\t\n\t       ^^^^^^^\nThe type c1m.c1a is not visible\n----------\n2. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1m().new c1a();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n3. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1m().new c1a();\t\n\t        ^^^^^^^^^\nThe constructor c1.c1m() is not visible\n----------\n4. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1m().new c1a();\t\n\t                      ^^^\nThe type c1.c1m.c1a is not visible\n----------\n5. ERROR in p2\\c2.java (at line 7)\n\tmyC1a.foo();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n");
    }

    public void test029() {
        this.runConformTest(new String[]{"p2/Test.java", "package p2;\t\npublic class Test {\t\n\tpublic static void main (String args[]){\t\n\t\tnew c2();\t\n\t}\t\n}\t\n", "p1/c1.java", "package p1;\t\npublic class c1 {\t\n\tprotected class c1a{\t\n\t\tpublic c1a(){}\t\n\t\tpublic void foo(){ System.out.println(\"Foo called\");\t\n\t\t}\t\n\t};\t\n}\t\n", "p2/c2.java", "package p2;\t\nimport p1.*;\t\npublic class c2 extends c1 {\t\n\tpublic c1.c1a myC1a;\n\t{\t\n\t\tmyC1a = new c1a();\t\n\t\tmyC1a.foo();\t\n\t}\t\n}\t\n"}, "Foo called");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"p2/Test.java", "package p2;\t\npublic class Test {\t\n\tpublic static void main (String args[]){\t\n\t\tnew c2();\t\n\t}\t\n}\t\n", "p1/c1.java", "package p1;\t\npublic class c1 {\t\n\tprotected class c1a{\t\n\t\tpublic c1a(){}\t\n\t\tpublic void foo(){ System.out.println(\"Foo called\");\t\n\t\t}\t\n\t};\t\n}\t\n", "p2/c2.java", "package p2;\t\nimport p1.*;\t\npublic class c2 extends c1.c1a {// qualified acces does not work\t\n\tpublic c1a myC1a; \n\t{\t\n\t\tmyC1a = new c1a();\t\n\t\tmyC1a.foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p2\\c2.java (at line 3)\n\tpublic class c2 extends c1.c1a {// qualified acces does not work\t\n\t                        ^^^^^^\nThe type c1.c1a is not visible\n----------\n2. ERROR in p2\\c2.java (at line 4)\n\tpublic c1a myC1a; \n\t       ^^^\nc1a cannot be resolved to a type\n----------\n3. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1a();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n4. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1a();\t\n\t            ^^^\nc1a cannot be resolved to a type\n----------\n5. ERROR in p2\\c2.java (at line 7)\n\tmyC1a.foo();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"p2/Test.java", "package p2;\t\npublic class Test {\t\n\tpublic static void main (String args[]){\t\n\t\tnew c2();\t\n\t}\t\n}\t\n", "p1/c1.java", "package p1;\t\npublic class c1 {\t\n\tprotected class c1a{\t\n\t\tpublic c1a(){}\t\n\t\tpublic void foo(){ System.out.println(\"Foo called\");\t\n\t\t}\t\n\t};\t\n}\t\n", "p2/c2.java", "package p2;\t\nimport p1.c1.*;\t\npublic class c2 extends c1a {\t\n\tpublic c1a myC1a; \n\t{\t\n\t\tmyC1a = new c1a();\t\n\t\tmyC1a.foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p2\\c2.java (at line 3)\n\tpublic class c2 extends c1a {\t\n\t                        ^^^\nThe type c1a is not visible\n----------\n2. ERROR in p2\\c2.java (at line 4)\n\tpublic c1a myC1a; \n\t       ^^^\nThe type c1a is not visible\n----------\n3. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1a();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n4. ERROR in p2\\c2.java (at line 6)\n\tmyC1a = new c1a();\t\n\t            ^^^\nThe type c1a is not visible\n----------\n5. ERROR in p2\\c2.java (at line 7)\n\tmyC1a.foo();\t\n\t^^^^^\nmyC1a cannot be resolved\n----------\n");
    }

    public void test032() {
        this.runConformTest(new String[]{"p/A.java", "package p;\t\npublic class A {\n\t\tpublic class B {\n\t\t\t\tpublic B() {\n\t\t\t\t}\n\t\t\t\tpublic Class getCls() {\n\t\t\t\t\t\treturn A.class;\n\t\t\t\t}\n\t\t}\n\t\tpublic A() {\n\t\t\t\tsuper();\n\t\t\t\tB b = new B();\n\t\t\t\tSystem.out.println(\"Class: \" + b.getCls());\n\t\t}\n\t\tpublic static void main(String[] args) {\n\t\t\t\tA a = new A();\n\t\t}\n}\n"}, "Class: class p.A");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"p1/A2.java", "package p1;\t\nclass D {\t\n\tclass E {\t\n\t\tE(Object o, Object o1, Object o2, F f) {}\t\n\t\tvoid execute() {}\t\n\t}\t\n}\t\nclass F {\t\n\tF(Object o) {\t\n\t}\t\n}\t\npublic class A2 {\t\n\tprivate abstract class B {\t\n\t\tpublic Object get() {\t\n\t\t\treturn null;\t\n\t\t}\t\n\t}\t\n\tprivate class C extends B {\t\n\t\tpublic void foo() {\t\n\t\t\t(new D.E(null, null, null, new F(get()) {}) {}).execute();\t\n\t\t}\t\n\t}\t\n}\n"}, "----------\n1. WARNING in p1\\A2.java (at line 18)\n\tprivate class C extends B {\t\n\t              ^\nThe type A2.C is never used locally\n----------\n2. WARNING in p1\\A2.java (at line 18)\n\tprivate class C extends B {\t\n\t              ^\nAccess to enclosing constructor A2.B() is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n3. ERROR in p1\\A2.java (at line 20)\n\t(new D.E(null, null, null, new F(get()) {}) {}).execute();\t\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNo enclosing instance of type D is accessible. Must qualify the allocation with an enclosing instance of type D (e.g. x.new A() where x is an instance of D).\n----------\n");
    }

    public void test034() {
        this.runConformTest(new String[]{"p1/A2.java", "package p1;\t\nclass D {\t\n\tclass E {\t\n\t\tE(Object o, Object o1, Object o2, F f) {}\t\n\t\tvoid execute() {}\t\n\t}\t\n}\t\nclass F {\t\n\tF(Object o) {\t\n\t}\t\n}\t\npublic class A2 {\t\n\tprivate abstract class B {\t\n\t\tpublic Object get() {\t\n\t\t\treturn null;\t\n\t\t}\t\n\t}\t\n\tprivate class C extends B {\t\n\t\tpublic void foo() {\t\n\t\t\t(new D().new E(null, null, null, new F(get()) {}) {}).execute();\t\n\t\t}\t\n\t}\t\n\tpublic static void main(String[] argv){\t\n\t\tnew A2().new C().foo();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"p1/A2.java", "package p1;\t\nclass D {\t\n\tclass E {\t\n\t\tE(Object o, Object o1, Object o2, F f) {}\t\n\t\tvoid execute() {}\t\n\t}\t\n}\t\nclass F {\t\n\tF(Object o) {\t\n\t}\t\n}\t\npublic class A2 {\t\n\tprivate abstract class B {\t\n\t\tpublic Object get() {\t\n\t\t\treturn null;\t\n\t\t}\t\n\t}\t\n\tprivate class C extends B {\t\n\t\tpublic void foo() {\t\n\t\t\t(new D.E(null, null, null, new F(get()) {})).execute();\t\n\t\t}\t\n\t}\t\n}\n"}, "----------\n1. WARNING in p1\\A2.java (at line 18)\n\tprivate class C extends B {\t\n\t              ^\nThe type A2.C is never used locally\n----------\n2. WARNING in p1\\A2.java (at line 18)\n\tprivate class C extends B {\t\n\t              ^\nAccess to enclosing constructor A2.B() is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n3. ERROR in p1\\A2.java (at line 20)\n\t(new D.E(null, null, null, new F(get()) {})).execute();\t\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNo enclosing instance of type D is accessible. Must qualify the allocation with an enclosing instance of type D (e.g. x.new A() where x is an instance of D).\n----------\n");
    }

    public void test036() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\npublic class A {\t\n\tpublic static void main(String[] argv){\t\n\t\tnew A().foo();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tpublic Object foo() {\t\n\t\tB b = new B() {\t\n\t\t\tprotected Object bar() {\t\n\t\t\t\treturn new B.C() {};\t\n\t\t\t}\t\n\t\t};\t\n\t\treturn b;\t\n\t}\t\n}\t\nclass B {\t\n\tclass C {\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test037() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\npublic class A {\t\n\tpublic static void main(String[] argv){\t\n\t\tnew A().foo();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tpublic Object foo() {\t\n\t\tI i = new I() {\t\n\t\t\tprotected Object bar() {\t\n\t\t\t\treturn new I.C() {};\t\n\t\t\t}\t\n\t\t};\t\n\t\treturn i;\t\n\t}\t\n}\t\ninterface I {\t\n\tclass C {\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String argv[]) {\t\n\t\tif (new X().foo())\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tboolean bar() {\t\n\t\treturn false;\t\n\t}\t\n\tboolean foo() {\t\n\t\tX x = new X() {\t\n\t\t\tboolean test() {\t\n\t\t\t\treturn (X.this == this);\t\n\t\t\t}\t\n\t\t};\t\n\t\treturn x.bar();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test039() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        Y.this.foo(); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test040() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        new Y().foo(); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test041() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        Y.super.foo(); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test042() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"SUCCESS\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(Y.super.foo); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test043() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"SUCCESS\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(Y.this.foo); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test044() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"SUCCESS\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(new Y().foo); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test045() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"SUCCESS\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(foo); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test046() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"SUCCESS\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n   Y someY;\t\n\tpublic void bar() {\t\n\t\tsomeY = this;\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(someY.foo); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test047() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"FAILED\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(Y.super.foo = \"SUCCESS\"); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test048() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"FAILED\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(Y.this.foo = \"SUCCESS\"); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test049() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"FAILED\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(new Y().foo = \"SUCCESS\"); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test050() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"FAILED\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(foo = \"SUCCESS\"); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test051() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"FAILED\";\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew p2.Y().bar();\t\n\t}\t\n}\t\n", "p2/Y.java", "package p2;\t\npublic class Y extends p1.X {\t\n   Y someY;\t\n\tpublic void bar() {\t\n\t\tsomeY = this;\t\n\t\tnew Object(){\t\n\t      void doSomething(){\t\n\t        System.out.println(someY.foo = \"SUCCESS\"); \n\t      }\t\n\t    }.doSomething();\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test052() {
        this.runConformTest(new String[]{"p2/Y.java", "package p2;\t\npublic class Y {\t\n\tvoid bar(final int someVal){\t\n\t\tclass Local {\t\n\t\t\tvoid localDo(final int localVal){\t\n\t\t\t\tnew Object(){\t\n\t\t\t\t\tvoid doSomething(){\t\n\t\t\t\t\t\tSystem.out.print(someVal + localVal);\t\n\t\t\t\t\t}\t\n\t\t\t\t}.doSomething();\t\n\t\t\t}\t\t\t\t\n\t\t};\t\n\t\tLocal loc = new Local();\t\n\t\tloc.localDo(8);\t\n\t\tclass SubLocal extends Local {\t\n\t\t\tvoid localDo(final int localVal){\t\n\t\t\t\tsuper.localDo(localVal + 1);\t\n\t\t\t\tnew Object(){\t\n\t\t\t\t\tvoid doSomething(){\t\n\t\t\t\t\t\tSubLocal.super.localDo(localVal + 2);\t\n\t\t\t\t\t\tSystem.out.print(someVal + localVal + 3);\t\n\t\t\t\t\t}\t\n\t\t\t\t}.doSomething();\t\n\t\t\t}\t\n\t\t};\t\n\t\tSubLocal subloc = new SubLocal();\t\n\t\tsubloc.localDo(8);\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew Y().bar(4);\t\n\t\tSystem.out.println();\t\n\t}\t\n}\t\n"}, "12131415");
    }

    public void test053() {
        this.runConformTest(new String[]{"p2/Z.java", "package p2;\t\nimport p1.X;\t\npublic class Z {\t\n\tclass ZMember extends X {\t\n\t\tZMember(Object o){}\t\n\t\tZ bar(){\t\n\t\t\tSystem.out.println(foo = \"FAILED\");\t\n\t\t\treturn Z.this;\t\n\t\t}\t\n\t}\t\n\tZ(final Object foo){\t\n\t\tObject obj2 = new Object(){\t\n\t\t\tObject doSomething(){\t\n\t\t\t\tZMember obj3 = new ZMember(foo){\t\n\t\t\t\t\tZ bar(){\t\n\t\t\t\t\t\tSystem.out.println(this.foo);\t\n\t\t\t\t\t\treturn Z.this;\t\n\t\t\t\t\t} \n\t\t\t\t};\t\n\t\t\t\tobj3.bar();\t\n\t\t\t\treturn this;\t\n\t\t\t}\t\n\t\t}.doSomething();\t\n\t}\t\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew Z(new Object());\t\n\t}\t\n}\t\n", "p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected String foo = \"SUCCESS\";\t\n}\t\n"}, "SUCCESS");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tvoid foo() {\t\n\t\tclass L1 {\t\n\t\t\tclass LM1 {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass L2 extends L1.LM1 {\t\n\t\t}\t\n\t\tnew L2();\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 8)\n\tclass L2 extends L1.LM1 {\t\n\t      ^^\nNo enclosing instance of type L1 is accessible to invoke the super constructor. Must define a constructor and explicitly qualify its super constructor invocation with an instance of L1 (e.g. x.super() where x is an instance of L1).\n----------\n");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tvoid foo() {\t\n\t\tclass L1 {\t\n\t\t\tclass LM1 {\t\n\t\t\t}\t\n\t\t}\t\n\t\tnew L1().new LM1(){};\t//ok\n\t\tnew L1.LM1(){};\t//ko\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 9)\n\tnew L1.LM1(){};\t//ko\n\t^^^^^^^^^^^^^^\nNo enclosing instance of type L1 is accessible. Must qualify the allocation with an enclosing instance of type L1 (e.g. x.new A() where x is an instance of L1).\n----------\n");
    }

    public void test057() {
        this.runConformTest(new String[]{"VE_Test.java", "public class VE_Test {\t\n    class VE_Inner {\t\n        private VE_Inner() {}\t\n    }\t\n    private static void test(){\t\n        VE_Test ve_test = new VE_Test();\t\n        VE_Inner pi = ve_test.new VE_Inner();\t\n    }\t\n    public static void main(String[] args){\t\n        new VE_Test();\t\n        System.out.println(\"SUCCESS\");\t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test058() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1;\t\nimport p2.A;\t\npublic class Test {\t\n    public static void main(String[] args){\t\n        new Test().a.bar();\t\n    }\t\n\tprivate A a = new A() {\t\n\t\tpublic void bar() {\t\n\t\t\tnew Object() {\t\n\t\t\t\tprotected void foo() {\t\n\t\t\t\t\tinit();\t\n\t\t\t\t}\t\n\t\t\t}.foo(); \t\n\t\t}\t\n\t};\t\n\tprivate void init() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n", "p2/A.java", "package p2;\t\npublic class A {\t\n  public void bar() {\t\n  }\t\n  private void init() {\t\n\t\tSystem.out.println(\"FAILED\");\t\n  }\t\n} \t\n"}, "SUCCESS");
    }

    public void test059() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1;\t\nimport p2.A;\t\npublic class Test {\t\n    public static void main(String[] args){\t\n        new Test().a.bar();\t\n    }\t\n\tprivate A a = new A() {\t\n\t\tpublic void bar() {\t\n\t\t\tnew Object() {\t\n\t\t\t\tprotected void foo() {\t\n\t\t\t\t\tSystem.out.println(init);\t\n\t\t\t\t}\t\n\t\t\t}.foo(); \t\n\t\t}\t\n\t};\t\n\tprivate String init = \"SUCCESS\";\t\n}\t\n", "p2/A.java", "package p2;\t\npublic class A {\t\n  public void bar() {\t\n  }\t\n\tprivate String init = \"FAILED\";\t\n} \t\n"}, "SUCCESS");
    }

    public void test060() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1;\t\nimport p2.A;\t\npublic class Test {\t\n    public static void main(String[] args){\t\n        new Test().a.bar();\t\n    }\t\n\tprivate A a = new A() {\t\n\t\tpublic void bar() {\t\n\t\t\tclass L {\t\n\t\t\t\tTest next = Test.this;\t\n\t\t\t\tprotected void foo() {\t\n\t\t\t\t\tSystem.out.println(next.init);\t\n\t\t\t\t}\t\n\t\t\t};\t\n\t\t\tnew L().foo(); \t\n\t\t}\t\n\t};\t\n\tprivate String init = \"SUCCESS\";\t\n}\t\n", "p2/A.java", "package p2;\t\npublic class A {\t\n  public void bar() {\t\n  }\t\n} \t\n"}, "SUCCESS");
    }

    public void test061() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1;\t\nimport p2.A;\t\npublic class Test {\t\n    public static void main(String[] args){\t\n        new Test().a.bar();\t\n    }\t\n\tprivate A a = new A() {\t\n\t\tpublic void bar() {\t\n\t\t\tclass L {\t\n\t\t\t\tprotected void foo() {\t\n\t\t\t\t\tSystem.out.println(Test.this.init);\t\n\t\t\t\t}\t\n\t\t\t};\t\n\t\t\tnew L().foo(); \t\n\t\t}\t\n\t};\t\n\tprivate String init = \"SUCCESS\";\t\n}\t\n", "p2/A.java", "package p2;\t\npublic class A {\t\n  public void bar() {\t\n  }\t\n} \t\n"}, "SUCCESS");
    }

    public void test062() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n    public static void main(String args[]) {\t\n\t\tfinal String s = args.length == 0 ? \"SUCCESS\" : null;\t\n\t\tfinal class Local {\t\n\t\t\tprivate Local() {\t\n\t\t\t\tnew LocalMember();\t\n\t\t\t}\t\n\t\t\tclass LocalMember {\t\n\t\t\t\t{\t\n\t\t\t\t\tnew LocalMemberMember();\t\n\t\t\t\t}\t\n\t\t\t\tclass LocalMemberMember {\t\n\t\t\t\t\t{\t\n\t\t\t\t\t\tSystem.out.println(s);\t\n\t\t\t\t\t}\t\n\t\t\t\t}\t\n\t\t\t}\t\n\t\t}\t\n\t\tnew Local();\t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test062a() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n    public static void main(String args[]) {\t\n\t\tfinal String s = \"SUCCESS\";\n\t\tfinal class Local {\t\n\t\t\tLocal() {\t\n\t\t\t\tnew LocalMember();\t\n\t\t\t}\t\n\t\t\tclass LocalMember {\t\n\t\t\t\t{\t\n\t\t\t\t\tnew LocalMemberMember();\t\n\t\t\t\t}\t\n\t\t\t\tclass LocalMemberMember {\t\n\t\t\t\t\t{\t\n\t\t\t\t\t\tSystem.out.println(s);\t\n\t\t\t\t\t}\t\n\t\t\t\t}\t\n\t\t\t}\t\n\t\t}\t\n\t\tnew Local();\t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test063() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tString a = new Object(){\t\n\t\t\tclass LocalMember {\t\n\t\t\t\tString s = \"SUCCESS\";\t\n\t\t\t};\t\n\t\t\tString get_a(){\t\n\t\t\t\treturn new LocalMember().s;\t\n\t\t\t}\t\n\t}.get_a();\t\n\tpublic static void main(String argv[]) {\t\n\t\tSystem.out.println(new X().a);\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test064() {
        this.runConformTest(new String[]{"p2/Y.java", "package p2;\t\npublic class Y extends T {\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew Y().bar();\t\n\t}\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"Y.foo()\");\t\n\t}\t\n}\t\n", "p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"X.foo()\");\t\n\t}\t\n}\t\n", "p2/T.java", "package p2;\t\npublic class T extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t\t\tvoid doSomething(){\t\n\t\t\t\tT.this.foo();\t\n\t\t\t}\t\n\t\t}.doSomething();\t\n\t}\t\n}\t\n"}, "Y.foo()");
    }

    public void test065() {
        this.runConformTest(new String[]{"p2/Y.java", "package p2;\t\npublic class Y extends T {\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew Y().bar();\t\n\t}\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"Y.foo()\");\t\n\t}\t\n}\t\n", "p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"X.foo()\");\t\n\t}\t\n}\t\n", "p2/T.java", "package p2;\t\npublic class T extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t\t\tvoid doSomething(){\t\n\t\t\t\tT.this.foo();\t\n\t\t\t}\t\n\t\t}.doSomething();\t\n\t}\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"T.foo()\");\t\n\t}\t\n}\t\n"}, "Y.foo()");
    }

    public void test066() {
        this.runConformTest(new String[]{"p2/Y.java", "package p2;\t\npublic class Y extends T {\t\n\tpublic static void main(String argv[]) {\t\n\t\tnew Y().bar();\t\n\t}\t\n\tprotected void foo() {\t\n\t\tSystem.out.print(\"Y.foo()-\");\t\n\t}\t\n}\t\n", "p1/X.java", "package p1;\t\npublic class X {\t\n\tprotected void foo() {\t\n\t\tSystem.out.println(\"X.foo()\");\t\n\t}\t\n}\t\n", "p2/T.java", "package p2;\t\npublic class T extends p1.X {\t\n\tpublic void bar() {\t\n\t\tnew Object(){\t\n\t\t\tvoid doSomething(){\t\n\t\t\t\tT.this.foo();\t\n\t\t\t\tT.super.foo();\t//need extra access method \n\t\t\t}\t\n\t\t}.doSomething();\t\n\t}\t\n}\t\n"}, "Y.foo()-X.foo()");
    }

    public void test067() {
        this.runConformTest(new String[]{"p/Test.java", "package p;\t\npublic class Test {\t\n\tclass Member {\t\n\t\tprivate Member(){\t\n\t\t}\t\n\t\tprivate Member(Member other){\t\n\t\t}\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tTest t = new Test();\t\n\t\tMember m1 = t.new Member();\t\n\t\tt.new Member(m1);\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new X2().foo();\t\n\t}\t\n\tclass X1 {\t\n\t\tvoid baz1() {\t\n\t\t\tSystem.out.print(\"-X1.baz1()\");\t\n\t\t}\t\n\t}\t\n\tclass X2 {\t\n\t\tvoid foo(){\t\n\t\t\tX.this.new X1(){\t\n\t\t\t\tvoid bar(){\t\n\t\t\t\t\tbaz();\t\n\t\t\t\t\tbaz1();\t\n\t\t\t\t\tbaz2();\t\n\t\t\t\t}\t\n\t\t\t}.bar();\t\n\t\t}\t\t\n\t\tvoid baz2() {\t\n\t\t\tSystem.out.println(\"-X2.baz2()\");\t\n\t\t}\t\n\t}\t\n\tvoid baz() {\t\n\t\tSystem.out.print(\"X.baz()\");\t\n\t}\t\n}\t\n"}, "X.baz()-X1.baz1()-X2.baz2()");
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    X(String s, int j) {}\t\n    public static void main(String[] args) {\t\n        final int i;\t\n        new X(\"hello\", i = 1) {\t\n            { \t\n            \tSystem.out.print(\"SUCCESS:\"+i); \t\n            }\t\n        };\t\n    }\t\n}\t\n"}, "SUCCESS:1");
    }

    public void test070() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    X() {}\t\n    public static void main(String[] args) {\t\n        final int i;\t\n        new X().new Y(\"hello\", i = 1) {\t\n            { \t\n            \tSystem.out.print(\"SUCCESS:\"+i); \t\n            }\t\n        };\t\n    }\t\n\tclass Y {\t\n\t\tY(String s, int j) {}\t\n\t}\t\n}\t\n"}, "SUCCESS:1");
    }

    public void test071() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tvoid foo(int i) {\t\n\t\tfinal long v0 = i, v1 = i, v2 = i, v3 = i, v4 = i, v5 = i, v6 = i;\t\n\t\tfinal long v7 = i, v8 = i, v9 = i, v10 = i, v11 = i, v12 = i, v13 = i;\t\n\t\tfinal long v14 = i, v15 = i, v16 = i, v17 = i, v18 = i, v19 = i, v20 = i;\t\n\t\tfinal long v21 = i, v22 = i, v23 = i, v24 = i, v25 = i, v26 = i, v27 = i;\t\n\t\tfinal long v28 = i, v29 = i, v30 = i, v31 = i, v32 = i, v33 = i, v34 = i;\t\n\t\tfinal long v35 = i, v36 = i, v37 = i, v38 = i, v39 = i, v40 = i, v41 = i;\t\n\t\tfinal long v42 = i, v43 = i, v44 = i, v45 = i, v46 = i, v47 = i, v48 = i;\t\n\t\tfinal long v49 = i, v50 = i, v51 = i, v52 = i, v53 = i, v54 = i, v55 = i;\t\n\t\tfinal long v56 = i, v57 = i, v58 = i, v59 = i, v60 = i, v61 = i, v62 = i;\t\n\t\tfinal long v63 = i, v64 = i, v65 = i, v66 = i, v67 = i, v68 = i, v69 = i;\t\n\t\tfinal long v70 = i, v71 = i, v72 = i, v73 = i, v74 = i, v75 = i, v76 = i;\t\n\t\tfinal long v77 = i, v78 = i, v79 = i, v80 = i, v81 = i, v82 = i, v83 = i;\t\n\t\tfinal long v84 = i, v85 = i, v86 = i, v87 = i, v88 = i, v89 = i, v90 = i;\t\n\t\tfinal long v91 = i, v92 = i, v93 = i, v94 = i, v95 = i, v96 = i, v97 = i;\t\n\t\tfinal long v98 = i, v99 = i, v100 = i, v101 = i, v102 = i, v103 = i, v104 = i;\t\n\t\tfinal long v105 = i, v106 = i, v107 = i, v108 = i, v109 = i, v110 = i, v111 = i;\t\n\t\tfinal long v112 = i, v113 = i, v114 = i, v115 = i, v116 = i, v117 = i, v118 = i;\t\n\t\tfinal long v119 = i, v120 = i, v121 = i, v122 = i, v123 = i, v124 = i, v125 = i;\t\n\t\tfinal long v126 = i;\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tfinal int v127 = i;\t// int is already too many arg\t\t\t\t\t\n\t\tnew X() {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t{\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\tSystem.out.println(\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\tv0 + v1 + v2 + v3 + v4 + v5 + v6\t\t\t\t\t\t\n\t\t\t\t\t+ v7 + v8 + v9 + v10 + v11 + v12 + v13\t\t\t\t\t\n\t\t\t\t\t+ v14 + v15 + v16 + v17 + v18 + v19 + v20\t\t\t\t\n\t\t\t\t\t+ v21 + v22 + v23 + v24 + v25 + v26 + v27\t\t\t\t\n\t\t\t\t\t+ v28 + v29 + v30 + v31 + v32 + v33 + v34\t\t\t\t\n\t\t\t\t\t+ v35 + v36 + v37 + v38 + v39 + v40 + v41\t\t\t\t\n\t\t\t\t\t+ v42 + v43 + v44 + v45 + v46 + v47 + v48\t\t\t\t\n\t\t\t\t\t+ v49 + v50 + v51 + v52 + v53 + v54 + v55\t\t\t\t\n\t\t\t\t\t+ v56 + v57 + v58 + v59 + v60 + v61 + v62\t\t\t\t\n\t\t\t\t\t+ v63 + v64 + v65 + v66 + v67 + v68 + v69\t\t\t\t\n\t\t\t\t\t+ v70 + v71 + v72 + v73 + v74 + v75 + v76\t\t\t\t\n\t\t\t\t\t+ v77 + v78 + v79 + v80 + v81 + v82 + v83\t\t\t\t\n\t\t\t\t\t+ v84 + v85 + v86 + v87 + v88 + v89 + v90\t\t\t\t\n\t\t\t\t\t+ v91 + v92 + v93 + v94 + v95 + v96 + v97\t\t\t\t\n\t\t\t\t\t+ v98 + v99 + v100 + v101 + v102 + v103 + v104\t\t\t\n\t\t\t\t\t+ v105 + v106 + v107 + v108 + v109 + v110 + v111\t\t\n\t\t\t\t\t+ v112 + v113 + v114 + v115 + v116 + v117 + v118\t\t\n\t\t\t\t\t+ v119 + v120 + v121 + v122 + v123 + v124 + v125\t\t\n\t\t\t\t\t+ v126);\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tnew X() {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t    ^^^\nToo many synthetic parameters, emulated parameter val$v126 is exceeding the limit of 255 words eligible for method parameters\n----------\n");
    }

    public void test072() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tvoid foo(int i) {\t\n\t\tfinal long v0 = i, v1 = i, v2 = i, v3 = i, v4 = i, v5 = i, v6 = i;\t\n\t\tfinal long v7 = i, v8 = i, v9 = i, v10 = i, v11 = i, v12 = i, v13 = i;\t\n\t\tfinal long v14 = i, v15 = i, v16 = i, v17 = i, v18 = i, v19 = i, v20 = i;\t\n\t\tfinal long v21 = i, v22 = i, v23 = i, v24 = i, v25 = i, v26 = i, v27 = i;\t\n\t\tfinal long v28 = i, v29 = i, v30 = i, v31 = i, v32 = i, v33 = i, v34 = i;\t\n\t\tfinal long v35 = i, v36 = i, v37 = i, v38 = i, v39 = i, v40 = i, v41 = i;\t\n\t\tfinal long v42 = i, v43 = i, v44 = i, v45 = i, v46 = i, v47 = i, v48 = i;\t\n\t\tfinal long v49 = i, v50 = i, v51 = i, v52 = i, v53 = i, v54 = i, v55 = i;\t\n\t\tfinal long v56 = i, v57 = i, v58 = i, v59 = i, v60 = i, v61 = i, v62 = i;\t\n\t\tfinal long v63 = i, v64 = i, v65 = i, v66 = i, v67 = i, v68 = i, v69 = i;\t\n\t\tfinal long v70 = i, v71 = i, v72 = i, v73 = i, v74 = i, v75 = i, v76 = i;\t\n\t\tfinal long v77 = i, v78 = i, v79 = i, v80 = i, v81 = i, v82 = i, v83 = i;\t\n\t\tfinal long v84 = i, v85 = i, v86 = i, v87 = i, v88 = i, v89 = i, v90 = i;\t\n\t\tfinal long v91 = i, v92 = i, v93 = i, v94 = i, v95 = i, v96 = i, v97 = i;\t\n\t\tfinal long v98 = i, v99 = i, v100 = i, v101 = i, v102 = i, v103 = i, v104 = i;\t\n\t\tfinal long v105 = i, v106 = i, v107 = i, v108 = i, v109 = i, v110 = i, v111 = i;\t\n\t\tfinal long v112 = i, v113 = i, v114 = i, v115 = i, v116 = i, v117 = i, v118 = i;\t\n\t\tfinal long v119 = i, v120 = i, v121 = i, v122 = i, v123 = i, v124 = i, v125 = i;\t\n\t\tnew X() {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t{\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\tSystem.out.println(\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\tv0 + v1 + v2 + v3 + v4 + v5 + v6\t\t\t\t\t\t\n\t\t\t\t\t+ v7 + v8 + v9 + v10 + v11 + v12 + v13\t\t\t\t\t\n\t\t\t\t\t+ v14 + v15 + v16 + v17 + v18 + v19 + v20\t\t\t\t\n\t\t\t\t\t+ v21 + v22 + v23 + v24 + v25 + v26 + v27\t\t\t\t\n\t\t\t\t\t+ v28 + v29 + v30 + v31 + v32 + v33 + v34\t\t\t\t\n\t\t\t\t\t+ v35 + v36 + v37 + v38 + v39 + v40 + v41\t\t\t\t\n\t\t\t\t\t+ v42 + v43 + v44 + v45 + v46 + v47 + v48\t\t\t\t\n\t\t\t\t\t+ v49 + v50 + v51 + v52 + v53 + v54 + v55\t\t\t\t\n\t\t\t\t\t+ v56 + v57 + v58 + v59 + v60 + v61 + v62\t\t\t\t\n\t\t\t\t\t+ v63 + v64 + v65 + v66 + v67 + v68 + v69\t\t\t\t\n\t\t\t\t\t+ v70 + v71 + v72 + v73 + v74 + v75 + v76\t\t\t\t\n\t\t\t\t\t+ v77 + v78 + v79 + v80 + v81 + v82 + v83\t\t\t\t\n\t\t\t\t\t+ v84 + v85 + v86 + v87 + v88 + v89 + v90\t\t\t\t\n\t\t\t\t\t+ v91 + v92 + v93 + v94 + v95 + v96 + v97\t\t\t\t\n\t\t\t\t\t+ v98 + v99 + v100 + v101 + v102 + v103 + v104\t\t\t\n\t\t\t\t\t+ v105 + v106 + v107 + v108 + v109 + v110 + v111\t\t\n\t\t\t\t\t+ v112 + v113 + v114 + v115 + v116 + v117 + v118\t\t\n\t\t\t\t\t+ v119 + v120 + v121 + v122 + v123 + v124 + v125);\t\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n    public static void main(String[] args) {\t\n       System.out.print(\"SUCCESS\"); \t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test073() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(final String[] args) {\t\n\t\tclass Local {\t\n\t\t\tprivate Local(String str){\t\n\t\t\t\tObject o = args;\t\n\t\t\t\tSystem.out.println(str);\t\n\t\t\t}\t\n\t\t};\t\n\t\tnew Local(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test074() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(final String[] args) {\t\n\t\tclass Local {\t\n\t\t\tpublic Local(String str, Local loc, String str2){\t\n\t\t\t}\t\n\t\t\tpublic Local(String str, Local loc){\t\n\t\t\t}\t\n\t\t\tprivate Local(String str){\t\n\t\t\t\tObject o = args;\t\n\t\t\t\tSystem.out.println(str);\t\n\t\t\t}\t\n\t\t};\t\n\t\tnew Local(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test075() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n   public static void main(final String[] args) {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tprivate static void foo() {\t\n\t}\t\n    A a = new A();\t\n    class A {\t\n\t\tprivate A() {}\t\n\t\tA(String s) {\t\n\t\t\tfoo();\t\n\t\t}\t\n\t\tA(int s) {\t\n\t\t\tfoo();\t\n\t\t}\t\n    }\t\n    class B extends A {\t\n    \tB(){\t\n    \t\tsuper();\t\n    \t}\t\n    }\t\n}\t\n"}, "SUCCESS");
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\t\n\tvoid foo(){\t\n\t\tnew X().new A(null);\t\n\t\tnew X().access$0();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in Y.java (at line 4)\n\tnew X().access$0();\t\n\t        ^^^^^^^^\nThe method access$0() is undefined for the type X\n----------\n", null, false);
    }

    public void test076() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel <= 0x2F0000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tX(Object o){\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tclass B extends X {\t\n\t      ^\nThe type B is never used locally\n----------\n2. WARNING in X.java (at line 8)\n\tB() {\t\n\t^^^\nThe constructor B() is never used locally\n----------\n3. ERROR in X.java (at line 9)\n\tsuper(new A(){\t\n\t\t\t\t});\t\n\t      ^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n4. WARNING in X.java (at line 9)\n\tsuper(new A(){\t\n\t          ^^^\nAccess to enclosing constructor A() is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n");
            return;
        }
        if (options.sourceLevel <= 0x300000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tX(Object o){\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tclass B extends X {\t\n\t      ^\nThe type B is never used locally\n----------\n2. WARNING in X.java (at line 8)\n\tB() {\t\n\t^^^\nThe constructor B() is never used locally\n----------\n3. ERROR in X.java (at line 9)\n\tsuper(new A(){\t\n\t\t\t\t});\t\n\t      ^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tX(Object o){\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "");
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] args){\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tX(Object o){\t\n\t}\t\n\tstatic void foo() {\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "SUCCESS");
    }

    public void test078() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel <= 0x2F0000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tX(Object o){\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t\tvoid foo() { System.out.println(X.this);\t} \n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tclass B extends X {\t\n\t      ^\nThe type B is never used locally\n----------\n2. WARNING in X.java (at line 8)\n\tB() {\t\n\t^^^\nThe constructor B() is never used locally\n----------\n3. ERROR in X.java (at line 9)\n\tsuper(new A(){\t\n\t\t\t\t\tvoid foo() { System.out.println(X.this);\t} \n\t\t\t\t});\t\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n4. WARNING in X.java (at line 9)\n\tsuper(new A(){\t\n\t          ^^^\nAccess to enclosing constructor A() is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n5. WARNING in X.java (at line 10)\n\tvoid foo() { System.out.println(X.this);\t} \n\t     ^^^^^\nThe method foo() from the type new A(){} is never used locally\n----------\n6. ERROR in X.java (at line 10)\n\tvoid foo() { System.out.println(X.this);\t} \n\t                                ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
            return;
        }
        if (options.sourceLevel <= 0x300000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tX(Object o){\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t\tvoid foo() { System.out.println(X.this);\t} \n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tclass B extends X {\t\n\t      ^\nThe type B is never used locally\n----------\n2. WARNING in X.java (at line 8)\n\tB() {\t\n\t^^^\nThe constructor B() is never used locally\n----------\n3. ERROR in X.java (at line 9)\n\tsuper(new A(){\t\n\t\t\t\t\tvoid foo() { System.out.println(X.this);\t} \n\t\t\t\t});\t\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n4. WARNING in X.java (at line 10)\n\tvoid foo() { System.out.println(X.this);\t} \n\t     ^^^^^\nThe method foo() from the type new A(){} is never used locally\n----------\n5. ERROR in X.java (at line 10)\n\tvoid foo() { System.out.println(X.this);\t} \n\t                                ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tX(Object o){\t\n\t\tclass A { \t\n\t\t\tprivate A() {\t\n\t\t\t}\t\n\t\t}\t\n\t\tclass B extends X {\t\n\t\t\tB() {\t\n\t\t\t\tsuper(new A(){\t\n\t\t\t\t\tvoid foo() { System.out.println(X.this);\t} \n\t\t\t\t});\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n} \t\n"}, "");
    }

    public void test079() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new Y().new Z().bar();\t\n\t}\t\n\tString foo() { return \"X-foo\"; }\t\n\tclass Y extends X {\t\n\t\tString foo() { return \"Y-foo\"; }\t\n\t\tclass Z extends Y {\t\n\t\t\tZ(){\t\n\t\t\t\tX.this.super();\t\n\t\t\t}\t\n\t\t\tString foo() { return \"Z-foo\"; }\t\n\t\t\tvoid bar () {\t\n\t\t\t\tSystem.out.println(X.this.foo());\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n}\t\n"}, "X-foo");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) { \n\t\tnew X().new C();\t\n\t}\t\n\tint m() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t\treturn 1;\t\n\t}\t\n\tclass C extends B {\t\n\t\tC(int j){}\t\n\t\tC(){\t\n\t\t\tthis(X.this.m());\t\n\t\t}\t\n\t}\t\n}\t\nclass B extends X {\t\n}\t\n"}, "SUCCESS");
    }

    public void test081() {
        this.runConformTest(new String[]{"p/X.java", "package p;\t\npublic class X {\t\n\tpublic static void main(String[] arguments) { \n\t\tnew X().new C();\t\n\t}\t\n\tint m() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t\treturn 1;\t\n\t}\t\n\tclass C extends q.B {\t\n\t\tC(int j){}\t\n\t\tC(){\t\n\t\t\tthis(m());\t\n\t\t}\t\n\t}\t\n}\t\n", "q/B.java", "package q;\t\npublic class B extends p.X {\t\n}\t\n"}, "SUCCESS");
    }

    public void test083() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new Y().new Z().bar();\t\n\t}\t\n\tString foo() { return \"X-foo\"; }\t\n\tclass Y extends X {\t\n\t\tString foo() { return \"Y-foo\"; }\t\n\t\tclass Z {\t\n\t\t\tZ(){\t\n\t\t\t\t//X.this.super();\t\n\t\t\t}\t\n\t\t\tString foo() { return \"Z-foo\"; }\t\n\t\t\tvoid bar () {\t\n\t\t\t\tSystem.out.println(X.this.foo());\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n}\t\n"}, "X-foo");
    }

    public void test084() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew Foo(null);\t\n\t}\t\n\tFoo(int i){}\t\n\tFoo(Object o){\t\t\n\t\tclass A { \t\t\n\t\t\tprivate A() {\t \t\n\t\t\t}\t\t\n\t\t}\t\t\n\t\tclass B extends Foo {\t\t\n\t\t\tB() {\t\t\n\t\t\t\tsuper(0);\t\n\t\t\t\tnew A(){\t\t\n\t\t\t\t\tvoid foo() { \t\n\t\t\t\t\t\tSystem.out.println(Foo.this.getClass().getName());\t\t\n\t\t\t\t\t} \t\n\t\t\t\t}.foo();\t\t\n\t\t\t}\t\t\n\t\t}\t\t\n\t\tnew B();\t\n\t}\t\t\n} \t\n"}, "Foo");
    }

    public void test085() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tint m() {\t\t\n\t\treturn 1;\t\t\n\t}\t\t\n\tclass C extends B {\t\t\n\t\tC(int j){}\t\t\n\t\tC(){\t\t\n\t\t\tthis(\t\n\t\t\t\tnew B(){ \t\n\t\t\t\t\tX x = X.this; \t\n\t\t\t\t\tint m(){\t\n\t\t\t\t\t\treturn 1;\t\n\t\t\t\t\t}\t\n\t\t\t\t}.m());\t\n\t\t}\t\t\n\t}\t\t\n}\t\t\nclass B extends X {\t\t\n}\t\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tX x = X.this; \t\n\t  ^\nThe field new B(){}.x is never read locally\n----------\n2. ERROR in X.java (at line 10)\n\tX x = X.this; \t\n\t      ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tint m() {\t\t\n\t\treturn 1;\t\t\n\t}\t\t\n\tclass C extends B {\t\t\n\t\tC(int j){}\t\t\n\t\tC(){\t\t\n\t\t\tthis(\t\n\t\t\t\tnew B(){ \t\n\t\t\t\t\tX x = X.this; \t\n\t\t\t\t\tint m(){\t\n\t\t\t\t\t\treturn 1;\t\n\t\t\t\t\t}\t\n\t\t\t\t}.m());\t\n\t\t}\t\t\n\t}\t\t\n}\t\t\nclass B extends X {\t\t\n}\t\n"}, "");
    }

    public void test086() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) { \t\n\t\tnew X().new C();\t\t\n\t}\t\t\n\tint m() {\t\t\n\t\treturn 1;\t\t\n\t}\t\t\n\tclass C extends B {\t\t\n\t\tC(int j){}\t\t\n\t\tC(){\t\t\n\t\t\tthis(\t\n\t\t\t\tnew B(){ \t\n\t\t\t\t\tint m(){\t\n\t\t\t\t\t\tSystem.out.println(\"SUCCESS\");\t\t\n\t\t\t\t\t\treturn 1;\t\n\t\t\t\t\t}\t\n\t\t\t\t}.m());\t\n\t\t}\t\t\n\t}\t\t\n}\t\t\nclass B extends X {\t\t\n}\t\n"}, "SUCCESS");
    }

    public void test087() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.complianceLevel <= 0x300000L) {
            this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().f();\t\n\t}\t\n    void f () {\t\n        class C {\t\n        \tC() {\t\n        \t\tSystem.out.println(\"[\"+X.this.getClass().getName()+\"]\");\t\n        \t}\t\n        }\t\n        class N extends X {\t\n            { new C(); } // selects N.this, not O.this\t\n        }\t\n        new N();\t\n    }\t\n}\t\n"}, "[X$1$N]");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().f();\t\n\t}\t\n    void f () {\t\n        class C {\t\n        \tC() {\t\n        \t\tSystem.out.println(\"[\"+X.this.getClass().getName()+\"]\");\t\n        \t}\t\n        }\t\n        class N extends X {\t\n            { new C(); } // selects N.this, not O.this\t\n        }\t\n        new N();\t\n    }\t\n}\t\n"}, "[X$1N]");
    }

    public void test088() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tclass Middle {\t\n\t\tclass Inner {\t\n\t\t}\t\n\t} \t\n\tclass M extends Middle.Inner {\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tclass M extends Middle.Inner {\t\n\t      ^\nNo enclosing instance of type X.Middle is accessible to invoke the super constructor. Must define a constructor and explicitly qualify its super constructor invocation with an instance of X.Middle (e.g. x.super() where x is an instance of X.Middle).\n----------\n");
    }

    public void test089() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tstatic class Middle {\t\n\t\tstatic class Inner {\t\n\t\t}\t\n\t} \t\n\tclass M extends Middle.Inner {\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new M();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test090() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tvoid foo() {\t\n\t\tclass Middle {\t\n\t\t\tclass Inner {\t\n\t\t\t}\t\n\t\t} \t\n\t\tclass M extends Middle.Inner {\t\n\t\t\tM() {\t\n\t\t\t\tnew Middle().super();\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().foo();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test091() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tObject o = new Object() {\t\n\t\tclass Inner {\t\n\t\t\tprivate Inner() {}\t\n\t\t}\t\n\t}.new Inner(){};\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test092() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tclass A {\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tSystem.out.println(\"[\"+new X(){}.new A(){}.getClass().getName()+\"]\");\t\n\t}\t\n}\t\n"}, "[X$2]");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tSystem.out.println(X.this);\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(X.this);\t\n\t                   ^^^^^^\nCannot use this in a static context \n----------\n");
    }

    public void test094() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tclass Y {}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tint i = 0;\t\n\t\ti.new Y();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 5)\n\ti.new Y();\t\n\t^\nCannot use an expression of the type int as a valid enclosing instance\n----------\n");
    }

    public void test095() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tclass Y {}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tint i = 0;\t\n\t\ti.new Y(){};\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 5)\n\ti.new Y(){};\t\n\t^\nCannot use an expression of the type int as a valid enclosing instance\n----------\n");
    }

    public void test096() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tstatic class Y {}\t\n\tvoid foo() {\t\n\t\tnew X().new Y(){};\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew X().new Y(){};\t\n\t^^^^^^^\nIllegal enclosing instance specification for type X.Y\n----------\n");
    }

    public void test097() {
        this.runConformTest(new String[]{"apples/Base.java", "package apples;\t\npublic class Base {\t\n\tprotected String foo = \"SUCCESS\";\t\n\tpublic static void main(String[] args){\t\n\t\tnew oranges.Derived().new Inner(new oranges.Derived()).bug();\t\n\t}\t\n}\t\n", "oranges/Derived.java", "package oranges;\t\nimport apples.*;\t\npublic class Derived extends Base {\t\n    public class Inner {\t\n        Derived c = null;\t\n        public Inner(Derived c) {\t\n            this.c = c;\t\n        } \t\n        public void bug() {\t\n            // The following reference to Base.foo causes the \t\n            // VerifyError\t\n            System.out.println(c.foo);\t\n        }\t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test098() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] args) {\t\n\t\tSystem.out.println(\"first inner class = \" + new Object() {}.getClass());\t\n\t\tif (true) {\t\n\t\t\tSystem.out.println(\"Always true\");\t\n\t\t} else {\t\n\t\tSystem.out.println(\"unreachable inner class = \" + new Object() {}.getClass());\t\n\t\t}\t\n\t\tSystem.out.println(\"last inner class = \" + new Object() {}.getClass());\t\n\t}\t\n}\t\n"}, "first inner class = class X$1\nAlways true\nlast inner class = class X$2");
    }

    public void test099() {
        this.runConformTest(new String[]{"Y.java", "public class Y { \n\tpublic static void main(String[] args) {\t\n\t\tclass Local {} \n\t\tSystem.out.println(\"SUCCESS\");\t\n\t} \n} \n"}, "SUCCESS");
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.complianceLevel <= 0x300000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X { \n    public static void main(String argv[]) { \n\t\tObject a = new Y$1$Local();        // compile-time error \n    } \n} \n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject a = new Y$1$Local();        // compile-time error \n\t               ^^^^^^^^^\nThe nested type Y$1$Local cannot be referenced using its binary name\n----------\n", null, false);
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X { \n    public static void main(String argv[]) { \n\t\tObject a = new Y$1Local();        // compile-time error \n    } \n} \n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject a = new Y$1Local();        // compile-time error \n\t               ^^^^^^^^\nThe nested type Y$1Local cannot be referenced using its binary name\n----------\n", null, false);
    }

    public void test101() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX(Object o) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X(null).new M(null);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tclass M extends Top {\n\t\tM() {\n\t\t\tsuper(null);\n\t\t}\n\t\tM(Object o) {\n\t\t\tsuper(new M(){});\n\t\t}\n\t}\n\tclass Top {\n\t\tTop(Object o) {\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test102() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX(Object o) {\n\t}\n\tclass M extends X {\n\t\tM() {\n\t\t\tsuper(null); //1\n\t\t}\n\t\tM(Object o) {\n\t\t\tsuper(new M());//2\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tsuper(new M());//2\n\t      ^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test104() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX(Object o) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X(null).new M(null);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tclass N extends X {\n\t\tN() {\n\t\t\tsuper(null); //1\n\t\t}\n\t\tN(Object o) {\n\t\t\tsuper(new M());//2\n\t\t}\n\t}\n \tclass M extends X {\n\t\tM() {\n\t\t\tsuper(null); //3\n\t\t}\n\t\tM(Object o) {\n\t\t\tsuper(new M());//4\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tsuper(new M());//2\n\t      ^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n2. ERROR in X.java (at line 21)\n\tsuper(new M());//4\n\t      ^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test107() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n\tpublic static class Y { \n\t\tpublic Y(Z z) {} \n\t} \n\tpublic interface Z {} \n} \n\nclass A { \n\tprivate static class B extends X.Y implements X.Z { \n\t\tB(A a) { \n\t\t\tsuper(B.this); \n\t\t} \n\t} \n} "}, "----------\n1. WARNING in X.java (at line 9)\n\tprivate static class B extends X.Y implements X.Z { \n\t                     ^\nThe type A.B is never used locally\n----------\n2. ERROR in X.java (at line 11)\n\tsuper(B.this); \n\t      ^^^^^^\nCannot refer to 'this' nor 'super' while explicitly invoking a constructor\n----------\n");
    }

    public void test108() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel == 0x300000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\t{\n\t\tclass Local1 extends X {\n\t\t}\n\t\tclass Local2 extends Local1 {\n\t\t}\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\tclass Local2 extends Local1 {\n\t      ^^^^^^\nThe type Local2 is never used locally\n----------\n2. ERROR in X.java (at line 5)\n\tclass Local2 extends Local1 {\n\t      ^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\t{\n\t\tclass Local1 extends X {\n\t\t}\n\t\tclass Local2 extends Local1 {\n\t\t}\n\t}\n}"}, "");
    }

    public void test109() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel == 0x300000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void bar() {\n\t\tclass C extends X {\n\t\t\tpublic void foo() {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t\tX a= new X() {\n\t\t\tpublic void foo() {\n\t\t\t\t\n\t\t\t}\n\t\t};\n\t\tclass D extends C {\n\t\t\t\n\t\t};\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic void foo() {\n\t            ^^^^^\nThe method foo() from the type C is never used locally\n----------\n2. WARNING in X.java (at line 9)\n\tpublic void foo() {\n\t            ^^^^^\nThe method foo() from the type new X(){} is never used locally\n----------\n3. WARNING in X.java (at line 13)\n\tclass D extends C {\n\t      ^\nThe type D is never used locally\n----------\n4. ERROR in X.java (at line 13)\n\tclass D extends C {\n\t      ^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void bar() {\n\t\tclass C extends X {\n\t\t\tpublic void foo() {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t\tX a= new X() {\n\t\t\tpublic void foo() {\n\t\t\t\t\n\t\t\t}\n\t\t};\n\t\tclass D extends C {\n\t\t\t\n\t\t};\n\t}\n}"}, "");
    }

    public void test110() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif (true) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tclass ShouldNotBeGenerated {\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test111() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif (true) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\treturn;\n\t\t}\n\t\tnew Object() {}; \n\t}\n}"}, "SUCCESS");
    }

    public void test112() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    private Object t;\n    X(Object t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X(\"OUTER\").bar();\n    }\n    void bar() {\n        new X(this) {\n            void run() {\n                new Object() {\n                    void run() {\n\t\t\t\t        System.out.println(t);\n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n"}, "OUTER");
    }

    public void test113() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    private Object t;\n    X(Object t) {\n        this.t = t;\n    }\n    public static void main(String[] args) {\n        new X(\"OUTER\").bar();\n    }\n    void bar() {\n        new X(this) {\n            void run() {\n                new Object() {\n                    void run() {\n\t\t\t\t\t\ttry {\t\n\t\t\t\t\t\t\tX x = (X) t;\t\n\t\t\t\t        } catch(ClassCastException e){ \n\t\t\t\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t\t\t\t} \n                    }\n                }.run();\n            }\n        }.run();\n    }\n}\n"}, "SUCCESS");
    }

    public void test114() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString s;\n\tX(String s) {\n\t\tthis.s = s;\n\t}\n\tvoid foo() {\n\t\tclass L extends X {\n\t\t\tL() {\n\t\t\t\tsuper(s);\n\t\t\t\tSystem.out.println(s);\t\t\n\t\t\t}\n\t\t}\n\t\tnew L();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X(\"SUCCESS\").foo();\t\t\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tsuper(s);\n\t      ^\nCannot refer to an instance field s while explicitly invoking a constructor\n----------\n");
    }

    public void test115() {
        this.runConformTest(new String[]{"p2/X2.java", "package p2;\npublic class X2 extends p1.X1 {\n    private void foo() {\n        new p1.X1.M1() {\n            public void bar() {\n                System.out.print(X2.this.field);\n                X2.this.doit();\n            }\n        }.bar();\n    }\n    public static void main(String[] args) {\n        X2 t2 = new X2();\n        t2.foo();\n    }\n}", "p1/X1.java", "package p1;\npublic class X1 {\n    public abstract class M1 {\n        public abstract void bar();\n    }\n    protected static String field = \"SUCC\";\n    protected static void doit() {\n        System.out.println(\"ESS\");\n    }\n}"}, "SUCCESS");
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.java", "class Display {\n  public interface Bla {\n    void a();\n  }\n}\npublic class X {\n  void aMethod() {\n    Display display = null;\n    display.new Bla() {\n    };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tdisplay.new Bla() {\n\t^^^^^^^\nIllegal enclosing instance specification for type Display.Bla\n----------\n2. ERROR in X.java (at line 9)\n\tdisplay.new Bla() {\n\t            ^^^^^\nThe type new Display.Bla(){} must implement the inherited abstract method Display.Bla.a()\n----------\n");
    }

    public void test117() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().bar();\n\t}\n\tvoid bar() {\n\t\tnew X(){\n\t\t\tvoid baz() {\n\t\t\t\tnew M();\n\t\t\t}\n\t\t}.baz();\n\t}\n\tclass M {\n\t\tM() {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test118() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {}\n\tclass M {\n\t\tM(Object o) {}\n\t\tM() {\n\t\t\tthis(new Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t});\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t\tvoid bar() {}\n\t\tvoid baz() {\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tbar();\n\t^^^\nCannot refer to an instance method while explicitly invoking a constructor\n----------\n2. WARNING in X.java (at line 22)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n");
    }

    public void test119() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().new M();\n\t}\n\tvoid foo(String s) { System.out.print(\"<foo:\"+s+\">\"); }\n\tclass M {\n\t\tM(Runnable r) { r.run(); }\n\t\tM() {\n\t\t\tthis(new Runnable() {\n\t\t\t\tpublic void run() {\n\t\t\t\t\tfoo(\"0\");\n\t\t\t\t\tnew Object() {\n\t\t\t\t\t\tvoid baz() {\n//\t\t\t\t\t\t\tfoo(\"1\");\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t\tclass Local {\n\t\t\t\t\t\tvoid baz() {\n//\t\t\t\t\t\t\tfoo(\"2\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\t\t\t\t\n\t\t\t\t\tnew Local();\n\t\t\t\t}\n\t\t\t});\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo(\"3\");\n\t\t\t\t\tbar(\"3\");\n\t\t\t\t}\n\t\t\t}.baz();\n\t\t}\n\t\tvoid bar(String s) { System.out.print(\"<bar:\"+s+\">\"); }\n\t\tvoid baz() {\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo(\"4\");\n\t\t\t\t\tbar(\"4\");\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tfoo(\"0\");\n\t^^^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n2. WARNING in X.java (at line 13)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n3. WARNING in X.java (at line 18)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type Local is never used locally\n----------\n4. WARNING in X.java (at line 35)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n");
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().new M();\n\t}\n\tvoid foo(String s) { System.out.print(\"<foo:\"+s+\">\"); }\n\tclass M {\n\t\tM(Runnable r) { r.run(); }\n\t\tM() {\n\t\t\tthis(new Runnable() {\n\t\t\t\tpublic void run() {\n\t\t\t\t\tfoo(\"0\");\n\t\t\t\t\tnew Object() {\n\t\t\t\t\t\tvoid baz() {\n//\t\t\t\t\t\t\tfoo(\"1\");\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t\tclass Local {\n\t\t\t\t\t\tvoid baz() {\n//\t\t\t\t\t\t\tfoo(\"2\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\t\t\t\t\n\t\t\t\t\tnew Local();\n\t\t\t\t}\n\t\t\t});\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo(\"3\");\n\t\t\t\t\tbar(\"3\");\n\t\t\t\t}\n\t\t\t}.baz();\n\t\t}\n\t\tvoid bar(String s) { System.out.print(\"<bar:\"+s+\">\"); }\n\t\tvoid baz() {\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo(\"4\");\n\t\t\t\t\tbar(\"4\");\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "<foo:0><foo:3><bar:3>");
    }

    public void test120() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {}\n\tclass M {\n\t\tM(Object o) {}\n\t\tM() {\n\t\t\tthis(new Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tnew Object() {\n\t\t\t\t\t\tvoid baz() {\n\t\t\t\t\t\t\tfoo(); //0\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t\tclass Local {\n\t\t\t\t\t\tvoid baz() {\n\t\t\t\t\t\t\tfoo(); //1\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tnew Local();\n\t\t\t\t\tfoo();//2\n\t\t\t\t}\n\t\t\t});\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();//3\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t\tvoid bar() {}\n\t\tvoid baz() {\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();//4\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n2. WARNING in X.java (at line 9)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n3. ERROR in X.java (at line 10)\n\tfoo(); //0\n\t^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n4. WARNING in X.java (at line 14)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type Local is never used locally\n----------\n5. ERROR in X.java (at line 15)\n\tfoo(); //1\n\t^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n6. ERROR in X.java (at line 19)\n\tfoo();//2\n\t^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n7. WARNING in X.java (at line 23)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n8. WARNING in X.java (at line 32)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {}\n\tclass M {\n\t\tM(Object o) {}\n\t\tM() {\n\t\t\tthis(new Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tclass Local {\n\t\t\t\t\t\tvoid baz() {\n\t\t\t\t\t\t\tfoo(); //1\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tnew Local();\n\t\t\t\t\tfoo();//2\n\t\t\t\t}\n\t\t\t});\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();//3\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t\tvoid bar() {}\n\t\tvoid baz() {\n\t\t\tnew Object() {\n\t\t\t\tvoid baz() {\n\t\t\t\t\tfoo();//4\n\t\t\t\t\tbar();\n\t\t\t\t}\n\t\t\t};\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n2. WARNING in X.java (at line 9)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type Local is never used locally\n----------\n3. ERROR in X.java (at line 10)\n\tfoo(); //1\n\t^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n4. WARNING in X.java (at line 18)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n5. WARNING in X.java (at line 27)\n\tvoid baz() {\n\t     ^^^^^\nThe method baz() from the type new Object(){} is never used locally\n----------\n");
    }

    public void test121() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX(Object o) {\n\t}\n\tclass M extends X {\n\t\tM() {\n\t\t\tsuper(null); //1\n\t\t}\n\t\tM(Object o) {\n\t\t\tsuper(new X(null){});//2\n\t\t}\n\t}\n}\n"}, "");
    }

    public void _test122() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().new M();\n\t}\n\tvoid foo(String s) { System.out.print(\"<foo:\"+s+\">\"); }\n\tclass M {\n\t\tM(Runnable r) { r.run(); }\n\t\tM() {\n\t\t\tthis(new Runnable() {\n\t\t\t\t{\n\t\t\t\t\tfoo(\"0\");\n\t\t\t\t\tbar(\"0\");\n\t\t\t\t}\n\t\t\t\tpublic void run() {\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t\tvoid bar(String s) { System.out.print(\"<bar:\"+s+\">\"); }\n\t}\n}\n"}, "----------\ncannot access foo(0)\n----------\n2. ERROR in X.java (at line 12)\n\tbar(\"0\");\n\t^^^\nCannot refer to an instance method while explicitly invoking a constructor\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().new M();\n\t}\n\tvoid foo(String s) { System.out.print(\"<foo:\"+s+\">\"); }\n\tclass M {\n\t\tM(Runnable r) { r.run(); }\n\t\tM() {\n\t\t\tthis(new Runnable() {\n\t\t\t\t{\n\t\t\t\t\tfoo(\"0\");\n\t\t\t\t\tbar(\"0\");\n\t\t\t\t}\n\t\t\t\tpublic void run() {\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t\tvoid bar(String s) { System.out.print(\"<bar:\"+s+\">\"); }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tbar(\"0\");\n\t^^^\nCannot refer to an instance method while explicitly invoking a constructor\n----------\n");
    }

    public void test123() {
        this.runConformTest(new String[]{"X.java", "class Y {\n\tpublic static final boolean b = false;\n}\npublic class X {\n    private static Y y = new Y(); \n    private static Object o = new Object(); \n\n\tstatic class Z {\n\t\tZ() {\n\t    \tif (y.b) {\n\t    \t\tSystem.out.println(\"dead code\");\n\t    \t}\n\t\t}\n\t\tpublic int bar() {\n\t    \tif (y.b) {\n\t    \t\tSystem.out.println(\"dead code\");\n\t    \t}\n    \t\tSystem.out.println(\"bar\");\n\t\t\treturn 0;\n\t\t}\n\t}\n    static int foo() {\n    \tsynchronized(o) { \n\t    \tZ z = new Z();\n    \t\treturn z.bar();\n    \t}\n    }\n    \n    public static void main(String[] args) {\n    \tfoo();\n    }\n}\n"}, "bar");
    }

    public void test124() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws Exception {\n        Foo foo = new Foo();\n        try {\n\t        foo.frob(Baz.class);\n        \tSystem.out.println(\"FAILED\");\n        } catch(IllegalAccessException e){\n        \tSystem.out.println(\"SUCCESS\");\n        }\n    }\n    private static class Baz {\n    }\n}\nclass Foo {\n    public void frob(Class cls) throws Exception {\n        Object o = cls.newInstance();\n    }\n}\n"}, "SUCCESS");
    }

    public void test125() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo(final String s) {\n\t\tclass Local {\n\t\t\tprivate Local() {}\n\t\t\t\tvoid bar() {\n\t\t\t\t\tSystem.out.println(s);\n\t\t\t\t}\n\t\t}\n\t\tnew Local().bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
        new CompilerOptions(this.getCompilerOptions());
    }

    public void test126() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel < 0x310000L) {
            this.runNegativeTest(new String[]{"X.java", "public interface X {\n        private class Inner {}\n        private interface IInner {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate class Inner {}\n\t              ^^^^^\nThe interface member type Inner can only be public\n----------\n2. ERROR in X.java (at line 3)\n\tprivate interface IInner {}\n\t                  ^^^^^^\nThe interface member type IInner can only be public\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public interface X {\n        private class Inner {}\n        private interface IInner {}\n        private enum EInner {}\n        private @interface AInner {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tprivate class Inner {}\n\t              ^^^^^\nThe interface member type Inner can only be public\n----------\n2. ERROR in X.java (at line 3)\n\tprivate interface IInner {}\n\t                  ^^^^^^\nThe interface member type IInner can only be public\n----------\n3. ERROR in X.java (at line 4)\n\tprivate enum EInner {}\n\t             ^^^^^^\nThe interface member type EInner can only be public\n----------\n4. ERROR in X.java (at line 5)\n\tprivate @interface AInner {}\n\t                   ^^^^^^\nThe interface member type AInner can only be public\n----------\n");
    }

    public void test127() {
        this.runConformTest(new String[]{"p/BugContainer.java", "package p;\n\npublic abstract class BugContainer {\n        protected static class InternalInfo$ {\n                public InternalInfo$() {}\n        }\n        abstract protected InternalInfo$ getInfo();\n}\n"}, "");
        this.runConformTest(new String[]{"q/BugUser.java", "package q;\n\nimport p.BugContainer;\n\npublic class BugUser extends BugContainer{\n        protected InternalInfo$ getInfo() {\n                return new InternalInfo$();\n        }\n}"}, "", null, false, null);
    }

    public void test128() {
        this.runConformTest(new String[]{"p/BugContainer.java", "package p;\n\npublic abstract class BugContainer {\n        protected static class InternalInfo$ {\n                public InternalInfo$() {}\n        }\n        abstract protected InternalInfo$ getInfo();\n}\n", "q/BugUser.java", "package q;\n\nimport p.BugContainer;\n\npublic class BugUser extends BugContainer{\n        protected InternalInfo$ getInfo() {\n                return new InternalInfo$();\n        }\n}"}, "");
    }

    public void test129() {
        this.runConformTest(new String[]{"X.java", "public interface X {\n  interface Entry {\n    interface Internal extends Entry {\n      Internal createEntry();\n    }\n  }\n}\n", "Y.java", "public class Y implements X.Entry.Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}\n"}, "");
        this.runConformTest(new String[]{"Y.java", "public class Y implements X.Entry.Internal {\n  public Internal createEntry() {\n    return null;\n  }\n}\n"}, "", null, false, null);
    }

    public void test130() {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        if (options.sourceLevel <= 0x2F0000L) {
            this.runConformTestThrowingError(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tnew M().foo2();\n    }\n}\nclass M  {\n\tString name;\n\t\n\tM() {\n\t\tthis.name = \"SUCCESS\";\n\t}\n\n\tprivate class Y extends N {\n\t\tprivate Y() {\n\t\t\tsuper();\n\t\t}\n\t\tprotected void foo(Z z) {\n\t\t\tz.bar(new A());\n\t\t}\n\t}\n\t\n    public class A implements I {\n    \tpublic void configure() {\n    \t\tnew B().foo();\n    \t}\n    \tpublic class B {\n            public void foo() {\n\t\t\t\ttry {\n                System.out.println(M.this.name);\n\t\t\t\t} catch(NullPointerException e) {\n\t\t\t\t\tSystem.err.println(\"NPE THROWN\");\n\t\t\t\t}\n            }\n        }\n    }\n    \n    public void foo2() {\n    \tnew Y();\n    }\n}\nclass Z {\n\tvoid bar(I i) {\n\t\ti.configure();\n\t}\n}\n\ninterface I {\n\tvoid configure();\n}\n\nclass N {\n\tprotected void foo(Z z) {\n\t}\n\tN() {\n\t\tthis.foo(new Z());\n\t}\n}\n"}, "NPE THROWN", null, true, null);
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tnew M().foo2();\n    }\n}\nclass M  {\n\tString name;\n\t\n\tM() {\n\t\tthis.name = \"SUCCESS\";\n\t}\n\n\tprivate class Y extends N {\n\t\tprivate Y() {\n\t\t\tsuper();\n\t\t}\n\t\tprotected void foo(Z z) {\n\t\t\tz.bar(new A());\n\t\t}\n\t}\n\t\n    public class A implements I {\n    \tpublic void configure() {\n    \t\tnew B().foo();\n    \t}\n    \tpublic class B {\n            public void foo() {\n                System.out.println(M.this.name);\n            }\n        }\n    }\n    \n    public void foo2() {\n    \tnew Y();\n    }\n}\nclass Z {\n\tvoid bar(I i) {\n\t\ti.configure();\n\t}\n}\n\ninterface I {\n\tvoid configure();\n}\n\nclass N {\n\tprotected void foo(Z z) {\n\t}\n\tN() {\n\t\tthis.foo(new Z());\n\t}\n}\n"}, "SUCCESS");
    }

    public void test131() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tvoid foo() {\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tclass Local {\n\t\t\t\tLocal(int i) {\n\t\t\t\t\tthis.init(i);\n\t\t\t\t\tthis.bar(); // should detect error\n\t\t\t\t}\n\t\t\t\tvoid init(int i) {\n\t\t\t\t}\n\t\t\t}\n\t\t\tLocal l = new Local(0); // should be fine\n\t\t}\n\t\tLocal l = new Local();\n\t\tl.foo();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tclass Local {\n\t      ^^^^^\nDuplicate nested type Local\n----------\n2. ERROR in X.java (at line 11)\n\tthis.bar(); // should detect error\n\t     ^^^\nThe method bar() is undefined for the type Local\n----------\n");
    }

    public void test132() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tclass Local {}\n\t\tclass Foo {\n\t\t\tvoid foo() {\n\t\t\t\tclass Local {}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Local {}\n\t      ^^^^^\nThe type Local is never used locally\n----------\n2. WARNING in X.java (at line 4)\n\tclass Foo {\n\t      ^^^\nThe type Foo is never used locally\n----------\n3. WARNING in X.java (at line 5)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() from the type Foo is never used locally\n----------\n4. WARNING in X.java (at line 6)\n\tclass Local {}\n\t      ^^^^^\nThe type Local is hiding the type Local\n----------\n5. WARNING in X.java (at line 6)\n\tclass Local {}\n\t      ^^^^^\nThe type Local is never used locally\n----------\n");
    }

    public void test133() {
        if (this.complianceLevel.compareTo("1.5") >= 0) {
            this.runConformTest(new String[]{"X.java", "public class X {\n  public static interface I {\n  }\n  public static interface IE extends I {\n  }\n  public static interface J {\n    I getI(int i);\n  }\n  public static interface JE extends J {\n    IE getI(int i);\n  }\n  public static class Y implements JE {\n    public IE getI(int i) {\n      return null;\n    }\n  }\n  private J j = new Y();\n  public void foo() {\n    j.getI(0);\n    System.out.println(\"SUCCESS\");\n  }\n  public static void main(String[] args) {\n    new X().foo();\n  }\n}"}, "SUCCESS");
        }
    }

    public void test134() {
        if (this.complianceLevel.compareTo("1.5") >= 0) {
            this.runConformTest(new String[]{"X.java", "public class X {\n  public interface I {\n    public String foo();\n  }\n  public interface J {\n    public I getI();\n  }\n  public static class XI implements I {\n    public String foo() {\n      return \"XI\";\n    }\n  }\n  public interface K extends J {\n    public XI getI();\n  }\n  public static abstract class XK implements K {\n    public XI getI() {\n      return new XI();\n    }\n  }\n  public static class Y extends XK {\n  }\n  public static void main(String[] args) {\n    K k = new Y();\n    System.out.println(k.getI().foo());\n    J j = k;\n    System.out.println(j.getI().foo());\n  }\n}"}, "XI\nXI");
        }
    }

    public void test135() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport p.A;\npublic class X {\n\t\n\tvoid foo(Object o, Object [] os) {\n\t\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t}\n\tprivate interface Outer {\n\t\tinterface Inner {\n\t\t\tString variable = \"my testing\";\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Outer.Inner.variable);\n\t\tZork z;\n\t}\n}", "p/A.java", "package p;\n/** @deprecated */\npublic class A {\n\tpublic class M1 {\n\t\tpublic class MM1 {\n\t\t}\n\t}\n\tpublic class M2 extends M1 {\n\t}\n}"}, "----------\n1. WARNING in p\\X.java (at line 2)\n\timport p.A;\n\t       ^^^\nThe type A is deprecated\n----------\n2. WARNING in p\\X.java (at line 6)\n\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t^^^^^^^^\nThe type A is deprecated\n----------\n3. WARNING in p\\X.java (at line 6)\n\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t^^^^^^^^\nThe type A.M2 is deprecated\n----------\n4. WARNING in p\\X.java (at line 6)\n\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t^^^^^^^^\nThe type A.M1.MM1 is deprecated\n----------\n5. WARNING in p\\X.java (at line 6)\n\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t                ^\nThe type A is deprecated\n----------\n6. WARNING in p\\X.java (at line 6)\n\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t                ^^^^\nThe type A.M2 is deprecated\n----------\n7. WARNING in p\\X.java (at line 6)\n\tA.M2.MM1 mm1 = (A.M2.MM1) o;\n\t                ^^^^^^^^\nThe type A.M1.MM1 is deprecated\n----------\n8. WARNING in p\\X.java (at line 7)\n\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t^^^^^^^^\nThe type A is deprecated\n----------\n9. WARNING in p\\X.java (at line 7)\n\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t^^^^^^^^\nThe type A.M2 is deprecated\n----------\n10. WARNING in p\\X.java (at line 7)\n\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t^^^^^^^^\nThe type A.M1.MM1 is deprecated\n----------\n11. WARNING in p\\X.java (at line 7)\n\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t                   ^^^^^^^^\nThe type A is deprecated\n----------\n12. WARNING in p\\X.java (at line 7)\n\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t                   ^^^^^^^^\nThe type A.M2 is deprecated\n----------\n13. WARNING in p\\X.java (at line 7)\n\tA.M2.MM1[] mm1s = (A.M2.MM1[]) os;\n\t                   ^^^^^^^^\nThe type A.M1.MM1 is deprecated\n----------\n14. ERROR in p\\X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test136() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tprivate interface Outer {\n\t\tinterface Inner {\n\t\t\tString variable = \"my testing\";\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tOuter.Inner variable = null;\n\t\tSystem.out.println(variable);\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in p\\X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test137() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tprivate interface Outer {\n\t\tinterface Inner {\n\t\t\tString variable = \"my testing\";\n\t\t}\n\t}\n\tprivate interface Outer2 extends Outer {\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Outer2.Inner.variable);\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in p\\X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test138() {
        this.runNegativeTest(new String[]{"p/X.java", "public class X {\n\tprivate interface Outer {\n\t\tinterface Inner {\n\t\t\tString variable = \"my testing\";\n\t\t}\n\t}\n\tprivate interface Outer2 extends Outer {\n\t}\n\tpublic static void main(String[] args) {\n\t\tOuter2.Inner variable = null;\n\t\tSystem.out.println(variable);\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in p\\X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test139() {
        this.runNegativeTest(new String[]{"X.java", "public class X { \n   private class A {\n    class B {}\n  }\n  private class Y extends A {\n  }\n  Y.B d = null;\n}\nclass Y extends Zork {}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tprivate class Y extends A {\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n2. ERROR in X.java (at line 9)\n\tclass Y extends Zork {}\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test140() {
        this.runConformTest(new String[]{"p/A.java", "package p;\npublic class A {\n\tpublic static interface I {\n\t\tvoid foo();\n\t}\n}", "p1/X.java", "package p1;\nimport p.A;\npublic class X implements A.I {\n        public void foo() { /* dummy */ }\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #5 p/A$I, outer class info: #20 p/A\n     inner name: #22 I, accessflags: 1545 public abstract static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "p1" + File.separator + "X.class", "X", expectedOutput);
    }

    public void test141() {
        this.runConformTest(new String[]{"p/A.java", "package p;\npublic class A {\n\tpublic static class B {\n\t\tvoid foo() { /* dummy */ }\n\t}\n}", "p1/X.java", "package p1;\nimport p.A;\npublic class X extends A.B {\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #3 p/A$B, outer class info: #17 p/A\n     inner name: #19 B, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "p1" + File.separator + "X.class", "X", expectedOutput);
    }

    public void test142() {
        this.runConformTest(new String[]{"p/A.java", "package p;\npublic class A {\n\tpublic class B {\n\t\tvoid foo() { /* dummy */ }\n\t}\n}", "p1/X.java", "package p1;\nimport p.A;\npublic class X {\n\tObject foo() {\n\t\treturn new A().new B();\n\t}\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #16 p/A$B, outer class info: #18 p/A\n     inner name: #31 B, accessflags: 1 public]\n";
        if (new CompilerOptions((Map)this.getCompilerOptions()).targetJDK == 2949123L) {
            expectedOutput = "  Inner classes:\n    [inner class info: #16 p/A$B, outer class info: #18 p/A\n     inner name: #27 B, accessflags: 1 public]\n";
        }
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "p1" + File.separator + "X.class", "X", expectedOutput);
    }

    public void test143() {
        this.runConformTest(new String[]{"X.java", "class A {\n\tpublic class B {\n\t\tvoid foo() { /* dummy */ }\n\t}\n}\npublic class X {\n\tObject foo() {\n\t\treturn A.B.class;\n\t}\n}"});
        if (new CompilerOptions((Map)this.getCompilerOptions()).targetJDK >= 0x310000L) {
            String expectedOutput = "  Inner classes:\n    [inner class info: #16 A$B, outer class info: #21 A\n     inner name: #23 B, accessflags: 1 public]\n";
            this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
        }
    }

    public void test144() {
        this.runConformTest(new String[]{"X.java", "class A {\n\tpublic static class B {\n\t\tpublic static int CONST = 0;\n\t}\n}\npublic class X {\n\tint foo() {\n\t\treturn A.B.CONST;\n\t}\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #17 A$B, outer class info: #25 A\n     inner name: #27 B, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test145() {
        this.runConformTest(new String[]{"X.java", "class A {\n\tpublic static class B {\n\t}\n}\npublic class X {\n\tA.B field;\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #19 A$B, outer class info: #21 A\n     inner name: #23 B, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test146() {
        this.runConformTest(new String[]{"X.java", "class A {\n\tpublic static class B {\n\t}\n}\npublic class X {\n\tint foo(A.B o) {\n\t\treturn 0;\n\t}\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #21 A$B, outer class info: #23 A\n     inner name: #25 B, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test147() {
        this.runConformTest(new String[]{"X.java", "class A {\n\tpublic static class B {\n\t}\n}\npublic class X {\n\tA.B foo() {\n\t\treturn null;\n\t}\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #19 A$B, outer class info: #21 A\n     inner name: #23 B, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test148() {
        this.runConformTest(new String[]{"X.java", "class A {\n\tpublic static class B extends Exception {\n\t}\n}\npublic class X {\n\tvoid foo() throws A.B{\n\t}\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #16 A$B, outer class info: #21 A\n     inner name: #23 B, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test149() {
        this.runConformTest(new String[]{"X.java", "public final class X implements A.Foo1 {\n        public void foo() {}\n        public A.Foo2 foo2() {   return null; }\n        public void foo3( A.Foo3 foo ) {}\n        public void foo4() { A.Foo4 foo = null; }\n        public void foo5() {\n                new A.Foo5() {\n                        public void foo() {}\n                }.foo();\n        }\n        public static class Foo6 implements A.Foo6 {\n                public void foo() {}\n        }\n        public void foo7() { Bar2.foo7().foo(); }\n}", "A.java", "class A {\n        public static interface Foo1 { void foo(); }\n        public static interface Foo2 { void foo(); }\n        public static interface Foo3 { void foo(); }\n        public static interface Foo4 { void foo(); }\n        public static interface Foo5 { void foo(); }\n        public static interface Foo6 { void foo(); }\n        public static interface Foo7 { void foo(); }\n}", "Bar2.java", "class Bar2 {\n        public static A.Foo7 foo7() { return null; }\n}"});
        String expectedOutput = "  Inner classes:\n    [inner class info: #5 A$Foo1, outer class info: #44 A\n     inner name: #46 Foo1, accessflags: 1545 public abstract static],\n    [inner class info: #47 A$Foo2, outer class info: #44 A\n     inner name: #49 Foo2, accessflags: 1545 public abstract static],\n    [inner class info: #50 A$Foo3, outer class info: #44 A\n     inner name: #52 Foo3, accessflags: 1545 public abstract static],\n    [inner class info: #39 A$Foo7, outer class info: #44 A\n     inner name: #53 Foo7, accessflags: 1545 public abstract static],\n    [inner class info: #25 X$1, outer class info: #0\n     inner name: #0, accessflags: 0 default],\n    [inner class info: #54 X$Foo6, outer class info: #1 X\n     inner name: #56 Foo6, accessflags: 9 public static]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.InnerEmulationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

