/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class GenericTypeSignatureTest
extends AbstractRegressionTest {
    static final String RUN_SUN_JAVAC = System.getProperty("run.javac");
    static boolean RunJavac = "enabled".equals(RUN_SUN_JAVAC);
    IPath dirPath = new Path(OUTPUT_DIR);
    static /* synthetic */ Class class$0;

    public static Test suite() {
        return GenericTypeSignatureTest.buildMinimalComplianceTestSuite(GenericTypeSignatureTest.testClass(), 4);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.GenericTypeSignatureTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public GenericTypeSignatureTest(String name) {
        super(name);
    }

    protected void cleanUp() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
    }

    protected String[] getFileNames(String[] testFiles) {
        int length = testFiles.length;
        int max = length / 2;
        String[] fileNames = new String[max];
        int i = 0;
        while (i < max) {
            fileNames[i] = testFiles[i * 2];
            ++i;
        }
        return fileNames;
    }

    protected void runJavac(String testName, String[] testFiles) {
        try {
            this.writeFiles(testFiles);
            String[] fileNames = this.getFileNames(testFiles);
            Process process = null;
            try {
                String[] classpath = this.getDefaultClassPaths();
                StringBuffer cp = new StringBuffer();
                int length = classpath.length;
                int i = 0;
                while (i < length) {
                    if (classpath[i].indexOf(" ") != -1) {
                        cp.append("\"" + classpath[i] + "\"");
                    } else {
                        cp.append(classpath[i]);
                    }
                    if (i < length - 1) {
                        cp.append(";");
                    }
                    ++i;
                }
                IPath jdkDir = new Path(Util.getJREDirectory()).removeLastSegments(1);
                IPath javacPath = jdkDir.append("bin").append("javac.exe");
                StringBuffer cmdLine = new StringBuffer(javacPath.toString());
                cmdLine.append(" -classpath ");
                cmdLine.append(cp);
                cmdLine.append(" -source 1.5 -deprecation -g -Xlint ");
                int i2 = 0;
                int length2 = fileNames.length;
                while (i2 < length2) {
                    cmdLine.append(String.valueOf(fileNames[i2]) + " ");
                    ++i2;
                }
                process = Runtime.getRuntime().exec(cmdLine.toString(), null, this.dirPath.toFile());
                Logger errorLogger = new Logger(process.getErrorStream(), "ERROR");
                Logger outputLogger = new Logger(process.getInputStream(), "OUTPUT");
                errorLogger.start();
                outputLogger.start();
                if (process.waitFor() != 0) {
                    System.out.println(String.valueOf(testName) + ": javac has found error(s)!");
                }
            }
            catch (IOException iOException) {
                System.out.println(String.valueOf(testName) + ": Not possible to launch Sun javac compilation!");
            }
            catch (InterruptedException interruptedException) {
                if (process != null) {
                    process.destroy();
                }
                System.out.println(String.valueOf(testName) + ": Sun javac compilation was aborted!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void test001() {
        String[] testsSource = new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n    public static void main(String[] args) {\n    \tX<X<String>> xs = new X<X<String>>(new X<String>(\"SUCCESS\"));\n        System.out.print(xs.t.t);\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
    }

    public void test002() {
        String[] testsSource = new String[]{"X.java", "class X extends p.A<String> {\n    X() {\n        super(null);\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected A(P p) {\n    }\n}"};
        this.runConformTest(testsSource);
    }

    public void test003() {
        String[] testsSource = new String[]{"X.java", "public class X <T extends Object & p.B<? super T>> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}", "p/B.java", "package p;\npublic interface B<T> {\n}"};
        this.runConformTest(testsSource);
    }

    public void test004() {
        String[] testsSource = new String[]{"X.java", "public class X <T extends Object & p.B> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}", "p/B.java", "package p;\npublic interface B<T> {\n}"};
        this.runConformTest(testsSource);
    }

    public void test005() {
        String[] testsSource = new String[]{"X.java", "public class X <T extends Object & p.B & p.C> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}", "p/B.java", "package p;\npublic interface B<T> {\n}", "p/C.java", "package p;\npublic interface C<T> {\n}"};
        this.runConformTest(testsSource);
    }

    protected void writeFiles(String[] testFiles) {
        IPath dirFilePath = (IPath)this.dirPath.clone();
        File dir = dirFilePath.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            dirFilePath = (IPath)this.dirPath.clone();
            String contents = testFiles[i + 1];
            String fileName = testFiles[i++];
            IPath filePath = dirFilePath.append(fileName);
            if (fileName.lastIndexOf(47) >= 0 && !(dir = (dirFilePath = filePath.removeLastSegments(1)).toFile()).exists()) {
                dir.mkdirs();
            }
            Util.writeToFile(contents, filePath.toString());
            ++i;
        }
    }

    class Logger
    extends Thread {
        StringBuffer buffer;
        InputStream inputStream;
        String type;

        Logger(InputStream inputStream, String type) {
            this.inputStream = inputStream;
            this.type = type;
            this.buffer = new StringBuffer();
        }

        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.buffer.append(this.type).append("->").append(line);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

