/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractCompletionTest;
import org.eclipse.wst.jsdt.internal.codeassist.complete.InvalidCursorLocation;

public class CompletionParserTest
extends AbstractCompletionTest {
    static /* synthetic */ Class class$0;

    public CompletionParserTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.parser.CompletionParserTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CompletionParserTest.buildAllCompliancesTestSuite(clazz);
    }

    public void testA() {
        String str = "\tfunction foo(){\n\t\tvar i;\n\t\tif (i instanceof O) {\n\t\t}\n\t\tvar s = \"hello\";\n\t\ts.}\n\n";
        String testName = "<complete on methods/fields>";
        String completeBehind = "s.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:s.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function foo() {\n  var i;\n  if ((i instanceof O))\n      {\n      }\n  var s = \"hello\";\n  <CompleteOnMemberAccess:s.>;\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testAA_1() {
        String str = "\tfunction foo() {\n\t\tvar maxUnits = 0;\n\t\t\tvar unitResult = \n\t\t\t\tnew CompilationUnitResult(\n\t\t\t\t\tnull, \n\t\t\t\t\ti, \n\t\t\t\t\tmaxUnits); \n\t}}\n";
        String completeBehind = "n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedUnitDisplayString = "function foo() {\n  var maxUnits = 0;\n  var unitResult = <CompleteOnName:n>;\n  CompilationUnitResult(null, i, maxUnits);\n}\n";
        String expectedReplacedSource = "new";
        String testName = "<complete on initializer (new)>";
        int cursorLocation = str.indexOf("new CompilationUnitResult(") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testAA_2() {
        String str = "// test unicode \\u000a var c = 1; \nvar b =c; \n";
        String testName = "<unicode in comment complete on variable>";
        String expectedCompletionNodeToString = "<CompleteOnName:c>";
        String completionIdentifier = "c";
        String expectedReplacedSource = "c";
        int cursorLocation = str.indexOf("var b =c") - 1;
        String expectedUnitDisplayString = "// test unicode \\u000a var c = 1; \nvar b = <CompleteOnName:c>;\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testB() {
        String str = "function B() {\n\tvar o = new Object \n}\n";
        String testName = "<complete on type into type creation>";
        String completeBehind = "new Object";
        String expectedCompletionNodeToString = "<CompleteOnName:Object>";
        String completionIdentifier = "Object";
        String expectedReplacedSource = "Object";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function B() {\n  var o = new   <CompleteOnType:Object>;\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testBB_1FHJ8H9() {
        String str = "function bar() {\n\t\tz }\n\n";
        String testName = "<complete on method/field from implicit method call>";
        String completeBehind = "z";
        String expectedCompletionNodeToString = "<CompleteOnName:z>";
        String completionIdentifier = "z";
        String expectedReplacedSource = "z";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function bar() {\n  <CompleteOnName:z>;\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMsgSend() {
        String str = "  function foo() {\n    var removed = 0;\n    toto(Test.vvv).titi(removed);\n  }\n";
        String testName = "<complete on method call>";
        String completeBehind = "removed";
        String expectedCompletionNodeToString = "<CompleteOnName:removed>";
        String completionIdentifier = "removed";
        String expectedReplacedSource = "removed";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function foo() {\n  var removed = 0;\n  toto(Test.vvv).titi(<CompleteOnName:removed>);\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMsgSend2() {
        String str = "    abc.titi();\n";
        String testName = "<complete on method call 2>";
        String completeBehind = "titi";
        String expectedCompletionNodeToString = "<CompleteOnMessageSend:abc.titi()>";
        String completionIdentifier = "titi";
        String expectedReplacedSource = "titi()";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "<CompleteOnMessageSend:abc.titi()>;\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMsgSend3() {
        String str = "  function foo() {\n    var removed = 0;\n    toto(Test.vvv).titi(removed);\n  }\n";
        String testName = "<complete on method call 3>";
        String completeBehind = "titi";
        String expectedCompletionNodeToString = "<CompleteOnMessageSend:toto(Test.vvv).titi(removed)>";
        String completionIdentifier = "titi";
        String expectedReplacedSource = "titi(removed)";
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function foo() {\n  var removed = 0;\n  <CompleteOnMessageSend:toto(Test.vvv).titi(removed)>;\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testBC_1FJ4GSG_3() {
        String str = "\tfunction foo() {\n\t\tvar v = \n\t\t\tnew Vector();\n\t\tvar ans = v.elementAt(1);\n\t}\n\n";
        String testName = "<complete on method/field>";
        String completeBehind = "v.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:v.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "v.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function foo() {\n  var v = new   Vector();\n  var ans = <CompleteOnMemberAccess:v.>;\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testC() {
        String str = "function foo() {\n\t\tvar string = n;\n\t}\n\n";
        String completeBehind = "= n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedUnitDisplayString = "function foo() {\n  var string = <CompleteOnName:n>;\n}\n";
        String expectedReplacedSource = "n";
        String testName = "<complete on local variable initializer>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testCA_1FGPJQZ() {
        String str = "\tfunction moo() {\n\t\tunknownField.}\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "unknownField.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:unknownField.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "function moo() {\n  <CompleteOnMemberAccess:unknownField.>;\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testCB_1FHSKQ9_1() {
        String str = "\tfunction foo() {\n\t\tvar i = 0;\n\t\tvar tab1 = 0;\n\t\tSystem.out.println(\n\t\t\t\" \" + (i + 1)); \n}\n";
        String testName = "<complete on method call argument>";
        String completeBehind = "+ (i";
        String expectedCompletionNodeToString = "<CompleteOnName:i>";
        String completionIdentifier = "i";
        String expectedReplacedSource = "i";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function foo() {\n  var i = 0;\n  var tab1 = 0;\n  System.out.println((\" \" + (<CompleteOnName:i> + 1)));\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testCB_1FHSKQ9_2() {
        String str = "\tfunction foo() {\n\t\tvar i = 0;\n\t\tSystem.out.println(\n\t\t\t\" \" + (i + 1)); \n}\n";
        String completeBehind = "i + 1";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedUnitDisplayString = null;
        String expectedReplacedSource = "<NONE>";
        String testName = "<complete on digit into method call argument>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Number");
        }
    }

    public void testD_2() {
        String str = "\tvar a = new Vector();\n\tfunction foo(s) {\n\t\tvar string = null;\n\t\tvar soso;\n\t\tvar f;\n\t\tstring.regionMatches(\n\t\t\t0, \n\t\t\t\"\", \n\t\t\t0, \n\t\t\t0); \n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "string.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:string.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "string.";
        String expectedUnitDisplayString = "var a = new Vector();\nfunction foo(s) {\n  var string = null;\n  var soso;\n  var f;\n  <CompleteOnMemberAccess:string.>;\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testD_2b() {
        String str = "\tfunction foo(s) {\n\t\tfoo(string.regionMatches);\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "string.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:string.>";
        String completionIdentifier = "string.";
        String expectedReplacedSource = "regionMatches";
        String expectedUnitDisplayString = "function foo(s) {\n  foo(<CompleteOnMemberAccess:string.>);\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testD_2c() {
        String str = "\tvar obj= {\n\ta: string.regionMatches\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "string.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:string.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "regionMatches";
        String expectedUnitDisplayString = "var obj = {\n  a : <CompleteOnMemberAccess:string.>\n};\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDA_1() {
        String str = "package p; \npublic class DA {\n\tvoid foo() {\n\t\tnew TestCase(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t};\n\t}\n}\n";
        String testName = "<complete on method/field into anonymous declaration>";
        String completeBehind = "v";
        String expectedCompletionNodeToString = "<CompleteOnName:v>";
        String completionIdentifier = "v";
        String expectedReplacedSource = "v";
        int cursorLocation = str.indexOf("v }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class DA {\n  public DA() {\n  }\n  void foo() {\n    new TestCase(\"error\") {\n      () {\n      }\n      protected void runTest() {\n        Vector v11111;\n        <CompleteOnName:v>;\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDA_2() {
        String str = "package p; \npublic class DA {\n\tvoid foo() {\n\t\tnew TestCase(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t};\n\t}\n}\n";
        String completeBehind = "protected v";
        String expectedCompletionNodeToString = "<CompleteOnType:v>";
        String completionIdentifier = "v";
        String expectedUnitDisplayString = "package p;\npublic class DA {\n  public DA() {\n  }\n  void foo() {\n    new TestCase(\"error\") {\n      <CompleteOnType:v>;\n      () {\n      }\n      runTest() {\n      }\n    };\n  }\n}\n";
        String expectedReplacedSource = "void";
        String testName = "<complete on return type into anonymous declaration>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDA_3() {
        String str = "package p; \npublic class DA {\n\tvoid foo() {\n\t\tnew TestCase(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t};\n\t}\n}\n";
        String testName = "<complete on method selector into anonymous declaration>";
        String completeBehind = "r";
        String expectedCompletionNodeToString = "<CompleteOnFieldName:void r>;";
        String completionIdentifier = "r";
        String expectedReplacedSource = "runTest";
        int cursorLocation = str.indexOf("runTest") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class DA {\n  public DA() {\n  }\n  void foo() {\n    new TestCase(\"error\") {\n      <CompleteOnFieldName:void r>;\n      {\n      }\n      () {\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDA_4() {
        String str = "package p; \npublic class DA {\n\tvoid foo() {\n\t\tnew TestCase(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t};\n\t}\n}\n";
        String testName = "<complete on local variable type into anonymous declaration>";
        String completeBehind = "V";
        String expectedCompletionNodeToString = "<CompleteOnName:V>";
        String completionIdentifier = "V";
        String expectedReplacedSource = "Vector";
        int cursorLocation = str.indexOf("Vector v11111") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class DA {\n  public DA() {\n  }\n  void foo() {\n    new TestCase(\"error\") {\n      () {\n      }\n      protected void runTest() {\n        <CompleteOnName:V>;\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDA_5() {
        String str = "package p; \npublic class DA {\n\tvoid foo() {\n\t\tnew TestCase(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t};\n\t}\n}\n";
        String testName = "<complete on local type into anonymous declaration>";
        String completeBehind = "v";
        String expectedCompletionNodeToString = "<CompleteOnName:v>";
        String completionIdentifier = "v";
        String expectedReplacedSource = "v";
        int cursorLocation = str.indexOf("v }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class DA {\n  public DA() {\n  }\n  void foo() {\n    new TestCase(\"error\") {\n      () {\n      }\n      protected void runTest() {\n        Vector v11111;\n        <CompleteOnName:v>;\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDB_1FHSLDR() {
        String str = "package p; \n/**\n * 1FHSLDR\n */\npublic class DB {\n\tvoid foo() {\n\t\ttry {\n\t\t\tSystem.out.println(\"\");\n\t\t}\n\t\tfi }\n}\n";
        String testName = "<complete on finally keyword>";
        String completeBehind = "fi";
        String expectedCompletionNodeToString = "<CompleteOnKeyword:fi>";
        String completionIdentifier = "fi";
        String expectedReplacedSource = "fi";
        int cursorLocation = str.indexOf("fi }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class DB {\n  public DB() {\n  }\n  void foo() {\n    <CompleteOnKeyword:fi>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testDC_1FJJ0JR_1() {
        String str = "package p; \n/**\n * 1FJJ0JR\n */\npublic class DC\n\textends ModelChangeOperation {\n\tISec public SetSecondarySourceOperation(\n\t\tISecondarySourceContainer element, \n\t\tVersionID id) {\n\t}\n\tprotected abstract void doExecute(IProgressMonitor monitor)\n\t\tthrows OperationFailedException {\n\t}\n}\n";
        String testName = "<complete on method return type>";
        String completeBehind = "ISec";
        String expectedCompletionNodeToString = "<CompleteOnType:ISec>";
        String completionIdentifier = "ISec";
        String expectedReplacedSource = "ISec";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class DC extends ModelChangeOperation {\n  <CompleteOnType:ISec>;\n  public DC() {\n  }\n  public SetSecondarySourceOperation(ISecondarySourceContainer element, VersionID id) {\n  }\n  protected abstract void doExecute(IProgressMonitor monitor) throws OperationFailedException;\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testE_1FG1YDS_1() {
        String str = "package p; \n/**\n * 1FG1YDS\n */\npublic class E {\n\t{\n\t\tnew Y()\n\t }\n\t{\n\t\tnew Y().}\n\tclass Y\n\t\textends java.util.Vector {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on type into type creation>";
        String completeBehind = "Y";
        String expectedCompletionNodeToString = "<CompleteOnType:Y>";
        String completionIdentifier = "Y";
        String expectedReplacedSource = "Y";
        String expectedUnitDisplayString = "package p;\npublic class E {\n  class Y extends java.util.Vector {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n    new <CompleteOnType:Y>();\n  }\n  {\n  }\n  public E() {\n  }\n}\n";
        int cursorLocation = str.indexOf("Y()\n") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testE_1FG1YDS_2() {
        String str = "package p; \n/**\n * 1FG1YDS\n */\npublic class E {\n\t{\n\t\tnew Y()\n\t }\n\t{\n\t\tnew Y().}\n\tclass Y\n\t\textends java.util.Vector {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on implicit method call into intializer>";
        String completeBehind = "new Y().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new Y().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "package p;\npublic class E {\n  class Y extends java.util.Vector {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n  }\n  {\n    <CompleteOnMemberAccess:new Y().>;\n  }\n  public E() {\n  }\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testE_1FG1YDS_3() {
        String str = "package p; \n/**\n * 1FG1YDS\n */\npublic class E {\n\t{\n\t\tnew Y()\n\t }\n\t{\n\t\tnew Y().}\n\tclass Y\n\t\textends java.util.Vector {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on extend type>";
        String completeBehind = "java.util.";
        String expectedCompletionNodeToString = "<CompleteOnClass:java.util.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "java.util.Vector";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class E {\n  class Y extends <CompleteOnClass:java.util.> {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n  }\n  {\n  }\n  public E() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testEA_1() {
        String str = "package p; \npublic class EA {\n\tvoid foo() {\n\t\ttry {\n\t\t\tthrow new Error();\n\t\t} catch (Exception eeee) {\n\t\t\teeee.}\n\t}\n}\n";
        String testName = "<complete on catch block exception type declaration>";
        String completeBehind = "E";
        String expectedCompletionNodeToString = "<CompleteOnException:E>";
        String completionIdentifier = "E";
        String expectedReplacedSource = "Exception";
        String expectedUnitDisplayString = "package p;\npublic class EA {\n  public EA() {\n  }\n  void foo() {\n    <CompleteOnException:E>;\n  }\n}\n";
        int cursorLocation = str.indexOf("Exception eeee") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testEA_2() {
        String str = "package p; \npublic class EA {\n\tvoid foo() {\n\t\ttry {\n\t\t\tthrow new Error();\n\t\t} catch (Exception eeee) {\n\t\t\teeee.}\n\t}\n}\n";
        String testName = "<complete on method/field of thrown exception into catch block>";
        String completeBehind = "eeee.";
        String expectedCompletionNodeToString = "<CompleteOnName:eeee.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "eeee.";
        String expectedUnitDisplayString = "package p;\npublic class EA {\n  public EA() {\n  }\n  void foo() {\n    {\n      Exception eeee;\n      <CompleteOnName:eeee.>;\n    }\n  }\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testEB_1FI74S3() {
        String str = "package p; \n/**\n * 1FI74S3\n */\npublic class EB {\n\tint[] table;\n\tvoid foo() {\n\t\tint x = table.}\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "table.";
        String expectedCompletionNodeToString = "<CompleteOnName:table.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "table.";
        String expectedUnitDisplayString = "package p;\npublic class EB {\n  int[] table;\n  public EB() {\n  }\n  void foo() {\n    int x = <CompleteOnName:table.>;\n  }\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testEC_1FSBZ2Y() {
        String str = "package p; \n/**\n * 1FSBZ2Y\n */\nclass EC {\n\tvoid foo() {\n\t\tEC\n\t}\n}\nclass ECOtherTopLevel {\n}\n";
        String testName = "<complete on local variable decaration type>";
        String completeBehind = "EC";
        String expectedCompletionNodeToString = "<CompleteOnName:EC>";
        String completionIdentifier = "EC";
        String expectedReplacedSource = "EC";
        String expectedUnitDisplayString = "package p;\nclass EC {\n  EC() {\n  }\n  void foo() {\n    <CompleteOnName:EC>;\n  }\n}\nclass ECOtherTopLevel {\n  ECOtherTopLevel() {\n  }\n}\n";
        int cursorLocation = str.indexOf("EC\n") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testF() {
        String str = "package p; \npublic class F {\n\tvoid bar() {\n\t}\n\tclass Y {\n\t\tvoid foo() {\n\t\t\tba }\n\t}\n}\n";
        String testName = "<complete on method/field explicit access>";
        String completeBehind = "ba";
        String expectedCompletionNodeToString = "<CompleteOnName:ba>";
        String completionIdentifier = "ba";
        String expectedReplacedSource = "ba";
        String expectedUnitDisplayString = "package p;\npublic class F {\n  class Y {\n    Y() {\n    }\n    void foo() {\n      <CompleteOnName:ba>;\n    }\n  }\n  public F() {\n  }\n  void bar() {\n  }\n}\n";
        int cursorLocation = str.indexOf("ba }") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testFA_1() {
        String str = "package p; \npublic class FA {\n\tbyte value;\n\tpublic float foo() {\n\t\treturn (float) value;\n\t}\n}\n";
        String testName = "<complete on cast expression type>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "float";
        String expectedUnitDisplayString = "package p;\npublic class FA {\n  byte value;\n  public FA() {\n  }\n  public float foo() {\n    return <CompleteOnName:f>;\n  }\n}\n";
        int cursorLocation = str.indexOf("float)") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testFA_2() {
        String str = "package p; \npublic class FA {\n\tbyte value;\n\tpublic float foo() {\n\t\treturn (float) value; \n\t}\n}\n";
        String testName = "<complete on returned value>";
        String completeBehind = "v";
        String expectedCompletionNodeToString = "<CompleteOnName:v>";
        String completionIdentifier = "v";
        String expectedReplacedSource = "value";
        String expectedUnitDisplayString = "package p;\npublic class FA {\n  byte value;\n  public FA() {\n  }\n  public float foo() {\n    (float) <CompleteOnName:v>;\n  }\n}\n";
        int cursorLocation = str.indexOf("value; \n") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testFB_1FI74S3() {
        String str = "package p; \n/**\n * 1FI74S3\n */\npublic class FB {\n\tint[] table;\n\tvoid foo() {\n\t\tint x = table[1].}\n}\n";
        String testName = "<complete on method/field of array element>";
        String completeBehind = "table[1].";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:table[1].>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "package p;\npublic class FB {\n  int[] table;\n  public FB() {\n  }\n  void foo() {\n    int x = <CompleteOnMemberAccess:table[1].>;\n  }\n}\n";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testFC_1FSBZ9B() {
        String str = "package p; \n/**\n * 1FSBZ9B\n */\nclass FC {\n\tUNKOWNTYPE field;\n\tvoid foo() {\n\t\tf\n\t}\n}\n";
        String testName = "<complete on method/field implicit access>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf("f\n") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass FC {\n  UNKOWNTYPE field;\n  FC() {\n  }\n  void foo() {\n    <CompleteOnName:f>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testG() {
        String str = "package p; \npublic class G {\n\tint bar() {\n\t}\n\tclass Y {\n\t\tvoid foo(int b) {\n\t\t\treturn b }\n\t}\n}\n";
        String testName = "<complete on return value>";
        String completeBehind = "b";
        String expectedCompletionNodeToString = "<CompleteOnName:b>";
        String completionIdentifier = "b";
        String expectedReplacedSource = "b";
        String expectedUnitDisplayString = "package p;\npublic class G {\n  class Y {\n    Y() {\n    }\n    void foo(int b) {\n      return <CompleteOnName:b>;\n    }\n  }\n  public G() {\n  }\n  int bar() {\n  }\n}\n";
        int cursorLocation = str.indexOf("b }") + completeBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testGA() {
        String str = "package p; \npublic class GA {\n\tvoid foo(String s) {\n\t\tString string = s;\n\t}\n}\n";
        String testName = "<complete on local variable initializer>";
        String completeBehind = "s";
        String expectedCompletionNodeToString = "<CompleteOnName:s>";
        String completionIdentifier = "s";
        String expectedReplacedSource = "s";
        int cursorLocation = str.indexOf("s;") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class GA {\n  public GA() {\n  }\n  void foo(String s) {\n    String string = <CompleteOnName:s>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testGB_1FI74S3() {
        String str = "package p; \n/**\n * 1FI74S3\n */\npublic class GB {\n\tString[] table;\n\tvoid foo() {\n\t\tint x = table[1].}\n}\n";
        String testName = "<complete on method/field of array element>";
        String completeBehind = "table[1].";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:table[1].>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class GB {\n  String[] table;\n  public GB() {\n  }\n  void foo() {\n    int x = <CompleteOnMemberAccess:table[1].>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testGC_1FSHLHV_1() {
        String str = "package p; \n/**\n * 1FSHLHV\n */\npublic class GC {\npublic static void main(String[] args) {\n\tObject l = new Object() {\n\t\tpublic void handleEvent(String[] event) {\n\t\t\tString s = new String();\n\t\t\ts.\n\t\t\ttry {\n\t\t\t\tevent.;\n\t\t\t}\n\t\t\tcatch (Exception e) {\n\t\t\t\te.\n\t\t\t}\n\t\t}\n\t}\n}\n}\n";
        String testName = "<complete on anonymous declaration type>";
        String completeBehind = "O";
        String expectedCompletionNodeToString = "<CompleteOnType:O>";
        String completionIdentifier = "O";
        String expectedReplacedSource = "Object";
        int cursorLocation = str.indexOf("Object()") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class GC {\n  public GC() {\n  }\n  public static void main(String[] args) {\n    Object l = new <CompleteOnType:O>();\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testGC_1FSHLHV_2() {
        String str = "package p; \n/**\n * 1FSHLHV\n */\npublic class GC {\npublic static void main(String[] args) {\n\tObject l = new Object() {\n\t\tpublic void handleEvent(String[] event) {\n\t\t\tString s = new String();\n\t\t\ts.\n\t\t\ttry {\n\t\t\t\tevent.;\n\t\t\t}\n\t\t\tcatch (Exception e) {\n\t\t\t\te.\n\t\t\t}\n\t\t}\n\t}\n}\n}\n";
        String testName = "<complete on method/field of local variable into anonymous declaration>";
        String completeBehind = "s.";
        String expectedCompletionNodeToString = "<CompleteOnName:s.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "s.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class GC {\n  public GC() {\n  }\n  public static void main(String[] args) {\n    Object l;\n    new Object() {\n      () {\n      }\n      public void handleEvent(String[] event) {\n        String s;\n        <CompleteOnName:s.>;\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testGC_1FSHLHV_3() {
        String str = "package p; \n/**\n * 1FSHLHV\n */\npublic class GC {\npublic static void main(String[] args) {\n\tObject l = new Object() {\n\t\tpublic void handleEvent(String[] event) {\n\t\t\tString s = new String();\n\t\t\ts.\n\t\t\ttry {\n\t\t\t\tevent.;\n\t\t\t}\n\t\t\tcatch (Exception e) {\n\t\t\t\te.\n\t\t\t}\n\t\t}\n\t}\n}\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "event.";
        String expectedCompletionNodeToString = "<CompleteOnName:event.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "event.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class GC {\n  public GC() {\n  }\n  public static void main(String[] args) {\n    Object l;\n    new Object() {\n      () {\n      }\n      public void handleEvent(String[] event) {\n        String s;\n        {\n          <CompleteOnName:event.>;\n        }\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testGC_1FSHLHV_4() {
        String str = "package p; \n/**\n * 1FSHLHV\n */\npublic class GC {\npublic static void main(String[] args) {\n\tObject l = new Object() {\n\t\tpublic void handleEvent(String[] event) {\n\t\t\tString s = new String();\n\t\t\ts.\n\t\t\ttry {\n\t\t\t\tevent.;\n\t\t\t}\n\t\t\tcatch (Exception e) {\n\t\t\t\te.\n\t\t\t}\n\t\t}\n\t}\n}\n}\n";
        String testName = "<complete on method/field of thrown exception into catch block into anonymous declaration>";
        String completeBehind = "e.";
        String expectedCompletionNodeToString = "<CompleteOnName:e.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "e.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class GC {\n  public GC() {\n  }\n  public static void main(String[] args) {\n    Object l;\n    new Object() {\n      () {\n      }\n      public void handleEvent(String[] event) {\n        String s;\n        {\n          Exception e;\n          <CompleteOnName:e.>;\n        }\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testH0() {
        String str = "\tfunction foo() {\n\t\twhil \n\n";
        String testName = "<complete on while keyword argument>";
        String completeBehind = "whil";
        String expectedCompletionNodeToString = "<CompleteOnName:whil>";
        String completionIdentifier = "whil";
        String expectedReplacedSource = "whil";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "function foo() {\n  <CompleteOnName:whil>;\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testH() {
        String str = "\tfunction foo(bbbb) {\n\t\twhile (Xbm }\n\tfunction bar() {\n\t}\n}\n";
        String testName = "<complete on while keyword argument>";
        String completeBehind = "Xbm";
        String expectedCompletionNodeToString = "<CompleteOnName:Xbm>";
        String completionIdentifier = "Xbm";
        String expectedReplacedSource = "Xbm";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class H {\n  public H() {\n  }\n  function foo( bbbb) {\n    <CompleteOnName:Xbm>;\n  }\n  function bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testHA_1() {
        String str = "package p; \npublic class HA {\n\tvoid foo() {\n\t\tx.y.Z[] field1; \n\t\tfield1[1].}\n}\n";
        String testName = "<complete on package member type>";
        String completeBehind = "x.y.";
        String expectedCompletionNodeToString = "<CompleteOnName:x.y.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "x.y.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class HA {\n  public HA() {\n  }\n  void foo() {\n    <CompleteOnName:x.y.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testHA_2() {
        String str = "package p; \npublic class HA {\n\tvoid foo() {\n\t\tx.y.Z[] field1; \n\t\tfield1[1].}\n}\n";
        String testName = "<complete on method/field of array element>";
        String completeBehind = "field1[1].";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:field1[1].>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class HA {\n  public HA() {\n  }\n  void foo() {\n    x.y.Z[] field1;\n    <CompleteOnMemberAccess:field1[1].>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testHB_1FHSLDR() {
        String str = "package p; \n/**\n * 1FHSLDR\n */\npublic class HB {\n\tvoid foo() {\n\t\tfor (; i < totalUnits; i++) {\n\t\t\tunit = unitsToProcess[i];\n\t\t\ttry {\n\t\t\t\tif (options.verbose) {\n\t\t\t\t\tSystem.out.println(\n\t\t\t\t\t\t\"process \"\n\t\t\t\t\t\t\t+ (i + 1)\n\t\t\t\t\t\t\t+ \"/\"\n\t\t\t\t\t\t\t+ totalUnits\n\t\t\t\t\t\t\t+ \" : \"\n\t\t\t\t\t\t\t+ unitsToProcess[i]\n\t\t\t\t\t\t\t\t.sourceFileName()); \n\t\t\t\t}\n\t\t\t\tprocess(unit, i);\n\t\t\t}\n\t\t\tfi }\n\t}\n}\n";
        String testName = "<complete on finally keyword>";
        String completeBehind = "fi";
        String expectedCompletionNodeToString = "<CompleteOnKeyword:fi>";
        String completionIdentifier = "fi";
        String expectedReplacedSource = "fi";
        int cursorLocation = str.indexOf("fi }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class HB {\n  public HB() {\n  }\n  void foo() {\n    {\n      <CompleteOnKeyword:fi>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testHC_1FMPYO3_1() {
        String str = "package p; \n/**\n * 1FMPYO3\n */\nclass HC {\n\tHC(Object o){}\n\tvoid foo(){\n\t\tHC a = new HC(new Object()).\n\t}\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new HC(new Object()).";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new HC(new Object()).>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass HC {\n  HC(Object o) {\n  }\n  void foo() {\n    HC a = <CompleteOnMemberAccess:new HC(new Object()).>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testHC_1FMPYO3_2() {
        String str = "package p; \n/**\n * 1FMPYO3\n */\nclass HC {\n\tHC(Object o){}\n\tvoid foo(){\n\t\tA a = new A(new Object()).\n\t}\n}\n";
        String testName = "<complete on object of nested object creation declaration>";
        String completeBehind = "O";
        String expectedCompletionNodeToString = "<CompleteOnType:O>";
        String completionIdentifier = "O";
        String expectedReplacedSource = "Object";
        int cursorLocation = str.indexOf("Object()") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass HC {\n  HC(Object o) {\n  }\n  void foo() {\n    A a = new A(new <CompleteOnType:O>());\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testI() {
        String str = "package p; \npublic class I {\n\tComponent }\n";
        String testName = "<complete on incomplete field declaration type>";
        String completeBehind = "C";
        String expectedCompletionNodeToString = "<CompleteOnType:C>";
        String completionIdentifier = "C";
        String expectedReplacedSource = "Component";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class I {\n  <CompleteOnType:C>;\n  public I() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testIA_1FGNBPR_1() {
        String str = "package p; \n/**\n * 1FGNBPR\n */\npublic class IA {\n\tvoid foo1() {\n\t\tlabel1 : while (true) {\n\t\t\tclass A {\n\t\t\t\tvoid foo2() {\n\t\t\t\t\tlabel2 : while (true) {\n\t\t\t\t\t\tbreak la }\n\t\t\t\t}\n\t\t\t}\n\t\t\tA a = new A();\n\t\t\tbreak la }\n\t}\n}\n";
        String testName = "<complete on label name>";
        String completeBehind = "la";
        String expectedCompletionNodeToString = "break <CompleteOnLabel:la>;";
        String completionIdentifier = "la";
        String expectedReplacedSource = "la";
        int cursorLocation = str.indexOf("la }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class IA {\n  public IA() {\n  }\n  void foo1() {\n    {\n      class A {\n        A() {\n        }\n        void foo2() {\n          break <CompleteOnLabel:la>;\n        }\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testIA_1FGNBPR_2() {
        String str = "package p; \n/**\n * 1FGNBPR\n */\npublic class IA {\n\tvoid foo1() {\n\t\tlabel1 : while (true) {\n\t\t\tclass A {\n\t\t\t\tvoid foo2() {\n\t\t\t\t\tlabel2 : while (true) {\n\t\t\t\t\t\tbreak la }\n\t\t\t\t}\n\t\t\t}\n\t\t\tA a = new A();\n\t\t\tbreak la }\n\t}\n}\n";
        String testName = "<complete on label name>";
        String completeBehind = "la";
        String expectedCompletionNodeToString = "break <CompleteOnLabel:la>;";
        String completionIdentifier = "la";
        String expectedReplacedSource = "la";
        int cursorLocation = str.indexOf("la }", str.indexOf("la }") + 1) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class IA {\n  public IA() {\n  }\n  void foo1() {\n    {\n      class A {\n        A() {\n          super();\n        }\n        void foo2() {\n        }\n      }\n      A a;\n      break <CompleteOnLabel:la>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testIB() {
        String str = "package p; \npublic class IB {\n\tUnknownFieldTYPE field;\n\tvoid foo() {\n\t\tfield.}\n}\n";
        String testName = "<complete on method/field of field of unkown type>";
        String completeBehind = "field.";
        String expectedCompletionNodeToString = "<CompleteOnName:field.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "field.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class IB {\n  UnknownFieldTYPE field;\n  public IB() {\n  }\n  void foo() {\n    <CompleteOnName:field.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testIC_1FMGUPR() {
        String str = "package p; \n/**\n * 1FMGUPR\n */\npublic class IC {\n\tvoid foo(){\n\t\tnew String().toString().\n\t}\n}\n";
        String testName = "<complete on multiple method/field call>";
        String completeBehind = "new String().toString().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new String().toString().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class IC {\n  public IC() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new String().toString().>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testJ() {
        String str = "package p; \npublic class J {\n\tint foo1()[void foo2() int i;\n\tvoid foo3() {\n\t\tf }\n";
        String testName = "<complete on method/field access into corrupted method declaration>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf("f }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class J {\n  public J() {\n  }\n  int foo1() {\n  }\n  void foo2() {\n  }\n  void foo3() {\n    <CompleteOnName:f>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testJA_1FGQVW2_1() {
        String str = "package p; \n/**\n * 1FGQVW2\n */\npublic class JA {\n\tvoid foo() {\n\t\t\"abc.txt\". 'a'.}\n}\n";
        String testName = "<complete on string literal>";
        String completeBehind = "\"abc.txt\".";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:\"abc.txt\".>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class JA {\n  public JA() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:\"abc.txt\".>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testJA_1FGQVW2_2() {
        String str = "package p; \n/**\n * 1FGQVW2\n */\npublic class JA {\n\tvoid foo() {\n\t\t\"abc.txt\". 'a'.}\n}\n";
        String testName = "<complete on char literal>";
        String completeBehind = "'a'.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:'a'.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class JA {\n  public JA() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:'a'.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testJB() {
        String str = "package p; \npublic class JB\n\textends UnknownSUPERCLASS\n\timplements UnknownSUPERINTERFACE {\n\tvoid foo() {\n\t\tf }\n}\n";
        String testName = "<complete into method declared into corrupted class declaration>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf("f }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class JB extends UnknownSUPERCLASS implements UnknownSUPERINTERFACE {\n  public JB() {\n  }\n  void foo() {\n    <CompleteOnName:f>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testJC_1FLG1ZC() {
        String str = "package p; \n/**\n * 1FLG1ZC\n */\npublic class JC {\n\tvoid foo() {\n\t\tnew String ().\n\t}\n}\n";
        String testName = "<complete on method/field of object creation with dummy spaces>";
        String completeBehind = "new String ().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new String().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class JC {\n  public JC() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new String().>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testK_1() {
        String str = "package p; \nclass Other {\n\tvoid foo() {\n\t}\n}\npublic class K {\n\tpublic static void main(\n\t\tjava.lang.String[] args) {\n\t\tjava.io.File bbbb = \n\t\t\tnew File(\"c:\\abc.txt\"); \n\t\tO bb bbbb.}\n}\n";
        String testName = "<complete on corrupted local variable declaration>";
        String completeBehind = "\t\tO";
        String expectedCompletionNodeToString = "<CompleteOnName:O>";
        String completionIdentifier = "O";
        String expectedReplacedSource = "O";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass Other {\n  Other() {\n  }\n  void foo() {\n  }\n}\npublic class K {\n  public K() {\n  }\n  public static void main(java.lang.String[] args) {\n    java.io.File bbbb;\n    <CompleteOnName:O>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testK_2() {
        String str = "package p; \nclass Other {\n\tvoid foo() {\n\t}\n}\npublic class K {\n\tpublic static void main(\n\t\tjava.lang.String[] args) {\n\t\tjava.io.File bbbb = \n\t\t\tnew File(\"c:\\abc.txt\"); \n\t\tO bb bbbb.}\n}\n";
        String testName = "<complete on corrupted local variable declaration name>";
        String completeBehind = "bb";
        String expectedCompletionNodeToString = "<CompleteOnLocalName:O bb>;";
        String completionIdentifier = "bb";
        String expectedReplacedSource = "bb";
        int cursorLocation = str.indexOf("bb bbbb.") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass Other {\n  Other() {\n  }\n  void foo() {\n  }\n}\npublic class K {\n  public K() {\n  }\n  public static void main(java.lang.String[] args) {\n    java.io.File bbbb;\n    <CompleteOnLocalName:O bb>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testK_3() {
        String str = "package p; \nclass Other {\n\tvoid foo() {\n\t}\n}\npublic class K {\n\tpublic static void main(\n\t\tjava.lang.String[] args) {\n\t\tjava.io.File bbbb = \n\t\t\tnew File(\"c:\\abc.txt\"); \n\t\tO bb bbbb.}\n}\n";
        String testName = "<complete on corrupted local variable declaration>";
        String completeBehind = "bbbb";
        String expectedCompletionNodeToString = "<CompleteOnName:bbbb>";
        String completionIdentifier = "bbbb";
        String expectedReplacedSource = "bbbb";
        int cursorLocation = str.indexOf("bbbb.}") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass Other {\n  Other() {\n  }\n  void foo() {\n  }\n}\npublic class K {\n  public K() {\n  }\n  public static void main(java.lang.String[] args) {\n    java.io.File bbbb;\n    O bb;\n    <CompleteOnName:bbbb>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testK_4() {
        String str = "package p; \nclass Other {\n\tvoid foo() {\n\t}\n}\npublic class K {\n\tpublic static void main(\n\t\tjava.lang.String[] args) {\n\t\tjava.io.File bbbb = \n\t\t\tnew File(\"c:\\abc.txt\"); \n\t\tO bb bbbb.}\n}\n";
        String testName = "<complete on method/field of local variable with corrupted declaration>";
        String completeBehind = "bbbb.";
        String expectedCompletionNodeToString = "<CompleteOnName:bbbb.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "bbbb.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass Other {\n  Other() {\n  }\n  void foo() {\n  }\n}\npublic class K {\n  public K() {\n  }\n  public static void main(java.lang.String[] args) {\n    java.io.File bbbb;\n    O bb;\n    <CompleteOnName:bbbb.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testKA_1FH5SU5() {
        String str = "package p; \n/**\n * 1FH5SU5\n */\nclass KAHelper\n\textends java.util.Vector {\n}\npublic class KA {\n\tpublic int hashCode() {\n\t\treturn 10;\n\t}\n\tpublic static void main(String[] args) {\n\t\tKA a = new KA;\n\t\ta.has }\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "a.has";
        String expectedCompletionNodeToString = "<CompleteOnName:a.has>";
        String completionIdentifier = "has";
        String expectedReplacedSource = "a.has";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass KAHelper extends java.util.Vector {\n  KAHelper() {\n  }\n}\npublic class KA {\n  public KA() {\n  }\n  public int hashCode() {\n  }\n  public static void main(String[] args) {\n    KA a;\n    <CompleteOnName:a.has>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testKB() {
        String str = "package p; \npublic class KB {\n\tvoid foo()[i }\n}\n";
        String testName = "<complete on corrupted method header>";
        String completeBehind = "void foo()[i";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "i";
        String expectedReplacedSource = "i";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class KB {\n  public KB() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testKC_1FLG1ZC() {
        String str = "package p; \n/**\n * 1FLG1ZC\n */\nimport java.io.*;\npublic class KC {\nprivate static char[] read(String fileName){\n\ttry {\n\t\tFile file = new File(fileName);\n\t\tFileReader reader =\n\t\t\tnew FileReader(file);\n\t\tint length;\n\t\tchar[] contents =\n\t\t\tnew char[\n\t\t\t\tlength =\n\t\t\t\t(int) file.length()];\n\t\tint len = 0;\n\t\tint readSize = 0;\n\t\twhile ((readSize != -1)\n\t\t\t&& (len != length)) {\n\t\t\treadSize = reader.read(\n\t\t\t\tcontents,\n\t\t\t\tlen,\n\t\t\t\tlength - len);\n\t\t\tlen += readSize;\n\t\t}\n\t\treader. t\n";
        String testName = "<complete on method/field with dummy spaces>";
        String completeBehind = "reader. t";
        String expectedCompletionNodeToString = "<CompleteOnName:reader.t>";
        String completionIdentifier = "t";
        String expectedReplacedSource = "reader. t";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport java.io.*;\npublic class KC {\n  public KC() {\n  }\n  private static char[] read(String fileName) {\n    {\n      File file;\n      FileReader reader;\n      int length;\n      char[] contents;\n      int len;\n      int readSize;\n      <CompleteOnName:reader.t>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testL_1() {
        String str = "package p; \npublic class L {\n\tvoid foo() {\n\t\tx.y.Z[] field1, \n\t\t\tfield2; \n\t\tfield1.if (int[].class }\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "field1.";
        String expectedCompletionNodeToString = "<CompleteOnName:field1.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "field1.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class L {\n  public L() {\n  }\n  void foo() {\n    x.y.Z[] field1;\n    x.y.Z[] field2;\n    <CompleteOnName:field1.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testL_2() {
        String str = "package p; \npublic class L {\n\tvoid foo() {\n\t\tx.y.Z[] field1, \n\t\t\tfield2; \n\t\tfield1.if (int[].class }\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "int[].";
        String expectedCompletionNodeToString = "<CompleteOnClassLiteralAccess:int[].>";
        String completionIdentifier = "";
        String expectedReplacedSource = "int[].";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class L {\n  public L() {\n  }\n  void foo() {\n    x.y.Z[] field1;\n    x.y.Z[] field2;\n    <CompleteOnClassLiteralAccess:int[].>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testL_3() {
        String str = "package p; \npublic class L {\n\tvoid foo() {\n\t\tx.y.Z[] field1, \n\t\t\tfield2; \n\t\tfield1.if (int[].class }\n}\n";
        String testName = "<complete on argument of corrupted if statement>";
        String completeBehind = "int";
        String expectedCompletionNodeToString = "<CompleteOnName:int>";
        String completionIdentifier = "int";
        String expectedReplacedSource = "int";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class L {\n  public L() {\n  }\n  void foo() {\n    x.y.Z[] field1;\n    x.y.Z[] field2;\n    <CompleteOnName:int>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testLA_1FGLMOF() {
        String str = "package p; \n/**\n * 1FGLMOF\n */\npublic class LA {\n\tvoid[] foo() {\n\t}\n\tvoid bar() {\n\t\tf }\n}\n";
        String testName = "<complete on method/field with corrupted method header>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf("f }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class LA {\n  public LA() {\n  }\n  void[] foo() {\n  }\n  void bar() {\n    <CompleteOnName:f>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testLB() {
        String str = "package p; \npublic class LB {\n\tvoid foo() {\n\t}\n\tvoid foo() {\n\t}\n\tvoid bar() {\n\t\ti }\n}\n";
        String testName = "<complete on method/field with duplicate method declaration>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<CompleteOnName:i>";
        String completionIdentifier = "i";
        String expectedReplacedSource = "i";
        int cursorLocation = str.indexOf("i }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class LB {\n  public LB() {\n  }\n  void foo() {\n  }\n  void foo() {\n  }\n  void bar() {\n    <CompleteOnName:i>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testLC_1FLG1E2() {
        String str = "package p; \n/**\n * 1FLG1E2\n */\npublic class LC {\n\tvoid foo() {\n\t\tObject[] x = new Object[10];\n\t\tx [1].\n\t}\n}\n";
        String testName = "<complete on method/field of array element with dummy spaces>";
        String completeBehind = "x [1].";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:x[1].>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class LC {\n  public LC() {\n  }\n  void foo() {\n    Object[] x;\n    <CompleteOnMemberAccess:x[1].>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testM_1FGGLMT() {
        String str = "package p; \n/**\n * 1FGGLMT\n */\npublic class M {\n\tclass Member {\n\t\tvoid fooMember() {\n\t\t}\n\t}\n\tvoid foo() {\n\t\tnew Member().}\n}\nclass MemberOfCU {\n}\n";
        String testName = "<complete on method/field of explicit object creation>";
        String completeBehind = "new Member().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new Member().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class M {\n  class Member {\n    Member() {\n    }\n    void fooMember() {\n    }\n  }\n  public M() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new Member().>;\n  }\n}\nclass MemberOfCU {\n  MemberOfCU() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMA_1() {
        String str = "package p; \npublic class MA {\n\tclass Member\n\t\textends java.util.Vector {\n\t\tstatic void fooStaticMember() {\n\t\t}\n\t\tvoid fooMember() {\n\t\t}\n\t\tclass MemberMember {\n\t\t\tvoid fooMemberMember() {\n\t\t\t\tMemberOfCUMA m = \n\t\t\t\t\tnew MemberOfCUMA(); \n\t\t\t}\n\t\t}\n\t\tclass MemberMember2 {\n\t\t}\n\t}\n\tvoid foo() {\n\t\tMembe }\n\tvoid foobar() {\n\t\tnew Member().}\n\tclass Member2 {\n\t}\n}\nclass MemberOfCUMA {\n}\n";
        String testName = "<complete on local variable declaration type>";
        String completeBehind = "Membe";
        String expectedCompletionNodeToString = "<CompleteOnName:Membe>";
        String completionIdentifier = "Membe";
        String expectedReplacedSource = "Membe";
        int cursorLocation = str.indexOf("Membe }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class MA {\n  class Member extends java.util.Vector {\n    class MemberMember {\n      MemberMember() {\n      }\n      void fooMemberMember() {\n      }\n    }\n    class MemberMember2 {\n      MemberMember2() {\n      }\n    }\n    Member() {\n    }\n    static void fooStaticMember() {\n    }\n    void fooMember() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  public MA() {\n  }\n  void foo() {\n    <CompleteOnName:Membe>;\n  }\n  void foobar() {\n  }\n}\nclass MemberOfCUMA {\n  MemberOfCUMA() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMA_2() {
        String str = "package p; \npublic class MA {\n\tclass Member\n\t\textends java.util.Vector {\n\t\tstatic void fooStaticMember() {\n\t\t}\n\t\tvoid fooMember() {\n\t\t}\n\t\tclass MemberMember {\n\t\t\tvoid fooMemberMember() {\n\t\t\t\tMemberOfCUMA m = \n\t\t\t\t\tnew MemberOfCUMA(); \n\t\t\t}\n\t\t}\n\t\tclass MemberMember2 {\n\t\t}\n\t}\n\tvoid foo() {\n\t\tMembe }\n\tvoid foobar() {\n\t\tnew Member().}\n\tclass Member2 {\n\t}\n}\nclass MemberOfCUMA {\n}\n";
        String testName = "<complete on object creation type>";
        String completeBehind = "MemberOfCU";
        String expectedCompletionNodeToString = "<CompleteOnType:MemberOfCU>";
        String completionIdentifier = "MemberOfCU";
        String expectedReplacedSource = "MemberOfCUMA";
        int cursorLocation = str.indexOf("MemberOfCUMA();") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class MA {\n  class Member extends java.util.Vector {\n    class MemberMember {\n      MemberMember() {\n      }\n      void fooMemberMember() {\n        MemberOfCUMA m = new <CompleteOnType:MemberOfCU>();\n      }\n    }\n    class MemberMember2 {\n      MemberMember2() {\n      }\n    }\n    Member() {\n    }\n    static void fooStaticMember() {\n    }\n    void fooMember() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  public MA() {\n  }\n  void foo() {\n  }\n  void foobar() {\n  }\n}\nclass MemberOfCUMA {\n  MemberOfCUMA() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMA_3() {
        String str = "package p; \npublic class MA {\n\tclass Member\n\t\textends java.util.Vector {\n\t\tstatic void fooStaticMember() {\n\t\t}\n\t\tvoid fooMember() {\n\t\t}\n\t\tclass MemberMember {\n\t\t\tvoid fooMemberMember() {\n\t\t\t\tMemberOfCUMA m = \n\t\t\t\t\tnew MemberOfCUMA(); \n\t\t\t}\n\t\t}\n\t\tclass MemberMember2 {\n\t\t}\n\t}\n\tvoid foo() {\n\t\tMembe }\n\tvoid foobar() {\n\t\tnew Member().}\n\tclass Member2 {\n\t}\n}\nclass MemberOfCUMA {\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new Member().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new Member().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class MA {\n  class Member extends java.util.Vector {\n    class MemberMember {\n      MemberMember() {\n      }\n      void fooMemberMember() {\n      }\n    }\n    class MemberMember2 {\n      MemberMember2() {\n      }\n    }\n    Member() {\n    }\n    static void fooStaticMember() {\n    }\n    void fooMember() {\n    }\n  }\n  class Member2 {\n    Member2() {\n    }\n  }\n  public MA() {\n  }\n  void foo() {\n  }\n  void foobar() {\n    <CompleteOnMemberAccess:new Member().>;\n  }\n}\nclass MemberOfCUMA {\n  MemberOfCUMA() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMB_1FHSLMQ_1() {
        String str = "package p; \n/**\n * 1FHSLMQ\n */\npublic class MB {\n\tvoid foo() {\n\t\ttry {\n\t\t\tSystem.out.println(\"\");\n\t\t} catch (Exception eFirst) {\n\t\t\te } catch (Exception eSecond) {\n\t\t\te }\n\t}\n}\n";
        String testName = "<complete on local variable name into catch block>";
        String completeBehind = "e";
        String expectedCompletionNodeToString = "<CompleteOnName:e>";
        String completionIdentifier = "e";
        String expectedReplacedSource = "e";
        int cursorLocation = str.indexOf("e }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class MB {\n  public MB() {\n  }\n  void foo() {\n    {\n      Exception eFirst;\n      <CompleteOnName:e>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMB_1FHSLMQ_2() {
        String str = "package p; \n/**\n * 1FHSLMQ\n */\npublic class MB {\n\tvoid foo() {\n\t\ttry {\n\t\t\tSystem.out.println(\"\");\n\t\t} catch (Exeption eFirst) {\n\t\t\te } catch (Exception eSecond) {\n\t\t\te }\n\t}\n}\n";
        String testName = "<complete on local variable name into catch block>";
        String completeBehind = "e";
        String expectedCompletionNodeToString = "<CompleteOnName:e>";
        String completionIdentifier = "e";
        String expectedReplacedSource = "e";
        int cursorLocation = str.indexOf("e }\n") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class MB {\n  public MB() {\n  }\n  void foo() {\n    {\n      Exception eSecond;\n      <CompleteOnName:e>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testMC_1FJ8D9Z() {
        String str = "package p; \n/**\n * 1FJ8D9Z\n */\npublic class MC {\n\tp2.X someField;\n\tpublic void foo() {\n\t\tnew p2.X(\n\t}\n}\n";
        String testName = "<complete on object creation argument>";
        String completeBehind = "new p2.X(";
        String expectedCompletionNodeToString = "<CompleteOnAllocationExpression:new p2.X()>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class MC {\n  p2.X someField;\n  public MC() {\n  }\n  public void foo() {\n    <CompleteOnAllocationExpression:new p2.X()>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testN() {
        String str = "package p; \npublic class N extends p.M {\n\tvoid foo() {\n\t\tclass MLocal\n\t\t\textends Schmurz {\n\t\t\tvoid foo() {\n\t\t\t}\n\t\t\tint field1;\n\t\t\tclass MLocalMember\n\t\t\t\textends myInnerC {\n\t\t\t\tvoid foo() {\n\t\t\t\t}\n\t\t\t\tvoid bar() {\n\t\t\t\t\tnew M }\n\t\t\t}\n\t\t\tclass MLocalMember2 {\n\t\t\t\tvoid fooMyInnerC() {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n";
        String testName = "<complete on object creation type>";
        String completeBehind = "new M";
        String expectedCompletionNodeToString = "<CompleteOnType:M>";
        String completionIdentifier = "M";
        String expectedReplacedSource = "M";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class N extends p.M {\n  public N() {\n  }\n  void foo() {\n    class MLocal extends Schmurz {\n      class MLocalMember extends myInnerC {\n        MLocalMember() {\n        }\n        void foo() {\n        }\n        void bar() {\n          new <CompleteOnType:M>();\n        }\n      }\n      class MLocalMember2 {\n        MLocalMember2() {\n        }\n        void fooMyInnerC() {\n        }\n      }\n      int field1;\n      MLocal() {\n      }\n      void foo() {\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testNA_1() {
        String str = "package p; \nclass NException2\n\textends NoClassDefFoundError {\n}\ninterface NInterface {\n\tvoid foo();\n}\nclass DAB {\n\tpublic DA foo() {\n\t}\n\tpublic int foufou;\n}\nclass DANA {\n\tpublic int f;\n\tN fieldC;\n}\npublic class NA\n\textends NException2\n\timplements N {\n\tDA fieldB;\n\tclass freak {\n\t}\n\tvoid dede() {\n\t\tDA local;\n\t\tlocal.fieldC.foo();\n\t}\n}\ninterface NCool {\n}\n";
        String testName = "<complete on local variable name>";
        String completeBehind = "l";
        String expectedCompletionNodeToString = "<CompleteOnName:l>";
        String completionIdentifier = "l";
        String expectedReplacedSource = "local";
        int cursorLocation = str.indexOf("local.") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass NException2 extends NoClassDefFoundError {\n  NException2() {\n  }\n}\ninterface NInterface {\n  void foo();\n}\nclass DAB {\n  public int foufou;\n  DAB() {\n  }\n  public DA foo() {\n  }\n}\nclass DANA {\n  public int f;\n  N fieldC;\n  DANA() {\n  }\n}\npublic class NA extends NException2 implements N {\n  class freak {\n    freak() {\n    }\n  }\n  DA fieldB;\n  public NA() {\n  }\n  void dede() {\n    DA local;\n    <CompleteOnName:l>;\n  }\n}\ninterface NCool {\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testNA_2() {
        String str = "package p; \nclass NException2\n\textends NoClassDefFoundError {\n}\ninterface NInterface {\n\tvoid foo();\n}\nclass DAB {\n\tpublic DA foo() {\n\t}\n\tpublic int foufou;\n}\nclass DANA {\n\tpublic int f;\n\tN fieldC;\n}\npublic class NA\n\textends NException2\n\timplements N {\n\tDA fieldB;\n\tclass freak {\n\t}\n\tvoid dede() {\n\t\tDA local;\n\t\tlocal.fieldC.foo();\n\t}\n}\ninterface NCool {\n}\n";
        String testName = "<complete on method/field of local variable>";
        String completeBehind = "local.f";
        String expectedCompletionNodeToString = "<CompleteOnName:local.f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "local.fieldC";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass NException2 extends NoClassDefFoundError {\n  NException2() {\n  }\n}\ninterface NInterface {\n  void foo();\n}\nclass DAB {\n  public int foufou;\n  DAB() {\n  }\n  public DA foo() {\n  }\n}\nclass DANA {\n  public int f;\n  N fieldC;\n  DANA() {\n  }\n}\npublic class NA extends NException2 implements N {\n  class freak {\n    freak() {\n    }\n  }\n  DA fieldB;\n  public NA() {\n  }\n  void dede() {\n    DA local;\n    <CompleteOnName:local.f>;\n  }\n}\ninterface NCool {\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testNA_3() {
        String str = "package p; \nclass NException2\n\textends NoClassDefFoundError {\n}\ninterface NInterface {\n\tvoid foo();\n}\nclass DAB {\n\tpublic DA foo() {\n\t}\n\tpublic int foufou;\n}\nclass DANA {\n\tpublic int f;\n\tN fieldC;\n}\npublic class NA\n\textends NException2\n\timplements N {\n\tDA fieldB;\n\tclass freak {\n\t}\n\tvoid dede() {\n\t\tDA local;\n\t\tlocal.fieldC.foo();\n\t}\n}\ninterface NCool {\n}\n";
        String testName = "<complete on method/field of local variable>";
        String completeBehind = "local.fieldC.";
        String expectedCompletionNodeToString = "<CompleteOnName:local.fieldC.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "local.fieldC.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass NException2 extends NoClassDefFoundError {\n  NException2() {\n  }\n}\ninterface NInterface {\n  void foo();\n}\nclass DAB {\n  public int foufou;\n  DAB() {\n  }\n  public DA foo() {\n  }\n}\nclass DANA {\n  public int f;\n  N fieldC;\n  DANA() {\n  }\n}\npublic class NA extends NException2 implements N {\n  class freak {\n    freak() {\n    }\n  }\n  DA fieldB;\n  public NA() {\n  }\n  void dede() {\n    DA local;\n    <CompleteOnName:local.fieldC.>;\n  }\n}\ninterface NCool {\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testNB() {
        String str = "package p; \npublic class NB {\n\tvoid foo() {\n\t\tint iOutside;\n\t\tif (i != 0) {\n\t\t\tfor (int i = 10; --i >= 0;)\n\t\t\t\tunit[i].parseMethod(\n\t\t\t\t\tparser, \n\t\t\t\t\tunit); \n\t\t}\n\t}\n}\n";
        String testName = "<complete on variable name into for statement>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<CompleteOnName:i>";
        String completionIdentifier = "i";
        String expectedReplacedSource = "i";
        int cursorLocation = str.indexOf("i >=") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class NB {\n  public NB() {\n  }\n  void foo() {\n    int iOutside;\n    {\n      int i;\n      -- <CompleteOnName:i>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testNC_1FJ8D9Z() {
        String str = "package p; \n/**\n * 1FJ8D9Z\n */\npublic class NC {\n\tString s = new String(\n";
        String testName = "<complete on field intializer into corrupted class declaration>";
        String completeBehind = "new String(";
        String expectedCompletionNodeToString = "<CompleteOnAllocationExpression:new String()>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class NC {\n  String s = <CompleteOnAllocationExpression:new String()>;\n  public NC() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testO_1FG1YU0() {
        String str = "package p; \n/**\n * 1FG1YU0\n */\npublic class O\n\textends java.util.Vector {\n\tvoid bar(boolean bbbb) {\n\t\tthis.}\n}\n";
        String testName = "<complete on method/field of explicit this>";
        String completeBehind = "this.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "this.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class O extends java.util.Vector {\n  public O() {\n  }\n  void bar(boolean bbbb) {\n    <CompleteOnMemberAccess:this.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testOA_1() {
        String str = "package p; \npublic class OA {\n\tvoid proc() {\n\t\tint[] a = new int[10];\n\t\tObject b = a;\n\t\tClass c = a.getClass();\n\t\tString s = a.toString();\n\t\tboolean l = a.equals(b);\n\t\tint h = a.hashCode();\n\t\ttry {\n\t\t\ta.wait();\n\t\t\ta.wait(3);\n\t\t\ta.wait(4, 5);\n\t\t} catch (Exception e) {\n\t\t}\n\t\ta.notify();\n\t\ta.notifyAll();\n\t}\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "a.n";
        String expectedCompletionNodeToString = "<CompleteOnName:a.n>";
        String completionIdentifier = "n";
        String expectedReplacedSource = "a.notify";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class OA {\n  public OA() {\n  }\n  void proc() {\n    int[] a;\n    Object b;\n    Class c;\n    String s;\n    boolean l;\n    int h;\n    <CompleteOnName:a.n>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testOA_2() {
        String str = "package p; \npublic class OA {\n\tvoid proc() {\n\t\tint[] a = new int[10];\n\t\tObject b = a;\n\t\tClass c = a.getClass();\n\t\tString s = a.toString();\n\t\tboolean l = a.equals(b);\n\t\tint h = a.hashCode();\n\t\ttry {\n\t\t\ta.wait();\n\t\t\ta.wait(3);\n\t\t\ta.wait(4, 5);\n\t\t} catch (Exception e) {\n\t\t}\n\t\ta.notify();\n\t\ta.notifyAll();\n\t}\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "a.w";
        String expectedCompletionNodeToString = "<CompleteOnName:a.w>";
        String completionIdentifier = "w";
        String expectedReplacedSource = "a.wait";
        int cursorLocation = str.indexOf("a.wait(4, 5)") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class OA {\n  public OA() {\n  }\n  void proc() {\n    int[] a;\n    Object b;\n    Class c;\n    String s;\n    boolean l;\n    int h;\n    {\n      <CompleteOnName:a.w>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testOB_1() {
        String str = "package p; \npublic class OB {\n\tvoid foo() {\n\t\tlabel : while (true) {\n\t\t\tSystem.out.println(\"\");\n\t\t\tbreak label;\n\t\t}\n\t}\n}\n";
        String testName = "<complete on keyword>";
        String completeBehind = "b";
        String expectedCompletionNodeToString = "<CompleteOnName:b>";
        String completionIdentifier = "b";
        String expectedReplacedSource = "break";
        int cursorLocation = str.indexOf("break") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class OB {\n  public OB() {\n  }\n  void foo() {\n    {\n      <CompleteOnName:b>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testOB_2() {
        String str = "package p; \npublic class OB {\n\tvoid foo() {\n\t\tlabel : while (true) {\n\t\t\tSystem.out.println(\"\");\n\t\t\tbreak label;\n\t\t}\n\t}\n}\n";
        String testName = "<complete on label name>";
        String completeBehind = "l";
        String expectedCompletionNodeToString = "<CompleteOnName:l>";
        String completionIdentifier = "l";
        String expectedReplacedSource = "label";
        int cursorLocation = str.indexOf("label") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class OB {\n  public OB() {\n  }\n  void foo() {\n    <CompleteOnName:l>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testOC_1FM7J7F() {
        String str = "package p; \n/**\n * 1FM7J7F\n */\nclass OC {\n\tString s = new String(\n}\n";
        String testName = "<complete on field initializer>";
        String completeBehind = "new String(";
        String expectedCompletionNodeToString = "<CompleteOnAllocationExpression:new String()>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass OC {\n  String s = <CompleteOnAllocationExpression:new String()>;\n  OC() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testP_1FG1YU0() {
        String str = "package p; \n/**\n * 1FG1YU0\n */\npublic class P {\n\t{\n\t\tvoid bar() {\n\t\t\tf }\n\t\tvoid foo() {\n\t\t}\n\t}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf("f }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class P {\n  {\n  }\n  public P() {\n  }\n  void bar() {\n    <CompleteOnName:f>;\n  }\n  void foo() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testPA_1() {
        String str = "package p; \nclass PAHelper {\n\tpublic int fieldPublic;\n\tprotected int fieldProtected;\n\tprivate int fieldPrivate;\n\tint fieldDefault;\n\tstatic void staticFoo() {\n\t}\n\tstatic int i = 1;\n\tint neuneu1() {\n\t\treturn 0;\n\t}\n\tvoid neuneu2() {\n\t}\n}\npublic class PA\n\textends PAHelper {\n\tvoid foo() {\n\t\tB[] b = \n\t\t\tnew java.lang.Number[]; \n\t\tjava.lang.Short s;\n\t\t// b[1].;\n\t}\n}\n";
        String testName = "<complete on comment>";
        String completeBehind = "b[1].";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "<NONE>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = null;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Comment");
        }
    }

    public void testPA_2() {
        String str = "package p; \nclass PAHelper {\n\tpublic int fieldPublic;\n\tprotected int fieldProtected;\n\tprivate int fieldPrivate;\n\tint fieldDefault;\n\tstatic void staticFoo() {\n\t}\n\tstatic int i = 1;\n\tint neuneu1() {\n\t\treturn 0;\n\t}\n\tvoid neuneu2() {\n\t}\n}\npublic class PA\n\textends PAHelper {\n\tvoid foo() {\n\t\tB[] b = \n\t\t\tnew java.lang.Number[]; \n\t\tjava.lang.Short s;\n\t\t// b[1].;\n\t}\n}\n";
        String testName = "<complete on new keyword>";
        String completeBehind = "n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedReplacedSource = "new";
        int cursorLocation = str.indexOf("new ") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass PAHelper {\n  public int fieldPublic;\n  protected int fieldProtected;\n  private int fieldPrivate;\n  int fieldDefault;\n  static int i;\n  <clinit>() {\n  }\n  PAHelper() {\n  }\n  static void staticFoo() {\n  }\n  int neuneu1() {\n  }\n  void neuneu2() {\n  }\n}\npublic class PA extends PAHelper {\n  public PA() {\n  }\n  void foo() {\n    B[] b = <CompleteOnName:n>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testPB() {
        String str = "package p; \npublic class PB {\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tvoid foo() {\n\t\t\t}\n\t\t\tclass LocalMember1 {\n\t\t\t\tvoid foo() {\n\t\t\t\t\tclass LocalMemberLocal {\n\t\t\t\t\t\tvoid foo() {\n\t\t\t\t\t\t\tf\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tclass LocalMember2 {\n\t\t\t\tvoid foo() {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n";
        String testName = "<complete on method/field into nested local type>";
        String completeBehind = "f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf("f\n") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class PB {\n  public PB() {\n  }\n  void foo() {\n    class Local {\n      class LocalMember1 {\n        LocalMember1() {\n        }\n        void foo() {\n          class LocalMemberLocal {\n            LocalMemberLocal() {\n            }\n            void foo() {\n              <CompleteOnName:f>;\n            }\n          }\n        }\n      }\n      class LocalMember2 {\n        LocalMember2() {\n        }\n        void foo() {\n        }\n      }\n      Local() {\n      }\n      void foo() {\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testPC_1FSU4EF() {
        String str = "package p; \n/**\n * 1FSU4EF\n */\nimport java.util.Vector;\npublic class PC {\n\tvoid foo() {\n\t\tclass Inner {\n\t\t\tVector v = new Vector();\n\t\t\tvoid foo() {\n\t\t\t\tVector v = new Vector();\n\t\t\t\tv.addElement();\n\t\t\t}\n\t\t}\n\t}\n}\n";
        String testName = "<complete on method/field into local type>";
        String completeBehind = "v.a";
        String expectedCompletionNodeToString = "<CompleteOnName:v.a>";
        String completionIdentifier = "a";
        String expectedReplacedSource = "v.addElement";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport java.util.Vector;\npublic class PC {\n  public PC() {\n  }\n  void foo() {\n    class Inner {\n      Vector v;\n      Inner() {\n      }\n      void foo() {\n        Vector v;\n        <CompleteOnName:v.a>;\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testQ_1FG1YU0() {
        String str = "package p; \n/**\n * 1FG1YU0\n */\npublic class Q {\n\tvoid bar(boolean bbbb) {\n\t\tthis.}\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "this.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "this.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class Q {\n  public Q() {\n  }\n  void bar(boolean bbbb) {\n    <CompleteOnMemberAccess:this.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testQA_1() {
        String str = "package p; \nclass QAHelper {\n\tint i = 10;\n\tvoid f() {\n\t\tChk.chkIntVal(\n\t\t\t\"err_0\", \n\t\t\t\"i\", \n\t\t\tthis.i, \n\t\t\ti); \n\t}\n\tstatic class Y\n\t\textends QAHelper {\n\t\tpublic void f() {\n\t\t\tsuper.f();\n\t\t\tint j = super.i;\n\t\t}\n\t\tpublic static void main(String a[]) {\n\t\t\tY oy = new Y();\n\t\t\toy.f();\n\t\t}\n\t}\n}\npublic class QA {\n\tstatic String s[] = \n\t\t{\"Dolby\", \"Thx\",}; \n\tvoid check() {\n\t\tnew QAHelper().new Y().main(\n\t\t\ts); \n\t}\n\tstatic public void main(String args[]) {\n\t\tnew QA().check();\n\t\tChk.endTest(\"ciner111\");\n\t}\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "new QAHelper().new Y().m";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new QAHelper().new Y().m>";
        String completionIdentifier = "m";
        String expectedReplacedSource = "main";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass QAHelper {\n  static class Y extends QAHelper {\n    Y() {\n    }\n    public void f() {\n    }\n    public static void main(String[] a) {\n    }\n  }\n  int i;\n  QAHelper() {\n  }\n  void f() {\n  }\n}\npublic class QA {\n  static String[] s;\n  <clinit>() {\n  }\n  public QA() {\n  }\n  void check() {\n    <CompleteOnMemberAccess:new QAHelper().new Y().m>;\n  }\n  public static void main(String[] args) {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testQA_2() {
        String str = "package p; \nclass QAHelper {\n\tint i = 10;\n\tvoid f() {\n\t\tChk.chkIntVal(\n\t\t\t\"err_0\", \n\t\t\t\"i\", \n\t\t\tthis.i, \n\t\t\ti); \n\t}\n\tstatic class Y\n\t\textends QAHelper {\n\t\tpublic void f() {\n\t\t\tsuper.f();\n\t\t\tint j = super.i;\n\t\t}\n\t\tpublic static void main(String a[]) {\n\t\t\tY oy = new Y();\n\t\t\toy.f();\n\t\t}\n\t}\n}\npublic class QA {\n\tstatic String s[] = \n\t\t{\"Dolby\", \"Thx\",}; \n\tvoid check() {\n\t\tnew QAHelper().new Y().main(\n\t\t\ts); \n\t}\n\tstatic public void main(String args[]) {\n\t\tnew QA().check();\n\t\tChk.endTest(\"ciner111\");\n\t}\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new QAHelper().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new QAHelper().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass QAHelper {\n  static class Y extends QAHelper {\n    Y() {\n    }\n    public void f() {\n    }\n    public static void main(String[] a) {\n    }\n  }\n  int i;\n  QAHelper() {\n  }\n  void f() {\n  }\n}\npublic class QA {\n  static String[] s;\n  <clinit>() {\n  }\n  public QA() {\n  }\n  void check() {\n    <CompleteOnMemberAccess:new QAHelper().>;\n  }\n  public static void main(String[] args) {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testQA_3() {
        String str = "package p; \nclass QAHelper {\n\tint i = 10;\n\tvoid f() {\n\t\tChk.chkIntVal(\n\t\t\t\"err_0\", \n\t\t\t\"i\", \n\t\t\tthis.i, \n\t\t\ti); \n\t}\n\tstatic class Y\n\t\textends QAHelper {\n\t\tpublic void f() {\n\t\t\tsuper.f();\n\t\t\tint j = super.i;\n\t\t}\n\t\tpublic static void main(String a[]) {\n\t\t\tY oy = new Y();\n\t\t\toy.f();\n\t\t}\n\t}\n}\npublic class QA {\n\tstatic String s[] = \n\t\t{\"Dolby\", \"Thx\",}; \n\tvoid check() {\n\t\tnew QAHelper().new Y().main(\n\t\t\ts); \n\t}\n\tstatic public void main(String args[]) {\n\t\tnew QA().check();\n\t\tChk.endTest(\"ciner111\");\n\t}\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new QAHelper().new Y().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new QAHelper().new Y().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass QAHelper {\n  static class Y extends QAHelper {\n    Y() {\n    }\n    public void f() {\n    }\n    public static void main(String[] a) {\n    }\n  }\n  int i;\n  QAHelper() {\n  }\n  void f() {\n  }\n}\npublic class QA {\n  static String[] s;\n  <clinit>() {\n  }\n  public QA() {\n  }\n  void check() {\n    <CompleteOnMemberAccess:new QAHelper().new Y().>;\n  }\n  public static void main(String[] args) {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testQA_4() {
        String str = "package p; \nclass QAHelper {\n\tint i = 10;\n\tvoid f() {\n\t\tChk.chkIntVal(\n\t\t\t\"err_0\", \n\t\t\t\"i\", \n\t\t\tthis.i, \n\t\t\ti); \n\t}\n\tstatic class Y\n\t\textends QAHelper {\n\t\tpublic void f() {\n\t\t\tsuper.f();\n\t\t\tint j = super.i;\n\t\t}\n\t\tpublic static void main(String a[]) {\n\t\t\tY oy = new Y();\n\t\t\toy.f();\n\t\t}\n\t}\n}\npublic class QA {\n\tstatic String s[] = \n\t\t{\"Dolby\", \"Thx\",}; \n\tvoid check() {\n\t\tnew QAHelper().new Y().main(\n\t\t\ts); \n\t}\n\tstatic public void main(String args[]) {\n\t\tnew QA().check();\n\t\tChk.endTest(\"ciner111\");\n\t}\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new QA().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new QA().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass QAHelper {\n  static class Y extends QAHelper {\n    Y() {\n    }\n    public void f() {\n    }\n    public static void main(String[] a) {\n    }\n  }\n  int i;\n  QAHelper() {\n  }\n  void f() {\n  }\n}\npublic class QA {\n  static String[] s;\n  <clinit>() {\n  }\n  public QA() {\n  }\n  void check() {\n  }\n  public static void main(String[] args) {\n    <CompleteOnMemberAccess:new QA().>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testQB_1FIK820() {
        String str = "package p; \n/**\n * 1FIK820\n */\npublic class QB {\n\tvoid foo() {\n\t\t{\n\t\t}\n\t\t.}\n}\n";
        String testName = "<complete on block (no answers wanted)>";
        String completeBehind = ".";
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(".}") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class QB {\n  public QB() {\n  }\n  void foo() {\n    <CompleteOnName:>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testR_1FGD31E() {
        String str = "package p; \n/**\n * 1FGD31E\n */\npublic class R {\n\tvoid moo() {\n\t\tb }\n\tvoid bar() {\n\t}\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "b";
        String expectedCompletionNodeToString = "<CompleteOnName:b>";
        String completionIdentifier = "b";
        String expectedReplacedSource = "b";
        int cursorLocation = str.indexOf("b }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class R {\n  public R() {\n  }\n  void moo() {\n    <CompleteOnName:b>;\n  }\n  void bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testRA_1() {
        String str = "package p; \npublic class RA extends A {\n\tprivate int f = 5;\n\tint i(int k) {\n\t}\n\tclass B extends I {\n\t\tvoid foo();\n\t\tclass C extends Z {\n\t\t}\n\t\tfinal int fo;\n\t}\n\tfinal void foo(k j) {\n\t}\n\to o() throws Exc, Exc {\n\t}\n\tstatic {\n\t\tthis.ff = 5;\n\t}\n}\n";
        String testName = "<complete on incorrect this call>";
        String completeBehind = "t";
        String expectedCompletionNodeToString = "<CompleteOnName:t>";
        String completionIdentifier = "t";
        String expectedReplacedSource = "this";
        int cursorLocation = str.indexOf("this.ff") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class RA extends A {\n  class B extends I {\n    class C extends Z {\n      C() {\n      }\n    }\n    final int fo;\n    B() {\n    }\n    void foo();\n  }\n  private int f;\n  static {\n    <CompleteOnName:t>;\n  }\n  <clinit>() {\n  }\n  public RA() {\n  }\n  int i(int k) {\n  }\n  final void foo(k j) {\n  }\n  o o() throws Exc, Exc {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testRA_2() {
        String str = "package p; \npublic class RA extends A {\n\tprivate int f = 5;\n\tint i(int k) {\n\t}\n\tclass B extends I {\n\t\tvoid foo();\n\t\tclass C extends Z {\n\t\t}\n\t\tfinal int fo;\n\t}\n\tfinal void foo(k j) {\n\t}\n\to o() throws Exc, Exc {\n\t}\n\tstatic {\n\t\tthis.ff = 5;\n\t}\n}\n";
        String testName = "<complete on t>";
        String completeBehind = "t";
        String expectedCompletionNodeToString = "<CompleteOnName:t>";
        String completionIdentifier = "t";
        String expectedReplacedSource = "this";
        int cursorLocation = str.indexOf("this") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class RA extends A {\n  class B extends I {\n    class C extends Z {\n      C() {\n      }\n    }\n    final int fo;\n    B() {\n    }\n    void foo();\n  }\n  private int f;\n  static {\n    <CompleteOnName:t>;\n  }\n  <clinit>() {\n  }\n  public RA() {\n  }\n  int i(int k) {\n  }\n  final void foo(k j) {\n  }\n  o o() throws Exc, Exc {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testRA_3() {
        String str = "package p; \npublic class RA extends A {\n\tprivate int f = 5;\n\tint i(int k) {\n\t}\n\tclass B extends I {\n\t\tvoid foo();\n\t\tclass C extends Z {\n\t\t}\n\t\tfinal int fo;\n\t}\n\tfinal void foo(k j) {\n\t}\n\to o() throws Exc, Exc {\n\t}\n\tstatic {\n\t\tthis.ff = 5;\n\t}\n}\n";
        String testName = "<complete on exception type>";
        String completeBehind = "Exc";
        String expectedCompletionNodeToString = "<CompleteOnException:Exc>";
        String completionIdentifier = "Exc";
        String expectedReplacedSource = "Exc";
        int cursorLocation = str.indexOf("Exc {") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class RA extends A {\n  class B extends I {\n    class C extends Z {\n      C() {\n      }\n    }\n    final int fo;\n    B() {\n    }\n    void foo();\n  }\n  private int f;\n  static {\n  }\n  <clinit>() {\n  }\n  public RA() {\n  }\n  int i(int k) {\n  }\n  final void foo(k j) {\n  }\n  o o() throws Exc, <CompleteOnException:Exc> {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testRB_1FI74S3() {
        String str = "package p; \n/**\n * 1FI74S3\n */\npublic class RB {\n\tint[] table;\n\tvoid foo() {\n\t\tint x = table.}\n}\n";
        String testName = "<complete on method/field of arry>";
        String completeBehind = "table.";
        String expectedCompletionNodeToString = "<CompleteOnName:table.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "table.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class RB {\n  int[] table;\n  public RB() {\n  }\n  void foo() {\n    int x = <CompleteOnName:table.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testS_1FGF64P_1() {
        String str = "package p; \n/**\n * 1FGF64P\n */\npublic class S {\n\t{\n\t\tnew Y()..}\n\tclass Y {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on incorrect call>";
        String completeBehind = "new Y()..";
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class S {\n  class Y {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n    {\n      <CompleteOnName:>;\n    }\n  }\n  public S() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testS_1FGF64P_2() {
        String str = "package p; \n/**\n * 1FGF64P\n */\npublic class S {\n\t{\n\t\tnew Y()..}\n\tclass Y {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new Y().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new Y().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class S {\n  class Y {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n    <CompleteOnMemberAccess:new Y().>;\n  }\n  public S() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testS_1FGF64P_3() {
        String str = "package p; \n/**\n * 1FGF64P\n */\npublic class S {\n\t{\n\t\tnew Y()..}\n\tclass Y {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on incorrect call>";
        String completeBehind = "new Y()..";
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class S {\n  class Y {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n    {\n      <CompleteOnName:>;\n    }\n  }\n  public S() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testSA() {
        String str = "package p; \npublic class SA {\n\tpublic sy void foo() {\n\t}\n}\n";
        String testName = "<complete on method modifier>";
        String completeBehind = "sy";
        String expectedCompletionNodeToString = "<CompleteOnType:sy>";
        String completionIdentifier = "sy";
        String expectedReplacedSource = "sy";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class SA {\n  <CompleteOnType:sy>;\n  public SA() {\n  }\n  void foo() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testSB_1FILFDG() {
        String str = "package p; \n/**\n * 1FILFDG\n */\npublic class SB {\n\tpublic void foo() {\n\t\tString s = \"hello\n\t\tint}\n}\n";
        String testName = "<complete on field declaration type>";
        String completeBehind = "int";
        String expectedCompletionNodeToString = "<CompleteOnName:int>";
        String completionIdentifier = "int";
        String expectedReplacedSource = "int";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class SB {\n  public SB() {\n  }\n  public void foo() {\n    String s;\n    <CompleteOnName:int>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testT_1FGF64P() {
        String str = "package p; \n/**\n * 1FGF64P\n */\npublic class T {\n\t{\n\t\tnew Y().}\n\tclass Y {\n\t\tvoid foo() {\n\t\t}\n\t}\n}\n";
        String testName = "<complete on object creation>";
        String completeBehind = "new Y().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new Y().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class T {\n  class Y {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  {\n    <CompleteOnMemberAccess:new Y().>;\n  }\n  public T() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testTA_1FHISJJ_1() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class TA {\n\tvoid foo() {\n\t\tObject[] items = \n\t\t\t{\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.;\n\t\titems.}\n}\n";
        String testName = "<complete on array intializer value>";
        String completeBehind = "n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedReplacedSource = "null";
        int cursorLocation = str.indexOf("null, ") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class TA {\n  public TA() {\n  }\n  void foo() {\n    Object[] items = {<CompleteOnName:n>};\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testTA_1FHISJJ_2() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class TA {\n\tvoid foo() {\n\t\tObject[] items = \n\t\t\t{\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.;\n\t\titems.}\n}\n";
        String testName = "<complete on method/field of array intializer>";
        String completeBehind = "\t\t\t{\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.";
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class TA {\n  public TA() {\n  }\n  void foo() {\n    Object[] items;\n    <CompleteOnName:>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testTA_1FHISJJ_3() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class TA {\n\tvoid foo() {\n\t\tObject[] items = \n\t\t\t{\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.;\n\t\titems.}\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "items.";
        String expectedCompletionNodeToString = "<CompleteOnName:items.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "items.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class TA {\n  public TA() {\n  }\n  void foo() {\n    Object[] items;\n    <CompleteOnName:items.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testTB_1FHSLMQ() {
        String str = "package p; \n/**\n * 1FHSLMQ\n */\npublic class TB {\n\tvoid foo() {\n\t\tif (true)\n\t\t\tSystem.out.println(\"\");\n\t\te }\n}\n";
        String testName = "<complete on else keyword>";
        String completeBehind = "e";
        String expectedCompletionNodeToString = "<CompleteOnName:e>";
        String completionIdentifier = "e";
        String expectedReplacedSource = "e";
        int cursorLocation = str.indexOf("e }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class TB {\n  public TB() {\n  }\n  void foo() {\n    <CompleteOnName:e>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testU_1FGGUME() {
        String str = "package p; \n/**\n * 1FGGUME\n */\npublic class U {\n\tpublic static final int Source = \n\t\t5; \n}\n";
        String testName = "<complete on digit>";
        String completeBehind = "5";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "<NONE>";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = null;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Number");
        }
    }

    public void testUA_1FHISJJ_1() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class UA {\n\tvoid foo() {\n\t\tObject[] items = \n\t\t\tnew String[] {\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.;\n\t\titems.}\n}\n";
        String testName = "<complete on array initializer>";
        String completeBehind = "new String[] {\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new String[]{\"Mark unublishable\", null, \"Properties...\"}.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class UA {\n  public UA() {\n  }\n  void foo() {\n    Object[] items = <CompleteOnMemberAccess:new String[]{\"Mark unublishable\", null, \"Properties...\"}.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testUA_1FHISJJ_2() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class UA {\n\tvoid foo() {\n\t\tObject[] items = \n\t\t\tnew String[] {\n\t\t\t\t\"Mark unublishable\", \n\t\t\t\tnull, \n\t\t\t\t\"Properties...\"}\n\t\t.;\n\t\titems.}\n}\n";
        String testName = "<complete on method/field of array>";
        String completeBehind = "items.";
        String expectedCompletionNodeToString = "<CompleteOnName:items.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "items.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class UA {\n  public UA() {\n  }\n  void foo() {\n    Object[] items;\n    <CompleteOnName:items.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testUB_1FSBZ02() {
        String str = "package p; \n/**\n * 1FSBZ02\n */\nclass UB {\n\tvoid bar() {\n\t}\n\tclass UBMember {\n\t\tvoid bar2() {\n\t\t}\n\t\tvoid foo() {\n\t\t\tb\n\t\t}\n\t}\n}\n";
        String testName = "<complete on keyword>";
        String completeBehind = "b";
        String expectedCompletionNodeToString = "<CompleteOnName:b>";
        String completionIdentifier = "b";
        String expectedReplacedSource = "b";
        int cursorLocation = str.indexOf("b\n") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass UB {\n  class UBMember {\n    UBMember() {\n    }\n    void bar2() {\n    }\n    void foo() {\n      <CompleteOnName:b>;\n    }\n  }\n  UB() {\n  }\n  void bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testV_1FGGUOO_1() {
        String str = "package p; \n/**\n * 1FGGUOO\n */\npublic class V i java\n\t.io\n\t.Serializable {\n}\n";
        String testName = "<complete on implements keyword>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<CompleteOnKeyword:i>";
        String completionIdentifier = "i";
        String expectedReplacedSource = "i";
        int cursorLocation = str.indexOf("i java") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class V extends <CompleteOnKeyword:i> {\n  {\n  }\n  public V() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testV_1FGGUOO_2() {
        String str = "package x.y.z; \n/**\n * 1FGGUOO\n */\npublic class V implements java.io.Serializable {\n}\n";
        String testName = "<complete on package>";
        String completeBehind = "y";
        String expectedCompletionNodeToString = "<CompleteOnPackage:x.y>";
        String completionIdentifier = "y";
        String expectedReplacedSource = "x.y.z";
        int cursorLocation = str.indexOf("y") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package <CompleteOnPackage:x.y>;\npublic class V implements java.io.Serializable {\n  public V() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testVA_1FHISJJ_1() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class VA {\n\tvoid foo() {\n\t\tObject item = new String() {\n\t\t\tpublic boolean equals() {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t\t.;\n\t\titem.}\n}\n";
        String testName = "<complete on anonymous type declaration>";
        String completeBehind = "new String() {\n\t\t\tpublic boolean equals() {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t\t.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new String() {\n  public boolean equals() {\n    return false;\n  }\n}.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VA {\n  public VA() {\n  }\n  void foo() {\n    Object item = <CompleteOnMemberAccess:new String() {\n  public boolean equals() {\n    return false;\n  }\n}.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testVA_1FHISJJ_2() {
        String str = "package p; \n/**\n * 1FHISJJ\n */\npublic class VA {\n\tvoid foo() {\n\t\tObject item = new String() {\n\t\t\tpublic boolean equals() {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t\t.;\n\t\titem.}\n}\n";
        String testName = "<complete on local variable>";
        String completeBehind = "item.";
        String expectedCompletionNodeToString = "<CompleteOnName:item.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "item.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VA {\n  public VA() {\n  }\n  void foo() {\n    Object item;\n    <CompleteOnName:item.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testVB_1() {
        String str = "package p; \npublic class VB {\n\tvoid foo() {\n\t\tnew java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}\n\t\t.;\n\t}\n}\n";
        String testName = "<complete on local variable name into anonymous declaration>";
        String completeBehind = "v";
        String expectedCompletionNodeToString = "<CompleteOnName:v>";
        String completionIdentifier = "v";
        String expectedReplacedSource = "v";
        int cursorLocation = str.indexOf("v }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VB {\n  public VB() {\n  }\n  void foo() {\n    new java.io.File(\"error\") {\n      protected void runTest() {\n        Vector v11111;\n        <CompleteOnName:v>;\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void _testVB_2() {
        String str = "package p; \npublic class VB {\n\tvoid foo() {\n\t\tnew java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}.\n\t}\n}\n";
        String testName = "<complete on anonymous type declaration>";
        String completeBehind = "new java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new java.io.File(\"error\") {\n  protected void runTest() {\n  }\n}.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "new java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VB {\n  public VB() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new java.io.File(\"error\") {\n  protected void runTest() {\n  }\n}.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testVB_3() {
        String str = "package p; \npublic class VB {\n\tvoid foo() {\n\t\tnew java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}\n\t\t.;\n\t}\n}\n";
        String testName = "<complete on constructor>";
        String completeBehind = "new java.io.File(";
        String expectedCompletionNodeToString = "<CompleteOnAllocationExpression:new java.io.File()>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VB {\n  public VB() {\n  }\n  void foo() {\n    <CompleteOnAllocationExpression:new java.io.File()>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void _testVB_4() {
        String str = "package p; \npublic class VB {\n\tvoid foo() {\n\t\tnew java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}\n\t\t.;\n\t}\n}\n";
        String testName = "<complete on anonymous type declaration with dummy spaces>";
        String completeBehind = "new java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}\n\t\t.";
        String expectedCompletionNodeToString = "<CompleteOnName:new java.io.File(\"error\") {\n  protected void runTest() {\n  }\n}.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "new java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}\n\t\t.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VB {\n  public VB() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new java.io.File(\"error\") {\n  protected void runTest() {\n  }\n}.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void _testVB_5() {
        String str = "package p; \npublic class VB {\n\tvoid foo() {\n\t\tnew java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}.;\n\t}\n}\n";
        String testName = "<complete on anonymous type declaration with trailing semi-colon>";
        String completeBehind = "new java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new java.io.File(\"error\") {\n  protected void runTest() {\n  }\n}.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "new java.io.File(\"error\") {\n\t\t\tprotected void runTest() {\n\t\t\t\tVector v11111 = new Vector();\n\t\t\t\tv }\n\t\t}.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class VB {\n  public VB() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new java.io.File(\"error\") {\n  protected void runTest() {\n  }\n}.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testW_1FGGUS4() {
        String str = "package p; \n/**\n * 1FGGUS4\n */\npublic class W {\n\tpublic static final int LA = \n\t\t1; \n\tpublic static final int LAB = \n\t\t2; \n\tpublic static final int LABO = \n\t\t4; \n\tpublic int produceDebugAttributes = \n\t\tLABO; \n}\n";
        String testName = "<complete on field initializer>";
        String completeBehind = "L";
        String expectedCompletionNodeToString = "<CompleteOnName:L>";
        String completionIdentifier = "L";
        String expectedReplacedSource = "LABO";
        int cursorLocation = str.indexOf("LABO;") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class W {\n  public static final int LA;\n  public static final int LAB;\n  public static final int LABO;\n  public int produceDebugAttributes = <CompleteOnName:L>;\n  public W() {\n  }\n  <clinit>() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testWA_1() {
        String str = "package p; \npublic class WA {\n\tvoid foo() {\n\t\tint value = 10;\n\t\tv int[] tab = new int[value];\n\t}\n";
        String testName = "<complete on array size value>";
        String completeBehind = "v";
        String expectedCompletionNodeToString = "<CompleteOnName:v>";
        String completionIdentifier = "v";
        String expectedReplacedSource = "value";
        int cursorLocation = str.indexOf("value];") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class WA {\n  public WA() {\n  }\n  void foo() {\n    int value;\n    int[] tab = new int[<CompleteOnName:v>];\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testWA_2() {
        String str = "package p; \npublic class WA {\n\tvoid foo() {\n\t\tint value = 10;\n\t\tv int[] tab = new int[value];\n\t}\n";
        String testName = "<complete on corrupter local variable declaration>";
        String completeBehind = "v";
        String expectedCompletionNodeToString = "<CompleteOnName:v>";
        String completionIdentifier = "v";
        String expectedReplacedSource = "v";
        int cursorLocation = str.indexOf("v int[]") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class WA {\n  public WA() {\n  }\n  void foo() {\n    int value;\n    <CompleteOnName:v>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testWB_1FI313C() {
        String str = "package p; \n/*\n * 1FI313C\n */\nclass WBHelper {\n\tpublic int fieldPublic;\n\tprotected int fieldProtected;\n\tprivate int fieldPrivate;\n\tint fieldDefault;\n\tstatic void staticFoo() {\n\t}\n\tstatic int i = d;\n\tint neuneu1() {\n\t}\n\tvoid neuneu2() {\n\t}\n}\npublic class WB\n\textends WBHelper {\n\tvoid foo() {\n\t\tBIJOUR[] b = \n\t\t\tnew java.lang.Number[]; \n\t\tjava.lang.Short s;\n\t\tb[1].}\n\tB() {\n\t}\n\tB(int) {\n\t}\n}\n";
        String testName = "<complete on method/field of array element>";
        String completeBehind = "b[1].";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:b[1].>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nclass WBHelper {\n  public int fieldPublic;\n  protected int fieldProtected;\n  private int fieldPrivate;\n  int fieldDefault;\n  static int i;\n  WBHelper() {\n  }\n  <clinit>() {\n  }\n  static void staticFoo() {\n  }\n  int neuneu1() {\n  }\n  void neuneu2() {\n  }\n}\npublic class WB extends WBHelper {\n  public WB() {\n  }\n  void foo() {\n    BIJOUR[] b;\n    java.lang.Short s;\n    <CompleteOnMemberAccess:b[1].>;\n  }\n  B() {\n  }\n  B() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testX_1FGGV8C_1() {
        String str = "package p; \nimport p2.Y; \n/**\n * 1FGGV8C and 1FGPE8E\n */\npublic class X {\n\tpublic static final float Vars; \n\tpublic static final float Lines; \n\tpublic static final float Source; \n\tpublic static final float UnreachableCode; \n\tpublic static final float produceDebugAttributes; \n\tvoid foo() {\n\t\tint locale, \n\t\t\terrorThreshold, \n\t\t\tpreserveAllLocalVariables; \n\t\treturn new Y[] {\n\t\t\tnew Y(\n\t\t\t\t\"debug.vars\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Vars)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.lines\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Lines)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.source\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Source)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.preserveAllLocals\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\tpreserveAllLocalVariables\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"optionalError.unReachableCode\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(errorThreshold\n\t\t\t\t\t& UnreachableCode)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1)\n\t\t\t\t }\n\t}\n}\n";
        String testName = "<complete on argument of anonymous type declaration>";
        String completeBehind = "t";
        String expectedCompletionNodeToString = "<CompleteOnName:t>";
        String completionIdentifier = "t";
        String expectedReplacedSource = "this";
        int cursorLocation = str.indexOf("this, ") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport p2.Y;\npublic class X {\n  public static final float Vars;\n  public static final float Lines;\n  public static final float Source;\n  public static final float UnreachableCode;\n  public static final float produceDebugAttributes;\n  <clinit>() {\n  }\n  public X() {\n  }\n  void foo() {\n    int locale;\n    int errorThreshold;\n    int preserveAllLocalVariables;\n    new Y(\"debug.vars\", <CompleteOnName:t>);\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testX_1FGGV8C_2() {
        String str = "package p; \nimport p2.YZA; \n/**\n * 1FGGV8C and 1FGPE8E\n */\npublic class X {\n\tpublic static final float Vars; \n\tpublic static final float Lines; \n\tpublic static final float Source; \n\tpublic static final float UnreachableCode; \n\tpublic static final float produceDebugAttributes; \n\tvoid foo() {\n\t\tint locale, \n\t\t\terrorThreshold, \n\t\t\tpreserveAllLocalVariables; \n\t\treturn new YZA[] {\n\t\t\tnew YZA(\n\t\t\t\t\"debug.vars\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Vars)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"debug.lines\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Lines)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"debug.source\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Source)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"debug.preserveAllLocals\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\tpreserveAllLocalVariables\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"optionalError.unReachableCode\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(errorThreshold\n\t\t\t\t\t& UnreachableCode)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1)\n\t\t\t\t }\n\t}\n}\n";
        String testName = "<complete on anonymous type declaration into a return statement>";
        String completeBehind = "Y";
        String expectedCompletionNodeToString = "<CompleteOnType:Y>";
        String completionIdentifier = "Y";
        String expectedReplacedSource = "YZA";
        int cursorLocation = str.indexOf("YZA[]") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport p2.YZA;\npublic class X {\n  public static final float Vars;\n  public static final float Lines;\n  public static final float Source;\n  public static final float UnreachableCode;\n  public static final float produceDebugAttributes;\n  <clinit>() {\n  }\n  public X() {\n  }\n  void foo() {\n    int locale;\n    int errorThreshold;\n    int preserveAllLocalVariables;\n    return new <CompleteOnType:Y>();\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testX_1FGGV8C_3() {
        String str = "package p; \nimport p2.YZA; \n/**\n * 1FGGV8C and 1FGPE8E\n */\npublic class X {\n\tpublic static final float Vars; \n\tpublic static final float Lines; \n\tpublic static final float Source; \n\tpublic static final float UnreachableCode; \n\tpublic static final float produceDebugAttributes; \n\tvoid foo() {\n\t\tint locale, \n\t\t\terrorThreshold, \n\t\t\tpreserveAllLocalVariables; \n\t\treturn new YZA[] {\n\t\t\tnew YZA(\n\t\t\t\t\"debug.vars\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Vars)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"debug.lines\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Lines)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"debug.source\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Source)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"debug.preserveAllLocals\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\tpreserveAllLocalVariables\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew YZA(\n\t\t\t\t\"optionalError.unReachableCode\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(errorThreshold\n\t\t\t\t\t& UnreachableCode)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1)\n\t\t\t\t }\n\t}\n}\n";
        String testName = "<complete on anonymous type declaration nested into an array initializer>";
        String completeBehind = "Y";
        String expectedCompletionNodeToString = "<CompleteOnType:Y>";
        String completionIdentifier = "Y";
        String expectedReplacedSource = "YZA";
        int cursorLocation = str.indexOf("YZA(") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport p2.YZA;\npublic class X {\n  public static final float Vars;\n  public static final float Lines;\n  public static final float Source;\n  public static final float UnreachableCode;\n  public static final float produceDebugAttributes;\n  <clinit>() {\n  }\n  public X() {\n  }\n  void foo() {\n    int locale;\n    int errorThreshold;\n    int preserveAllLocalVariables;\n    new YZA[]{new <CompleteOnType:Y>()};\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testX_1FGGV8C_4() {
        String str = "package p; \nimport p2.Y; \n/**\n * 1FGGV8C and 1FGPE8E\n */\npublic class X {\n\tpublic static final float Vars; \n\tpublic static final float Lines; \n\tpublic static final float Source; \n\tpublic static final float UnreachableCode; \n\tpublic static final float produceDebugAttributes; \n\tvoid foo() {\n\t\tint locale, \n\t\t\terrorThreshold, \n\t\t\tpreserveAllLocalVariables; \n\t\treturn new Y[] {\n\t\t\tnew Y(\n\t\t\t\t\"debug.vars\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Vars)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.lines\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Lines)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.source\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Source)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.preserveAllLocals\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\tpreserveAllLocalVariables\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"optionalError.unReachableCode\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(errorThreshold\n\t\t\t\t\t& UnreachableCode)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1)\n\t\t\t\t }\n\t}\n}\n";
        String testName = "<complete on method/field into array intializer>";
        String completeBehind = "n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedReplacedSource = "new";
        int cursorLocation = str.indexOf("new Y(") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport p2.Y;\npublic class X {\n  public static final float Vars;\n  public static final float Lines;\n  public static final float Source;\n  public static final float UnreachableCode;\n  public static final float produceDebugAttributes;\n  <clinit>() {\n  }\n  public X() {\n  }\n  void foo() {\n    int locale;\n    int errorThreshold;\n    int preserveAllLocalVariables;\n    new Y[]{<CompleteOnName:n>};\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testX_1FGPE8E() {
        String str = "package p; \nimport p2.Y; \n/**\n * 1FGGV8C and 1FGPE8E\n */\npublic class X {\n\tpublic static final float Vars; \n\tpublic static final float Lines; \n\tpublic static final float Source; \n\tpublic static final float UnreachableCode; \n\tpublic static final float produceDebugAttributes; \n\tvoid foo() {\n\t\tint locale, \n\t\t\terrorThreshold, \n\t\t\tpreserveAllLocalVariables; \n\t\treturn new Y[] {\n\t\t\tnew Y(\n\t\t\t\t\"debug.vars\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Vars)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.lines\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Lines)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.source\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(produceDebugAttributes\n\t\t\t\t\t& Source)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"debug.preserveAllLocals\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\tpreserveAllLocalVariables\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1), \n\t\t\tnew Y(\n\t\t\t\t\"optionalError.unReachableCode\", \n\t\t\t\tthis, \n\t\t\t\tlocale, \n\t\t\t\t(errorThreshold\n\t\t\t\t\t& UnreachableCode)\n\t\t\t\t\t!= 0\n\t\t\t\t\t? 0\n\t\t\t\t\t: 1)\n\t\t\t\t }\n\t}\n}\n";
        String testName = "<complete on method/field into return statement>";
        String completeBehind = "n";
        String expectedCompletionNodeToString = "<CompleteOnName:n>";
        String completionIdentifier = "n";
        String expectedReplacedSource = "new";
        int cursorLocation = str.indexOf("new Y[]") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport p2.Y;\npublic class X {\n  public static final float Vars;\n  public static final float Lines;\n  public static final float Source;\n  public static final float UnreachableCode;\n  public static final float produceDebugAttributes;\n  <clinit>() {\n  }\n  public X() {\n  }\n  void foo() {\n    int locale;\n    int errorThreshold;\n    int preserveAllLocalVariables;\n    return <CompleteOnName:n>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void _testXA_1FGGUQF_1FHSL8H_1() {
        String str = "// int\npackage p; \n/**\n * 1FGGUQF and 1FHSL8H\n */\n/**\n * int\n */\n/*\n * int\n */\n// int\n/**\nint.\n * Internal API used to resolve a compilation unit minimally for code assist engine\n */\n/**\n * int\n */\npublic class XA {\n\t//  int\n\t/*  int */\n\t/** int */\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tvoid /* int */\n\tfoo() {\n\t\t//  int\n\t\t/*  int */\n\t\t/** int */\n\t}\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tint field /* int */\n\t;\n\t/*\n\t    int\n\t*/\n\tstatic {\n\t\t// int\n\t}\n}\n//  int\n/*  int */\n/** int */\n";
        String testName = "<complete on comment>";
        String completeBehind = "int.";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "<NONE>";
        int cursorLocation = str.indexOf("int.\n") + completeBehind.length() - 1;
        String expectedUnitDisplayString = null;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Comment");
        }
    }

    public void testXA_1FGGUQF_1FHSL8H_2() {
        String str = "// int\npackage p; \n/**\n * 1FGGUQF and 1FHSL8H\n */\n/**\n * int\n */\n/*\n * int\n */\n// int\n/**\nint.\n * Internal API used to resolve a compilation unit minimally for code assist engine\n */\n/**\n * int\n */\npublic class XA {\n\t//  int\n\t/*  int */\n\t/** int */\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tvoid /* int */\n\tfoo() {\n\t\t//  int\n\t\t/*  int */\n\t\t/** int */\n\t}\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tint field /* int */\n\t;\n\t/*\n\t    int\n\t*/\n\tstatic {\n\t\t// int\n\t}\n}\n//  int\n/*  int */\n/** int */\n";
        String testName = "<complete on comment>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "<NONE>";
        int cursorLocation = str.indexOf("int\n") + completeBehind.length() - 1;
        String expectedUnitDisplayString = null;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Comment");
        }
    }

    public void testXA_1FGGUQF_1FHSL8H_3() {
        String str = "// int\npackage p; \n/**\n * 1FGGUQF and 1FHSL8H\n */\n/**\n * int\n */\n/*\n * int\n */\n// int\n/**\nint.\n * Internal API used to resolve a compilation unit minimally for code assist engine\n */\n/**\n * int\n */\npublic class XA {\n\t//  int\n\t/*  int */\n\t/** int */\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tvoid /* int */ foo() {\n\t\t//  int\n\t\t/*  int */\n\t\t/** int */\n\t}\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tint field /* int */\n\t;\n\t/*\n\t    int\n\t*/\n\tstatic {\n\t\t// int\n\t}\n}\n//  int\n/*  int */\n/** int */\n";
        String testName = "<complete on comment>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "<NONE>";
        int cursorLocation = str.indexOf("int */") + completeBehind.length() - 1;
        String expectedUnitDisplayString = null;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Comment");
        }
    }

    public void testXA_1FGGUQF_1FHSL8H_4() {
        String str = "// int\npackage p; \n/**\n * 1FGGUQF and 1FHSL8H\n */\n/**\n * int\n */\n/*\n * int\n */\n// int\n/**\nint.\n * Internal API used to resolve a compilation unit minimally for code assist engine\n */\n/**\n * int\n */\npublic class XA {\n\t//  int\n\t/*  int */\n\t/** int */\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tvoid /* int */ foo() {\n\t\t//  int\n\t\t/*  int */\n\t\t/** int */\n\t}\n\t/**\n\tint.\n\t * Internal API used to resolve a compilation unit minimally for code assist engine\n\t */\n\tint field /* int */\n\t;\n\t/*\n\t    int\n\t*/\n\tstatic {\n\t\t// int\n\t}\n}\n//  int\n/*  int  */\n/** int   */\n";
        String testName = "<complete on comment>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "<NONE>";
        int cursorLocation = str.indexOf("int */ foo()") + completeBehind.length() - 1;
        String expectedUnitDisplayString = null;
        try {
            this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
            CompletionParserTest.assertTrue((String)"failed to detect invalid cursor location", (boolean)false);
        }
        catch (InvalidCursorLocation e) {
            CompletionParserTest.assertEquals("invalid cursor location: ", e.irritant, "No Completion Inside Comment");
        }
    }

    public void testXB_1FIYM5I_1() {
        String str = "package p; \n/*\n * 1FIYM5I\n */\npublic class XB\n\textends java.io.File {\n\tvoid foo() {\n\t\tXB xb = new XB();\n\t\tthis.separator.;\n\t\tthis.bar().;\n\t}\n\tString bar() {\n\t}\n}\n";
        String testName = "<complete on method/field of explicit this access>";
        String completeBehind = "this.s";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.s>";
        String completionIdentifier = "s";
        String expectedReplacedSource = "this.separator";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class XB extends java.io.File {\n  public XB() {\n  }\n  void foo() {\n    XB xb;\n    <CompleteOnMemberAccess:this.s>;\n  }\n  String bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testXB_1FIYM5I_2() {
        String str = "package p; \n/*\n * 1FIYM5I\n */\npublic class XB\n\textends java.io.File {\n\tvoid foo() {\n\t\tXB xb = new XB();\n\t\tthis.separator.;\n\t\tthis.bar().;\n\t}\n\tString bar() {\n\t}\n}\n";
        String testName = "<complete on method/field of explicitly accessed field>";
        String completeBehind = "this.separator.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.separator.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class XB extends java.io.File {\n  public XB() {\n  }\n  void foo() {\n    XB xb;\n    <CompleteOnMemberAccess:this.separator.>;\n  }\n  String bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testXB_1FIYM5I_3() {
        String str = "package p; \n/*\n * 1FIYM5I\n */\npublic class XB\n\textends java.io.File {\n\tvoid foo() {\n\t\tXB xb = new XB();\n\t\tthis.separator.;\n\t\tthis.bar().;\n\t}\n\tString bar() {\n\t}\n}\n";
        String testName = "<complete on method/field of explicit this access>";
        String completeBehind = "this.b";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.b>";
        String completionIdentifier = "b";
        String expectedReplacedSource = "this.bar";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class XB extends java.io.File {\n  public XB() {\n  }\n  void foo() {\n    XB xb;\n    <CompleteOnMemberAccess:this.b>;\n  }\n  String bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testXB_1FIYM5I_4() {
        String str = "package p; \n/*\n * 1FIYM5I\n */\npublic class XB\n\textends java.io.File {\n\tvoid foo() {\n\t\tXB xb = new XB();\n\t\tthis.separator.;\n\t\tthis.bar().;\n\t}\n\tString bar() {\n\t}\n}\n";
        String testName = "<complete on method/field of explicitly accessed method>";
        String completeBehind = "this.bar().";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.bar().>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class XB extends java.io.File {\n  public XB() {\n  }\n  void foo() {\n    XB xb;\n    <CompleteOnMemberAccess:this.bar().>;\n  }\n  String bar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testY_1FGPESI() {
        String str = "package p; \nimport p2.; \n/**\n * 1FGPESI\n */\npublic class Y {\n}\n";
        String testName = "<complete on imports>";
        String completeBehind = "p2.";
        String expectedCompletionNodeToString = "<CompleteOnImport:p2.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "p2.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport <CompleteOnImport:p2.>;\npublic class Y {\n  public Y() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testYA_1FGRIUH() {
        String str = "package p; \n/**\n * 1FGRIUH\n */\npublic class YA\n\textends YASecondTopLevel {\n\tvoid eFoo() {\n\t}\n\tclass YAMember {\n\t\tvoid eFoo() {\n\t\t}\n\t\tvoid eBar() {\n\t\t\te }\n\t}\n}\nclass YASecondTopLevel {\n\tpublic boolean equals(YA yaya) {\n\t\treturn true;\n\t}\n\tpublic eFoo() {\n\t}\n\tpublic void eFooBar() {\n\t}\n}\n";
        String testName = "<complete on method/field>";
        String completeBehind = "e";
        String expectedCompletionNodeToString = "<CompleteOnName:e>";
        String completionIdentifier = "e";
        String expectedReplacedSource = "e";
        int cursorLocation = str.indexOf("e }") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class YA extends YASecondTopLevel {\n  class YAMember {\n    YAMember() {\n    }\n    void eFoo() {\n    }\n    void eBar() {\n      <CompleteOnName:e>;\n    }\n  }\n  public YA() {\n  }\n  void eFoo() {\n  }\n}\nclass YASecondTopLevel {\n  YASecondTopLevel() {\n  }\n  public boolean equals(YA yaya) {\n  }\n  public eFoo() {\n  }\n  public void eFooBar() {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testYB_1FJ4D46_1() {
        String str = "package p; \n/**\n * 1FJ4D46\n */\npublic class YB {\n\tvoid foo() {\n\t\tnew String(\"asdf\".getBytes()).}\n}\n";
        String testName = "<complete on method/field of object creation>";
        String completeBehind = "new String(\"asdf\".getBytes()).";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:new String(\"asdf\".getBytes()).>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class YB {\n  public YB() {\n  }\n  void foo() {\n    <CompleteOnMemberAccess:new String(\"asdf\".getBytes()).>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZ_1FGPF3D_1() {
        String str = "package p; \n/**\n * 1FGPF3D\n */\npublic class Z imp Pro.Sev, \n\tBla.Blo {\n}\n";
        String testName = "<complete on implements keyword>";
        String completeBehind = "imp";
        String expectedCompletionNodeToString = "<CompleteOnKeyword:imp>";
        String completionIdentifier = "imp";
        String expectedReplacedSource = "imp";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class Z extends <CompleteOnKeyword:imp> {\n  {\n  }\n  public Z() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZ_1FGPF3D_2() {
        String str = "package p; \n/**\n * 1FGPF3D\n */\npublic class Z implements Pro.Sev, \n\tBla.Blo {\n}\n";
        String testName = "<complete on implented interface>";
        String completeBehind = "P";
        String expectedCompletionNodeToString = "<CompleteOnInterface:P>";
        String completionIdentifier = "P";
        String expectedReplacedSource = "Pro";
        int cursorLocation = str.indexOf("Pro.Sev") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class Z implements <CompleteOnInterface:P>, Bla.Blo {\n  public Z() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZA_1() {
        String str = "package p; \nimport java.util.Vector;\n";
        String testName = "<complete on import keyword>";
        String completeBehind = "i";
        String expectedCompletionNodeToString = "<CompleteOnKeyword:i>";
        String completionIdentifier = "i";
        String expectedReplacedSource = "import";
        int cursorLocation = str.indexOf("import") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport <CompleteOnKeyword:i>;\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZA_2() {
        String str = "package p; \nimport java.util.Vector;\n";
        String testName = "<complete on imported package>";
        String completeBehind = "jav";
        String expectedCompletionNodeToString = "<CompleteOnImport:jav>";
        String completionIdentifier = "jav";
        String expectedReplacedSource = "java.util.Vector";
        int cursorLocation = str.indexOf("java.util.Vector") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport <CompleteOnImport:jav>;\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZA_3() {
        String str = "package p; \nimport java.util.Vector;\n";
        String testName = "<complete on imported type>";
        String completeBehind = "java.util.V";
        String expectedCompletionNodeToString = "<CompleteOnImport:java.util.V>";
        String completionIdentifier = "V";
        String expectedReplacedSource = "java.util.Vector";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport <CompleteOnImport:java.util.V>;\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZB_1FJ4D46_1() {
        String str = "package p; \n/**\n * 1FJ4D46\n */\nimport java.util.zip.CRC32;\nimport java.io.*;\npublic class ZB {\n\tpublic static void main(\n\t\tjava.lang.String[] args) {\n\t\tFile file = \n\t\t\tnew File(\"d:\\\\314\"); \n\t\tCRC32 crc = new CRC32();\n\t\tfile.}\n}\n";
        String testName = "<complete on method/field of local variable>";
        String completeBehind = "file.";
        String expectedCompletionNodeToString = "<CompleteOnName:file.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "file.";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport java.util.zip.CRC32;\nimport java.io.*;\npublic class ZB {\n  public ZB() {\n  }\n  public static void main(java.lang.String[] args) {\n    File file;\n    CRC32 crc;\n    <CompleteOnName:file.>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testZB_1FJ4D46_2() {
        String str = "package p; \n/**\n * 1FJ4D46\n */\nimport java.util.zip.CRC32;\nimport java.io.*;\npublic class ZB {\n\tpublic static void main(\n\t\tjava.lang.String[] args) {\n\t\tFile file = \n\t\t\tnew File(\"d:\\\\314\"); \n\t\tCRC32 crc = new CRC32();\n\t\tfile.}\n}\n";
        String testName = "<complete on local variable type>";
        String completeBehind = "CRC";
        String expectedCompletionNodeToString = "<CompleteOnName:CRC>";
        String completionIdentifier = "CRC";
        String expectedReplacedSource = "CRC32";
        int cursorLocation = str.indexOf("CRC32 crc") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\nimport java.util.zip.CRC32;\nimport java.io.*;\npublic class ZB {\n  public ZB() {\n  }\n  public static void main(java.lang.String[] args) {\n    File file;\n    <CompleteOnName:CRC>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test001() {
        String str = "package p;\npublic class X {\n  void foo(){\n    int v1;\n    {\n      Obj\n    }\n  }\n}\n";
        String testName = "<complete in initializer>";
        String completeBehind = "Obj";
        String expectedCompletionNodeToString = "<CompleteOnName:Obj>";
        String completionIdentifier = "Obj";
        String expectedReplacedSource = "Obj";
        int cursorLocation = str.indexOf("Obj") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class X {\n  public X() {\n  }\n  void foo() {\n    int v1;\n    {\n      <CompleteOnName:Obj>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test002() {
        String str = "package p;\npublic class X {\n  void foo(){\n    int v1;\n    {\n      int v2\n    }\n    Obj  }\n}\n";
        String testName = "<complete after initializer>";
        String completeBehind = "Obj";
        String expectedCompletionNodeToString = "<CompleteOnName:Obj>";
        String completionIdentifier = "Obj";
        String expectedReplacedSource = "Obj";
        int cursorLocation = str.indexOf("Obj") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class X {\n  public X() {\n  }\n  void foo() {\n    int v1;\n    <CompleteOnName:Obj>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test003() {
        String str = "package p;\npublic class X {\n  void foo(){\n    int v1;\n    {\n      this.\n    }\n  }\n}\n";
        String testName = "<complete in initializer>";
        String completeBehind = "this.";
        String expectedCompletionNodeToString = "<CompleteOnMemberAccess:this.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "this.";
        int cursorLocation = str.indexOf("this.") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "package p;\npublic class X {\n  public X() {\n  }\n  void foo() {\n    int v1;\n    {\n      <CompleteOnMemberAccess:this.>;\n    }\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test004() {
        String str = "public class X {\n  final static int ZZZ = 1;\n  void foo(){\n    switch(2)\n      case 0 + ZZZ :\n      case 1 + ZZZ :\n          bar(ZZZ)\n  }\n  void bar(int y) {}\n}\n";
        String testName = "<complete in switch>";
        String completeBehind = "ZZZ";
        String expectedCompletionNodeToString = "<CompleteOnName:ZZZ>";
        String completionIdentifier = "ZZZ";
        String expectedReplacedSource = "ZZZ";
        int cursorLocation = str.lastIndexOf("ZZZ") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  static final int ZZZ;\n  <clinit>() {\n  }\n  public X() {\n  }\n  void foo() {\n    bar(<CompleteOnName:ZZZ>);\n  }\n  void bar(int y) {\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test005() {
        String str = "public class X {\n  clon foo(){\n  }\n}\n";
        String testName = "<complete in method type>";
        String completeBehind = "clon";
        String expectedCompletionNodeToString = "<CompleteOnType:clon>";
        String completionIdentifier = "clon";
        String expectedReplacedSource = "clon";
        int cursorLocation = str.lastIndexOf("clon") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  <CompleteOnType:clon>\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test006() {
        String str = "public class X {\n  clon\n  foo();\n}\n";
        String testName = "<complete in method type>";
        String completeBehind = "clon";
        String expectedCompletionNodeToString = "<CompleteOnType:clon>;";
        String completionIdentifier = "clon";
        String expectedReplacedSource = "clon";
        int cursorLocation = str.lastIndexOf("clon") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  <CompleteOnType:clon>;\n  public X() {\n  }\n  foo();\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test007() {
        String str = "public class X {\n  clon  x;\n}\n";
        String testName = "<complete in field type>";
        String completeBehind = "clon";
        String expectedCompletionNodeToString = "<CompleteOnType:clon>;";
        String completionIdentifier = "clon";
        String expectedReplacedSource = "clon";
        int cursorLocation = str.lastIndexOf("clon") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  <CompleteOnType:clon>;\n  public X() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test008() {
        String str = "public class X {\n  clon\n  x;\n}\n";
        String testName = "<complete in field type>";
        String completeBehind = "clon";
        String expectedCompletionNodeToString = "<CompleteOnType:clon>;";
        String completionIdentifier = "clon";
        String expectedReplacedSource = "clon";
        int cursorLocation = str.lastIndexOf("clon") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  <CompleteOnType:clon>;\n  public X() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test009() {
        String str = "public class X {\n  clon\n  x y;\n}\n";
        String testName = "<complete in field tpye>";
        String completeBehind = "clon";
        String expectedCompletionNodeToString = "<CompleteOnType:clon>;";
        String completionIdentifier = "clon";
        String expectedReplacedSource = "clon";
        int cursorLocation = str.lastIndexOf("clon") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  <CompleteOnType:clon>;\n  x y;\n  public X() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test010() {
        String str = "public class X {\n  clon\n  x y(){}\n}\n";
        String testName = "<complete in method type>";
        String completeBehind = "clon";
        String expectedCompletionNodeToString = "<CompleteOnType:clon>;";
        String completionIdentifier = "clon";
        String expectedReplacedSource = "clon";
        int cursorLocation = str.lastIndexOf("clon") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  <CompleteOnType:clon>;\n  public X() {\n  }\n  x y() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test011() {
        String str = "public class X {\n  void foo() {\n    new Object[]{\n      bar(zzz)\n    };\n  }\n}\n";
        String testName = "<bug 25233>";
        String completeBehind = "zzz";
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        int cursorLocation = str.lastIndexOf("zzz") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  void foo() {\n    bar(<CompleteOnName:zzz>);\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test012() {
        String str = "public class X {\n  public X() {\n    super();\n  }\n  Object o = new ZZZ\n}\n";
        String testName = "<bug 27370>";
        String completeBehind = "ZZZ";
        String expectedCompletionNodeToString = "<CompleteOnType:ZZZ>";
        String completionIdentifier = "ZZZ";
        String expectedReplacedSource = "ZZZ";
        int cursorLocation = str.lastIndexOf("ZZZ") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class X {\n  Object o = new <CompleteOnType:ZZZ>();\n  public X() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test013() {
        String str = "public class Bar {\n  #\n  Bar foo1 = new Bar(){};\n  {int i;}\n  synchronized void foo3() {}\n  zzz\n}\n";
        String testName = "<bug 27735>";
        String completeBehind = "zzz";
        String expectedCompletionNodeToString = "<CompleteOnType:zzz>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        int cursorLocation = str.lastIndexOf("zzz") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class Bar {\n  Bar foo1;\n  {\n  }\n  <CompleteOnType:zzz>;\n  public Bar() {\n  }\n  synchronized void foo3() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test014() {
        String str = "public class Bar {\n  void foo() {\n    String s = \"a\" + \"b\";\n    zzz\n  }\n}\n";
        String testName = "<bug 27941>";
        String completeBehind = "zzz";
        String expectedCompletionNodeToString = "<CompleteOnName:zzz>";
        String completionIdentifier = "zzz";
        String expectedReplacedSource = "zzz";
        int cursorLocation = str.lastIndexOf("zzz") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class Bar {\n  public Bar() {\n  }\n  void foo() {\n    String s;\n    <CompleteOnName:zzz>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test015() {
        String str = "public class Bar {\n  void foo() {\n    Object o = new Object[]{};\n    foo();\n  }\n}\n";
        String testName = "<bug 39502>";
        String completeBehind = "foo(";
        String expectedCompletionNodeToString = "<CompleteOnMessageSend:foo()>";
        String completionIdentifier = "";
        String expectedReplacedSource = "foo(";
        int cursorLocation = str.lastIndexOf("foo(") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class Bar {\n  public Bar() {\n  }\n  void foo() {\n    Object o;\n    <CompleteOnMessageSend:foo()>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test016() {
        String str = "public class Bar {\n  void foo() {\n    Object o = new Object[0];\n    foo();\n  }\n}\n";
        String testName = "<bug 39502>";
        String completeBehind = "foo(";
        String expectedCompletionNodeToString = "<CompleteOnMessageSend:foo()>";
        String completionIdentifier = "";
        String expectedReplacedSource = "foo(";
        int cursorLocation = str.lastIndexOf("foo(") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class Bar {\n  public Bar() {\n  }\n  void foo() {\n    Object o;\n    <CompleteOnMessageSend:foo()>;\n  }\n}\n";
        this.checkMethodParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test017() {
        String str = "public class Bar {\n  String s;\n  /**/\n}\n";
        String testName = "";
        String completeBehind = "/**/";
        String expectedCompletionNodeToString = "<CompleteOnType:>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        int cursorLocation = str.lastIndexOf("/**/") + completeBehind.length() - 1;
        String expectedUnitDisplayString = "public class Bar {\n  String s;\n  <CompleteOnType:>;\n  public Bar() {\n  }\n}\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void testRECOVERY001() {
        String str = "var foo;\nif (f) {\n";
        String testName = "<complete on name inside if>";
        String completeBehind = "(f";
        String expectedCompletionNodeToString = "<CompleteOnName:f>";
        String completionIdentifier = "f";
        String expectedReplacedSource = "f";
        int cursorLocation = str.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedUnitDisplayString = "var foo;\nif (<CompleteOnName:f>)\n\n";
        this.checkDietParse(str.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }
}

