/*******************************************************************************
 * Copyright (c) 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.internal.codeassist.select;

import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;


public class SelectionOnNameOfMemberValuePair extends MemberValuePair {

	public SelectionOnNameOfMemberValuePair(char[] token, int sourceStart, int sourceEnd, Expression value) {
		super(token, sourceStart, sourceEnd, value);
	}

	public StringBuffer print(int indent, StringBuffer output) {
		output.append("<SelectOnName:"); //$NON-NLS-1$
		output.append(name);
		output.append(">"); //$NON-NLS-1$
		return output;
	}

	public void resolveTypeExpecting(BlockScope scope, TypeBinding requiredType) {
		super.resolveTypeExpecting(scope, requiredType);

		if(this.binding != null) {
			throw new SelectionNodeFound(this.binding);
		}
		throw new SelectionNodeFound();
	}
}
