/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.projection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.ui.internal.projection.ProjectionModelNodeAdapterFactoryCSS;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;

public class ProjectionModelNodeAdapterCSS
implements INodeAdapter {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.css.ui/projectionperf"));
    ProjectionModelNodeAdapterFactoryCSS fAdapterFactory;
    private Map fTagAnnotations = new HashMap();
    static /* synthetic */ Class class$0;

    public ProjectionModelNodeAdapterCSS(ProjectionModelNodeAdapterFactoryCSS factory) {
        this.fAdapterFactory = factory;
    }

    private Position createProjectionPosition(ICSSNode node) {
        Position pos = null;
        if (this.isNodeProjectable(node) && node instanceof IndexedRegion) {
            IndexedRegion inode = (IndexedRegion)node;
            int start = inode.getStartOffset();
            int end = inode.getEndOffset();
            if (start >= 0 && start < end) {
                pos = new Position(start, end - start);
            }
        }
        return pos;
    }

    private TagProjectionAnnotation getExistingAnnotation(ICSSNode node) {
        TagProjectionAnnotation anno = null;
        if (node != null && !this.fTagAnnotations.isEmpty()) {
            Iterator it = this.fTagAnnotations.keySet().iterator();
            while (it.hasNext() && anno == null) {
                TagProjectionAnnotation a = (TagProjectionAnnotation)((Object)it.next());
                ICSSNode n = a.getNode();
                if (!node.equals(n)) continue;
                anno = a;
            }
        }
        return anno;
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.css.ui.internal.projection.ProjectionModelNodeAdapterCSS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    private boolean isNodeProjectable(ICSSNode node) {
        short type;
        return node != null && ((type = node.getNodeType()) == 1 || type == 6 || type == 4 || type == 3 || type == 5 || type == 2);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (!this.fAdapterFactory.isActive()) {
            return;
        }
        if ((eventType == 2 || eventType == 3) && notifier instanceof ICSSNode) {
            this.updateAdapter((ICSSNode)notifier);
        }
    }

    void updateAdapter(ICSSNode node) {
        this.updateAdapter(node, null);
    }

    void updateAdapter(ICSSNode node, ProjectionViewer viewer) {
        long start = System.currentTimeMillis();
        HashMap<TagProjectionAnnotation, Position> additions = new HashMap<TagProjectionAnnotation, Position>();
        HashMap<TagProjectionAnnotation, Position> projectionAnnotations = new HashMap<TagProjectionAnnotation, Position>();
        if (node != null) {
            ICSSNode childNode = node.getFirstChild();
            while (childNode != null) {
                Position newPos = this.createProjectionPosition(childNode);
                if (newPos != null) {
                    TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation(childNode, false);
                    TagProjectionAnnotation existing = this.getExistingAnnotation(childNode);
                    if (existing == null) {
                        projectionAnnotations.put(newAnnotation, newPos);
                        additions.put(newAnnotation, newPos);
                    } else {
                        projectionAnnotations.put(existing, newPos);
                        this.fTagAnnotations.remove((Object)existing);
                    }
                }
                childNode = childNode.getNextSibling();
            }
            ProjectionAnnotation[] oldList = null;
            if (!this.fTagAnnotations.isEmpty()) {
                oldList = this.fTagAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            ProjectionAnnotation[] modifyList = null;
            if (!projectionAnnotations.isEmpty()) {
                modifyList = projectionAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            if (viewer != null && !projectionAnnotations.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, projectionAnnotations, null, viewer);
            }
            if (oldList != null && oldList.length > 0 || !additions.isEmpty() || modifyList != null && modifyList.length > 0) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])oldList, additions, (Annotation[])modifyList);
            }
        }
        this.fTagAnnotations = projectionAnnotations;
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            String nodeName = node != null ? node.toString() : "null";
            System.out.println("ProjectionModelNodeAdapterCSS.updateAdapter (" + nodeName + "):" + (end - start));
        }
    }

    private class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible = false;
        private ICSSNode fNode;

        public TagProjectionAnnotation(ICSSNode node, boolean isCollapsed) {
            super(isCollapsed);
            this.fNode = node;
        }

        public ICSSNode getNode() {
            return this.fNode;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }
    }
}

