/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSUtils;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebParamAttributeInitializer
extends AnnotationAttributeInitializer {
    public List<MemberValuePair> getMemberValuePairs(ASTNode astNode, AST ast, Class<? extends Annotation> annotationClass) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (astNode instanceof SingleVariableDeclaration) {
            MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"name", (Object)this.getName((SingleVariableDeclaration)astNode));
            memberValuePairs.add(nameValuePair);
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(ASTNode astNode, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        if (astNode instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration parameter = (SingleVariableDeclaration)astNode;
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("name")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getName(parameter), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("partName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getPartName(parameter), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("targetNamespace")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getTargetNamespace(parameter), memberValuePair.getValue()));
            }
        }
        return completionProposals;
    }

    private String getName(SingleVariableDeclaration parameter) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)parameter.getParent();
        if (this.hasDocumentBareSOAPBinding((BodyDeclaration)methodDeclaration)) {
            return this.getWebMethodOperationName(methodDeclaration);
        }
        List siblings = (List)methodDeclaration.getStructuralProperty(parameter.getLocationInParent());
        return "arg" + siblings.indexOf(parameter);
    }

    private String getPartName(SingleVariableDeclaration parameter) {
        String name;
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((SingleVariableDeclaration)parameter, WebParam.class);
        if (annotation != null && (name = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"name")) != null) {
            return name;
        }
        return this.getName(parameter);
    }

    private String getTargetNamespace(SingleVariableDeclaration parameter) {
        if (this.hasDocumentWrappedSOAPBinding(parameter) && !this.isHeader(parameter)) {
            return "";
        }
        return this.getDefaultTargetNamespace(parameter);
    }

    private String getDefaultTargetNamespace(SingleVariableDeclaration parameter) {
        String targetNamespace;
        MethodDeclaration methodDeclaration = (MethodDeclaration)parameter.getParent();
        TypeDeclaration typeDeclaration = (TypeDeclaration)methodDeclaration.getParent();
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((BodyDeclaration)typeDeclaration, WebService.class);
        if (annotation != null && (targetNamespace = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"targetNamespace")) != null) {
            return targetNamespace;
        }
        return JDTUtils.getTargetNamespaceFromPackageName((String)this.getPackageName(typeDeclaration));
    }

    private String getPackageName(TypeDeclaration typeDeclaration) {
        PackageDeclaration packageDeclaration;
        if (typeDeclaration.isPackageMemberTypeDeclaration() && (packageDeclaration = ((CompilationUnit)typeDeclaration.getParent()).getPackage()) != null) {
            return packageDeclaration.getName().getFullyQualifiedName();
        }
        return "";
    }

    private boolean isHeader(SingleVariableDeclaration parameter) {
        Boolean header;
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((SingleVariableDeclaration)parameter, WebParam.class);
        if (annotation != null && (header = AnnotationUtils.getBooleanValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"header")) != null) {
            return header;
        }
        return false;
    }

    private boolean hasDocumentWrappedSOAPBinding(SingleVariableDeclaration parameter) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)parameter.getParent();
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((BodyDeclaration)methodDeclaration, SOAPBinding.class);
        if (annotation != null) {
            return JAXWSUtils.isDocumentWrapped((org.eclipse.jdt.core.dom.Annotation)annotation);
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)methodDeclaration.getParent();
        org.eclipse.jdt.core.dom.Annotation typeAnnotation = AnnotationUtils.getAnnotation((BodyDeclaration)typeDeclaration, SOAPBinding.class);
        if (typeAnnotation != null) {
            return JAXWSUtils.isDocumentWrapped((org.eclipse.jdt.core.dom.Annotation)typeAnnotation);
        }
        return true;
    }

    private boolean hasDocumentBareSOAPBinding(BodyDeclaration bodyDeclaration) {
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((BodyDeclaration)bodyDeclaration, SOAPBinding.class);
        if (annotation != null) {
            return JAXWSUtils.isDocumentBare((org.eclipse.jdt.core.dom.Annotation)annotation);
        }
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            return this.hasDocumentBareSOAPBinding((BodyDeclaration)((TypeDeclaration)methodDeclaration.getParent()));
        }
        return false;
    }

    private String getWebMethodOperationName(MethodDeclaration methodDeclaration) {
        String operationName;
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((BodyDeclaration)methodDeclaration, WebMethod.class);
        if (annotation != null && (operationName = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"operationName")) != null) {
            return operationName;
        }
        return methodDeclaration.getName().getIdentifier();
    }
}

