/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;

public final class JDTUtils {
    private JDTUtils() {
    }

    public static void addToClasspath(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        try {
            List<IClasspathEntry> currentEntries = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            newEntries.addAll(currentEntries);
            if (classpathEntry != null && !newEntries.contains(classpathEntry)) {
                newEntries.add(classpathEntry);
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
    }

    public static void removeFromClasspath(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        try {
            List<IClasspathEntry> currentEntries = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            newEntries.addAll(currentEntries);
            if (classpathEntry != null && newEntries.contains(classpathEntry)) {
                newEntries.remove(classpathEntry);
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
    }

    public static IStatus checkTypeExists(IType type, String compilationUnitName) {
        compilationUnitName = compilationUnitName.trim();
        IPackageFragment packageFragment = type.getPackageFragment();
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit(compilationUnitName);
        IResource resource = compilationUnit.getResource();
        if (resource.exists()) {
            return new Status(4, "org.eclipse.jst.ws.jaxws.core", JAXWSCoreMessages.bind((String)JAXWSCoreMessages.TYPE_WITH_NAME_ALREADY_EXISTS, (Object[])new Object[]{compilationUnitName, packageFragment.getElementName()}));
        }
        URI location = resource.getLocationURI();
        if (location != null) {
            try {
                IFileStore fileStore = EFS.getStore((URI)location);
                if (fileStore.fetchInfo().exists()) {
                    return new Status(4, "org.eclipse.jst.ws.jaxws.core", JAXWSCoreMessages.TYPE_NAME_DIFFERENT_CASE_EXISTS);
                }
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log(ce.getStatus());
            }
        }
        return Status.OK_STATUS;
    }

    public static String getClassName(String projectName, String fullyQualifiedClassName) {
        return JDTUtils.getType(JDTUtils.getJavaProject(projectName), fullyQualifiedClassName).getElementName();
    }

    public static IJavaProject getJavaProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject;
    }

    public static IJavaProject getJavaProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return JDTUtils.getJavaProject(project);
    }

    public static String getJavaProjectOutputDirectoryPath(IJavaProject javaProject) {
        String fullPath = "";
        try {
            IPath outputPath = javaProject.getOutputLocation();
            fullPath = ResourcesPlugin.getWorkspace().getRoot().findMember(outputPath).getLocation().toOSString();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
        return fullPath;
    }

    public static String getJavaProjectOutputDirectoryPath(String projectName) {
        return JDTUtils.getJavaProjectOutputDirectoryPath(JDTUtils.getJavaProject(projectName));
    }

    public static String getJavaProjectSourceDirectoryPath(IJavaProject javaProject, String fullyQualifiedClassName) {
        IType type = JDTUtils.getType(javaProject, fullyQualifiedClassName);
        IPackageFragment packageFragment = type.getPackageFragment();
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getParent();
        IResource srcDirectoryResource = packageFragmentRoot.getResource();
        return srcDirectoryResource.getFullPath().toOSString();
    }

    public static String getJavaProjectSourceDirectoryPath(String projectName, String fullyQualifiedClassName) {
        return JDTUtils.getJavaProjectSourceDirectoryPath(JDTUtils.getJavaProject(projectName), fullyQualifiedClassName);
    }

    public static String getJavaProjectSourceDirectoryPath(String projectName) {
        return JDTUtils.getJavaProjectSourceDirectoryPath(JDTUtils.getJavaProject(projectName));
    }

    public static String getJavaProjectSourceDirectoryPath(IProject project) {
        return JDTUtils.getJavaProjectSourceDirectoryPath(JDTUtils.getJavaProject(project));
    }

    public static String getJavaProjectSourceDirectoryPath(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[0];
            IResource srcDirectoryResource = packageFragmentRoot.getResource();
            return srcDirectoryResource.getFullPath().toOSString();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return "";
        }
    }

    public static String getPackageNameFromClass(IJavaProject javaProject, String fullyQualifiedClassName) {
        return JDTUtils.getType(javaProject, fullyQualifiedClassName).getPackageFragment().getElementName();
    }

    public static String getPackageNameFromClass(String projectName, String fullyQualifiedClassName) {
        return JDTUtils.getPackageNameFromClass(JDTUtils.getJavaProject(projectName), fullyQualifiedClassName);
    }

    public static IMethod[] getPublicMethods(IType type) {
        ArrayList<IMethod> publicMethods = new ArrayList<IMethod>();
        try {
            IMethod[] allMethods = type.getMethods();
            if (type.isInterface()) {
                return allMethods;
            }
            int i = 0;
            while (i < allMethods.length) {
                IMethod method = allMethods[i];
                if (Flags.isPublic((int)method.getFlags()) && !method.isConstructor() && !method.isMainMethod()) {
                    publicMethods.add(method);
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
        return publicMethods.toArray(new IMethod[publicMethods.size()]);
    }

    public static String getSourceFromType(IType type) {
        try {
            return type.getCompilationUnit().getBuffer().getContents();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return "";
        }
    }

    public static String getTargetNamespaceFromPackageName(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return "http://default_package/";
        }
        List<String> namespaceElements = Arrays.asList(packageName.split("\\."));
        Collections.reverse(namespaceElements);
        String targetNamespace = "http://";
        Iterator<String> namespaceIterator = namespaceElements.iterator();
        while (namespaceIterator.hasNext()) {
            String element = namespaceIterator.next();
            if (element.trim().length() <= 0) continue;
            targetNamespace = String.valueOf(targetNamespace) + element;
            if (!namespaceIterator.hasNext()) continue;
            targetNamespace = String.valueOf(targetNamespace) + ".";
        }
        targetNamespace = String.valueOf(targetNamespace) + "/";
        return targetNamespace;
    }

    public static IType getType(IJavaProject javaProject, String fullyQualifiedClassName) {
        try {
            return javaProject.findType(fullyQualifiedClassName);
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return null;
        }
    }

    public static IType getType(IProject project, String fullyQualifiedClassName) {
        return JDTUtils.getType(JDTUtils.getJavaProject(project), fullyQualifiedClassName);
    }

    public static IType getType(String projectName, String fullyQualifiedClassName) {
        return JDTUtils.getType(JDTUtils.getJavaProject(projectName), fullyQualifiedClassName);
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ce) {
            JAXWSCorePlugin.log(ce.getStatus());
            return false;
        }
    }

    public static boolean isPublicMethod(IMethod method) {
        try {
            return Flags.isPublic((int)method.getFlags()) && !method.isConstructor() && !method.isMainMethod();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return false;
        }
    }

    public static IStatus validateJavaTypeName(String compilationUnitName) {
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        return JavaConventions.validateJavaTypeName((String)compilationUnitName, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validateJavaTypeName(String projectName, String compilationUnitName) {
        IJavaProject javaProject = JDTUtils.getJavaProject(projectName);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateJavaTypeName((String)compilationUnitName, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validatePackageName(String projectName, String packageName) {
        IJavaProject javaProject = JDTUtils.getJavaProject(projectName);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validatePackageName((String)packageName, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validateIdentifier(String id) {
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        return JavaConventions.validateIdentifier((String)id, (String)sourceLevel, (String)complianceLevel);
    }

    public static ICompilationUnit getCompilationUnitFromFile(IFile file) {
        IProject project = file.getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IPackageFragmentRoot[] packageFragmentRoots;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int n = packageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (packageFragmentRoot.getKind() == 1) {
                        IJavaElement[] packageFragments;
                        IJavaElement[] iJavaElementArray = packageFragments = packageFragmentRoot.getChildren();
                        int n3 = packageFragments.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement javaElement = iJavaElementArray[n4];
                            if (javaElement.getElementType() == 4) {
                                ICompilationUnit[] compilationUnits;
                                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                                ICompilationUnit[] iCompilationUnitArray = compilationUnits = packageFragment.getCompilationUnits();
                                int n5 = compilationUnits.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    ICompilationUnit compilationUnit = iCompilationUnitArray[n6];
                                    if (compilationUnit.getPath().equals((Object)file.getFullPath())) {
                                        return compilationUnit;
                                    }
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
        catch (CoreException ce) {
            JAXWSCorePlugin.log(ce.getStatus());
        }
        return null;
    }

    public static CompilationUnit getCompilationUnit(ICompilationUnit source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        compilationUnit.recordModifications();
        return compilationUnit;
    }
}

