/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import javax.jws.WebService;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicePublicAbstractFinalRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            TypeDeclaration typeDeclaration;
            if (!(declaration instanceof TypeDeclaration)) continue;
            Collection modifiers = declaration.getModifiers();
            if (modifiers.contains(Modifier.FINAL) || modifiers.contains(Modifier.ABSTRACT) || !modifiers.contains(Modifier.PUBLIC)) {
                Collection annotationMirrors = declaration.getAnnotationMirrors();
                for (AnnotationMirror mirror : annotationMirrors) {
                    if (!mirror.getAnnotationType().toString().equals(annotationDeclaration.getQualifiedName())) continue;
                    this.printFixableError(declaration.getPosition(), JAXWSCoreMessages.WEBSERVICE_PUBLIC_ABSTRACT_FINAL);
                }
            }
            if ((typeDeclaration = (TypeDeclaration)declaration).getNestedTypes().size() <= 0) continue;
            this.testNestedTypes(typeDeclaration.getNestedTypes(), annotationDeclaration);
        }
    }

    private void testNestedTypes(Collection<TypeDeclaration> nestedTypes, AnnotationTypeDeclaration annotationDeclaration) {
        for (TypeDeclaration nestedDeclaration : nestedTypes) {
            Collection annotationMirrors = nestedDeclaration.getAnnotationMirrors();
            for (AnnotationMirror mirror : annotationMirrors) {
                if (!mirror.getAnnotationType().toString().equals(annotationDeclaration.getQualifiedName())) continue;
                this.printError(mirror.getPosition(), JAXWSCoreMessages.WEBSERVICE_PUBLIC_ABSTRACT_FINAL);
            }
        }
    }
}

