/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.WebMethod;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class WebMethodExcludeRuleOnSEITest
extends AbstractAnnotationValidationTest {
    protected Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair excludeValuePair = AnnotationsCore.createBooleanMemberValuePair((AST)this.ast, (String)"exclude", (Object)Boolean.TRUE);
        memberValuePairs.add(excludeValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebMethod.class, (String)WebMethod.class.getSimpleName(), memberValuePairs);
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"MyInterface\")\n");
        classContents.append("public interface MyClass {\n\n\tpublic String myMethod();\n}");
        return classContents.toString();
    }

    protected String getClassName() {
        return "MyClass.java";
    }

    protected String getPackageName() {
        return "com.example";
    }

    public void testWebMethodExcludeRuleOnInterface() {
        try {
            WebMethodExcludeRuleOnSEITest.assertNotNull((Object)this.annotation);
            WebMethodExcludeRuleOnSEITest.assertEquals((String)WebMethod.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("myMethod", new String[0]);
            WebMethodExcludeRuleOnSEITest.assertNotNull((Object)method);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebMethod.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToMethod((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IMethod)method, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            WebMethodExcludeRuleOnSEITest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            WebMethodExcludeRuleOnSEITest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            WebMethodExcludeRuleOnSEITest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            WebMethodExcludeRuleOnSEITest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            WebMethodExcludeRuleOnSEITest.assertEquals((Object)JAXWSCoreMessages.WEBMETHOD_EXCLUDE_NOT_ALLOWED_ON_SEI, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            WebMethodExcludeRuleOnSEITest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            WebMethodExcludeRuleOnSEITest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            WebMethodExcludeRuleOnSEITest.fail((String)ie.getLocalizedMessage());
        }
    }
}

