/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.facet;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.SessionConfig;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.ws.internal.cxf.core.CXFCoreMessages;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CXFFacetInstallDelegate
implements IDelegate {
    public void execute(final IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IClasspathAttribute[] iClasspathAttributeArray;
        if (CXFCorePlugin.getDefault().getJava2WSContext().getCxfRuntimeLocation().equals("")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.cxf.core", CXFCoreMessages.CXF_FACET_INSTALL_DELEGATE_RUNTIME_LOCATION_NOT_SET));
        }
        Path cxfLibPath = new Path(CXFCorePlugin.getDefault().getJava2WSContext().getCxfRuntimeLocation());
        if (!cxfLibPath.hasTrailingSeparator()) {
            cxfLibPath = cxfLibPath.addTrailingSeparator();
        }
        cxfLibPath = cxfLibPath.append("lib");
        IClasspathAttribute jstComponentDependency = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)"/WEB-INF/lib");
        Path path = new Path("org.eclipse.jst.ws.cxf.core.CXF_CLASSPATH_CONTAINER");
        IAccessRule[] iAccessRuleArray = new IAccessRule[]{};
        if (CXFCorePlugin.getDefault().getJava2WSContext().isExportCXFClasspathContainer()) {
            IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
            iClasspathAttributeArray = iClasspathAttributeArray2;
            iClasspathAttributeArray2[0] = jstComponentDependency;
        } else {
            iClasspathAttributeArray = new IClasspathAttribute[]{};
        }
        IClasspathEntry cxfClasspathContainer = JavaCore.newContainerEntry((IPath)path, (IAccessRule[])iAccessRuleArray, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)true);
        JDTUtils.addToClasspath((IJavaProject)JavaCore.create((IProject)project), (IClasspathEntry)cxfClasspathContainer);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        provider.modify(new Runnable(){

            public void run() {
                Object modelProvider = provider.getModelObject();
                boolean useSpringAppContext = CXFCorePlugin.getDefault().getJava2WSContext().isUseSpringApplicationContext();
                if (modelProvider instanceof WebApp) {
                    WebApp javaeeWebApp = (WebApp)modelProvider;
                    CXFFacetInstallDelegate.this.addCXFJSTWEB25Servlet(project, javaeeWebApp);
                    if (useSpringAppContext) {
                        CXFFacetInstallDelegate.this.addSpringApplicationContextWeb25(project, javaeeWebApp);
                    }
                }
                if (modelProvider instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelProvider;
                    CXFFacetInstallDelegate.this.addCXFJSTWEB24Servlet(project, webApp);
                    if (useSpringAppContext) {
                        CXFFacetInstallDelegate.this.addSpringApplicationContextWeb24(project, webApp);
                    }
                }
            }
        }, null);
        if (CXFCorePlugin.getDefault().getJava2WSContext().isAnnotationProcessingEnabled()) {
            AptConfig.setEnabled((IJavaProject)JavaCore.create((IProject)project), (boolean)true);
        }
    }

    private void addSpringApplicationContextWeb24(IProject webProject, org.eclipse.jst.j2ee.webapplication.WebApp webapp) {
        EList contextParams = webapp.getContextParams();
        int i = 0;
        while (i < contextParams.size()) {
            ContextParam contextParam = (ContextParam)contextParams.get(i);
            if (contextParam.getParamName().equals("contextConfigLocation")) {
                return;
            }
            ++i;
        }
        EList listeners = webapp.getListeners();
        int i2 = 0;
        while (i2 < listeners.size()) {
            Listener contextLoaderListener = (Listener)listeners.get(i2);
            if (contextLoaderListener.getListenerClass().getName().equals("org.springframework.web.context.ContextLoaderListener")) {
                return;
            }
            ++i2;
        }
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        JavaRefFactory javaRefFactory = JavaRefFactory.eINSTANCE;
        ParamValue configLocationParam = commonFactory.createParamValue();
        configLocationParam.setName("contextConfigLocation");
        configLocationParam.setValue("WEB-INF/beans.xml");
        webapp.getContextParams().add((Object)configLocationParam);
        Listener contextLoaderListener = commonFactory.createListener();
        JavaClass javaClass = javaRefFactory.createJavaClass();
        javaClass.setName("org.springframework.web.context.ContextLoaderListener");
        contextLoaderListener.setListenerClass(javaClass);
        webapp.getListeners().add((Object)contextLoaderListener);
    }

    private void addSpringApplicationContextWeb25(IProject webProject, WebApp webapp) {
        List contextParams = webapp.getContextParams();
        int i = 0;
        while (i < contextParams.size()) {
            org.eclipse.jst.javaee.core.ParamValue contextParam = (org.eclipse.jst.javaee.core.ParamValue)contextParams.get(i);
            if (contextParam.getParamName().equals("contextConfigLocation")) {
                return;
            }
            ++i;
        }
        List listeners = webapp.getListeners();
        int i2 = 0;
        while (i2 < listeners.size()) {
            org.eclipse.jst.javaee.core.Listener contextLoaderListener = (org.eclipse.jst.javaee.core.Listener)listeners.get(i2);
            if (contextLoaderListener.getListenerClass().equals("org.springframework.web.context.ContextLoaderListener")) {
                return;
            }
            ++i2;
        }
        JavaeeFactory javaeeFactory = JavaeeFactory.eINSTANCE;
        org.eclipse.jst.javaee.core.ParamValue configLocationParam = javaeeFactory.createParamValue();
        configLocationParam.setParamName("contextConfigLocation");
        configLocationParam.setParamValue("WEB-INF/beans.xml");
        webapp.getContextParams().add(configLocationParam);
        org.eclipse.jst.javaee.core.Listener contextLoaderListener = javaeeFactory.createListener();
        contextLoaderListener.setListenerClass("org.springframework.web.context.ContextLoaderListener");
        webapp.getListeners().add(contextLoaderListener);
    }

    private void addCXFJSTWEB24Servlet(IProject webProject, org.eclipse.jst.j2ee.webapplication.WebApp webapp) {
        EList servlets = webapp.getServlets();
        int i = 0;
        while (i < servlets.size()) {
            Servlet servlet = (Servlet)servlets.get(i);
            if (servlet.getServletName().equals("cxf")) {
                return;
            }
            ++i;
        }
        WebapplicationFactory factory = WebapplicationFactory.eINSTANCE;
        Servlet cxfServlet = factory.createServlet();
        ServletType servletType = factory.createServletType();
        cxfServlet.setWebType((WebType)servletType);
        cxfServlet.setServletName("cxf");
        servletType.setClassName("org.apache.cxf.transport.servlet.CXFServlet");
        cxfServlet.setDisplayName("cxf");
        cxfServlet.setLoadOnStartup(Integer.valueOf(1));
        webapp.getServlets().add((Object)cxfServlet);
        org.eclipse.jst.j2ee.webapplication.ServletMapping servletMapping = factory.createServletMapping();
        servletMapping.setServlet(cxfServlet);
        servletMapping.setUrlPattern("/services/*");
        webapp.getServletMappings().add((Object)servletMapping);
        SessionConfig sessionConfig = factory.createSessionConfig();
        sessionConfig.setSessionTimeout(60);
        webapp.setSessionConfig(sessionConfig);
    }

    private void addCXFJSTWEB25Servlet(IProject webProject, WebApp webapp) {
        List servlets = webapp.getServlets();
        int i = 0;
        while (i < servlets.size()) {
            org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)servlets.get(i);
            if (servlet.getServletName().equals("cxf")) {
                return;
            }
            ++i;
        }
        WebFactory factory = WebFactory.eINSTANCE;
        org.eclipse.jst.javaee.web.Servlet cxfServlet = factory.createServlet();
        cxfServlet.setServletName("cxf");
        DisplayName cxfServletDisplayName = JavaeeFactory.eINSTANCE.createDisplayName();
        cxfServletDisplayName.setValue("cxf");
        cxfServlet.getDisplayNames().add(cxfServletDisplayName);
        Description cxfServletDescription = JavaeeFactory.eINSTANCE.createDescription();
        cxfServletDescription.setValue("Apache CXF Endpoint");
        cxfServlet.getDescriptions().add(cxfServletDescription);
        cxfServlet.setServletClass("org.apache.cxf.transport.servlet.CXFServlet");
        cxfServlet.setLoadOnStartup((Object)1);
        webapp.getServlets().add(cxfServlet);
        ServletMapping cxfServletMapping = factory.createServletMapping();
        cxfServletMapping.setServletName("cxf");
        UrlPatternType url = JavaeeFactory.eINSTANCE.createUrlPatternType();
        url.setValue("/services/*");
        cxfServletMapping.getUrlPatterns().add(url);
        webapp.getServletMappings().add(cxfServletMapping);
        org.eclipse.jst.javaee.web.SessionConfig sessionConfig = factory.createSessionConfig();
        sessionConfig.setSessionTimeout(new BigInteger("60"));
        webapp.getSessionConfigs().add(sessionConfig);
    }
}

