/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.context;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.wst.command.internal.env.context.PersistentContext;

public abstract class CXFPersistentContext
extends PersistentContext
implements CXFContext {
    private static final String PREFERENCE_CXF_RUNTIME_LOCATION = "cxfRuntimeLocation";
    private static final String PREFERENCE_CXF_RUNTIME_EDITION = "cxfRuntimeEdition";
    private static final String PREFERENCE_CXF_RUNTIME_VERSION = "cxfRuntimeVersion";
    private static final String PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER = "exportCXFClasspathContainer";
    private static final String PREFERENCE_CXF_VERBOSE = "cxfVerbose";
    private static final String PREFERENCE_CXF_USE_SPRING_APP_CONTEXT = "cxfUseSpringAppContext";

    public CXFPersistentContext(Plugin plugin) {
        super((Plugin)CXFCorePlugin.getDefault());
    }

    public void load() {
        this.setDefault(PREFERENCE_CXF_RUNTIME_LOCATION, "");
        this.setDefault(PREFERENCE_CXF_RUNTIME_EDITION, "");
        this.setDefault(PREFERENCE_CXF_RUNTIME_VERSION, "");
        this.setDefault(PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER, CXFModelUtils.getDefaultBooleanValue(0, 10));
        this.setDefault(PREFERENCE_CXF_VERBOSE, CXFModelUtils.getDefaultBooleanValue(0, 3));
        this.setDefault(PREFERENCE_CXF_USE_SPRING_APP_CONTEXT, CXFModelUtils.getDefaultBooleanValue(0, 9));
    }

    public String getCxfRuntimeLocation() {
        return this.getValueAsString(PREFERENCE_CXF_RUNTIME_LOCATION);
    }

    public void setCxfRuntimeLocation(String runtimeLocation) {
        this.setValue(PREFERENCE_CXF_RUNTIME_LOCATION, runtimeLocation);
    }

    public String getCxfRuntimeEdition() {
        return this.getValueAsString(PREFERENCE_CXF_RUNTIME_EDITION);
    }

    public void setCxfRuntimeEdition(String runtimeEdition) {
        this.setValue(PREFERENCE_CXF_RUNTIME_EDITION, runtimeEdition);
    }

    public String getCxfRuntimeVersion() {
        return this.getValueAsString(PREFERENCE_CXF_RUNTIME_VERSION);
    }

    public void setCxfRuntimeVersion(String runtimeVersion) {
        this.setValue(PREFERENCE_CXF_RUNTIME_VERSION, runtimeVersion);
    }

    public boolean isExportCXFClasspathContainer() {
        return this.getValueAsBoolean(PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER);
    }

    public void setExportCXFClasspathContainer(boolean exportCXFClasspathContainer) {
        this.setValue(PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER, exportCXFClasspathContainer);
    }

    public boolean isVerbose() {
        return this.getValueAsBoolean(PREFERENCE_CXF_VERBOSE);
    }

    public void setVerbose(boolean verbose) {
        this.setValue(PREFERENCE_CXF_VERBOSE, true);
    }

    public boolean isUseSpringApplicationContext() {
        return this.getValueAsBoolean(PREFERENCE_CXF_USE_SPRING_APP_CONTEXT);
    }

    public void setUseSpringApplicationContext(boolean useSpringAppContext) {
        this.setValue(PREFERENCE_CXF_USE_SPRING_APP_CONTEXT, useSpringAppContext);
    }
}

