/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.BuildBeanCommand;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.command.StartServerCommand;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class GSTCLaunchCommand
extends AbstractDataModelOperation {
    public static String INPUT = "Input.jsp";
    public static String TEST_CLIENT = "TestClient.jsp";
    public static String RESULT = "Result.jsp";
    public static String METHOD = "Method.jsp";
    private TestInfo testInfo;
    private String jspfolder;

    public GSTCLaunchCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        this.setJSPFolder();
        return this.launchSample(env, monitor);
    }

    private void setJSPFolder() {
        IProject clientIProject = ProjectUtilities.getProject((String)this.testInfo.getClientProject());
        if (clientIProject != null && !J2EEUtils.isWebComponent((IProject)clientIProject)) {
            IProject project = ProjectUtilities.getProject((String)this.testInfo.getGenerationProject());
            IPath path = J2EEUtils.getWebContentPath((IProject)project);
            int index = this.testInfo.getJspFolder().lastIndexOf("/");
            String jsp = this.testInfo.getJspFolder().substring(index + 1);
            StringBuffer sb = new StringBuffer();
            sb.append("/").append(path.toString()).append("/").append(jsp);
            this.jspfolder = sb.toString();
        } else {
            this.jspfolder = this.testInfo.getJspFolder();
        }
    }

    /*
     * Loose catch block
     */
    private IStatus launchSample(IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        Path fDestinationFolderPath = new Path(this.jspfolder);
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        IProject sampleProject = ProjectUtilities.getProject((String)this.testInfo.getGenerationProject());
        BuildBeanCommand buildCommand = new BuildBeanCommand();
        buildCommand.setEnvironment(env);
        buildCommand.setProject(sampleProject);
        try {
            buildCommand.execute(monitor, null);
        }
        catch (ExecutionException executionException) {}
        StartServerCommand serverCommand = new StartServerCommand(true);
        serverCommand.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
        serverCommand.setEnvironment(env);
        status = serverCommand.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        String newPath = ServerUtils.getWebComponentURL((IProject)sampleProject, (String)this.testInfo.getClientServerTypeID(), (IServer)this.testInfo.getClientExistingServer());
        int count = J2EEUtils.getWebContentPath((IProject)sampleProject).segmentCount();
        newPath = String.valueOf(newPath) + "/" + fDestinationFolderPath.removeFirstSegments(count);
        StringBuffer urlString = new StringBuffer(String.valueOf(newPath) + "/" + TEST_CLIENT);
        if (this.testInfo.getEndpoint() != null && !this.testInfo.getEndpoint().isEmpty()) {
            urlString.append("?endpoint=");
            urlString.append(this.testInfo.getEndpoint().get(0).toString());
        }
        try {
            URL url = new URL(urlString.toString());
            InputStream resultStream = null;
            InputStream methodStream = null;
            InputStream inputStream = null;
            InputStream clientStream = null;
            int retries = 0;
            while (retries < 10) {
                resultStream = new URL(String.valueOf(newPath) + "/" + RESULT).openStream();
                methodStream = new URL(String.valueOf(newPath) + "/" + METHOD).openStream();
                inputStream = new URL(String.valueOf(newPath) + "/" + INPUT).openStream();
                clientStream = new URL(String.valueOf(newPath) + "/" + TEST_CLIENT).openStream();
                try {
                    if (resultStream != null) {
                        resultStream.close();
                    }
                    if (methodStream != null) {
                        methodStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (clientStream == null) break;
                    clientStream.close();
                }
                catch (IOException iOException) {}
                break;
                catch (IOException iOException) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable throwable) {
                        try {
                            if (resultStream != null) {
                                resultStream.close();
                            }
                            if (methodStream != null) {
                                methodStream.close();
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (clientStream != null) {
                                clientStream.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        if (resultStream != null) {
                            resultStream.close();
                        }
                        if (methodStream != null) {
                            methodStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (clientStream != null) {
                            clientStream.close();
                        }
                    }
                    catch (IOException iOException3) {}
                }
                ++retries;
            }
            IWorkbenchBrowserSupport browserSupport = WebServiceConsumptionUIPlugin.getInstance().getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(2, null, null, null);
            browser.openURL(url);
            return status;
        }
        catch (PartInitException exc) {
            env.getLog().log(4, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = StatusUtils.errorStatus((String)exc.getMessage(), (Throwable)exc);
            env.getStatusHandler().reportError(status);
            return status;
        }
        catch (MalformedURLException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = StatusUtils.warningStatus((String)ConsumptionUIMessages.MSG_ERROR_MALFORMED_URL, (Throwable)exc);
            try {
                env.getStatusHandler().report(status);
            }
            catch (StatusException e) {
                status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_MALFORMED_URL, (Throwable)e);
            }
            return status;
        }
    }
}

