/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat32Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat40Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat41Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat50Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat55Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat60Handler;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.VerifyResourceSpec;

public class TomcatPlugin
extends Plugin {
    protected static TomcatPlugin singleton;
    public static final String PLUGIN_ID = "org.eclipse.jst.server.tomcat.core";
    public static final String TOMCAT_32 = "org.eclipse.jst.server.tomcat.32";
    public static final String TOMCAT_40 = "org.eclipse.jst.server.tomcat.40";
    public static final String TOMCAT_41 = "org.eclipse.jst.server.tomcat.41";
    public static final String TOMCAT_50 = "org.eclipse.jst.server.tomcat.50";
    public static final String TOMCAT_55 = "org.eclipse.jst.server.tomcat.55";
    public static final String TOMCAT_60 = "org.eclipse.jst.server.tomcat.60";
    protected static final String VERIFY_INSTALL_FILE = "verifyInstall.properties";
    protected static VerifyResourceSpec[] verify32;
    protected static VerifyResourceSpec[] verify40;
    protected static VerifyResourceSpec[] verify41;
    protected static VerifyResourceSpec[] verify50;
    protected static VerifyResourceSpec[] verify55;
    protected static VerifyResourceSpec[] verify60;
    protected static final IStatus emptyInstallDirStatus;
    protected static final IStatus wrongDirVersionStatus;
    protected static final IStatus installDirDoesNotExist;

    static {
        emptyInstallDirStatus = new Status(4, PLUGIN_ID, 0, Messages.errorInstallDirEmpty, null);
        wrongDirVersionStatus = new Status(4, PLUGIN_ID, 0, Messages.errorInstallDirWrongVersion, null);
        installDirDoesNotExist = new Status(4, PLUGIN_ID, 0, Messages.errorInstallDirDoesNotExist, null);
    }

    public TomcatPlugin() {
        singleton = this;
    }

    public static TomcatPlugin getInstance() {
        return singleton;
    }

    public static String getPreference(String id) {
        return TomcatPlugin.getInstance().getPluginPreferences().getString(id);
    }

    public static void setPreference(String id, String value) {
        TomcatPlugin.getInstance().getPluginPreferences().setValue(id, value);
        TomcatPlugin.getInstance().savePluginPreferences();
    }

    public static void log(IStatus status) {
        TomcatPlugin.getInstance().getLog().log(status);
    }

    protected static String getTomcatStateLocation() {
        try {
            return TomcatPlugin.getInstance().getStateLocation().toOSString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ITomcatVersionHandler getTomcatVersionHandler(String id) {
        if (id.indexOf("runtime") > 0) {
            id = String.valueOf(id.substring(0, 30)) + id.substring(38);
        }
        if (TOMCAT_32.equals(id)) {
            return new Tomcat32Handler();
        }
        if (TOMCAT_40.equals(id)) {
            return new Tomcat40Handler();
        }
        if (TOMCAT_41.equals(id)) {
            return new Tomcat41Handler();
        }
        if (TOMCAT_50.equals(id)) {
            return new Tomcat50Handler();
        }
        if (TOMCAT_55.equals(id)) {
            return new Tomcat55Handler();
        }
        if (TOMCAT_60.equals(id)) {
            return new Tomcat60Handler();
        }
        return null;
    }

    public static void loadVerifyFiles() {
        if (verify32 != null) {
            return;
        }
        verify32 = new VerifyResourceSpec[0];
        verify40 = new VerifyResourceSpec[0];
        verify41 = new VerifyResourceSpec[0];
        verify50 = new VerifyResourceSpec[0];
        verify55 = new VerifyResourceSpec[0];
        verify60 = new VerifyResourceSpec[0];
        try {
            URL url = TomcatPlugin.getInstance().getBundle().getEntry(VERIFY_INSTALL_FILE);
            url = FileLocator.resolve((URL)url);
            Properties p = new Properties();
            p.load(url.openStream());
            String verify = System.getProperty("org.eclipse.jst.server.tomcat.core.verify32install");
            if (verify == null) {
                verify = p.getProperty("verify32install");
            }
            verify.replace('/', File.separatorChar);
            StringTokenizer st = new StringTokenizer(verify, ",");
            ArrayList<VerifyResourceSpec> list = new ArrayList<VerifyResourceSpec>();
            while (st.hasMoreTokens()) {
                list.add(new VerifyResourceSpec(st.nextToken()));
            }
            Trace.trace((byte)3, "Verify32: " + ((Object)list).toString());
            verify32 = new VerifyResourceSpec[list.size()];
            list.toArray(verify32);
            verify = System.getProperty("org.eclipse.jst.server.tomcat.core.verify40install");
            if (verify == null) {
                verify = p.getProperty("verify40install");
            }
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(new VerifyResourceSpec(st.nextToken()));
            }
            Trace.trace((byte)3, "Verify40: " + ((Object)list).toString());
            verify40 = new VerifyResourceSpec[list.size()];
            list.toArray(verify40);
            verify = System.getProperty("org.eclipse.jst.server.tomcat.core.verify41install");
            if (verify == null) {
                verify = p.getProperty("verify41install");
            }
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(new VerifyResourceSpec(st.nextToken()));
            }
            Trace.trace((byte)3, "Verify41: " + ((Object)list).toString());
            verify41 = new VerifyResourceSpec[list.size()];
            list.toArray(verify41);
            verify = System.getProperty("org.eclipse.jst.server.tomcat.core.verify50install");
            if (verify == null) {
                verify = p.getProperty("verify50install");
            }
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(new VerifyResourceSpec(st.nextToken()));
            }
            Trace.trace((byte)3, "Verify50: " + ((Object)list).toString());
            verify50 = new VerifyResourceSpec[list.size()];
            list.toArray(verify50);
            verify = System.getProperty("org.eclipse.jst.server.tomcat.core.verify55install");
            if (verify == null) {
                verify = p.getProperty("verify55install");
            }
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(new VerifyResourceSpec(st.nextToken()));
            }
            Trace.trace((byte)3, "Verify55: " + ((Object)list).toString());
            verify55 = new VerifyResourceSpec[list.size()];
            list.toArray(verify55);
            verify = System.getProperty("org.eclipse.jst.server.tomcat.core.verify60install");
            if (verify == null) {
                verify = p.getProperty("verify60install");
            }
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(new VerifyResourceSpec(st.nextToken()));
            }
            Trace.trace((byte)3, "Verify60: " + ((Object)list).toString());
            verify60 = new VerifyResourceSpec[list.size()];
            list.toArray(verify60);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not load installation verification properties", e);
        }
    }

    public static IStatus verifyInstallPathWithFolderCheck(IPath installPath, String id) {
        IStatus status = TomcatPlugin.verifyTomcatVersionFromPath(installPath, id);
        if (status.isOK()) {
            status = TomcatPlugin.verifyInstallPath(installPath, id);
        }
        return status;
    }

    public static IStatus verifyInstallPath(IPath installPath, String id) {
        if (installPath == null) {
            return emptyInstallDirStatus;
        }
        String dir = installPath.toOSString();
        if (dir.trim().length() == 0) {
            return emptyInstallDirStatus;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return installDirDoesNotExist;
        }
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        TomcatPlugin.loadVerifyFiles();
        VerifyResourceSpec[] specs = null;
        if (TOMCAT_32.equals(id)) {
            specs = verify32;
        } else if (TOMCAT_40.equals(id)) {
            specs = verify40;
        } else if (TOMCAT_41.equals(id)) {
            specs = verify41;
        } else if (TOMCAT_50.equals(id)) {
            specs = verify50;
        } else if (TOMCAT_55.equals(id)) {
            specs = verify55;
        } else if (TOMCAT_60.equals(id)) {
            specs = verify60;
        } else {
            return new Status(4, PLUGIN_ID, 0, Messages.errorUnknownVersion, null);
        }
        int i = 0;
        while (i < specs.length) {
            VerifyResourceSpec fs = specs[i];
            IStatus status = fs.checkResource(dir);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static IStatus verifyTomcatVersionFromPath(IPath installPath, String version) {
        if (version == null) {
            return new Status(4, PLUGIN_ID, 0, Messages.errorVersionEmpty, null);
        }
        if (installPath == null) {
            return emptyInstallDirStatus;
        }
        String s = installPath.lastSegment();
        if (s == null) {
            return Status.OK_STATUS;
        }
        if (s.indexOf("-3.2") > 0 || s.indexOf(" 3.2") > 0) {
            return TOMCAT_32.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-4.0") > 0 || s.indexOf(" 4.0") > 0) {
            return TOMCAT_40.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-4.1") > 0 || s.indexOf(" 4.1") > 0) {
            return TOMCAT_41.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-5.0") > 0 || s.indexOf(" 5.0") > 0) {
            return TOMCAT_50.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-5.5") > 0 || s.indexOf(" 5.5") > 0) {
            return TOMCAT_55.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-6.0") > 0 || s.indexOf(" 6.0") > 0) {
            return TOMCAT_60.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        return Status.OK_STATUS;
    }

    protected static File getPlugin() {
        try {
            URL installURL = TomcatPlugin.getInstance().getBundle().getEntry("/");
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void log(String message) {
        TomcatPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void log(Throwable e) {
        TomcatPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getMessage(), e));
    }
}

