/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class ArithmeticMultiplyTestCase
extends SingleJSPTestCase {
    public ArithmeticMultiplyTestCase() {
        super("/testdata/jsps/arithmeticMultiply.jsp.data", "/WEB-INF/arithmeticMultiply.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        super.testSanity();
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.integerProperty * 3", (String)ELAssert.getELText(this._structuredDocument, 828));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.stringProperty * 3", (String)ELAssert.getELText(this._structuredDocument, 887));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.integerProperty * myBean.integerProperty", (String)ELAssert.getELText(this._structuredDocument, 945));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.bigIntegerProperty * 4", (String)ELAssert.getELText(this._structuredDocument, 1025));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.bigIntegerProperty * 5.5", (String)ELAssert.getELText(this._structuredDocument, 1087));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.bigDoubleProperty * 5.5", (String)ELAssert.getELText(this._structuredDocument, 1151));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.doubleProperty * 5", (String)ELAssert.getELText(this._structuredDocument, 1214));
        ArithmeticMultiplyTestCase.assertEquals((String)"5 * 3", (String)ELAssert.getELText(this._structuredDocument, 1302));
        ArithmeticMultiplyTestCase.assertEquals((String)"5.5 * 4", (String)ELAssert.getELText(this._structuredDocument, 1337));
        ArithmeticMultiplyTestCase.assertEquals((String)"5.5 * null", (String)ELAssert.getELText(this._structuredDocument, 1374));
        ArithmeticMultiplyTestCase.assertEquals((String)"'5' * '4'", (String)ELAssert.getELText(this._structuredDocument, 1417));
        ArithmeticMultiplyTestCase.assertEquals((String)"null * null", (String)ELAssert.getELText(this._structuredDocument, 1459));
        ArithmeticMultiplyTestCase.assertEquals((String)"5.5 * 3.5", (String)ELAssert.getELText(this._structuredDocument, 1504));
        ArithmeticMultiplyTestCase.assertEquals((String)"5 * true", (String)ELAssert.getELText(this._structuredDocument, 1567));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.integerProperty * myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1605));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.stringArrayProperty * myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1682));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.integerProperty * true ", (String)ELAssert.getELText(this._structuredDocument, 1766));
        ArithmeticMultiplyTestCase.assertEquals((String)"'a' * 'b'", (String)ELAssert.getELText(this._structuredDocument, 1829));
        ArithmeticMultiplyTestCase.assertEquals((String)"myBean.bigIntegerProperty * true", (String)ELAssert.getELText(this._structuredDocument, 1871));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "J");
        this.assertNoError(887, "J");
        this.assertNoError(945, "J");
        this.assertNoError(1025, "Ljava.math.BigInteger;");
        this.assertNoError(1087, "Ljava.math.BigDecimal;");
        this.assertNoError(1151, "Ljava.math.BigDecimal;");
        this.assertNoError(1214, "D");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1302, "J", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1337, "D", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1374, "D", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1417, "J", 1);
        ELAssert.assertContainsProblem(list, 3);
        list = this.assertSemanticWarning(1459, "J", 1);
        ELAssert.assertContainsProblem(list, 0);
        list = this.assertSemanticWarning(1504, "D", 1);
        ELAssert.assertContainsProblem(list, 3);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(1567, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1605, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1682, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1766, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(1829, null, 1);
        ELAssert.assertContainsProblem(list, 9);
        list = this.assertSemanticError(1871, null, 1);
        ELAssert.assertContainsProblem(list, 2);
    }
}

