/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.base;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.JSPTestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleJSPTestCase
extends JSPTestCase {
    public static final String FACES_CONFIG_FILE_NAME_1_1 = "/testdata/web/faces-config_1_1.xml.data";
    public static final String FACES_CONFIG_FILE_NAME_1_2 = "/testdata/web/faces-config_1_2.xml.data";
    protected IFile _testJSP;
    protected IStructuredModel _structuredModel;
    protected IStructuredDocument _structuredDocument;
    private final String _srcFileName;
    protected final String _destFileName;

    protected SingleJSPTestCase(String srcFileName, String destFileName, JSFVersion defaultJSFVersion, String defaultFacesConfigFile) {
        super(defaultJSFVersion, defaultFacesConfigFile);
        this._srcFileName = srcFileName;
        this._destFileName = destFileName;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this._testJSP = this.loadJSP(this._srcFileName, this._destFileName);
        this._structuredModel = StructuredModelManager.getModelManager().getModelForRead(this._testJSP);
        this._structuredDocument = this._structuredModel.getStructuredDocument();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._structuredModel != null) {
            this._structuredModel.releaseFromRead();
        }
    }

    public abstract void testNoErrorExprs();

    public abstract void testWarningExprs();

    public abstract void testErrorExprs();

    protected void assertNoError(int docPos, String expectedSignature) {
        ELAssert.assertNoError(this._structuredDocument, this._symbolResolverFactory, docPos, this._testJSP, expectedSignature);
    }

    protected void assertNoError(int docPos, String expectedSignature, int assignability) {
        ELAssert.assertNoError(this._structuredDocument, this._symbolResolverFactory, docPos, this._testJSP, expectedSignature, assignability);
    }

    protected List<MockValidationReporter.ReportedProblem> assertSyntaxError(int docPos, int expectedProblems) {
        return ELAssert.assertSyntaxError(this._structuredDocument, this._symbolResolverFactory, docPos, this._testJSP, expectedProblems);
    }

    protected List<MockValidationReporter.ReportedProblem> assertSyntaxWarning(int docPos, int expectedProblems) {
        return ELAssert.assertSyntaxWarning(this._structuredDocument, this._symbolResolverFactory, docPos, this._testJSP, expectedProblems);
    }

    protected List<MockValidationReporter.ReportedProblem> assertSemanticError(int docPos, String expectedSignature, int expectedProblems) {
        return ELAssert.assertSemanticError(this._structuredDocument, this._symbolResolverFactory, docPos, this._testJSP, expectedSignature, expectedProblems);
    }

    protected List<MockValidationReporter.ReportedProblem> assertSemanticWarning(int docPos, String expectedSignature, int expectedProblems) {
        return ELAssert.assertSemanticWarning(this._structuredDocument, this._symbolResolverFactory, docPos, this._testJSP, expectedSignature, expectedProblems);
    }
}

