/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IHandlerTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IJSFTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.analyzer.TagAnalyzer;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.BaseTestClass;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.TestUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;

public class TestTagAnalyzer
extends BaseTestClass {
    private TLDElementDeclaration _inputTextTag;
    private TLDElementDeclaration _commandButtonTag;
    private TLDElementDeclaration _convertDateTimeTag;
    private TLDElementDeclaration _validateLongRangeTag;
    private TLDElementDeclaration _facetTag;

    protected void setUp() throws Exception {
        super.setUp();
        ITaglibRecord coreTags = (ITaglibRecord)this._tagRecords.get("http://java.sun.com/jsf/core");
        ITaglibRecord htmlTags = (ITaglibRecord)this._tagRecords.get("http://java.sun.com/jsf/html");
        this._convertDateTimeTag = TestUtil.getTag(coreTags, "convertDateTime");
        this._validateLongRangeTag = TestUtil.getTag(coreTags, "validateLongRange");
        this._facetTag = TestUtil.getTag(coreTags, "facet");
        this._inputTextTag = TestUtil.getTag(htmlTags, "inputText");
        this._commandButtonTag = TestUtil.getTag(htmlTags, "commandButton");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFindComponentType() {
        String componentType = TagAnalyzer.findComponentType((TLDElementDeclaration)this._inputTextTag, (IProject)this._webProjectTestEnv.getTestProject());
        TestTagAnalyzer.assertEquals((String)"javax.faces.HtmlInputText", (String)componentType);
    }

    public void testCreateTLDTagElement() {
        IProject project = this._webProjectTestEnv.getTestProject();
        this.verifyCommandButton((IComponentTagElement)TagAnalyzer.createTLDTagElement((TLDElementDeclaration)this._commandButtonTag, (IProject)project));
        this.verifyCommandButton((IComponentTagElement)TagAnalyzer.createTLDTagElement((TLDElementDeclaration)this._commandButtonTag, (IProject)project));
        this.verifyFacetHandler((IHandlerTagElement)TagAnalyzer.createTLDTagElement((TLDElementDeclaration)this._facetTag, (IProject)project));
    }

    public void testCreateComponentTagElement() {
        TLDTagElement tagElement = TagAnalyzer.createComponentTagElement((TLDElementDeclaration)this._commandButtonTag, (IProject)this._webProjectTestEnv.getTestProject());
        TestTagAnalyzer.assertNotNull((Object)tagElement);
        TestTagAnalyzer.assertTrue((boolean)(tagElement instanceof IComponentTagElement));
        this.verifyCommandButton((IComponentTagElement)tagElement);
    }

    private void verifyCommandButton(IComponentTagElement componentTagElement) {
        TestTagAnalyzer.assertEquals((Object)IJSFTagElement.TagType.COMPONENT, (Object)componentTagElement.getType());
        ComponentTypeInfo componentTypeInfo = componentTagElement.getComponent();
        TestTagAnalyzer.assertEquals((String)"javax.faces.component.html.HtmlCommandButton", (String)componentTypeInfo.getClassName());
        TestTagAnalyzer.assertEquals((String)"javax.faces.HtmlCommandButton", (String)componentTypeInfo.getComponentType());
        TestTagAnalyzer.assertEquals((String)"javax.faces.Command", (String)componentTypeInfo.getComponentFamily());
        new Exception("TODO: derive renderer type from configuration files where possible").printStackTrace(System.err);
    }

    public void testCreateHandlerTagElement() throws Exception {
        IType type = JavaCore.create((IProject)this._webProjectTestEnv.getTestProject()).findType(this._facetTag.getTagclass());
        TLDTagElement tagElement = TagAnalyzer.createHandlerTagElement((TLDElementDeclaration)this._facetTag, (IType)type);
        TestTagAnalyzer.assertNotNull((Object)tagElement);
        TestTagAnalyzer.assertTrue((boolean)(tagElement instanceof IHandlerTagElement));
        this.verifyFacetHandler((IHandlerTagElement)tagElement);
    }

    private void verifyFacetHandler(IHandlerTagElement tagElement) {
        TestTagAnalyzer.assertEquals((Object)IHandlerTagElement.TagHandlerType.FACET, (Object)tagElement.getTagHandlerType());
    }

    public void testGetJSFComponentTagType() throws Exception {
        String inputTextTagClass = this._inputTextTag.getTagclass();
        IType tagClassType = JavaCore.create((IProject)this._webProjectTestEnv.getTestProject()).findType(inputTextTagClass);
        TestTagAnalyzer.assertEquals((Object)IJSFTagElement.TagType.COMPONENT, (Object)TagAnalyzer.getJSFComponentTagType((IType)tagClassType, (IProject)this._webProjectTestEnv.getTestProject()));
        String validateLongRangeTagClass = this._validateLongRangeTag.getTagclass();
        tagClassType = JavaCore.create((IProject)this._webProjectTestEnv.getTestProject()).findType(validateLongRangeTagClass);
        TestTagAnalyzer.assertEquals((Object)IJSFTagElement.TagType.VALIDATOR, (Object)TagAnalyzer.getJSFComponentTagType((IType)tagClassType, (IProject)this._webProjectTestEnv.getTestProject()));
        String converterDateTimeTagClass = this._convertDateTimeTag.getTagclass();
        tagClassType = JavaCore.create((IProject)this._webProjectTestEnv.getTestProject()).findType(converterDateTimeTagClass);
        TestTagAnalyzer.assertEquals((Object)IJSFTagElement.TagType.CONVERTER, (Object)TagAnalyzer.getJSFComponentTagType((IType)tagClassType, (IProject)this._webProjectTestEnv.getTestProject()));
        ITaglibRecord coreTags = (ITaglibRecord)this._tagRecords.get("http://java.sun.com/jsf/core");
        TLDElementDeclaration loadBundleTag = TestUtil.getTag(coreTags, "loadBundle");
        TestTagAnalyzer.assertNotNull((Object)loadBundleTag);
        String loadBundleTagClass = loadBundleTag.getTagclass();
        IType tagClassType2 = JavaCore.create((IProject)this._webProjectTestEnv.getTestProject()).findType(loadBundleTagClass);
        TestTagAnalyzer.assertNull((Object)TagAnalyzer.getJSFComponentTagType((IType)tagClassType2, (IProject)this._webProjectTestEnv.getTestProject()));
    }
}

