/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

abstract class BaseTestClass
extends TestCase {
    protected WebProjectTestEnvironment _webProjectTestEnv;
    protected Map<String, ITaglibRecord> _tagRecords;
    protected JSFVersion _jsfVersion;
    private final String ENV_JSF_VERSION = "jsfRuntimeVersion";

    BaseTestClass() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        String version = System.getProperty("jsfRuntimeVersion");
        if (version == null) {
            BaseTestClass.fail((String)"No version specified in jsfRuntimeVersion");
        }
        this._jsfVersion = JSFVersion.valueOfString((String)version);
        BaseTestClass.assertTrue((this._jsfVersion == JSFVersion.V1_1 || this._jsfVersion == JSFVersion.V1_2 ? 1 : 0) != 0);
        BaseTestClass.assertNotNull((Object)JSFCoreUtilHelper.getJSFRuntimeJarsDirectory((JSFVersion)this._jsfVersion));
        String jst_web_version = this._jsfVersion == JSFVersion.V1_1 ? "2.4" : (this._jsfVersion == JSFVersion.V1_2 ? "2.5" : null);
        BaseTestClass.assertNotNull((Object)jst_web_version);
        String jst_jsf_version = this._jsfVersion.toString();
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName(), JavaFacetUtils.JAVA_50, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion(jst_web_version));
        this._webProjectTestEnv.createProject(false);
        BaseTestClass.assertNotNull((Object)this._webProjectTestEnv);
        BaseTestClass.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        BaseTestClass.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacetedTestEnv = new JSFFacetedTestEnvironment(this._webProjectTestEnv);
        jsfFacetedTestEnv.initialize(jst_jsf_version);
        BaseTestClass.assertTrue((boolean)JSFCoreUtilHelper.addJSFRuntimeJarsToClasspath((JSFVersion)this._jsfVersion, (JSFFacetedTestEnvironment)jsfFacetedTestEnv));
        ITaglibRecord[] tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)this._webProjectTestEnv.getTestProject().getFullPath());
        this._tagRecords = new HashMap<String, ITaglibRecord>();
        ITaglibRecord[] iTaglibRecordArray = tldrecs;
        int n = tldrecs.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord taglibRecord = iTaglibRecordArray[n2];
            this._tagRecords.put(taglibRecord.getDescriptor().getURI(), taglibRecord);
            ++n2;
        }
        BaseTestClass.assertNotNull((Object)this._tagRecords.get("http://java.sun.com/jsf/core"));
        BaseTestClass.assertNotNull((Object)this._tagRecords.get("http://java.sun.com/jsf/html"));
    }
}

