/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.symbols.DefaultBeanSymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.osgi.framework.Bundle;

public class TestDefaultBeanSymbolSourceProvider
extends TestCase {
    private JDTTestEnvironment _jdtTestEnvironment;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private IFile _facesConfigFile;
    private static final String SRC_FOLDER_NAME = "src";
    private static final String PACKAGE_NAME = "com.test";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestDefaultBeanSymbolSourceProvider_" + this.getName());
        projectTestEnvironment.createProject(false);
        this._facesConfigFile = (IFile)projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/faces-config.xml.data", "/WEB-INF/faces-config.xml");
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        JSFTestUtil.loadSourceClass((Bundle)TestsPlugin.getDefault().getBundle(), (String)"/testfiles/TestBean1.java.data", (String)"TestBean1", (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSanity() {
        DefaultBeanSymbolSourceProvider provider = DefaultBeanSymbolSourceProvider.getInstance();
        ISymbol[] symbol = provider.getSymbols((IAdaptable)this._facesConfigFile, 15);
        TestDefaultBeanSymbolSourceProvider.assertNotNull((Object)symbol);
        TestDefaultBeanSymbolSourceProvider.assertEquals((String)"Check that test suite is in sync with setup()", (int)symbol.length, (int)4);
    }

    public void testAllScopes() {
        String[] names = new String[]{"myBean_request", "myBean_session", "myBean_application", "myBean_none"};
        this.testScopeBeans(15, names.length, names);
    }

    public void testOnlyRequestBeans() {
        String[] names = new String[]{"myBean_request"};
        this.testScopeBeans(1, names.length, names);
    }

    public void testOnlySessionBeans() {
        String[] names = new String[]{"myBean_session"};
        this.testScopeBeans(2, names.length, names);
    }

    public void testOnlyApplicationBeans() {
        String[] names = new String[]{"myBean_application"};
        this.testScopeBeans(4, names.length, names);
    }

    public void testOnlyNoneBeans() {
        String[] names = new String[]{"myBean_none"};
        this.testScopeBeans(8, names.length, names);
    }

    private void testScopeBeans(int scope, int expectedSize, String[] expectedNames) {
        DefaultBeanSymbolSourceProvider provider = DefaultBeanSymbolSourceProvider.getInstance();
        ISymbol[] symbols = provider.getSymbols((IAdaptable)this._facesConfigFile, scope);
        TestDefaultBeanSymbolSourceProvider.assertEquals((int)expectedSize, (int)symbols.length);
        int j = 0;
        while (j < expectedNames.length) {
            String expectedName = expectedNames[j];
            TestDefaultBeanSymbolSourceProvider.assertNotNull((Object)expectedName);
            boolean found = false;
            int i = 0;
            while (i < symbols.length) {
                if (expectedName.equals(symbols[i].getName())) {
                    found = true;
                    break;
                }
                ++i;
            }
            TestDefaultBeanSymbolSourceProvider.assertTrue((boolean)found);
            ++j;
        }
    }

    public void testPrefixSearch() {
        DefaultBeanSymbolSourceProvider provider = DefaultBeanSymbolSourceProvider.getInstance();
        ISymbol[] symbols = provider.getSymbols("myBean_n", (IAdaptable)this._facesConfigFile, 15);
        TestDefaultBeanSymbolSourceProvider.assertEquals((int)1, (int)symbols.length);
        TestDefaultBeanSymbolSourceProvider.assertEquals((String)"myBean_none", (String)symbols[0].getName());
    }

    public void testGetSymbolByName() {
        this.testGetSymbolByName("myBean_none");
        this.testGetSymbolByName("myBean_application");
        this.testGetSymbolByName("myBean_session");
        this.testGetSymbolByName("myBean_request");
    }

    private void testGetSymbolByName(String expectedName) {
        DefaultBeanSymbolSourceProvider provider = DefaultBeanSymbolSourceProvider.getInstance();
        ISymbol symbol = provider.getSymbol(expectedName, (IAdaptable)this._facesConfigFile, 15);
        TestDefaultBeanSymbolSourceProvider.assertNotNull((Object)symbol);
        TestDefaultBeanSymbolSourceProvider.assertEquals((String)expectedName, (String)symbol.getName());
    }
}

