/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ImmutableLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.context.AbstractDTExternalContextFactory;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.context.IExternalContextFactoryLocator;
import org.eclipse.jst.jsf.designtime.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.designtime.internal.BasicExtensionFactory;
import org.eclipse.jst.jsf.designtime.internal.view.AbstractDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.osgi.framework.Bundle;

public final class DesignTimeApplicationManager {
    private static final String SETTINGS_DIR_NAME = ".settings";
    private static final String ORG_ECLIPSE_JST_JSF_DESIGNTIME_APPMGR_PREFS = "org.eclipse.jst.jsf.designtime.appmgr.prefs";
    private static final String PROPERTY_QUALIFIER = "org.eclipse.jst.jsf.designtime.internal";
    private static final String SESSION_PROPERTY_NAME_PROJECT = "DesignTimeApplicationManager";
    private static final QualifiedName SESSION_PROPERTY_KEY_PROJECT = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "DesignTimeApplicationManager");
    private static final String PERSIST_PROPERTY_NAME_EXTERNAL_CONTEXT_PROVIDER = "ExternalContextProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "ExternalContextProvider");
    private static final String PERSIST_PROPERTY_NAME_VARIABLE_RESOLVER_PROVIDER = "VariableResolverProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "VariableResolverProvider");
    private static final String PERSIST_PROPERTY_NAME_PROPERTY_RESOLVER_PROVIDER = "PropertyResolverProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "PropertyResolverProvider");
    private static final String PERSIST_PROPERTY_NAME_METHOD_RESOLVER_PROVIDER = "MethodResolverProvider";
    private static final QualifiedName PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER = new QualifiedName("org.eclipse.jst.jsf.designtime.internal", "MethodResolverProvider");
    private static final String PERSIST_PROPERTY_NAME_VIEW_HANDLER = "ViewHandler";
    private static final String DEFAULT_EXTERNAL_CONTEXT_ID = "org.eclipse.jst.jsf.core.externalcontext.default";
    private static final String DEFAULT_VARIABLE_RESOLVER_ID = "org.eclipse.jst.jsf.core.variableresolver.default.decorative";
    private static final String DEFAULT_PROPERTY_RESOLVER_ID = "org.eclipse.jst.jsf.core.propertyresolver.default.decorative";
    private static final String DEFAULT_METHOD_RESOLVER_ID = "org.eclipse.jst.jsf.core.methodresolver.default";
    private static final String DEFAULT_VIEW_HANDLER_ID = "org.eclipse.jst.jsf.designtime.view.jspviewhandler";
    private static final Object GET_INSTANCE_LOCK = new Object();
    private final IProject _project;
    private final IExternalContextFactoryLocator _locator;
    private final LifecycleListener _lifecycleListener;
    private final AtomicBoolean _isDisposed;
    private final ViewHandlerManager _viewHandlerManager;
    private final Map<IFile, DTFacesContext> _facesContexts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DesignTimeApplicationManager getInstance(IProject project) {
        if (!DesignTimeApplicationManager.hasJSFDesignTime(project)) {
            return null;
        }
        try {
            Object object = GET_INSTANCE_LOCK;
            synchronized (object) {
                DesignTimeApplicationManager manager = (DesignTimeApplicationManager)project.getSessionProperty(SESSION_PROPERTY_KEY_PROJECT);
                if (manager != null && !project.equals((Object)manager._project)) {
                    if (!manager._isDisposed.get()) {
                        manager.dispose();
                    }
                    manager = null;
                }
                if (manager == null) {
                    manager = new DesignTimeApplicationManager(project);
                    project.setSessionProperty(SESSION_PROPERTY_KEY_PROJECT, (Object)manager);
                }
                return manager;
            }
        }
        catch (CoreException ce) {
            Platform.getLog((Bundle)JSFCorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, JSFCorePlugin.getDefault().getBundle().getSymbolicName(), 0, "Problem loading design time appmanager", (Throwable)new Exception(ce)));
            return null;
        }
    }

    private synchronized void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this.removeViewHandler();
            this._lifecycleListener.dispose();
            this._facesContexts.clear();
        }
    }

    public static boolean hasJSFDesignTime(IProject project) {
        return project != null && project.isAccessible() && JSFAppConfigUtils.isValidJSFProject(project);
    }

    private DesignTimeApplicationManager(IProject project) {
        this._project = project;
        this._locator = new MyExternalContextFactoryLocator();
        this._isDisposed = new AtomicBoolean();
        this._lifecycleListener = new LifecycleListener((IResource)this._project);
        this._lifecycleListener.addListener(new IResourceLifecycleListener(){

            public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
                if (event.getAffectedResource() == DesignTimeApplicationManager.this._project && event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE && event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED) {
                    DesignTimeApplicationManager.this.dispose();
                }
                return IResourceLifecycleListener.EventResult.getDefaultEventResult();
            }
        });
        PropertyFileManager properties = new PropertyFileManager(this._project);
        this._viewHandlerManager = new ViewHandlerManager(properties);
        this._facesContexts = new HashMap<IFile, DTFacesContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTFacesContext getFacesContext(IFile file) {
        this.checkIsDisposed();
        if (!this.hasDTFacesContext(file)) {
            return null;
        }
        Map<IFile, DTFacesContext> map = this._facesContexts;
        synchronized (map) {
            DTFacesContext context = this._facesContexts.get(file);
            if (context == null) {
                context = new DTFacesContext((IAdaptable)file, this._locator);
                context.initialize(this._lifecycleListener);
                this._facesContexts.put(file, context);
            }
            return context;
        }
    }

    public boolean hasDTFacesContext(IFile file) {
        this.checkIsDisposed();
        IDTViewHandler viewHandler = this.getViewHandler();
        return file != null && file.isAccessible() && viewHandler != null && viewHandler.supportsViewDefinition(file);
    }

    public IDTViewHandler getViewHandler() {
        this.checkIsDisposed();
        return this._viewHandlerManager.getViewHandler(this._project, this._lifecycleListener);
    }

    private void removeViewHandler() {
        this._viewHandlerManager.removeViewHandler(this._project);
    }

    public void setViewHandlerId(String viewHandlerId) {
        this.checkIsDisposed();
        this._viewHandlerManager.setViewHandlerId(this._project, viewHandlerId);
    }

    public synchronized void setExternalContextProvider(String resolverPluginId) throws CoreException {
        this.checkIsDisposed();
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER, resolverPluginId);
    }

    public synchronized String getExternalContextProvider() {
        this.checkIsDisposed();
        return this.getResolverId(PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER, DEFAULT_EXTERNAL_CONTEXT_ID);
    }

    public synchronized AbstractDTVariableResolver getVariableResolver() {
        this.checkIsDisposed();
        BasicExtensionFactory.ExtensionData<AbstractDTVariableResolver> extData = null;
        String id = this.getResolverId_OLD(PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER);
        if (id != null) {
            extData = JSFCorePlugin.getVariableResolvers(id);
        }
        if (extData == null) {
            extData = JSFCorePlugin.getVariableResolvers(DEFAULT_VARIABLE_RESOLVER_ID);
        }
        return extData.getInstance(this._project);
    }

    public synchronized void setVariableResolverProvider(String resolverPluginId) throws CoreException {
        this.checkIsDisposed();
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER, resolverPluginId);
    }

    public synchronized String getVariableResolverProvider() {
        this.checkIsDisposed();
        return this.getResolverId(PERSIST_PROPERTY_KEY_VARIABLE_RESOLVER_PROVIDER, DEFAULT_VARIABLE_RESOLVER_ID);
    }

    public synchronized AbstractDTPropertyResolver getDefaultPropertyResolver() {
        this.checkIsDisposed();
        return JSFCorePlugin.getPropertyResolver(DEFAULT_PROPERTY_RESOLVER_ID).getInstance(this._project);
    }

    public synchronized AbstractDTPropertyResolver getPropertyResolver() {
        this.checkIsDisposed();
        BasicExtensionFactory.ExtensionData<AbstractDTPropertyResolver> extData = null;
        String id = this.getResolverId_OLD(PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER);
        if (id != null) {
            extData = JSFCorePlugin.getPropertyResolver(id);
        }
        if (extData == null) {
            extData = JSFCorePlugin.getPropertyResolver(DEFAULT_PROPERTY_RESOLVER_ID);
        }
        return extData.getInstance(this._project);
    }

    public synchronized void setPropertyResolverProvider(String resolverPluginId) throws CoreException {
        this.checkIsDisposed();
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER, resolverPluginId);
    }

    public synchronized String getPropertyResolverProvider() {
        this.checkIsDisposed();
        return this.getResolverId(PERSIST_PROPERTY_KEY_PROPERTY_RESOLVER_PROVIDER, DEFAULT_PROPERTY_RESOLVER_ID);
    }

    public synchronized AbstractDTMethodResolver getMethodResolver() {
        this.checkIsDisposed();
        BasicExtensionFactory.ExtensionData<AbstractDTMethodResolver> extData = null;
        String id = this.getResolverId_OLD(PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER);
        if (id != null) {
            extData = JSFCorePlugin.getMethodResolvers(id);
        }
        if (extData == null) {
            extData = JSFCorePlugin.getMethodResolvers(DEFAULT_METHOD_RESOLVER_ID);
        }
        return extData.getInstance(this._project);
    }

    public synchronized void setMethodResolverProvider(String resolverPluginId) throws CoreException {
        this.checkIsDisposed();
        this._project.setPersistentProperty(PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER, resolverPluginId);
    }

    public synchronized String getMethodResolverProvider() {
        this.checkIsDisposed();
        return this.getResolverId(PERSIST_PROPERTY_KEY_METHOD_RESOLVER_PROVIDER, DEFAULT_METHOD_RESOLVER_ID);
    }

    private String getResolverId_OLD(QualifiedName pluginKey) {
        String pluginId = null;
        try {
            pluginId = this._project.getPersistentProperty(pluginKey);
        }
        catch (CoreException ce) {
            JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Error getting plugin property", (Throwable)ce));
            pluginId = null;
        }
        return pluginId;
    }

    private String getResolverId(QualifiedName key, String defaultValue) {
        String id = defaultValue;
        try {
            String userId = this._project.getPersistentProperty(key);
            if (userId != null) {
                id = userId;
            }
        }
        catch (CoreException coreException) {}
        return id;
    }

    private void checkIsDisposed() {
        if (this._isDisposed.get()) {
            JSFCorePlugin.log("A call to a disposed DesignTimeApplicationManager was attempted", new Throwable("This exception is only to record a stack trace"));
        }
    }

    private class MyExternalContextFactoryLocator
    implements IExternalContextFactoryLocator {
        private MyExternalContextFactoryLocator() {
        }

        public AbstractDTExternalContextFactory getFactory() {
            BasicExtensionFactory.ExtensionData<AbstractDTExternalContextFactory> extData = null;
            String id = DesignTimeApplicationManager.this.getResolverId_OLD(PERSIST_PROPERTY_KEY_EXTERNAL_CONTEXT_PROVIDER);
            if (id != null) {
                extData = JSFCorePlugin.getExternalContextProviders(id);
            }
            if (extData == null) {
                extData = JSFCorePlugin.getExternalContextProviders(DesignTimeApplicationManager.DEFAULT_EXTERNAL_CONTEXT_ID);
            }
            return extData.getInstance(DesignTimeApplicationManager.this._project);
        }
    }

    private static class PropertyFileManager {
        private final Properties _properties;
        private IProject _project;

        PropertyFileManager(IProject project) {
            this._project = project;
            this._properties = new Properties();
            PropertyFileManager.load(this._project, this._properties);
        }

        private synchronized IProject getProject() {
            return this._project;
        }

        public void setProperty(String key, String value) {
            this._properties.setProperty(key, value);
            this.store();
        }

        public String getProperty(String key, String defaultValue) {
            return this._properties.getProperty(key, defaultValue);
        }

        public void store() {
            IWorkspaceRunnable storeJob = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFile propFile = PropertyFileManager.getPropsFile(PropertyFileManager.this.getProject());
                        if (propFile != null) {
                            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                            PropertyFileManager.this._properties.store(outstream, null);
                            propFile.setContents((InputStream)new ByteArrayInputStream(outstream.toByteArray()), true, true, null);
                        }
                    }
                    catch (CoreException e) {
                        JSFCorePlugin.log((Exception)((Object)e), "Problem storing properties");
                    }
                    catch (IOException e) {
                        JSFCorePlugin.log(e, "Problem storing properties");
                    }
                }
            };
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                workspace.run(storeJob, (ISchedulingRule)this.getProject(), 1, null);
            }
            catch (CoreException ce) {
                JSFCorePlugin.log((Exception)((Object)ce), "Problem storing properties");
            }
        }

        private static void load(IProject project, Properties properties) {
            block7: {
                try {
                    IFile propFile = PropertyFileManager.getPropsFileHandle(project);
                    if (propFile == null || !propFile.isAccessible()) break block7;
                    InputStream inStream = null;
                    try {
                        inStream = propFile.getContents();
                        properties.load(inStream);
                    }
                    finally {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                }
                catch (CoreException ce) {
                    JSFCorePlugin.log((Exception)((Object)ce), "Problem loading properties");
                }
                catch (IOException ce) {
                    JSFCorePlugin.log(ce, "Problem loading properties");
                }
            }
        }

        private static IFile getPropsFile(IProject project) throws CoreException {
            IFile file;
            IFolder folder = project.getFolder((IPath)new Path(DesignTimeApplicationManager.SETTINGS_DIR_NAME));
            if (!folder.exists()) {
                folder.create(false, true, null);
            }
            if (!(file = folder.getFile((IPath)new Path(DesignTimeApplicationManager.ORG_ECLIPSE_JST_JSF_DESIGNTIME_APPMGR_PREFS))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
            }
            return file;
        }

        private static IFile getPropsFileHandle(IProject project) {
            return project.getFile(new Path(DesignTimeApplicationManager.SETTINGS_DIR_NAME).append(DesignTimeApplicationManager.ORG_ECLIPSE_JST_JSF_DESIGNTIME_APPMGR_PREFS));
        }
    }

    private static class ViewHandlerManager {
        private final PropertyFileManager _propertyFileManager;

        ViewHandlerManager(PropertyFileManager properties) {
            this._propertyFileManager = properties;
        }

        public synchronized void removeViewHandler(IProject project) {
            AbstractDTViewHandler handler;
            BasicExtensionFactory.ExtensionData<AbstractDTViewHandler> extData;
            String viewHandlerId = this._propertyFileManager.getProperty(DesignTimeApplicationManager.PERSIST_PROPERTY_NAME_VIEW_HANDLER, DesignTimeApplicationManager.DEFAULT_VIEW_HANDLER_ID);
            if (viewHandlerId != null && (extData = JSFCorePlugin.getViewHandlers(viewHandlerId)) != null && (handler = extData.removeInstance(project)) != null) {
                handler.dispose();
            }
        }

        public synchronized IDTViewHandler getViewHandler(IProject project, LifecycleListener listener) {
            String viewHandlerId = this._propertyFileManager.getProperty(DesignTimeApplicationManager.PERSIST_PROPERTY_NAME_VIEW_HANDLER, DesignTimeApplicationManager.DEFAULT_VIEW_HANDLER_ID);
            if (viewHandlerId != null) {
                BasicExtensionFactory.ExtensionData<AbstractDTViewHandler> viewHandlers = JSFCorePlugin.getViewHandlers(viewHandlerId);
                if (viewHandlers == null) {
                    viewHandlers = JSFCorePlugin.getViewHandlers(DesignTimeApplicationManager.DEFAULT_VIEW_HANDLER_ID);
                }
                AbstractDTViewHandler viewHandler = viewHandlers.getInstance(project);
                viewHandler.setLifecycleListener((ImmutableLifecycleListener)listener);
                return viewHandler;
            }
            return null;
        }

        public void setViewHandlerId(IProject project, String viewHandlerId) {
            this.removeViewHandler(project);
            this._propertyFileManager.setProperty(DesignTimeApplicationManager.PERSIST_PROPERTY_NAME_VIEW_HANDLER, viewHandlerId);
        }
    }
}

