/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.tests.model.component;

import java.util.List;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.FacetDecorator;
import org.eclipse.jst.jsf.common.runtime.tests.model.RuntimeTestUtil;
import org.eclipse.jst.jsf.common.runtime.tests.model.component.ComponentTestCase;

public class TestComponentInfo
extends ComponentTestCase {
    protected ComponentTypeInfo _componentTypeInfo;
    private ComponentInfo _componentInfo;

    protected void setUp() throws Exception {
        super.setUp();
        this._componentTypeInfo = RuntimeTestUtil.createComponentTypeInfo();
        this._componentInfo = ComponentFactory.createComponentInfo((String)"id", null, (ComponentTypeInfo)this._componentTypeInfo, (boolean)true);
    }

    public void testToString() {
        System.out.println(this.getComponentInfo().toString());
    }

    protected ComponentInfo getComponentInfo() {
        return this._componentInfo;
    }

    public void testGetId() {
        TestComponentInfo.assertEquals((String)"id", (String)this.getComponentInfo().getId());
    }

    public void testGetComponentTypeInfo() {
        TestComponentInfo.assertEquals((Object)this._componentTypeInfo, (Object)this.getComponentInfo().getComponentTypeInfo());
    }

    public void testIsRendered() {
        TestComponentInfo.assertTrue((boolean)this.getComponentInfo().isRendered());
    }

    public void testChildren() {
        TestComponentInfo.assertTrue((boolean)this.getComponentInfo().getChildren().isEmpty());
        ComponentInfo componentInfo = ComponentFactory.createComponentInfo((String)"id2", (ComponentInfo)this.getComponentInfo(), (ComponentTypeInfo)this._componentTypeInfo, (boolean)true);
        this.getComponentInfo().addChild(componentInfo);
        TestComponentInfo.assertEquals((int)1, (int)this.getComponentInfo().getChildren().size());
        RuntimeTestUtil.verifySame(componentInfo, (ComponentInfo)this.getComponentInfo().getChildren().get(0));
    }

    public void testFacet() {
        TestComponentInfo.assertTrue((boolean)this.getComponentInfo().getChildren().isEmpty());
        ComponentInfo componentInfo = ComponentFactory.createComponentInfo((String)"id2", (ComponentInfo)this.getComponentInfo(), (ComponentTypeInfo)this._componentTypeInfo, (boolean)true);
        this.getComponentInfo().addFacet("header", componentInfo);
        TestComponentInfo.assertEquals((int)1, (int)this.getComponentInfo().getChildren().size());
        RuntimeTestUtil.verifySame(componentInfo, (ComponentInfo)this.getComponentInfo().getChildren().get(0));
        TestComponentInfo.assertEquals((String)"header", (String)this.getComponentInfo().getFacetName(componentInfo));
        TestComponentInfo.assertEquals((Object)componentInfo, (Object)this.getComponentInfo().getFacet("header"));
        List facetDecorators = this.getComponentInfo().getDecorators(ComponentFactory.FACET);
        boolean hasFacet = false;
        for (FacetDecorator decorator : facetDecorators) {
            if (!"header".equals(decorator.getName())) continue;
            RuntimeTestUtil.verifySame(componentInfo, decorator.getDecorates());
            hasFacet = true;
            break;
        }
        TestComponentInfo.assertTrue((boolean)hasFacet);
        List useGetFacets = this.getComponentInfo().getFacets();
        TestComponentInfo.assertEquals((Object)facetDecorators, (Object)useGetFacets);
    }

    public void testGetParent() {
        ComponentInfo componentInfo = ComponentFactory.createComponentInfo((String)"id2", (ComponentInfo)this.getComponentInfo(), (ComponentTypeInfo)this._componentTypeInfo, (boolean)true);
        TestComponentInfo.assertEquals((Object)this.getComponentInfo(), (Object)componentInfo.getParent());
    }

    public void testSerializable() throws Exception {
        ComponentInfo child = ComponentFactory.createComponentInfo((String)"id2", (ComponentInfo)this.getComponentInfo(), (ComponentTypeInfo)this._componentTypeInfo, (boolean)true);
        this.getComponentInfo().addChild(child);
        ComponentInfo facet = ComponentFactory.createComponentInfo((String)"id3", (ComponentInfo)this.getComponentInfo(), (ComponentTypeInfo)this._componentTypeInfo, (boolean)true);
        this.getComponentInfo().addFacet("header", facet);
        ComponentInfo deserialized = RuntimeTestUtil.serializeDeserialize(this.getComponentInfo());
        RuntimeTestUtil.verifySame(this.getComponentInfo(), deserialized);
    }
}

