/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class ServerTargetUtil {
    private static final String defaultId = "com.ibm.etools.websphere.serverTarget.base.v51";
    private static final String defaultExpressId = "com.ibm.etools.websphere.serverTarget.express.v51";

    public static int findDefaultServerTargetIndex(List targets) {
        int index = 0;
        int i = 0;
        while (i < targets.size()) {
            IRuntime target = (IRuntime)targets.get(i);
            if (target.getId().equals(ServerTargetUtil.getDefaultServerTargetId())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static int findIndexOf(IRuntime target, List list) {
        int index = 0;
        if (target != null) {
            int i = 0;
            while (i < list.size()) {
                IRuntime element = (IRuntime)list.get(i);
                if (element.equals(target)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public static String getDefaultServerTargetId() {
        String id = defaultExpressId;
        if (J2EEPlugin.isEJBSupportAvailable()) {
            id = defaultId;
        }
        return id;
    }

    public static String getJ2EEVersion(boolean isJ2EE13) {
        return isJ2EE13 ? "1.3" : "1.2";
    }

    public static String[] getServerNames(List serverTargets) {
        String[] result = new String[serverTargets.size()];
        int i = 0;
        while (i < result.length) {
            IRuntime runtime = (IRuntime)serverTargets.get(i);
            result[i] = String.valueOf(runtime.getName()) + " (" + runtime.getRuntimeType().getName() + ")";
            ++i;
        }
        return result;
    }

    public static IRuntime getServerTarget(String prjName) {
        IProject prj;
        if (prjName != null && !prjName.trim().equals("") && (prj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName)) != null && prj.exists()) {
            return ServerCore.getProjectProperties((IProject)prj).getRuntimeTarget();
        }
        return null;
    }
}

