/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPropertyValueModelAdapter<T>
extends AspectPropertyValueModelAdapter<T> {
    protected final ListValueModel<?> listHolder;
    protected final ListChangeListener listChangeListener;

    protected ListPropertyValueModelAdapter(ListValueModel<?> listHolder) {
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                ListPropertyValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                ListPropertyValueModelAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                ListPropertyValueModelAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                ListPropertyValueModelAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListChangeEvent event) {
                ListPropertyValueModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListPropertyValueModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    @Override
    protected void engageModel_() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
    }

    @Override
    protected void disengageModel_() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.listHolder);
    }

    protected void itemsAdded(ListChangeEvent event) {
        this.propertyChanged();
    }

    protected void itemsRemoved(ListChangeEvent event) {
        this.propertyChanged();
    }

    protected void itemsReplaced(ListChangeEvent event) {
        this.propertyChanged();
    }

    protected void itemsMoved(ListChangeEvent event) {
        this.propertyChanged();
    }

    protected void listCleared(ListChangeEvent event) {
        this.propertyChanged();
    }

    protected void listChanged(ListChangeEvent event) {
        this.propertyChanged();
    }
}

