/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;
import java.util.EmptyStackException;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.internal.SimpleStack;
import org.eclipse.jpt.utility.internal.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedStack<E>
implements Stack<E>,
Serializable {
    private Stack<E> stack;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedStack(Stack<E> stack, Object mutex) {
        this.stack = stack;
        this.mutex = mutex;
    }

    public SynchronizedStack(Stack<E> stack) {
        this.stack = stack;
        this.mutex = this;
    }

    public SynchronizedStack(Object mutex) {
        this(new SimpleStack(), mutex);
    }

    public SynchronizedStack() {
        this(new SimpleStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(E o) {
        Object object = this.mutex;
        synchronized (object) {
            this.stack.push(o);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pop() {
        Object object = this.mutex;
        synchronized (object) {
            E o = this.stack.pop();
            this.mutex.notifyAll();
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean empty) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.isEmpty() != empty) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotEmpty() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToPush(E o) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmpty();
            this.push(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToPop() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotEmpty();
            return this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean empty, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (timeout != 0L) break block5;
                this.waitUntilEmptyIs(empty);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.isEmpty() != empty && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.isEmpty() == empty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmpty(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs(true, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs(false, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToPush(E o, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmpty(timeout);
            if (success) {
                this.push(o);
            }
            return success;
        }
    }

    public Object waitToPop(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilNotEmpty(timeout);
            if (success) {
                return this.pop();
            }
            throw new EmptyStackException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public Object mutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.toString();
        }
    }
}

