/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ReverseComparator;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseComparatorTests
extends TestCase {
    private Comparator<String> naturalReverseComparator;
    private Comparator<String> customComparator;
    private Comparator<String> customReverseComparator;

    public ReverseComparatorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.naturalReverseComparator = new ReverseComparator();
        this.customComparator = this.buildCustomComparator();
        this.customReverseComparator = new ReverseComparator(this.customComparator);
    }

    private Comparator<String> buildCustomComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                String lower2;
                String lower1 = s1.toLowerCase();
                int result = lower1.compareTo(lower2 = s2.toLowerCase());
                if (result == 0) {
                    return s1.compareTo(s2);
                }
                return result;
            }
        };
    }

    private List<String> buildUnsortedList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("T");
        result.add("Z");
        result.add("Y");
        result.add("M");
        result.add("m");
        result.add("a");
        result.add("B");
        result.add("b");
        result.add("A");
        return result;
    }

    private List<String> buildNaturallySortedList() {
        ArrayList<String> result = new ArrayList<String>(this.buildUnsortedList());
        Collections.sort(result);
        return result;
    }

    private List<String> buildCustomSortedList() {
        ArrayList<String> result = new ArrayList<String>(this.buildUnsortedList());
        Collections.sort(result, this.customComparator);
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNatural() {
        List<String> list = this.buildUnsortedList();
        Collections.sort(list, this.naturalReverseComparator);
        this.verifyList(this.buildNaturallySortedList(), list);
    }

    public void testCustom() {
        List<String> list = this.buildUnsortedList();
        Collections.sort(list, this.customReverseComparator);
        this.verifyList(this.buildCustomSortedList(), list);
    }

    private void verifyList(List<String> normal, List<String> reverse) {
        int size = normal.size();
        int max = size - 1;
        int i = 0;
        while (i < size) {
            ReverseComparatorTests.assertEquals((String)normal.get(i), (String)reverse.get(max - i));
            ++i;
        }
    }
}

