/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassToolsTests
extends TestCase {
    private static String testStaticField;

    public ClassToolsTests(String name) {
        super(name);
    }

    public static String compilerDependentClassNameFor(String className) {
        int index = className.indexOf("$1$");
        if (index == -1) {
            return className;
        }
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return String.valueOf(className.substring(0, index + 2)) + className.substring(index + 3);
        }
        return className;
    }

    private static String munge(String className) {
        return ClassToolsTests.compilerDependentClassNameFor(className);
    }

    public void testAllFields() {
        int fieldCount = 0;
        fieldCount += Vector.class.getDeclaredFields().length;
        fieldCount += AbstractList.class.getDeclaredFields().length;
        fieldCount += AbstractCollection.class.getDeclaredFields().length;
        Field[] fields = ClassTools.allFields(Vector.class);
        ClassToolsTests.assertEquals((int)(fieldCount += Object.class.getDeclaredFields().length), (int)fields.length);
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(fields), (Object)"modCount"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(fields), (Object)"serialVersionUID"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(fields), (Object)"capacityIncrement"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(fields), (Object)"elementCount"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(fields), (Object)"elementData"));
        ClassToolsTests.assertTrue((boolean)fields[0].isAccessible());
    }

    public void testAllMethods() {
        int methodCount = 0;
        methodCount += Vector.class.getDeclaredMethods().length;
        methodCount += AbstractList.class.getDeclaredMethods().length;
        methodCount += AbstractCollection.class.getDeclaredMethods().length;
        Method[] methods = ClassTools.allMethods(Vector.class);
        ClassToolsTests.assertEquals((int)(methodCount += Object.class.getDeclaredMethods().length), (int)methods.length);
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(methods), (Object)"wait"));
        ClassToolsTests.assertTrue((boolean)CollectionTools.contains(this.names(methods), (Object)"addElement"));
        ClassToolsTests.assertTrue((boolean)methods[0].isAccessible());
    }

    public void testNewInstanceClass() {
        Vector v = (Vector)ClassTools.newInstance(Vector.class);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
    }

    public void testNewInstanceClassClassObject() {
        int initialCapacity = 200;
        Vector v = (Vector)ClassTools.newInstance(Vector.class, Integer.TYPE, (Object)new Integer(initialCapacity));
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ClassTools.fieldValue((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassArrayObjectArray() {
        int initialCapacity = 200;
        Class[] parmTypes = new Class[]{Integer.TYPE};
        Object[] parms = new Object[]{new Integer(initialCapacity)};
        Vector v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ClassTools.fieldValue((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
        parms[0] = new Integer(-1);
        boolean exCaught = false;
        try {
            v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"RuntimeException not thrown", (boolean)exCaught);
        parmTypes[0] = String.class;
        parms[0] = "foo";
        exCaught = false;
        try {
            v = (Vector)ClassTools.attemptNewInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"NoSuchMethodException not thrown", (boolean)exCaught);
    }

    public void testFieldValue() {
        int initialCapacity = 200;
        Vector v = new Vector(initialCapacity);
        Object[] elementData = (Object[])ClassTools.fieldValue(v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
        Integer modCountInteger = (Integer)ClassTools.fieldValue(v, (String)"modCount");
        int modCount = modCountInteger;
        ClassToolsTests.assertEquals((int)0, (int)modCount);
        boolean exCaught = false;
        Object bogusFieldValue = null;
        try {
            bogusFieldValue = ClassTools.attemptToGetFieldValue(v, (String)"bogusField");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchFieldException not thrown: " + bogusFieldValue), (boolean)exCaught);
    }

    public void testExecuteMethodObjectString() {
        Vector<String> v = new Vector<String>();
        int size = (Integer)ClassTools.executeMethod(v, (String)"size");
        ClassToolsTests.assertEquals((int)0, (int)size);
        v.addElement("foo");
        size = (Integer)ClassTools.executeMethod(v, (String)"size");
        ClassToolsTests.assertEquals((int)1, (int)size);
    }

    public void testExecuteMethodObjectStringClassObject() {
        Vector v = new Vector();
        boolean booleanResult = (Boolean)ClassTools.executeMethod(v, (String)"add", Object.class, (Object)"foo");
        ClassToolsTests.assertTrue((boolean)booleanResult);
        ClassToolsTests.assertTrue((boolean)v.contains("foo"));
        Object voidResult = ClassTools.executeMethod(v, (String)"addElement", Object.class, (Object)"bar");
        ClassToolsTests.assertNull((Object)voidResult);
    }

    public void testExecuteMethodObjectStringClassArrayObjectArray() {
        Vector v = new Vector();
        Class[] parmTypes = new Class[]{Object.class};
        Object[] parms = new Object[]{"foo"};
        boolean booleanResult = (Boolean)ClassTools.executeMethod(v, (String)"add", (Class[])parmTypes, (Object[])parms);
        ClassToolsTests.assertTrue((boolean)booleanResult);
        ClassToolsTests.assertTrue((boolean)v.contains("foo"));
        boolean exCaught = false;
        Object bogusMethodReturnValue = null;
        try {
            bogusMethodReturnValue = ClassTools.attemptToExecuteMethod(v, (String)"bogusMethod", (Class[])parmTypes, (Object[])parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusMethodReturnValue), (boolean)exCaught);
    }

    public void testExecuteStaticMethodClassString() {
        Double randomObject = (Double)ClassTools.executeStaticMethod(Math.class, (String)"random");
        ClassToolsTests.assertNotNull((Object)randomObject);
        double random = randomObject;
        ClassToolsTests.assertTrue((random >= 0.0 ? 1 : 0) != 0);
        ClassToolsTests.assertTrue((random < 1.0 ? 1 : 0) != 0);
    }

    public void testExecuteStaticMethodClassStringClassObject() {
        String s = (String)ClassTools.executeStaticMethod(String.class, (String)"valueOf", Boolean.TYPE, (Object)Boolean.TRUE);
        ClassToolsTests.assertNotNull((Object)s);
        ClassToolsTests.assertEquals((String)"true", (String)s);
    }

    public void testExecuteStaticMethodClassStringClassArrayObjectArray() {
        Class[] parmTypes = new Class[]{Boolean.TYPE};
        Object[] parms = new Object[]{Boolean.TRUE};
        String s = (String)ClassTools.executeStaticMethod(String.class, (String)"valueOf", (Class[])parmTypes, (Object[])parms);
        ClassToolsTests.assertNotNull((Object)s);
        ClassToolsTests.assertEquals((String)"true", (String)s);
        boolean exCaught = false;
        Object bogusStaticMethodReturnValue = null;
        try {
            bogusStaticMethodReturnValue = ClassTools.attemptToExecuteStaticMethod(String.class, (String)"bogusStaticMethod", (Class[])parmTypes, (Object[])parms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
        exCaught = false;
        try {
            bogusStaticMethodReturnValue = ClassTools.attemptToExecuteStaticMethod(String.class, (String)"toString");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
    }

    public void testSetFieldValue() {
        Vector v = new Vector();
        Object[] newElementData = new Object[5];
        newElementData[0] = "foo";
        ClassTools.setFieldValue(v, (String)"elementData", (Object)newElementData);
        ClassTools.setFieldValue(v, (String)"elementCount", (Object)new Integer(1));
        ClassTools.setFieldValue(v, (String)"modCount", (Object)new Integer(1));
        ClassToolsTests.assertTrue((boolean)v.contains("foo"));
        boolean exCaught = false;
        try {
            ClassTools.attemptToSetFieldValue(v, (String)"bogusField", (Object)"foo");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testSetStaticFieldValue() {
        ClassTools.setStaticFieldValue(((Object)((Object)this)).getClass(), (String)"testStaticField", (Object)"new value");
        ClassToolsTests.assertEquals((String)testStaticField, (String)"new value");
        boolean exCaught = false;
        try {
            ClassTools.attemptToSetStaticFieldValue(((Object)((Object)this)).getClass(), (String)"bogusStaticField", (Object)"new value");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testShortName() {
        ClassToolsTests.assertEquals((String)"Vector", (String)ClassTools.shortClassNameForObject(new Vector()));
        ClassToolsTests.assertEquals((String)"Vector", (String)ClassTools.shortNameFor(Vector.class));
    }

    public void testNestedName() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Map.Entry entry = map.entrySet().iterator().next();
        ClassToolsTests.assertEquals((String)"Entry", (String)ClassTools.nestedClassNameForObject(entry));
        ClassToolsTests.assertEquals((String)"Entry", (String)ClassTools.nestedNameFor(Map.Entry.class));
    }

    public void testPackageName() {
        ClassToolsTests.assertEquals((String)"java.util", (String)ClassTools.packageNameFor(Vector.class));
        ClassToolsTests.assertEquals((String)"java.util", (String)ClassTools.packageNameFor(Map.Entry.class));
    }

    public void testArrayDepthFor() {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthFor(Vector.class));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthFor(Integer.TYPE));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthFor(Void.TYPE));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthFor(Vector[].class));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthFor(int[].class));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthFor(Vector[][][].class));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthFor(int[][][].class));
    }

    public void testArrayDepthForObject() {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForObject(new Vector()));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForObject((Object)new Vector[0]));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForObject((Object)new int[0]));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForObject((Object)new Vector[0][0][0]));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForObject((Object)new int[0][0][0]));
    }

    public void testArrayDepthForClassNamed() {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForClassNamed((String)Vector.class.getName()));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForClassNamed((String)Integer.TYPE.getName()));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForClassNamed((String)Void.TYPE.getName()));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForClassNamed((String)Vector[].class.getName()));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForClassNamed((String)int[].class.getName()));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForClassNamed((String)Vector[][][].class.getName()));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForClassNamed((String)int[][][].class.getName()));
    }

    public void testElementTypeFor() {
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementTypeFor(Vector.class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeFor(Integer.TYPE));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.elementTypeFor(Void.TYPE));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementTypeFor(Vector[].class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeFor(int[].class));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementTypeFor(Vector[][][].class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeFor(int[][][].class));
    }

    public void testElementTypeForObject() {
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementTypeForObject(new Vector()));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementTypeForObject((Object)new Vector[0]));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeForObject((Object)new int[0]));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementTypeForObject((Object)new Vector[0][0][0]));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementTypeForObject((Object)new int[0][0][0]));
    }

    public void testElementTypeNameFor() {
        ClassToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassTools.elementTypeNameFor(Vector.class));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameFor(Integer.TYPE));
        ClassToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassTools.elementTypeNameFor(Void.TYPE));
        ClassToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassTools.elementTypeNameFor(Vector[].class));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameFor(int[].class));
        ClassToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassTools.elementTypeNameFor(Vector[][][].class));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameFor(int[][][].class));
    }

    public void testElementTypeNameForClassNamed() {
        ClassToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Vector.class.getName()));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Integer.TYPE.getName()));
        ClassToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Void.TYPE.getName()));
        ClassToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Vector[].class.getName()));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)int[].class.getName()));
        ClassToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)Vector[][][].class.getName()));
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.elementTypeNameForClassNamed((String)int[][][].class.getName()));
    }

    public void testClassCodes() {
        ClassToolsTests.assertEquals((String)"byte", (String)ClassTools.classNameForCode((char)'B'));
        ClassToolsTests.assertEquals((String)"char", (String)ClassTools.classNameForCode((char)'C'));
        ClassToolsTests.assertEquals((String)"double", (String)ClassTools.classNameForCode((char)'D'));
        ClassToolsTests.assertEquals((String)"float", (String)ClassTools.classNameForCode((char)'F'));
        ClassToolsTests.assertEquals((String)"int", (String)ClassTools.classNameForCode((char)'I'));
        ClassToolsTests.assertEquals((String)"long", (String)ClassTools.classNameForCode((char)'J'));
        ClassToolsTests.assertEquals((String)"short", (String)ClassTools.classNameForCode((char)'S'));
        ClassToolsTests.assertEquals((String)"boolean", (String)ClassTools.classNameForCode((char)'Z'));
        ClassToolsTests.assertEquals((String)"void", (String)ClassTools.classNameForCode((char)'V'));
        boolean exCaught = false;
        try {
            ClassTools.classNameForCode((char)'X');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((String)"IllegalArgumentException not thrown", (boolean)exCaught);
    }

    public void testClassNamedIsTopLevel() throws Exception {
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsTopLevel((String)Map.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)Map.Entry.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsTopLevel((String)array.getClass().getName()));
    }

    public void testClassNamedIsMember() throws Exception {
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)Map.class.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)Map.Entry.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)array.getClass().getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$a1"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$a1$aaa$bbb"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$1a1$aaa"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$1a"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$a12345$b12345"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$12345a"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map$333"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsMember((String)"java.util.Map3$333"));
    }

    public void testClassNamedIsLocal() throws Exception {
        class LocalClass {
            LocalClass() {
            }

            void foo() {
                System.getProperty("foo");
            }
        }
        new LocalClass().foo();
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)Map.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)Map.Entry.class.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)array.getClass().getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$a1"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$a1$aaa$bbb"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$11$aaa"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$1$a"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2$abc"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2$abc1"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$1a"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2abc"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$2abc1"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$a12345$b12345"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$12345$a1234"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map$333"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsLocal((String)"java.util.Map3$333"));
    }

    public void testClassNamedIsAnonymous() throws Exception {
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)Map.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)Map.Entry.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass")).getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsAnonymous((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(ClassToolsTests.munge(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1$LocalClass"));
        array = (Object[])Array.newInstance(localClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)array.getClass().getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$a1"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$a1$aaa$bbb"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$1a1$aaa"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$1$a"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$1a"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$a12345$b12345"));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$12345$a1234"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map$333"));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsAnonymous((String)"java.util.Map3$333"));
    }

    public void testCodeForClass() {
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.codeForClass(Integer.TYPE));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.codeForClass(Byte.TYPE));
    }

    public void testCodeForClassNamed() {
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.codeForClassNamed((String)Integer.TYPE.getName()));
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.codeForClassNamed((String)"int"));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.codeForClassNamed((String)Byte.TYPE.getName()));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.codeForClassNamed((String)"byte"));
    }

    public void testClassIsPrimitiveWrapperClass() {
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsPrimitiveWrapperClass(Void.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsPrimitiveWrapperClass(Boolean.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsPrimitiveWrapperClass(Integer.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsPrimitiveWrapperClass(Float.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsPrimitiveWrapperClass(String.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsPrimitiveWrapperClass(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsPrimitiveWrapperClass(Integer.TYPE));
    }

    public void testClassIsVariablePrimitiveWrapperClass() {
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(Void.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(Boolean.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(Integer.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(Float.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(String.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.classIsVariablePrimitiveWrapperClass(Integer.TYPE));
    }

    public void testClassNamedIsPrimitive() {
        ClassToolsTests.assertTrue((boolean)Void.TYPE.isPrimitive());
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsPrimitive((String)Void.TYPE.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsPrimitive((String)Integer.TYPE.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsPrimitive((String)Float.TYPE.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsPrimitive((String)Boolean.TYPE.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsPrimitive((String)Number.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsPrimitive((String)String.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsPrimitive((String)Boolean.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsPrimitive((String)Integer.class.getName()));
    }

    public void testClassNamedIsVariablePrimitive() {
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitive((String)Void.TYPE.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsVariablePrimitive((String)Integer.TYPE.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsVariablePrimitive((String)Float.TYPE.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsVariablePrimitive((String)Boolean.TYPE.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitive((String)Number.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitive((String)String.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitive((String)Boolean.class.getName()));
    }

    public void testClassNamedIsVariablePrimitiveWrapperClass() {
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)Void.class.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)Integer.class.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)Float.class.getName()));
        ClassToolsTests.assertTrue((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)Boolean.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)Number.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)String.class.getName()));
        ClassToolsTests.assertFalse((boolean)ClassTools.classNamedIsVariablePrimitiveWrapperClass((String)Object.class.getName()));
    }

    public void testClassForTypeDeclarationStringInt() throws Exception {
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.classForTypeDeclaration((String)"int", (int)0));
        ClassToolsTests.assertEquals(int[].class, (Object)ClassTools.classForTypeDeclaration((String)"int", (int)1));
        ClassToolsTests.assertEquals(int[][][].class, (Object)ClassTools.classForTypeDeclaration((String)"int", (int)3));
        ClassToolsTests.assertEquals(Object.class, (Object)ClassTools.classForTypeDeclaration((String)"java.lang.Object", (int)0));
        ClassToolsTests.assertEquals(Object[][][].class, (Object)ClassTools.classForTypeDeclaration((String)"java.lang.Object", (int)3));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.classForTypeDeclaration((String)"void", (int)0));
        try {
            ClassTools.classForTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ClassToolsTests.fail((String)"should not get here...");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void testClassNameForTypeDeclarationString() throws Exception {
        ClassToolsTests.assertEquals((String)"int", (String)ClassTools.classNameForTypeDeclaration((String)"int"));
        ClassToolsTests.assertEquals((String)"[I", (String)ClassTools.classNameForTypeDeclaration((String)"int[]"));
        ClassToolsTests.assertEquals((String)"[[I", (String)ClassTools.classNameForTypeDeclaration((String)"int [ ] [ ]"));
        ClassToolsTests.assertEquals((String)"java.lang.Object", (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object"));
        ClassToolsTests.assertEquals((String)"[Ljava.lang.Object;", (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object\t[]"));
        ClassToolsTests.assertEquals((String)"[[Ljava.lang.Object;", (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object\t[]\t[]"));
    }

    public void testArrayDepthForTypeDeclarationString() throws Exception {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForTypeDeclaration((String)"java.lang.Object"));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForTypeDeclaration((String)"java.lang.Object[]"));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForTypeDeclaration((String)"java.lang.Object[][][]"));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForTypeDeclaration((String)"int"));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForTypeDeclaration((String)"int[]"));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForTypeDeclaration((String)"int[][][]"));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepthForTypeDeclaration((String)"float"));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepthForTypeDeclaration((String)"float [ ]"));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepthForTypeDeclaration((String)"float[] [] []"));
    }

    public void testElementTypeNameForTypeDeclarationString() throws Exception {
        ClassToolsTests.assertEquals((String)"java.lang.Object", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"java.lang.Object"));
        ClassToolsTests.assertEquals((String)"java.lang.Object", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"java.lang.Object[]"));
        ClassToolsTests.assertEquals((String)"java.lang.Object", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"java.lang.Object[][][]"));
        ClassToolsTests.assertEquals((String)"int", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"int"));
        ClassToolsTests.assertEquals((String)"int", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"int[]"));
        ClassToolsTests.assertEquals((String)"int", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"int[][][]"));
        ClassToolsTests.assertEquals((String)"float", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"float"));
        ClassToolsTests.assertEquals((String)"float", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"float [ ]"));
        ClassToolsTests.assertEquals((String)"float", (String)ClassTools.elementTypeNameForTypeDeclaration((String)"float[] [] []"));
    }

    public void testClassNameForTypeDeclarationStringInt() throws Exception {
        ClassToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"int", (int)0));
        ClassToolsTests.assertEquals((String)int[].class.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"int", (int)1));
        ClassToolsTests.assertEquals((String)int[][][].class.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"int", (int)3));
        ClassToolsTests.assertEquals((String)Object.class.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object", (int)0));
        ClassToolsTests.assertEquals((String)Object[][][].class.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"java.lang.Object", (int)3));
        ClassToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassTools.classNameForTypeDeclaration((String)"void", (int)0));
        try {
            ClassTools.classNameForTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ClassToolsTests.fail((String)"should not get here...");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private Iterator<String> names(Field[] fields) {
        return new TransformationIterator<Field, String>(CollectionTools.iterator((Object[])fields)){

            protected String transform(Field field) {
                return field.getName();
            }
        };
    }

    private Iterator<String> names(Method[] methods) {
        return new TransformationIterator<Method, String>(CollectionTools.iterator((Object[])methods)){

            protected String transform(Method method) {
                return method.getName();
            }
        };
    }
}

