/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitTestCase
extends ContextModelTestCase {
    protected EclipseLinkPersistenceUnit subject;
    protected PropertyValueModel<EclipseLinkPersistenceUnit> subjectHolder;
    protected PropertyChangeEvent propertyChangedEvent;
    protected int propertyChangedEventCount;
    protected int propertiesTotal;
    protected int modelPropertiesSizeOriginal;
    protected int modelPropertiesSize;

    protected PersistenceUnitTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject = this.getPersistenceUnit();
        this.subjectHolder = new SimplePropertyValueModel((Object)this.subject);
        this.populatePu();
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetDataModelProvider());
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)"org.eclipse.eclipselink.platform");
        dataModel.setProperty("JpaFacetDataModelProperties.CREATE_ORM_XML", (Object)Boolean.FALSE);
        return dataModel;
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    protected abstract PersistenceUnitProperties getModel();

    protected abstract void populatePu();

    protected abstract Object getProperty(String var1) throws Exception;

    protected abstract void setProperty(String var1, Object var2) throws Exception;

    protected String getEclipseLinkStringValueOf(Object value) {
        return EclipseLinkPersistenceUnitProperties.getEclipseLinkStringValueOf((Object)value);
    }

    protected void persistenceUnitSetProperty(String key, Object value) {
        this.persistenceUnitSetProperty(key, value, false);
    }

    protected void persistenceUnitSetProperty(String key, Object value, boolean allowDuplicates) {
        if (key == null) {
            throw new IllegalArgumentException("EclipseLink Key cannot be null");
        }
        if (value == null) {
            this.setNullProperty(key);
        } else {
            this.putProperty_(key, value, allowDuplicates);
        }
    }

    private void putProperty_(String elKey, Object value, boolean allowDuplicates) {
        this.clearEvent();
        this.getPersistenceUnit().setProperty(elKey, this.getEclipseLinkStringValueOf(value), allowDuplicates);
    }

    protected void setNullProperty(String elKey) {
        this.clearEvent();
        this.getPersistenceUnit().setProperty(elKey, null, false);
    }

    protected void clearEvent() {
        this.propertyChangedEvent = null;
        this.propertyChangedEventCount = 0;
    }

    protected void throwMissingDefinition(String methodName, String propertyName) throws NoSuchFieldException {
        throw new NoSuchFieldException("Missing Definition for: " + methodName + "( " + propertyName + ")");
    }

    protected void throwUnsupportedOperationException(ListChangeEvent e) {
        throw new UnsupportedOperationException(e.getAspectName());
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PersistenceUnitTestCase.this.propertyChangedEvent = event;
                ++PersistenceUnitTestCase.this.propertyChangedEventCount;
            }

            public String toString() {
                return "PersistenceUnit listener";
            }
        };
    }

    protected void verifyAAValue(Boolean expectedValue, Boolean subjectValue, PropertyValueModel<Boolean> aa, String persistenceXmlKey) {
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)subjectValue);
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)aa.getValue());
        if (expectedValue != null) {
            PersistenceUnitTestCase.assertEquals((String)expectedValue.toString(), (String)this.getPersistenceUnit().getProperty(persistenceXmlKey).getValue());
        }
    }

    protected <T extends Enum<T>> void verifyAAValue(T expectedValue, T subjectValue, PropertyValueModel<? extends Enum<T>> aa, String elKey) {
        PersistenceUnitTestCase.assertEquals(expectedValue, subjectValue);
        PersistenceUnitTestCase.assertEquals(expectedValue, (Object)aa.getValue());
        if (expectedValue != null) {
            PersistenceUnitTestCase.assertEquals((String)this.getEclipseLinkStringValueOf(expectedValue), (String)this.getPersistenceUnit().getProperty(elKey).getValue());
        }
    }

    protected void verifyInitialState(String propertyName, String elKey, ListValueModel<PersistenceUnit.Property> propertyListAdapter) throws Exception {
        PersistenceUnitTestCase.assertEquals((String)"Total not updated in populatePu(): ", (int)propertyListAdapter.size(), (int)this.propertiesTotal);
        this.verifyPuHasProperty(elKey, "Property not added to populatePu()");
        this.verifyHasListeners(propertyListAdapter);
        this.verifyHasListeners(this.getModel(), propertyName);
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        PersistenceUnitTestCase.assertTrue((String)"model.itemIsProperty() is false: ", (boolean)this.getModel().itemIsProperty(property));
        PersistenceUnitTestCase.assertEquals((String)"propertyIdFor() not updated: ", (String)propertyName, (String)this.getModel().propertyIdFor(property));
    }

    protected void verifyModelInitialized(String elKey, Object expectedValue) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        PersistenceUnitTestCase.assertTrue((String)"model.itemIsProperty() is false: ", (boolean)this.getModel().itemIsProperty(property));
        PersistenceUnitTestCase.assertEquals((String)"PersistenceUnit not populated - populatedPu()", (String)this.getEclipseLinkStringValueOf(expectedValue), (String)property.getValue());
        String propertyName = this.getModel().propertyIdFor(property);
        Object modelValue = this.getProperty(propertyName);
        PersistenceUnitTestCase.assertEquals((String)("Model not initialized - model.initializeProperties() - modelValue = " + modelValue), (Object)expectedValue, (Object)modelValue);
    }

    protected void verifySetProperty(String elKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        String propertyName = this.getModel().propertyIdFor(property);
        this.persistenceUnitSetProperty(elKey, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.setProperty(propertyName, testValue1);
        this.verifyPutProperty(propertyName, testValue1);
    }

    protected void verifyAddRemoveProperty(String elKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(elKey);
        String propertyName = this.getModel().propertyIdFor(property);
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        PersistenceUnitTestCase.assertNotNull((String)("persistenceUnit.properties doesn't contains: " + elKey), (Object)this.getPersistenceUnit().getProperty(elKey));
        this.getPersistenceUnit().removeProperty(elKey);
        PersistenceUnitTestCase.assertNull((Object)this.getPersistenceUnit().getProperty(elKey));
        PersistenceUnitTestCase.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutProperty(propertyName, null);
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(elKey, testValue1);
        this.verifyPutProperty(propertyName, testValue1);
        this.persistenceUnitSetProperty(elKey, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        this.verifyPutEvent(propertyName, this.getProperty(propertyName), expectedValue);
    }

    protected void verifyPutEvent(String propertyName, Object propertyValue, Object expectedValue) {
        this.verifyEvent(propertyName);
        this.verifyEventValue(propertyValue, expectedValue);
    }

    protected void verifyEventValue(Object value, Object expectedValue) {
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)this.propertyChangedEvent.getNewValue());
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)value);
    }

    protected void verifyEvent(String propertyName) {
        PersistenceUnitTestCase.assertNotNull((String)"No Event Fired.", (Object)this.propertyChangedEvent);
        PersistenceUnitTestCase.assertEquals((String)"Wrong Event.", (String)this.propertyChangedEvent.getAspectName(), (String)propertyName);
        PersistenceUnitTestCase.assertTrue((String)"No Event Received.", (this.propertyChangedEventCount > 0 ? 1 : 0) != 0);
        PersistenceUnitTestCase.assertTrue((String)("Multiple Event Received (" + this.propertyChangedEventCount + ")"), (this.propertyChangedEventCount < 2 ? 1 : 0) != 0);
    }

    protected void verifyHasNoListeners(ListValueModel<?> listValueModel) throws Exception {
        PersistenceUnitTestCase.assertTrue((boolean)((AbstractModel)listValueModel).hasNoListChangeListeners("list values"));
    }

    protected void verifyHasListeners(ListValueModel<?> listValueModel) throws Exception {
        PersistenceUnitTestCase.assertTrue((boolean)((AbstractModel)listValueModel).hasAnyListChangeListeners("list values"));
    }

    protected void verifyHasListeners(PersistenceUnitProperties model, String propertyName) throws Exception {
        PersistenceUnitTestCase.assertTrue((String)("Listener not added in setUp() - " + propertyName), (boolean)((AbstractModel)model).hasAnyPropertyChangeListeners(propertyName));
    }

    protected void verifyHasListeners(PropertyValueModel<?> pvm, String propertyName) throws Exception {
        PersistenceUnitTestCase.assertTrue((boolean)((AbstractModel)pvm).hasAnyPropertyChangeListeners(propertyName));
    }

    protected void verifyPuHasProperty(String eclipseLinkPropertyName, String msg) {
        PersistenceUnitTestCase.assertNotNull((String)(String.valueOf(msg) + " - " + eclipseLinkPropertyName), (Object)this.getPersistenceUnit().getProperty(eclipseLinkPropertyName));
    }

    protected void verifyPuHasNotProperty(String eclipseLinkPropertyName, String msg) {
        PersistenceUnitTestCase.assertNull((String)(String.valueOf(msg) + " - " + eclipseLinkPropertyName), (Object)this.getPersistenceUnit().getProperty(eclipseLinkPropertyName));
    }
}

